/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.AbstractDecoration;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.TabPaneDesignInfoX;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;

public class TabOutline {
    private final Path ringPath = new Path();
    private final MoveTo moveTo0 = new MoveTo();
    private final LineTo lineTo1 = new LineTo();
    private final LineTo lineTo2 = new LineTo();
    private final LineTo lineTo3 = new LineTo();
    private final LineTo lineTo4 = new LineTo();
    private final LineTo lineTo5 = new LineTo();
    private final LineTo lineTo6 = new LineTo();
    private final LineTo lineTo7 = new LineTo();
    private final TabPaneDesignInfoX tabPaneDesignInfo = new TabPaneDesignInfoX();
    private final Tab tab;

    public TabOutline(Tab tab) {
        assert (tab != null);
        this.tab = tab;
        ObservableList ringElements = this.ringPath.getElements();
        ringElements.add(this.moveTo0);
        ringElements.add(this.lineTo1);
        ringElements.add(this.lineTo2);
        ringElements.add(this.lineTo3);
        ringElements.add(this.lineTo3);
        ringElements.add(this.lineTo4);
        ringElements.add(this.lineTo5);
        ringElements.add(this.lineTo6);
        ringElements.add(this.lineTo7);
        ringElements.add(new ClosePath());
    }

    public Path getRingPath() {
        return this.ringPath;
    }

    public void layout(AbstractDecoration<?> hostDecoration) {
        TabPane tabPane = this.tab.getTabPane();
        Bounds headerBounds = this.tabPaneDesignInfo.computeTabBounds(tabPane, this.tab);
        Bounds contentBounds = this.tabPaneDesignInfo.computeContentAreaBounds(tabPane);
        switch (tabPane.getSide()) {
            default: {
                this.layoutForTopSide(headerBounds, contentBounds, hostDecoration);
                break;
            }
            case BOTTOM: {
                this.layoutForBottomSide(headerBounds, contentBounds, hostDecoration);
                break;
            }
            case LEFT: {
                this.layoutForLeftSide(headerBounds, contentBounds, hostDecoration);
                break;
            }
            case RIGHT: {
                this.layoutForRightSide(headerBounds, contentBounds, hostDecoration);
            }
        }
    }

    private void layoutForTopSide(Bounds headerBounds, Bounds contentBounds, AbstractDecoration<?> hd) {
        double x0 = contentBounds.getMinX();
        double x1 = headerBounds.getMinX();
        double x2 = headerBounds.getMaxX();
        double x3 = contentBounds.getMaxX();
        double y0 = headerBounds.getMinY();
        double y1 = contentBounds.getMinY();
        double y2 = contentBounds.getMaxY();
        boolean snapToPixel = true;
        Point2D p0 = hd.sceneGraphObjectToDecoration(x0, y1, true);
        Point2D p1 = hd.sceneGraphObjectToDecoration(x1, y1, true);
        Point2D p2 = hd.sceneGraphObjectToDecoration(x1, y0, true);
        Point2D p3 = hd.sceneGraphObjectToDecoration(x2, y0, true);
        Point2D p4 = hd.sceneGraphObjectToDecoration(x2, y1, true);
        Point2D p5 = hd.sceneGraphObjectToDecoration(x3, y1, true);
        Point2D p6 = hd.sceneGraphObjectToDecoration(x3, y2, true);
        Point2D p7 = hd.sceneGraphObjectToDecoration(x0, y2, true);
        this.moveTo0.setX(p0.getX());
        this.moveTo0.setY(p0.getY());
        this.lineTo1.setX(p1.getX());
        this.lineTo1.setY(p1.getY());
        this.lineTo2.setX(p2.getX());
        this.lineTo2.setY(p2.getY());
        this.lineTo3.setX(p3.getX());
        this.lineTo3.setY(p3.getY());
        this.lineTo4.setX(p4.getX());
        this.lineTo4.setY(p4.getY());
        this.lineTo5.setX(p5.getX());
        this.lineTo5.setY(p5.getY());
        this.lineTo6.setX(p6.getX());
        this.lineTo6.setY(p6.getY());
        this.lineTo7.setX(p7.getX());
        this.lineTo7.setY(p7.getY());
    }

    private void layoutForBottomSide(Bounds headerBounds, Bounds contentBounds, AbstractDecoration<?> hd) {
        double x0 = contentBounds.getMinX();
        double x1 = headerBounds.getMinX();
        double x2 = headerBounds.getMaxX();
        double x3 = contentBounds.getMaxX();
        double y0 = contentBounds.getMinY();
        double y1 = contentBounds.getMaxY();
        double y2 = headerBounds.getMaxY();
        boolean snapToPixel = true;
        Point2D p0 = hd.sceneGraphObjectToDecoration(x0, y0, true);
        Point2D p1 = hd.sceneGraphObjectToDecoration(x3, y0, true);
        Point2D p2 = hd.sceneGraphObjectToDecoration(x3, y1, true);
        Point2D p3 = hd.sceneGraphObjectToDecoration(x2, y1, true);
        Point2D p4 = hd.sceneGraphObjectToDecoration(x2, y2, true);
        Point2D p5 = hd.sceneGraphObjectToDecoration(x1, y2, true);
        Point2D p6 = hd.sceneGraphObjectToDecoration(x1, y1, true);
        Point2D p7 = hd.sceneGraphObjectToDecoration(x0, y1, true);
        this.moveTo0.setX(p0.getX());
        this.moveTo0.setY(p0.getY());
        this.lineTo1.setX(p1.getX());
        this.lineTo1.setY(p1.getY());
        this.lineTo2.setX(p2.getX());
        this.lineTo2.setY(p2.getY());
        this.lineTo3.setX(p3.getX());
        this.lineTo3.setY(p3.getY());
        this.lineTo4.setX(p4.getX());
        this.lineTo4.setY(p4.getY());
        this.lineTo5.setX(p5.getX());
        this.lineTo5.setY(p5.getY());
        this.lineTo6.setX(p6.getX());
        this.lineTo6.setY(p6.getY());
        this.lineTo7.setX(p7.getX());
        this.lineTo7.setY(p7.getY());
    }

    private void layoutForLeftSide(Bounds headerBounds, Bounds contentBounds, AbstractDecoration<?> hd) {
        double x0 = headerBounds.getMinX();
        double x1 = contentBounds.getMinX();
        double x2 = contentBounds.getMaxX();
        double y0 = contentBounds.getMinY();
        double y1 = headerBounds.getMinY();
        double y2 = headerBounds.getMaxY();
        double y3 = contentBounds.getMaxY();
        boolean snapToPixel = true;
        Point2D p0 = hd.sceneGraphObjectToDecoration(x0, y1, true);
        Point2D p1 = hd.sceneGraphObjectToDecoration(x1, y1, true);
        Point2D p2 = hd.sceneGraphObjectToDecoration(x1, y0, true);
        Point2D p3 = hd.sceneGraphObjectToDecoration(x2, y0, true);
        Point2D p4 = hd.sceneGraphObjectToDecoration(x2, y3, true);
        Point2D p5 = hd.sceneGraphObjectToDecoration(x1, y3, true);
        Point2D p6 = hd.sceneGraphObjectToDecoration(x1, y2, true);
        Point2D p7 = hd.sceneGraphObjectToDecoration(x0, y2, true);
        this.moveTo0.setX(p0.getX());
        this.moveTo0.setY(p0.getY());
        this.lineTo1.setX(p1.getX());
        this.lineTo1.setY(p1.getY());
        this.lineTo2.setX(p2.getX());
        this.lineTo2.setY(p2.getY());
        this.lineTo3.setX(p3.getX());
        this.lineTo3.setY(p3.getY());
        this.lineTo4.setX(p4.getX());
        this.lineTo4.setY(p4.getY());
        this.lineTo5.setX(p5.getX());
        this.lineTo5.setY(p5.getY());
        this.lineTo6.setX(p6.getX());
        this.lineTo6.setY(p6.getY());
        this.lineTo7.setX(p7.getX());
        this.lineTo7.setY(p7.getY());
    }

    private void layoutForRightSide(Bounds headerBounds, Bounds contentBounds, AbstractDecoration<?> hd) {
        double x0 = contentBounds.getMinX();
        double x1 = contentBounds.getMaxX();
        double x2 = headerBounds.getMaxX();
        double y0 = contentBounds.getMinY();
        double y1 = headerBounds.getMinY();
        double y2 = headerBounds.getMaxY();
        double y3 = contentBounds.getMaxY();
        boolean snapToPixel = true;
        Point2D p0 = hd.sceneGraphObjectToDecoration(x0, y0, true);
        Point2D p1 = hd.sceneGraphObjectToDecoration(x1, y0, true);
        Point2D p2 = hd.sceneGraphObjectToDecoration(x1, y1, true);
        Point2D p3 = hd.sceneGraphObjectToDecoration(x2, y1, true);
        Point2D p4 = hd.sceneGraphObjectToDecoration(x2, y2, true);
        Point2D p5 = hd.sceneGraphObjectToDecoration(x1, y2, true);
        Point2D p6 = hd.sceneGraphObjectToDecoration(x1, y3, true);
        Point2D p7 = hd.sceneGraphObjectToDecoration(x0, y3, true);
        this.moveTo0.setX(p0.getX());
        this.moveTo0.setY(p0.getY());
        this.lineTo1.setX(p1.getX());
        this.lineTo1.setY(p1.getY());
        this.lineTo2.setX(p2.getX());
        this.lineTo2.setY(p2.getY());
        this.lineTo3.setX(p3.getX());
        this.lineTo3.setY(p3.getY());
        this.lineTo4.setX(p4.getX());
        this.lineTo4.setY(p4.getY());
        this.lineTo5.setX(p5.getX());
        this.lineTo5.setY(p5.getY());
        this.lineTo6.setX(p6.getX());
        this.lineTo6.setY(p6.getY());
        this.lineTo7.setX(p7.getX());
        this.lineTo7.setY(p7.getY());
    }
}

