/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver;

import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AbstractDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AccessoryDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.AbstractDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.TabPaneDesignInfoX;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles.AbstractHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles.TabHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.pring.AbstractPring;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.pring.TabPring;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.AbstractResizer;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.tring.AbstractTring;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.tring.TabTring;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;

public class TabDriver
extends AbstractDriver {
    public TabDriver(ContentPanelController contentPanelController) {
        super(contentPanelController);
    }

    @Override
    public AbstractHandles<?> makeHandles(FXOMObject fxomObject) {
        assert (fxomObject.getSceneGraphObject() instanceof Tab);
        assert (fxomObject instanceof FXOMInstance);
        return new TabHandles(this.contentPanelController, (FXOMInstance)fxomObject);
    }

    @Override
    public AbstractTring<?> makeTring(AbstractDropTarget dropTarget) {
        assert (dropTarget != null);
        assert (dropTarget.getTargetObject() instanceof FXOMInstance);
        assert (dropTarget.getTargetObject().getSceneGraphObject() instanceof Tab);
        return new TabTring(this.contentPanelController, (FXOMInstance)dropTarget.getTargetObject());
    }

    @Override
    public AbstractPring<?> makePring(FXOMObject fxomObject) {
        assert (fxomObject.getSceneGraphObject() instanceof Tab);
        assert (fxomObject instanceof FXOMInstance);
        return new TabPring(this.contentPanelController, (FXOMInstance)fxomObject);
    }

    @Override
    public AbstractResizer<?> makeResizer(FXOMObject fxomObject) {
        return null;
    }

    @Override
    public FXOMObject refinePick(Node hitNode, double sceneX, double sceneY, FXOMObject fxomObject) {
        return fxomObject;
    }

    @Override
    public AbstractDropTarget makeDropTarget(FXOMObject fxomObject, double sceneX, double sceneY) {
        assert (fxomObject instanceof FXOMInstance);
        return new AccessoryDropTarget((FXOMInstance)fxomObject, DesignHierarchyMask.Accessory.CONTENT);
    }

    @Override
    public Node getInlineEditorBounds(FXOMObject fxomObject) {
        assert (fxomObject.getSceneGraphObject() instanceof Tab);
        Tab tab = (Tab)fxomObject.getSceneGraphObject();
        TabPaneDesignInfoX di = new TabPaneDesignInfoX();
        return di.getTabNode(tab.getTabPane(), tab);
    }

    @Override
    public boolean intersectsBounds(FXOMObject fxomObject, Bounds bounds) {
        boolean result;
        assert (fxomObject.getSceneGraphObject() instanceof Tab);
        Tab tab = (Tab)fxomObject.getSceneGraphObject();
        if (tab.isSelected()) {
            TabPane tabPane = tab.getTabPane();
            Bounds sceneGraphNodeBounds = tabPane.localToScene(tabPane.getLayoutBounds(), true);
            result = sceneGraphNodeBounds.intersects(bounds);
        } else {
            result = false;
        }
        return result;
    }
}

