/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver;

import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AbstractDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.ContainerZDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.AbstractNodeDriver;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.tring.AbstractTring;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.tring.HBoxTring;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.layout.HBox;

public class HBoxDriver
extends AbstractNodeDriver {
    public HBoxDriver(ContentPanelController contentPanelController) {
        super(contentPanelController);
    }

    @Override
    public AbstractDropTarget makeDropTarget(FXOMObject fxomObject, double sceneX, double sceneY) {
        DesignHierarchyMask m;
        int targetIndex;
        assert (fxomObject instanceof FXOMInstance);
        assert (fxomObject.getSceneGraphObject() instanceof HBox);
        HBox hbox = (HBox)fxomObject.getSceneGraphObject();
        assert (hbox.getScene() != null);
        double localX = hbox.sceneToLocal(sceneX, sceneY, true).getX();
        int childCount = hbox.getChildrenUnmodifiable().size();
        if (childCount == 0) {
            targetIndex = -1;
        } else {
            assert (childCount >= 1);
            int childIndex = 0;
            Node child = (Node)hbox.getChildrenUnmodifiable().get(childIndex++);
            Bounds childBounds = child.getBoundsInParent();
            double midX = (childBounds.getMinX() + childBounds.getMaxX()) / 2.0;
            while (localX > midX && childIndex < childCount) {
                child = (Node)hbox.getChildrenUnmodifiable().get(childIndex++);
                childBounds = child.getBoundsInParent();
                midX = (childBounds.getMinX() + childBounds.getMaxX()) / 2.0;
            }
            if (localX <= midX) {
                assert (childIndex - 1 < childCount);
                targetIndex = childIndex - 1;
            } else {
                targetIndex = -1;
            }
        }
        FXOMObject beforeChild = targetIndex == -1 ? null : (targetIndex < (m = new DesignHierarchyMask(fxomObject)).getSubComponentCount() ? m.getSubComponentAtIndex(targetIndex) : null);
        return new ContainerZDropTarget((FXOMInstance)fxomObject, beforeChild);
    }

    @Override
    public AbstractTring<?> makeTring(AbstractDropTarget dropTarget) {
        assert (dropTarget instanceof ContainerZDropTarget);
        assert (dropTarget.getTargetObject() instanceof FXOMInstance);
        assert (dropTarget.getTargetObject().getSceneGraphObject() instanceof HBox);
        ContainerZDropTarget zDropTarget = (ContainerZDropTarget)dropTarget;
        int targetIndex = zDropTarget.getBeforeChild() == null ? -1 : zDropTarget.getBeforeChild().getIndexInParentProperty();
        return new HBoxTring(this.contentPanelController, (FXOMInstance)dropTarget.getTargetObject(), targetIndex);
    }
}

