/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.wrap;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.JobUtils;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.AbstractWrapInSubComponentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.FXOMObjectCourseComparator;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;

public class WrapInSplitPaneJob
extends AbstractWrapInSubComponentJob {
    public WrapInSplitPaneJob(EditorController editorController) {
        super(editorController);
        this.newContainerClass = SplitPane.class;
    }

    @Override
    protected void modifyNewContainer(List<FXOMObject> children) {
        super.modifyNewContainer(children);
        Orientation orientation = this.getOrientation(children);
        JobUtils.setOrientation(this.newContainer, SplitPane.class, orientation.name());
    }

    @Override
    protected Collection<FXOMObject> sortChildren(List<FXOMObject> children) {
        ArrayList<FXOMObject> sorted = new ArrayList<FXOMObject>(children);
        Orientation orientation = this.getOrientation(children);
        Collections.sort(sorted, FXOMObjectCourseComparator.UnidimensionalComparator.of(orientation));
        return sorted;
    }

    private Orientation getOrientation(List<FXOMObject> fxomObjects) {
        int cols = this.computeSizeByCourse(fxomObjects, FXOMObjectCourseComparator.GridCourse.COL_BY_COL);
        if (cols == fxomObjects.size()) {
            return Orientation.HORIZONTAL;
        }
        int rows = this.computeSizeByCourse(fxomObjects, FXOMObjectCourseComparator.GridCourse.ROW_BY_ROW);
        if (rows == fxomObjects.size()) {
            return Orientation.VERTICAL;
        }
        Orientation orientation = cols >= rows ? Orientation.HORIZONTAL : Orientation.VERTICAL;
        return orientation;
    }

    private int computeSizeByCourse(List<FXOMObject> fxomObjects, FXOMObjectCourseComparator.GridCourse course) {
        FXOMObjectCourseComparator.BidimensionalComparator comparator = new FXOMObjectCourseComparator.BidimensionalComparator(course);
        FXOMObject lastObject = null;
        int rc = 0;
        int max = -1;
        for (FXOMObject currentObject : fxomObjects) {
            if (lastObject != null && comparator.compare(lastObject, currentObject) != 0) {
                Node lastNode = (Node)lastObject.getSceneGraphObject();
                Node currentNode = (Node)currentObject.getSceneGraphObject();
                Bounds lastBounds = lastNode.getBoundsInParent();
                Bounds currentBounds = currentNode.getBoundsInParent();
                if (course.getMinY(currentBounds) >= course.getMaxY(lastBounds)) {
                    ++rc;
                }
            }
            max = Math.max(max, rc);
            lastObject = currentObject;
        }
        return max;
    }
}

