/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.reference;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.InlineDocumentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RemovePropertyJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNodes;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import java.util.LinkedList;
import java.util.List;

public class FixToggleGroupIntrinsicReferenceJob
extends InlineDocumentJob {
    private final FXOMIntrinsic reference;

    public FixToggleGroupIntrinsicReferenceJob(FXOMIntrinsic reference, EditorController editorController) {
        super(editorController);
        assert (reference != null);
        assert (reference.getFxomDocument() == editorController.getFxomDocument());
        this.reference = reference;
    }

    @Override
    protected List<Job> makeAndExecuteSubJobs() {
        String fxId;
        LinkedList<Job> result = new LinkedList<Job>();
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        FXOMObject referee = fxomDocument.searchWithFxId(fxId = FXOMNodes.extractReferenceSource(this.reference));
        if (referee != null) {
            assert (referee.getParentProperty() != null);
            FXOMPropertyC referenceProperty = this.reference.getParentProperty();
            FXOMPropertyC refereeProperty = referee.getParentProperty();
            RemovePropertyJob removeReferenceJob = new RemovePropertyJob(referenceProperty, this.getEditorController());
            removeReferenceJob.execute();
            result.add(removeReferenceJob);
            RemovePropertyJob removeRefereeJob = new RemovePropertyJob(refereeProperty, this.getEditorController());
            removeRefereeJob.execute();
            result.add(removeRefereeJob);
            Job addReferenceJob = removeRefereeJob.makeMirrorJob(referenceProperty);
            addReferenceJob.execute();
            result.add(addReferenceJob);
            Job addRefereeJob = removeRefereeJob.makeMirrorJob(refereeProperty);
            addRefereeJob.execute();
            result.add(addReferenceJob);
        } else {
            FXOMPropertyC referenceProperty = this.reference.getParentProperty();
            RemovePropertyJob removeReferenceJob = new RemovePropertyJob(referenceProperty, this.getEditorController());
            removeReferenceJob.execute();
            result.add(removeReferenceJob);
            FXOMPropertyC newToggleGroup = FXOMNodes.makeToggleGroup(fxomDocument, fxId);
            Job addJob = removeReferenceJob.makeMirrorJob(newToggleGroup);
            addJob.execute();
            result.add(addJob);
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean isExecutable() {
        return this.reference.getType() == FXOMIntrinsic.Type.FX_REFERENCE && this.reference.getParentProperty() != null;
    }
}

