/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchDocumentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RemoveFxControllerJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RemovePropertyJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import java.util.ArrayList;
import java.util.List;

public class PrunePropertiesJob
extends BatchDocumentJob {
    private final FXOMObject fxomObject;
    private final FXOMObject targetParent;

    public PrunePropertiesJob(FXOMObject fxomObject, FXOMObject targetParent, EditorController editorController) {
        super(editorController);
        assert (fxomObject != null);
        this.fxomObject = fxomObject;
        this.targetParent = targetParent;
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        Metadata metadata = Metadata.getMetadata();
        if (this.fxomObject instanceof FXOMInstance) {
            FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
            for (FXOMProperty p : fxomInstance.getProperties().values()) {
                boolean prune;
                if (!metadata.isPropertyTrimmingNeeded(p.getName())) continue;
                Class<?> residentClass = p.getName().getResidenceClass();
                if (residentClass == null) {
                    prune = true;
                } else if (this.targetParent instanceof FXOMInstance) {
                    FXOMInstance parentInstance = (FXOMInstance)this.targetParent;
                    prune = residentClass != parentInstance.getDeclaredClass();
                } else {
                    assert (this.targetParent == null || this.targetParent instanceof FXOMCollection);
                    prune = true;
                }
                if (!prune) continue;
                result.add(new RemovePropertyJob(p, this.getEditorController()));
            }
        }
        if (this.fxomObject.getFxController() != null && this.targetParent != null) {
            result.add(new RemoveFxControllerJob(this.fxomObject, this.getEditorController()));
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return this.getClass().getSimpleName();
    }
}

