/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.drag.target;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.AbstractDragSource;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AbstractDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.BackupSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.UpdateSelectionJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.ImagePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignImage;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import javafx.scene.image.ImageView;

public class ImageViewDropTarget
extends AbstractDropTarget {
    private final FXOMInstance targetImageView;

    public ImageViewDropTarget(FXOMObject targetImageView) {
        assert (targetImageView instanceof FXOMInstance);
        assert (targetImageView.getSceneGraphObject() instanceof ImageView);
        this.targetImageView = (FXOMInstance)targetImageView;
    }

    @Override
    public FXOMObject getTargetObject() {
        return this.targetImageView;
    }

    @Override
    public boolean acceptDragSource(AbstractDragSource dragSource) {
        assert (dragSource != null);
        return dragSource.isSingleImageViewOnly();
    }

    @Override
    public Job makeDropJob(AbstractDragSource dragSource, EditorController editorController) {
        assert (dragSource != null);
        assert (dragSource.isSingleImageViewOnly());
        FXOMObject draggedObject = dragSource.getDraggedObjects().get(0);
        assert (draggedObject instanceof FXOMInstance);
        FXOMInstance draggedInstance = (FXOMInstance)draggedObject;
        PropertyName imageName = new PropertyName("image");
        ValuePropertyMetadata vpm = Metadata.getMetadata().queryValueProperty(draggedInstance, imageName);
        assert (vpm instanceof ImagePropertyMetadata);
        ImagePropertyMetadata imageVPM = (ImagePropertyMetadata)vpm;
        DesignImage image = (DesignImage)imageVPM.getValue(draggedInstance);
        BatchJob result = new BatchJob(editorController);
        result.addSubJob(new BackupSelectionJob(editorController));
        result.addSubJob(new ModifyObjectJob(this.targetImageView, imageVPM, image, editorController));
        result.addSubJob(new UpdateSelectionJob(this.targetImageView, editorController));
        return result;
    }

    @Override
    public boolean isSelectRequiredAfterDrop() {
        return false;
    }
}

