/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.LazyFileOutputStream;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.SessionEvent;
import org.apache.maven.wagon.events.SessionEventSupport;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferEventSupport;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.proxy.ProxyUtils;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractWagon
implements Wagon {
    protected static final int DEFAULT_BUFFER_SIZE = 4096;
    protected Repository repository;
    protected SessionEventSupport sessionEventSupport = new SessionEventSupport();
    protected TransferEventSupport transferEventSupport = new TransferEventSupport();
    protected AuthenticationInfo authenticationInfo;
    protected boolean interactive = true;
    private int connectionTimeout = 60000;
    private int readTimeout = Integer.parseInt(System.getProperty("maven.wagon.rto", Integer.toString(1800000)));
    private ProxyInfoProvider proxyInfoProvider;
    protected ProxyInfo proxyInfo;
    private RepositoryPermissions permissionsOverride;

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfoProvider != null ? this.proxyInfoProvider.getProxyInfo(null) : null;
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationInfo;
    }

    @Override
    public void openConnection() throws ConnectionException, AuthenticationException {
        try {
            this.openConnectionInternal();
        }
        catch (ConnectionException e2) {
            this.fireSessionConnectionRefused();
            throw e2;
        }
        catch (AuthenticationException e3) {
            this.fireSessionConnectionRefused();
            throw e3;
        }
    }

    @Override
    public void connect(Repository repository) throws ConnectionException, AuthenticationException {
        this.connect(repository, null, (ProxyInfoProvider)null);
    }

    @Override
    public void connect(Repository repository, ProxyInfo proxyInfo) throws ConnectionException, AuthenticationException {
        this.connect(repository, null, proxyInfo);
    }

    @Override
    public void connect(Repository repository, ProxyInfoProvider proxyInfoProvider) throws ConnectionException, AuthenticationException {
        this.connect(repository, null, proxyInfoProvider);
    }

    @Override
    public void connect(Repository repository, AuthenticationInfo authenticationInfo) throws ConnectionException, AuthenticationException {
        this.connect(repository, authenticationInfo, (ProxyInfoProvider)null);
    }

    @Override
    public void connect(Repository repository, AuthenticationInfo authenticationInfo, ProxyInfo proxyInfo) throws ConnectionException, AuthenticationException {
        final ProxyInfo proxy2 = proxyInfo;
        this.connect(repository, authenticationInfo, new ProxyInfoProvider(){

            @Override
            public ProxyInfo getProxyInfo(String protocol) {
                if (protocol == null || proxy2 == null || protocol.equalsIgnoreCase(proxy2.getType())) {
                    return proxy2;
                }
                return null;
            }
        });
    }

    @Override
    public void connect(Repository repository, AuthenticationInfo authenticationInfo, ProxyInfoProvider proxyInfoProvider) throws ConnectionException, AuthenticationException {
        if (repository == null) {
            throw new NullPointerException("repository cannot be null");
        }
        if (this.permissionsOverride != null) {
            repository.setPermissions(this.permissionsOverride);
        }
        this.repository = repository;
        if (authenticationInfo == null) {
            authenticationInfo = new AuthenticationInfo();
        }
        if (authenticationInfo.getUserName() == null && repository.getUsername() != null) {
            authenticationInfo.setUserName(repository.getUsername());
            if (repository.getPassword() != null && authenticationInfo.getPassword() == null) {
                authenticationInfo.setPassword(repository.getPassword());
            }
        }
        this.authenticationInfo = authenticationInfo;
        this.proxyInfoProvider = proxyInfoProvider;
        this.fireSessionOpening();
        this.openConnection();
        this.fireSessionOpened();
    }

    protected abstract void openConnectionInternal() throws ConnectionException, AuthenticationException;

    @Override
    public void disconnect() throws ConnectionException {
        this.fireSessionDisconnecting();
        try {
            this.closeConnection();
        }
        catch (ConnectionException e2) {
            this.fireSessionError(e2);
            throw e2;
        }
        this.fireSessionDisconnected();
    }

    protected abstract void closeConnection() throws ConnectionException;

    protected void createParentDirectories(File destination) throws TransferFailedException {
        File destinationDirectory = destination.getParentFile();
        try {
            destinationDirectory = destinationDirectory.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (destinationDirectory != null && !destinationDirectory.exists()) {
            destinationDirectory.mkdirs();
            if (!destinationDirectory.exists()) {
                throw new TransferFailedException("Specified destination directory cannot be created: " + destinationDirectory);
            }
        }
    }

    @Override
    public void setTimeout(int timeoutValue) {
        this.connectionTimeout = timeoutValue;
    }

    @Override
    public int getTimeout() {
        return this.connectionTimeout;
    }

    protected void getTransfer(Resource resource2, File destination, InputStream input) throws TransferFailedException {
        this.getTransfer(resource2, destination, input, true, Long.MAX_VALUE);
    }

    protected void getTransfer(Resource resource2, OutputStream output, InputStream input) throws TransferFailedException {
        this.getTransfer(resource2, output, input, true, Long.MAX_VALUE);
    }

    @Deprecated
    protected void getTransfer(Resource resource2, File destination, InputStream input, boolean closeInput, int maxSize) throws TransferFailedException {
        this.getTransfer(resource2, destination, input, closeInput, (long)maxSize);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void getTransfer(Resource resource2, File destination, InputStream input, boolean closeInput, long maxSize) throws TransferFailedException {
        this.fireTransferDebug("attempting to create parent directories for destination: " + destination.getName());
        this.createParentDirectories(destination);
        this.fireGetStarted(resource2, destination);
        LazyFileOutputStream output = null;
        try {
            output = new LazyFileOutputStream(destination);
            this.getTransfer(resource2, (OutputStream)output, input, closeInput, maxSize);
            ((OutputStream)output).close();
            output = null;
        }
        catch (IOException e2) {
            try {
                boolean deleted;
                if (destination.exists() && !(deleted = destination.delete())) {
                    destination.deleteOnExit();
                }
                this.fireTransferError(resource2, e2, 5);
                String msg = "GET request of: " + resource2.getName() + " from " + this.repository.getName() + " failed";
                throw new TransferFailedException(msg, e2);
                catch (TransferFailedException e3) {
                    if (destination.exists() && !(deleted = destination.delete())) {
                        destination.deleteOnExit();
                    }
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(output);
                throw throwable;
            }
        }
        IOUtil.close(output);
        this.fireGetCompleted(resource2, destination);
    }

    @Deprecated
    protected void getTransfer(Resource resource2, OutputStream output, InputStream input, boolean closeInput, int maxSize) throws TransferFailedException {
        this.getTransfer(resource2, output, input, closeInput, (long)maxSize);
    }

    protected void getTransfer(Resource resource2, OutputStream output, InputStream input, boolean closeInput, long maxSize) throws TransferFailedException {
        try {
            this.transfer(resource2, input, output, 5, maxSize);
            this.finishGetTransfer(resource2, input, output);
            if (closeInput) {
                input.close();
                input = null;
            }
        }
        catch (IOException e2) {
            this.fireTransferError(resource2, e2, 5);
            String msg = "GET request of: " + resource2.getName() + " from " + this.repository.getName() + " failed";
            throw new TransferFailedException(msg, e2);
        }
        finally {
            if (closeInput) {
                IOUtil.close(input);
            }
            this.cleanupGetTransfer(resource2);
        }
    }

    protected void finishGetTransfer(Resource resource2, InputStream input, OutputStream output) throws TransferFailedException {
    }

    protected void cleanupGetTransfer(Resource resource2) {
    }

    protected void putTransfer(Resource resource2, File source2, OutputStream output, boolean closeOutput) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        this.firePutStarted(resource2, source2);
        this.transfer(resource2, source2, output, closeOutput);
        this.firePutCompleted(resource2, source2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void transfer(Resource resource2, File source2, OutputStream output, boolean closeOutput) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        FileInputStream input = null;
        try {
            input = new FileInputStream(source2);
            this.putTransfer(resource2, input, output, closeOutput);
            ((InputStream)input).close();
            input = null;
        }
        catch (FileNotFoundException e2) {
            try {
                this.fireTransferError(resource2, e2, 6);
                throw new TransferFailedException("Specified source file does not exist: " + source2, e2);
                catch (IOException e3) {
                    this.fireTransferError(resource2, e3, 6);
                    throw new TransferFailedException("Failure transferring " + source2, e3);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(input);
                throw throwable;
            }
        }
        IOUtil.close(input);
    }

    protected void putTransfer(Resource resource2, InputStream input, OutputStream output, boolean closeOutput) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        try {
            this.transfer(resource2, input, output, 6, resource2.getContentLength() == -1L ? Long.MAX_VALUE : resource2.getContentLength());
            this.finishPutTransfer(resource2, input, output);
            if (closeOutput) {
                output.close();
                output = null;
            }
        }
        catch (IOException e2) {
            this.fireTransferError(resource2, e2, 6);
            String msg = "PUT request to: " + resource2.getName() + " in " + this.repository.getName() + " failed";
            throw new TransferFailedException(msg, e2);
        }
        finally {
            if (closeOutput) {
                IOUtil.close(output);
            }
            this.cleanupPutTransfer(resource2);
        }
    }

    protected void cleanupPutTransfer(Resource resource2) {
    }

    protected void finishPutTransfer(Resource resource2, InputStream input, OutputStream output) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
    }

    protected void transfer(Resource resource2, InputStream input, OutputStream output, int requestType) throws IOException {
        this.transfer(resource2, input, output, requestType, Long.MAX_VALUE);
    }

    @Deprecated
    protected void transfer(Resource resource2, InputStream input, OutputStream output, int requestType, int maxSize) throws IOException {
        this.transfer(resource2, input, output, requestType, (long)maxSize);
    }

    protected void transfer(Resource resource2, InputStream input, OutputStream output, int requestType, long maxSize) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource2, 3, requestType);
        transferEvent.setTimestamp(System.currentTimeMillis());
        for (long remaining = maxSize; remaining > 0L && (n = input.read(buffer, 0, (int)Math.min((long)buffer.length, remaining))) != -1; remaining -= (long)n) {
            this.fireTransferProgress(transferEvent, buffer, n);
            output.write(buffer, 0, n);
        }
        output.flush();
    }

    protected void fireTransferProgress(TransferEvent transferEvent, byte[] buffer, int n) {
        this.transferEventSupport.fireTransferProgress(transferEvent, buffer, n);
    }

    protected void fireGetCompleted(Resource resource2, File localFile) {
        long timestamp = System.currentTimeMillis();
        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource2, 2, 5);
        transferEvent.setTimestamp(timestamp);
        transferEvent.setLocalFile(localFile);
        this.transferEventSupport.fireTransferCompleted(transferEvent);
    }

    protected void fireGetStarted(Resource resource2, File localFile) {
        long timestamp = System.currentTimeMillis();
        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource2, 1, 5);
        transferEvent.setTimestamp(timestamp);
        transferEvent.setLocalFile(localFile);
        this.transferEventSupport.fireTransferStarted(transferEvent);
    }

    protected void fireGetInitiated(Resource resource2, File localFile) {
        long timestamp = System.currentTimeMillis();
        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource2, 0, 5);
        transferEvent.setTimestamp(timestamp);
        transferEvent.setLocalFile(localFile);
        this.transferEventSupport.fireTransferInitiated(transferEvent);
    }

    protected void firePutInitiated(Resource resource2, File localFile) {
        long timestamp = System.currentTimeMillis();
        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource2, 0, 6);
        transferEvent.setTimestamp(timestamp);
        transferEvent.setLocalFile(localFile);
        this.transferEventSupport.fireTransferInitiated(transferEvent);
    }

    protected void firePutCompleted(Resource resource2, File localFile) {
        long timestamp = System.currentTimeMillis();
        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource2, 2, 6);
        transferEvent.setTimestamp(timestamp);
        transferEvent.setLocalFile(localFile);
        this.transferEventSupport.fireTransferCompleted(transferEvent);
    }

    protected void firePutStarted(Resource resource2, File localFile) {
        long timestamp = System.currentTimeMillis();
        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource2, 1, 6);
        transferEvent.setTimestamp(timestamp);
        transferEvent.setLocalFile(localFile);
        this.transferEventSupport.fireTransferStarted(transferEvent);
    }

    protected void fireSessionDisconnected() {
        long timestamp = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 3);
        sessionEvent.setTimestamp(timestamp);
        this.sessionEventSupport.fireSessionDisconnected(sessionEvent);
    }

    protected void fireSessionDisconnecting() {
        long timestamp = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 2);
        sessionEvent.setTimestamp(timestamp);
        this.sessionEventSupport.fireSessionDisconnecting(sessionEvent);
    }

    protected void fireSessionLoggedIn() {
        long timestamp = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 7);
        sessionEvent.setTimestamp(timestamp);
        this.sessionEventSupport.fireSessionLoggedIn(sessionEvent);
    }

    protected void fireSessionLoggedOff() {
        long timestamp = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 8);
        sessionEvent.setTimestamp(timestamp);
        this.sessionEventSupport.fireSessionLoggedOff(sessionEvent);
    }

    protected void fireSessionOpened() {
        long timestamp = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 6);
        sessionEvent.setTimestamp(timestamp);
        this.sessionEventSupport.fireSessionOpened(sessionEvent);
    }

    protected void fireSessionOpening() {
        long timestamp = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 5);
        sessionEvent.setTimestamp(timestamp);
        this.sessionEventSupport.fireSessionOpening(sessionEvent);
    }

    protected void fireSessionConnectionRefused() {
        long timestamp = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 4);
        sessionEvent.setTimestamp(timestamp);
        this.sessionEventSupport.fireSessionConnectionRefused(sessionEvent);
    }

    protected void fireSessionError(Exception exception) {
        long timestamp = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, exception);
        sessionEvent.setTimestamp(timestamp);
        this.sessionEventSupport.fireSessionError(sessionEvent);
    }

    protected void fireTransferDebug(String message) {
        this.transferEventSupport.fireDebug(message);
    }

    protected void fireSessionDebug(String message) {
        this.sessionEventSupport.fireDebug(message);
    }

    @Override
    public boolean hasTransferListener(TransferListener listener) {
        return this.transferEventSupport.hasTransferListener(listener);
    }

    @Override
    public void addTransferListener(TransferListener listener) {
        this.transferEventSupport.addTransferListener(listener);
    }

    @Override
    public void removeTransferListener(TransferListener listener) {
        this.transferEventSupport.removeTransferListener(listener);
    }

    @Override
    public void addSessionListener(SessionListener listener) {
        this.sessionEventSupport.addSessionListener(listener);
    }

    @Override
    public boolean hasSessionListener(SessionListener listener) {
        return this.sessionEventSupport.hasSessionListener(listener);
    }

    @Override
    public void removeSessionListener(SessionListener listener) {
        this.sessionEventSupport.removeSessionListener(listener);
    }

    protected void fireTransferError(Resource resource2, Exception e2, int requestType) {
        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource2, e2, requestType);
        this.transferEventSupport.fireTransferError(transferEvent);
    }

    public SessionEventSupport getSessionEventSupport() {
        return this.sessionEventSupport;
    }

    public void setSessionEventSupport(SessionEventSupport sessionEventSupport) {
        this.sessionEventSupport = sessionEventSupport;
    }

    public TransferEventSupport getTransferEventSupport() {
        return this.transferEventSupport;
    }

    public void setTransferEventSupport(TransferEventSupport transferEventSupport) {
        this.transferEventSupport = transferEventSupport;
    }

    protected void postProcessListeners(Resource resource2, File source2, int requestType) throws TransferFailedException {
        byte[] buffer = new byte[4096];
        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource2, 3, requestType);
        transferEvent.setTimestamp(System.currentTimeMillis());
        transferEvent.setLocalFile(source2);
        FileInputStream input = null;
        try {
            int n;
            input = new FileInputStream(source2);
            while ((n = ((InputStream)input).read(buffer)) != -1) {
                this.fireTransferProgress(transferEvent, buffer, n);
            }
            ((InputStream)input).close();
            input = null;
        }
        catch (IOException e2) {
            try {
                this.fireTransferError(resource2, e2, requestType);
                throw new TransferFailedException("Failed to post-process the source file", e2);
            }
            catch (Throwable throwable) {
                IOUtil.close(input);
                throw throwable;
            }
        }
        IOUtil.close(input);
    }

    @Override
    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        throw new UnsupportedOperationException("The wagon you are using has not implemented putDirectory()");
    }

    @Override
    public boolean supportsDirectoryCopy() {
        return false;
    }

    protected static String getPath(String basedir, String dir2) {
        String path2 = basedir;
        if (!basedir.endsWith("/") && !dir2.startsWith("/")) {
            path2 = path2 + "/";
        }
        path2 = path2 + dir2;
        return path2;
    }

    @Override
    public boolean isInteractive() {
        return this.interactive;
    }

    @Override
    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    @Override
    public List<String> getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        throw new UnsupportedOperationException("The wagon you are using has not implemented getFileList()");
    }

    @Override
    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        throw new UnsupportedOperationException("The wagon you are using has not implemented resourceExists()");
    }

    protected ProxyInfo getProxyInfo(String protocol, String host) {
        ProxyInfo proxyInfo;
        if (this.proxyInfoProvider != null && !ProxyUtils.validateNonProxyHosts(proxyInfo = this.proxyInfoProvider.getProxyInfo(protocol), host)) {
            return proxyInfo;
        }
        return null;
    }

    public RepositoryPermissions getPermissionsOverride() {
        return this.permissionsOverride;
    }

    public void setPermissionsOverride(RepositoryPermissions permissionsOverride) {
        this.permissionsOverride = permissionsOverride;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }
}

