/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.List;
import java.util.Random;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.loadbalancer.QueueLoadBalancer;

public class RandomLoadBalancer
extends QueueLoadBalancer {
    private static final Random RANDOM = new Random();
    private transient int index;

    @Override
    protected synchronized Processor chooseProcessor(List<Processor> processors, Exchange exchange) {
        int size2 = processors.size();
        if (size2 == 0) {
            return null;
        }
        if (size2 == 1) {
            return processors.get(0);
        }
        this.index = RANDOM.nextInt(size2);
        return processors.get(this.index);
    }

    public int getLastChosenProcessorIndex() {
        return this.index;
    }

    public String toString() {
        return "RandomLoadBalancer";
    }
}

