/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import com.sun.activation.registries.MailcapFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;
import javax.activation.SecuritySupport;

public class MailcapCommandMap
extends CommandMap {
    private static MailcapFile defDB = null;
    private MailcapFile[] DB;
    private static final int PROG = 0;
    private static boolean debug = false;
    static /* synthetic */ Class class$javax$activation$MailcapCommandMap;

    static {
        try {
            debug = Boolean.getBoolean("javax.activation.debug");
        }
        catch (Throwable throwable) {}
    }

    public MailcapCommandMap() {
        Object object;
        Vector<MailcapFile> vector = new Vector<MailcapFile>(5);
        MailcapFile mailcapFile = null;
        vector.addElement(null);
        if (debug) {
            System.out.println("MailcapCommandMap: load HOME");
        }
        try {
            String string;
            object = System.getProperty("user.home");
            if (object != null && (mailcapFile = this.loadFile(string = String.valueOf(object) + File.separator + ".mailcap")) != null) {
                vector.addElement(mailcapFile);
            }
        }
        catch (SecurityException securityException) {}
        if (debug) {
            System.out.println("MailcapCommandMap: load SYS");
        }
        try {
            object = String.valueOf(System.getProperty("java.home")) + File.separator + "lib" + File.separator + "mailcap";
            mailcapFile = this.loadFile((String)object);
            if (mailcapFile != null) {
                vector.addElement(mailcapFile);
            }
        }
        catch (SecurityException securityException) {}
        if (debug) {
            System.out.println("MailcapCommandMap: load JAR");
        }
        this.loadAllResources(vector, "META-INF/mailcap");
        if (debug) {
            System.out.println("MailcapCommandMap: load DEF");
        }
        object = class$javax$activation$MailcapCommandMap != null ? class$javax$activation$MailcapCommandMap : (class$javax$activation$MailcapCommandMap = MailcapCommandMap.class$("javax.activation.MailcapCommandMap"));
        synchronized (object) {
            if (defDB == null) {
                defDB = this.loadResource("/META-INF/mailcap.default");
            }
        }
        if (defDB != null) {
            vector.addElement(defDB);
        }
        this.DB = new MailcapFile[vector.size()];
        vector.copyInto(this.DB);
    }

    public MailcapCommandMap(InputStream inputStream) {
        block3: {
            this();
            if (debug) {
                System.out.println("MailcapCommandMap: load PROG");
            }
            if (this.DB[0] != null) break block3;
            try {
                this.DB[0] = new MailcapFile(inputStream);
            }
            catch (IOException iOException) {}
        }
    }

    public MailcapCommandMap(String string) throws IOException {
        this();
        if (debug) {
            System.out.println("MailcapCommandMap: load PROG from " + string);
        }
        if (this.DB[0] == null) {
            this.DB[0] = new MailcapFile(string);
        }
    }

    public synchronized void addMailcap(String string) {
        if (debug) {
            System.out.println("MailcapCommandMap: add to PROG");
        }
        if (this.DB[0] == null) {
            this.DB[0] = new MailcapFile();
        }
        this.DB[0].appendToMailcap(string);
    }

    private void appendCmdsToVector(Hashtable hashtable, Vector vector) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector2 = (Vector)hashtable.get(string);
            Enumeration enumeration2 = vector2.elements();
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                vector.insertElementAt(new CommandInfo(string, string2), 0);
            }
        }
    }

    private void appendPrefCmdsToVector(Hashtable hashtable, Vector vector) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.checkForVerb(vector, string)) continue;
            Vector vector2 = (Vector)hashtable.get(string);
            String string2 = (String)vector2.firstElement();
            vector.addElement(new CommandInfo(string, string2));
        }
    }

    private boolean checkForVerb(Vector vector, String string) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = ((CommandInfo)enumeration.nextElement()).getCommandName();
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public synchronized DataContentHandler createDataContentHandler(String string) {
        if (debug) {
            System.out.println("MailcapCommandMap: createDataContentHandler for " + string);
        }
        int n = 0;
        while (n < this.DB.length) {
            if (this.DB[n] != null) {
                Vector vector;
                Hashtable hashtable;
                if (debug) {
                    System.out.println("  search DB #" + n);
                }
                if ((hashtable = this.DB[n].getMailcapList(string)) != null && (vector = (Vector)hashtable.get("content-handler")) != null) {
                    if (debug) {
                        System.out.println("    got content-handler");
                    }
                    try {
                        if (debug) {
                            System.out.println("      class " + (String)vector.firstElement());
                        }
                        return (DataContentHandler)Class.forName((String)vector.firstElement()).newInstance();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {}
                }
            }
            ++n;
        }
        return null;
    }

    public synchronized CommandInfo[] getAllCommands(String string) {
        Object object;
        Vector vector = new Vector();
        int n = 0;
        while (n < this.DB.length) {
            if (this.DB[n] != null && (object = this.DB[n].getMailcapList(string)) != null) {
                this.appendCmdsToVector((Hashtable)object, vector);
            }
            ++n;
        }
        object = new CommandInfo[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public synchronized CommandInfo getCommand(String string, String string2) {
        int n = 0;
        while (n < this.DB.length) {
            String string3;
            Vector vector;
            Hashtable hashtable;
            if (this.DB[n] != null && (hashtable = this.DB[n].getMailcapList(string)) != null && (vector = (Vector)hashtable.get(string2)) != null && (string3 = (String)vector.firstElement()) != null) {
                return new CommandInfo(string2, string3);
            }
            ++n;
        }
        return null;
    }

    public synchronized CommandInfo[] getPreferredCommands(String string) {
        Object object;
        Vector vector = new Vector();
        int n = 0;
        while (n < this.DB.length) {
            if (this.DB[n] != null && (object = this.DB[n].getMailcapList(string)) != null) {
                this.appendPrefCmdsToVector((Hashtable)object, vector);
            }
            ++n;
        }
        object = new CommandInfo[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    private void loadAllResources(Vector vector, String string) {
        Object object;
        boolean bl;
        block24: {
            bl = false;
            try {
                ClassLoader classLoader = null;
                classLoader = SecuritySupport.getInstance().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                if ((object = classLoader != null ? SecuritySupport.getInstance().getResources(classLoader, string) : SecuritySupport.getInstance().getSystemResources(string)) == null) break block24;
                if (debug) {
                    MailcapCommandMap.pr("MailcapCommandMap: getResources");
                }
                int n = 0;
                while (n < ((URL[])object).length) {
                    Object var10_10;
                    URL uRL = object[n];
                    InputStream inputStream = null;
                    if (debug) {
                        MailcapCommandMap.pr("MailcapCommandMap: URL " + uRL);
                    }
                    try {
                        block25: {
                            try {
                                inputStream = SecuritySupport.getInstance().openStream(uRL);
                                if (inputStream != null) {
                                    vector.addElement(new MailcapFile(inputStream));
                                    bl = true;
                                    if (debug) {
                                        MailcapCommandMap.pr("MailcapCommandMap: successfully loaded mailcap file from URL: " + uRL);
                                    }
                                } else if (debug) {
                                    MailcapCommandMap.pr("MailcapCommandMap: not loading mailcap file from URL: " + uRL);
                                }
                            }
                            catch (IOException iOException) {
                                if (debug) {
                                    MailcapCommandMap.pr("MailcapCommandMap: " + iOException);
                                }
                            }
                            catch (SecurityException securityException) {
                                if (!debug) break block25;
                                MailcapCommandMap.pr("MailcapCommandMap: " + securityException);
                            }
                        }
                        var10_10 = null;
                    }
                    catch (Throwable throwable) {
                        var10_10 = null;
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    ++n;
                }
            }
            catch (Exception exception) {
                if (!debug) break block24;
                MailcapCommandMap.pr("MailcapCommandMap: " + exception);
            }
        }
        if (!bl) {
            if (debug) {
                MailcapCommandMap.pr("MailcapCommandMap: !anyLoaded");
            }
            if ((object = this.loadResource("/" + string)) != null) {
                vector.addElement(object);
            }
        }
    }

    private MailcapFile loadFile(String string) {
        MailcapFile mailcapFile = null;
        try {
            mailcapFile = new MailcapFile(string);
        }
        catch (IOException iOException) {}
        return mailcapFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MailcapFile loadResource(String string) {
        InputStream inputStream;
        block15: {
            MailcapFile mailcapFile;
            block14: {
                inputStream = null;
                try {
                    try {
                        inputStream = SecuritySupport.getInstance().getResourceAsStream(this.getClass(), string);
                        if (inputStream != null) {
                            MailcapFile mailcapFile2 = new MailcapFile(inputStream);
                            if (debug) {
                                MailcapCommandMap.pr("MailcapCommandMap: successfully loaded mailcap file: " + string);
                            }
                            mailcapFile = mailcapFile2;
                            Object var5_7 = null;
                            break block14;
                        }
                        if (debug) {
                            MailcapCommandMap.pr("MailcapCommandMap: not loading mailcap file: " + string);
                        }
                        break block15;
                    }
                    catch (IOException iOException) {
                        if (debug) {
                            MailcapCommandMap.pr("MailcapCommandMap: " + iOException);
                        }
                        break block15;
                    }
                    catch (SecurityException securityException) {
                        if (debug) {
                            MailcapCommandMap.pr("MailcapCommandMap: " + securityException);
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    try {
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {}
            catch (IOException iOException) {}
            if (inputStream == null) return mailcapFile;
            inputStream.close();
            return mailcapFile;
        }
        Object var5_8 = null;
        try {}
        catch (IOException iOException) {
            return null;
        }
        if (inputStream == null) return null;
        inputStream.close();
        return null;
    }

    private static final void pr(String string) {
        System.out.println(string);
    }
}

