// Coordinates: 0.138050, -50.466245
// Map Width: 200km

RMS.LoadLibrary("rmgen");
RMS.LoadLibrary("rmgen2");

InitMap();

log("Initializing tile classes...");
setBiome(7);
initMapSettings();
initTileClasses();

log("Initializing environment...");
setSunColor(0.733, 0.746, 0.574);

setWaterTint(0.576, 0.541, 0.322);
setWaterColor(0.521, 0.475, 0.322);
setWaterWaviness(8);
setWaterMurkiness(0.87);
setWaterType("lake");

setTerrainAmbientColor(0.521, 0.475, 0.322);

setSunRotation(-1 * PI);
setSunElevation(PI / 6.25);

setFogFactor(0);
setFogThickness(0);
setFogColor(0.69, 0.616, 0.541);

setPPEffect("hdr");
setPPContrast(0.67);
setPPSaturation(0.42);
setPPBloom(0.23);

log("Initializing biome...");
g_Terrains.mainTerrain = "tropic_dirt_a_plants";
g_Terrains.forestFloor1 = "tropic_grass_c";
g_Terrains.forestFloor2 = "tropic_grass_c";
g_Terrains.tier1Terrain = "tropic_dirt_a";
g_Terrains.tier2Terrain = "tropic_plants";
g_Terrains.tier3Terrain = "tropic_grass_plants";
g_Terrains.tier4Terrain = "tropic_dirt_a_plants";
g_Terrains.roadWild = "road_rome_a";
g_Terrains.road = "road_stones";
g_Gaia.mainHuntableAnimal = "gaia/fauna_peacock";
g_Gaia.secondaryHuntableAnimal =  "gaia/fauna_crocodile";
g_Gaia.fish = "gaia/fauna_fish_tilapia";
g_Gaia.tree1 = "gaia/flora_tree_palm_tropical";
g_Gaia.tree2 = "gaia/flora_tree_date_palm";
g_Gaia.tree3 = "gaia/flora_tree_date_palm";
g_Gaia.tree4 = "gaia/flora_tree_palm_tropical";
g_Gaia.tree5 = "gaia/flora_tree_date_palm";
g_Gaia.fruitBush = "gaia/flora_bush_berry";
g_Decoratives.grass = "actor|props/flora/grass_tropical.xml";
g_Decoratives.grassShort = "actor|props/flora/grass_soft_tuft_a.xml";
g_Decoratives.rockLarge = "actor|geology/stone_savanna_med.xml";
g_Decoratives.rockMedium = "actor|geology/stone_savanna_med.xml";
g_Decoratives.bushMedium = "actor|props/flora/bush_tropic_a.xml";
g_Decoratives.bushSmall = "actor|props/flora/bush_tropic_b.xml";
initBiome();
RMS.SetProgress(5);

log("Resetting terrain...");
resetTerrain(g_Terrains.mainTerrain, g_TileClasses.land, 1);
RMS.SetProgress(10);

log("Copying heightmap...");
var scale = paintHeightmap(getHeightMap(), getTileMap(), getTilePallet());
RMS.SetProgress(30);

log("Paint tile classes...");
paintTileClassBasedOnHeight(-100, -1, 3, g_TileClasses.water);
RMS.SetProgress(40);

log("Placing players...");
//Coordinate system of the heightmap
var singleBases = [
	[90, 115],
	[240, 157],
	[35, 155],
	[140, 25],
	[260, 75],
	[160, 285],
	[105, 220],
	[185, 90]
];
var strongholdBases = [
	[80, 240],
	[190, 60]
];
randomPlayerPlacementAt(singleBases, strongholdBases, scale, 0.06);
RMS.SetProgress(50);

addElements([
	{
		"func": addLayeredPatches,
		"avoid": [
			g_TileClasses.bluff, 2,
			g_TileClasses.dirt, 5,
			g_TileClasses.forest, 2,
			g_TileClasses.mountain, 2,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 12,
			g_TileClasses.water, 3
		],
		"sizes": ["normal"],
		"mixes": ["normal"],
		"amounts": ["many"]
	},
	{
		"func": addDecoration,
		"avoid": [
			g_TileClasses.bluff, 2,
			g_TileClasses.forest, 2,
			g_TileClasses.mountain, 2,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 12,
			g_TileClasses.water, 3
		],
		"sizes": ["normal"],
		"mixes": ["normal"],
		"amounts": ["many"]
	}
]);

RMS.SetProgress(60);

addElements(shuffleArray([
	{
		"func": addMetal,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 2,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 10,
			g_TileClasses.metal, 20,
			g_TileClasses.water, 3
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["normal", "many"]
	},
	{
		"func": addStone,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 2,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 20,
			g_TileClasses.metal, 10,
			g_TileClasses.water, 3
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["normal", "many"]
	},
	{
		"func": addForests,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 18,
			g_TileClasses.metal, 3,
			g_TileClasses.mountain, 5,
			g_TileClasses.plateau, 5,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 3,
			g_TileClasses.water, 2
		],
		"sizes": ["normal"],
		"mixes": ["similar"],
		"amounts": ["tons"]
	}
]));
RMS.SetProgress(70);

addElements(shuffleArray([
	{
		"func": addBerries,
		"avoid": [
			g_TileClasses.berries, 30,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 5,
			g_TileClasses.metal, 10,
			g_TileClasses.mountain, 2,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 10,
			g_TileClasses.water, 3
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["normal", "many"]
	},
	{
		"func": addAnimals,
		"avoid": [
			g_TileClasses.animals, 20,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 2,
			g_TileClasses.metal, 2,
			g_TileClasses.mountain, 1,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 2,
			g_TileClasses.water, 3
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["many"]
	},
	{
		"func": addFish,
		"avoid": [
			g_TileClasses.fish, 12,
			g_TileClasses.player, 8
		],
		"stay": [g_TileClasses.water, 4],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["many"]
	},
	{
		"func": addStragglerTrees,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 7,
			g_TileClasses.metal, 2,
			g_TileClasses.mountain, 1,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 12,
			g_TileClasses.rock, 2,
			g_TileClasses.water, 5
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["many"]
	}
]));
RMS.SetProgress(80);

log("Adding lillies...");
createObjectGroups(
	new SimpleGroup(
		[
			new SimpleObject(g_Decoratives.lillies, 5, 12, 1, 4),
			new SimpleObject(g_Decoratives.rockMedium, 1, 2, 1, 5)
		],
		true,
		g_TileClasses.dirt
	),
	0,
	[
		stayClasses(g_TileClasses.water, 1),
		borderClasses(g_TileClasses.water, scaleByMapSize(2,8), scaleByMapSize(2,5))
	],
	scaleByMapSize(100, 5000),
	500
);
RMS.SetProgress(90);

ExportMap();

function getHeightMap()
{
	return [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1,-2,-1,1,1,0,0,0,0,0,1,-1,-1,-2,-2,-1,1,1,1,1,1,1,0,0,0,0,1,-1,-2,-2,-3,-3,-3,-3,-3,-3,-1,-1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,3,2,2,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,5,4,4,4,4,5,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1,-1,-1,-1,1,0,0,0,0,0,1,1,-1,-2,-1.90,-0.88,0.75,0.75,0.96,0.99,1,1,0,0,0,0,1,-1,-1,-2,-3,-3,-3,-3,-3,-2,-1,1,1,-1,1,1,0.87,0.75,0.87,0.87,0.75,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,6,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.75,-0.63,-1.50,-0.50,0.50,0.21,0,0,0,0,0,1,-0.68,-1.63,-1.54,-1.15,-0.67,0.62,0.87,0.97,1,1,0,0,0,0,1,1,-1,-1,-2,-3,-1,-1,-1,-1,-1,1,1,-1,-1,-1.50,-1.38,1.09,0.25,0.25,0.37,0.37,0.37,0.22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,2,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,4,4,5,4,4,4,5,7,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,5,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.50,-0.38,-0.63,-0.29,0.35,0.25,0,0,0,0,0,0.63,-0.25,-0.92,-1.50,-1.67,-0.75,0.62,0.71,0.95,1,1,0,0,0,0,0,1,1,-1,-2,-2,-1,1,1,1,1,1,1,1,-1,-1.53,-1.40,-1.30,-0.42,-0.40,-0.25,-0.02,0.12,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,2,2,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,4,4,4,5,5,6,6,6,5,5,5,5,5,5,5,5,5,5,4,5,5,5,6,5,5,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.33,0.25,-0.13,-0.29,-0.14,0.09,0.21,0.07,0,0,0,0,0.62,0.25,-0.63,-1.50,-1.67,-1.13,-0.63,0.62,0.87,1,1,0,0,0,0,0,0,1,-1,-1,-2,-1,-1,1,0,0,0,0,1,1,1.45,-1.28,-1.25,-0.88,-0.88,-0.67,-0.50,-0.14,0.12,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,4,4,4,4,5,5,5,5,5,5,5,4,4,4,5,5,5,4,4,4,4,4,5,6,5,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.21,-0.13,-0.14,-0.13,0.07,0.12,0.12,0,0,0,0,0.32,0.58,-0.38,-1.26,-1.50,-1.50,-0.75,0.62,0.75,1,1,0,0,0,0,0,0,1,1,-1,-1,-1,-1,1,1,1,0,0,0,0,1,0.75,-0.68,-0.42,-0.63,-0.88,-0.65,-0.40,-0.14,0.12,0.32,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,2,1,1,1,1,0,0,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,4,4,4,4,4,4,5,4,4,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.34,0.33,0,-0.13,-0.13,0,0.21,0.12,0,0,0,0,0,0.87,-0.40,-1,-1.50,-3.18,-2.77,-0.75,0.87,1,1,0,0,0,0,0,0,0,1,1,-1,1,-1,-1,-1,1,1,0,0,0,0,0.87,0.75,0.12,-0.27,-0.66,-0.75,-0.64,-0.50,-0.14,0.12,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,2,2,3,2,3,2,2,2,2,2,2,2,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,4,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.50,0.09,-0.01,-0.13,-0.05,0.25,0.83,1,0,0,0,0,0.87,0.37,-0.75,-3.16,-6,-6,-2.53,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,-1,-1,1,1,1,0,0,0,0,0.37,0.20,-0.25,-0.51,-0.88,-0.88,-0.65,-0.38,0,0.25,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,2,2,2,3,2,2,3,3,3,3,4,3,3,3,3,3,4,4,4,4,4,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.21,0.50,0,-0.28,-0.28,-0.15,0.12,0.50,0,0,0,0,0.11,0.73,-0.66,-4.25,-7,-8,-3.68,-1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,-1,-1,1,1,0,0,0,0,0.96,0.87,-0.14,-0.75,-1.13,-1.25,-0.79,-0.41,0.08,0.33,0.34,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.12,-0.13,-0.38,-0.67,-0.25,0,0,0,0,0,0.09,0.75,-0.75,-2.62,-6,-7,-3.65,-1,0.11,0.37,0.33,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1,-1,-1,1,0,0,0,0,0,1,0.25,-0.50,-1.05,-1.50,-1.38,-1.02,-0.50,-0.27,-0.03,0.12,0.25,0.22,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,0,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,4,3,3,4,3,3,3,3,3,4,4,4,4,3,3,4,4,4,3,3,4,4,4,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.32,0.12,-0.29,-0.64,-0.38,-0.13,0,0,0,0,0.25,0.21,-0.26,-1.30,-3.77,-6,-4.75,-2.25,-0.26,0.25,0.37,0.12,0,0,0,0,0,0,0,0,0,0,0,0,1,-1,-1,-1,1,1,1,1,1,1,1,0.50,0,-0.88,-1.75,-2,-2,-1.40,-1,-0.63,-0.28,0.10,0.25,0.37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,2,2,3,3,3,4,3,3,3,4,4,3,3,3,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.22,0.22,-0.05,-0.28,-0.25,-0.13,0,0,0,0,0.12,0.25,-0.13,-1,-3.50,-5.89,-5.88,-3.54,-0.92,-0.05,0.25,0.20,0,0,0,0,0,0,0,0,0,0,0,0,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,-1,-2.12,-2.55,-3.50,-3.25,-2.63,-2.17,-0.93,-0.39,-0.25,0.12,0.36,0.33,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.21,0.36,0,-0.17,-0.15,0.08,0,0,0,0,0.12,0.36,0,-0.76,-2.66,-5.03,-6,-3.93,-1.50,-0.28,0.25,0.37,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2.12,-3.64,-5,-5.66,-5.17,-4.74,-3.13,-2.25,-1.39,-0.80,-0.38,-0.13,0.26,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,2,3,2,2,2,2,2,2,2,2,2,2,2,2,3,3,2,2,3,3,3,3,3,3,4,3,3,3,3,3,3,3,3,3,3,3,4,4,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.25,0,-0.25,-0.25,0.33,1,0,0,0,0,0.25,-0.13,-0.76,-1.92,-4.17,-5.38,-5.18,-3.55,-0.92,-0.05,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,-1,-1,-0.55,-0.79,-1.26,-2,-3.90,-4.92,-5.75,-6,-5.55,-4.78,-4.12,-3.25,-2.24,-1.36,-0.67,-0.28,0.12,0.12,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2,3,3,3,3,2,3,3,3,3,4,3,3,3,3,3,3,3,3,3,4,4,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.75,-0.26,-0.54,-0.54,-0.17,0.12,0.25,0,0,0,0.25,-0.13,-0.75,-1.54,-3.13,-5.25,-6,-4.76,-2.25,-0.28,0.50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,-0.25,-0.50,-0.91,-1.88,-2,-3.74,-3.90,-4.53,-5.37,-5.99,-6,-5.25,-4.25,-3.05,-2.05,-1.14,-0.50,0.22,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,3,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.87,0.85,-0.41,-0.90,-0.88,-0.63,-0.26,0,0.60,0,0.12,0.25,0.20,-0.38,-1.26,-2.05,-4.18,-6,-6,-3.64,-1,0.97,0.99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.07,-0.14,-0.66,-1,-1.38,-2,-3,-4.38,-5.92,-7,-7,-5.74,-4.50,-3.38,-2.13,-1.13,-0.38,0.12,0.12,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,2,2,2,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.62,-0.75,-0.88,-1.13,-1.14,-0.90,-0.54,-0.17,0.21,1,0,0,0.35,-0.15,-1,-1.88,-3.49,-6,-7,-5.68,-1.87,-0.63,0.25,0.37,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0.12,-0.25,-0.65,-1.05,-1.53,-3.15,-4.75,-5.90,-6,-6,-5.41,-4.63,-3.43,-2.15,-1.02,-0.14,0.09,0.12,0.12,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,2,2,1,1,1,1,1,1,1,2,2,2,2,2,2,3,2,2,3,2,2,2,2,2,2,2,2,2,2,2,2,3,2,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.01,0,0.09,0.25,0.25,-0.50,-0.63,-0.88,-1.13,-0.92,-0.75,-0.50,-0.17,0.50,1,0,0.37,-0.13,-0.77,-1.52,-3.12,-5.38,-6,-5.68,-2.76,-0.75,-0.03,0.37,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.36,0.12,-0.13,-0.50,-0.88,-1.87,-3.15,-4.38,-5.13,-5.50,-5.63,-5.41,-4.76,-3.50,-2.05,-0.75,-0.27,0,0.12,0.25,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,2,2,3,2,2,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.02,-0.02,0,0.12,0.25,0.22,-0.27,-0.55,-0.78,-0.75,-0.68,-0.63,-0.63,-0.15,1,0,0.37,-0.01,-0.63,-1.25,-1.79,-3.15,-4.25,-3.87,-1.88,-0.92,-0.28,0.21,0.37,0.25,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.12,-0.13,-0.38,-0.90,-1.54,-2.66,-3.49,-4.13,-4.88,-5.42,-5.53,-4.75,-3.30,-1.28,-0.75,-0.29,-0.01,0.12,0.25,0.32,0.24,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,2,2,2,2,2,3,3,3,3,2,2,2,2,2,2,2,2,2,3,3,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.01,-0.02,-0.04,-0.13,-0.12,-0.02,0.12,0.49,0.09,-0.14,-0.38,-0.41,-0.50,-0.63,-0.75,-0.53,1,1,0.37,0.12,-0.38,-1,-1.50,-1.75,-1.88,-2,-1.18,-0.88,-0.50,-0.26,0,0.12,0.12,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.12,-0.15,-0.65,-1.38,-2,-2.63,-3.41,-4.39,-5.25,-5.25,-4.25,-2.61,-1.02,-0.50,-0.13,0.07,0.08,0.07,0.10,0.12,0.12,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,2,1,1,1,1,2,3,2,2,2,3,3,3,2,2,2,2,2,3,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.01,-0.03,-0.05,-0.12,-0.25,-0.25,-0.25,0.50,0.59,0.25,0.12,0.08,-0.18,-0.50,-0.67,-0.75,-0.25,0.32,0.37,0.12,-0.28,-0.75,-1.05,-1.14,-1,-1,-0.88,-0.14,-0.67,-0.66,-0.25,0,0.12,0.11,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.01,-0.50,-0.88,-1.37,-1.99,-2.78,-4,-4.86,-4.75,-3.66,-1.13,-0.26,0.09,0,-0.04,-0.13,-0.13,0,0.25,0.37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.01,-0.02,-0.04,-0.12,0.12,0.12,0.25,-0.13,-0.03,0.07,0.35,0.37,0.22,-0.17,-0.63,-0.75,-0.65,-0.01,0.37,0.20,-0.25,-0.65,-0.88,-0.75,-0.43,0.46,-0.13,-0.38,-0.42,-0.88,-0.50,-0.25,0,0.12,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,-0.25,-0.42,-0.79,-1.38,-2.01,-3.89,-5.51,-4.75,-1.88,0.87,0.23,0.12,-0.13,-0.30,-0.38,-0.26,-0.13,0.24,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.01,-0.13,-0.13,-0.13,-0.13,0,-0.13,-0.04,0,0.20,0.21,0,-0.25,-0.50,-0.63,-0.13,0.37,0.12,-0.26,-0.75,-0.90,-0.63,-0.25,0,0.12,0,-0.16,-0.54,-0.50,-0.39,-0.17,0.10,0.12,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.08,0.12,-0.29,-1,-2.90,-4.93,-4.93,-1.90,-1,0,0.12,-0.25,-0.50,-0.63,-0.65,-0.50,-0.13,0.12,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,2,2,2,2,2,2,2,2,2,2,2,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.03,-0.13,-0.13,-0.25,-0.25,-0.29,-0.13,0,-0.05,0,0.10,0,0.33,0.25,-0.16,-0.50,-0.40,0.11,-0.05,-0.50,-1.01,-1.13,-0.75,-0.29,0.09,0.25,0.36,0.25,0,-0.39,-0.53,-0.41,-0.13,0.12,0.20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.46,0.11,-0.42,-1.30,-2.88,-3.13,-2.17,-1,-0.88,-0.38,-0.52,-0.75,-0.88,-1,-0.68,-0.50,-0.13,0.12,0.37,0.32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,2,2,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.12,-0.13,-0.13,-0.18,-0.27,-0.37,-0.38,-0.13,0.10,0,0,0,0.07,0.22,0.50,0.20,-0.25,-0.63,-0.38,-0.50,-0.88,-1.38,-1.50,-1.13,-0.63,0.38,0.22,0.49,0.33,0.35,-0.26,-0.63,-0.75,-0.50,0,0.50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.82,0,-0.50,-1,-1.25,-1,-2,-2,-1,-1.13,-1.25,-1.25,-1,-0.76,-0.63,-0.43,-0.25,0,0.22,0.32,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,1,1,2,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,2,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.02,-0.13,-0.13,-0.13,-0.15,-0.25,-0.27,-0.38,-0.28,-0.13,0.12,0.12,0,0,0,0,0.32,0.12,-0.14,-0.75,-0.88,-0.93,-1.28,-1.66,-1.88,-1.75,-1.13,-0.79,-0.88,0.85,0.10,0.25,-0.15,-0.88,-1.25,-1,-0.42,0.99,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,-0.13,-0.38,-0.63,-1.03,-2,-2,-2,-2,-1.88,-1.80,-1.25,-0.50,-0.88,-0.86,-0.64,-0.41,-0.13,0.12,0.24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,1,2,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.03,-0.13,-0.14,-0.15,-0.16,-0.18,-0.25,-0.25,-0.17,-0.02,0.24,0.12,0,0,0,0,0,1,-0.28,-0.88,-1.16,-1.38,-1.63,-2.01,-4.25,-4,-1.88,-1.13,-0.16,0.22,0.62,0.37,-0.13,-0.67,-1,-1.13,-0.88,-0.38,0.22,0.37,0.33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.01,-0.38,-0.67,-1.14,-2,-2,-1.88,-1.88,-1.89,-1.37,-1.55,-1.39,-1.25,-1.01,-0.88,-0.63,-0.25,0.22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0,-0.13,-0.17,-0.25,-0.16,-0.14,-0.13,-0.04,0,0.12,0.25,0.12,0,0,0,0,0,1,0.25,-0.27,-0.75,-1.17,-1.66,-3.88,-6,-6,-3.88,-1.29,-0.25,0.25,0.60,0.37,0.75,0.63,-0.38,-0.75,-1,-1,-0.50,0.22,0.37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,-0.13,-0.38,-0.63,-0.75,-1,-1.24,-2,-2.38,-2.88,-2.75,-2.25,-1.65,-1.25,-1.13,-0.91,-0.50,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,2,2,2,-1,1,1,0,0.10,0.12,0,0,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.21,-0.16,-0.38,-0.25,-0.16,-0.13,0,0.08,0.12,0.23,0.25,0.23,0.12,0.10,0,0,0,0,0.47,0.23,-0.04,-0.79,-1.51,-3.88,-6,-6,-4.13,-1.50,-0.54,0.12,0.37,0.37,0.46,0.62,0.22,-0.38,-0.79,-1.38,-1,-0.50,0.22,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.13,-0.17,-0.17,-0.40,-1.25,-2.13,-3.50,-4.53,-4.53,-3.29,-1.75,-1.14,-1.04,-0.90,-0.63,-0.25,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,1,2,2,-1,-1,1,0.87,0.83,0.23,0.25,0.32,0.24,0.12,0.12,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.22,-0.50,-0.38,-0.29,-0.15,-0.03,0.08,0.24,0.25,0.23,0.21,0.22,0.32,0.25,0.12,0,0,0,0.22,0.49,0.33,-0.25,-1.25,-2,-4.27,-5.38,-4.30,-2.75,-0.90,0,0.36,0.25,0.12,0.25,0.33,0,-0.50,-1,-1.25,-0.78,-0.29,0.74,0.75,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.01,-0.04,-0.14,-0.50,-1.25,-2.25,-3.50,-4.53,-4.15,-2.63,-1.37,-0.88,-0.50,-0.29,-0.13,-0.53,-1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,-2,-1,-0.93,-0.88,0.38,0.34,0.25,0.48,0.37,0.25,0.21,0.12,0.10,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.21,0.34,0,-0.18,-0.15,-0.13,0,0.12,0.25,0.12,0.09,0.07,0,0.25,0.47,0.25,0,0,0,0,0,0.87,0.85,-0.88,-1.88,-3.40,-5.54,-6,-4.89,-2.13,-0.18,0.20,0.25,0,0,0,0.37,0.22,-0.50,-0.78,-1.02,-0.75,-0.63,0.62,0.22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.03,-0.38,-1.14,-2,-2.91,-3.50,-3,-1.88,-0.93,-0.54,-0.13,0.10,0.75,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,0,0,0,0,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,-2,-2,-1.89,-1.18,-0.78,-0.50,-0.38,-0.38,0.23,0.22,0.24,0.20,0.12,0.12,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.24,0.12,0.08,0,0,0.11,0.20,0.10,0,-0.04,-0.13,-0.13,-0.66,0.37,0.33,0.08,0,0,0,0.12,0.12,0.75,-0.80,-1.63,-3.18,-5.54,-6,-5.13,-2.38,-0.38,0.25,0.49,0.21,0,0,0.33,0.37,0,-0.25,-0.63,-1.15,-0.63,0.62,0.74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,-0.25,-0.88,-1.77,-2.05,-2.67,-2.04,-1.50,-0.90,-0.38,0.10,0.32,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,-2,-2,-1.88,-1.77,-1.13,-0.88,-0.78,-0.76,-0.39,0.09,0.10,0.12,0.12,0.12,0.12,0.11,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.20,0.25,0.22,0.12,0.12,0.21,0.10,-0.13,-0.25,-0.30,-0.38,-0.67,-0.75,0.25,0.25,0.12,0,0,0,0,0.23,0.75,-0.88,-1.25,-1.93,-3.40,-4.75,-3.55,-1.88,-0.75,-0.13,0.48,0.22,0,0,0,0,0.62,0.25,-0.26,-0.75,-0.75,-0.26,0.21,0.37,0.33,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.63,-0.38,-0.91,-1.25,-1,-1.43,-1.28,-0.90,-0.38,0.11,0.35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,1,2,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,2,2,1,1,1,1,-1,-1,-0.88,-0.76,-0.63,-0.54,-0.66,-0.88,-0.76,-0.50,-0.17,0,0.12,0.12,0.12,0.12,0.12,0.11,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.12,0.20,0.21,0.12,0.12,-0.01,-0.25,-0.38,-0.38,-0.50,-0.63,-0.88,0.25,0.32,0.24,0.10,0,0,0,0.25,0.71,0.62,-0.53,-1.25,-2.13,-2.86,-3,-2.25,-1.25,-0.50,-0.01,0.37,0,0,0,0,0.25,0.37,0,-0.37,-0.63,-0.75,-0.38,0.12,0.33,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.62,0.08,-0.37,-0.50,-0.42,-1.13,-1.38,-1.05,-0.50,0,0.22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,1,1,2,1,-1,1,0.85,0.75,0.33,-0.13,-0.39,-0.63,-1.05,-0.88,-0.40,-0.25,-0.13,0,0.10,0.12,0.20,0.12,0.12,0.08,0.07,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.12,0.12,0.12,0.10,-0.03,-0.13,-0.25,-0.39,-0.38,-0.38,-0.55,-0.66,-0.02,0.10,0.24,0.10,0,0,0,0.12,0.37,0.50,0.35,-0.55,-1.49,-2.30,-2.80,-2.49,-1.67,-1.13,-0.50,0.62,0.98,0,0,0,0,0.25,0.25,-0.01,-0.52,-1.25,-1,-0.50,0.07,0.25,0.25,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.63,0.12,-0.12,-0.25,-0.38,-1.13,-1.39,-1.16,-0.53,-0.01,0.12,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,2,1,1,1,1,1,1,0.12,0.23,0.71,0.13,-0.05,-0.28,-0.50,-0.50,-0.50,-0.50,-0.41,-0.29,-0.14,0,0.12,0.24,0.22,0.22,0.12,0.12,0.12,0.12,0.12,0.12,0.12,0.12,0.10,0.07,0,0,0,0,0.10,0.12,0.12,0.12,0.10,-0.04,-0.16,-0.25,-0.25,-0.25,-0.25,-0.18,-0.37,-0.53,-0.50,-0.12,0.20,0,-0.03,0,0.08,0.12,0.25,0.37,0.46,0.25,-0.54,-1.49,-2.12,-2.18,-2.15,-1.77,-1.18,-0.88,0.87,0.87,0.12,0.12,0,0.23,0.34,0.21,-0.41,-1.04,-1.13,-1,-0.63,-0.25,0.12,0.34,0.32,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0,-0.25,-0.26,-1.13,-1.75,-1.80,-0.63,0.75,0.25,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.07,0.20,0.23,0.25,0.37,0.37,0.25,0.12,-0.01,-0.15,-0.38,-0.75,-0.75,-0.66,-0.54,-0.38,0.11,0.12,0.12,0.33,0.25,0.23,0.21,0.12,0.20,0.21,0.23,0.25,0.23,0.12,0.07,0,0,0.07,0.12,0.12,0.10,0,-0.13,-0.38,-0.30,-0.26,-0.25,-0.13,-0.05,0.10,-0.13,-0.29,-0.50,-0.53,0.09,0.12,0.10,0.12,0.33,0.25,0.25,0.35,0.46,0.37,0.48,-0.63,-1.38,-2.13,-2.63,-2.65,-2,-1.25,-0.76,0.75,0.75,0.25,0.23,0.25,0.37,0.50,-0.63,-0.88,-1.16,-1.41,-1.16,-0.88,-0.38,0.12,0.37,0.33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.13,-0.25,-0.65,-1.53,-2.15,-2.25,-0.76,0.70,0.25,0.23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0.12,0.12,0.25,0.25,0.32,0.25,0.22,0.07,-0.18,-0.51,-0.79,-1,-1.05,-0.93,-0.75,-0.50,0.07,0.12,0.12,0.12,0.10,0.12,0.10,0.08,0.10,0.21,0.25,0.23,0.10,0,0,0.08,0.12,0.12,0.08,0,-0.25,-0.42,-0.50,-0.28,-0.13,-0.01,0.12,0.25,0.10,-0.13,-0.42,-0.88,-0.30,-0.25,-0.13,0.34,0.49,0.37,0.37,0.37,0.37,0.57,0.50,0.59,-0.78,-1.63,-2,-2.65,-2.75,-1.91,-1.25,-0.63,0.22,0.25,0.25,0.37,0.37,0.37,0.37,-0.38,-0.90,-1.50,-1.88,-1.65,-1.13,-0.39,0.21,0.37,0,0,0.09,0,0.12,0.24,0.25,0.25,0.24,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.71,-0.64,-1.14,-1.88,-2.63,-2.63,-1.13,0.62,0.71,0.75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0.08,0.12,0.12,0.24,0.25,0.25,0.25,0.12,-0.01,-0.25,-0.76,-1.25,-1.54,-3.53,-3.40,-1.25,-1,-0.64,-0.52,-0.43,-0.13,-0.02,-0.30,-0.28,-0.14,-0.03,0.25,0.25,0.12,0,0,0.08,0.12,0.12,0.07,-0.01,-0.25,-0.51,-0.50,-0.26,0,0.12,0.20,0.25,0.12,0.07,-0.18,-0.92,-0.75,-0.63,-0.54,-0.88,-0.66,0,0.12,0.25,0.48,0.37,0.37,0.58,-0.65,-1,-1.25,-1.38,-2.68,-2.63,-1.63,-1.13,-0.68,-0.38,-0.13,0.22,0.36,0.50,0.50,0.45,-0.75,-1.50,-2.25,-2.28,-1.88,-1.26,-0.50,0,1,1,0.12,0.12,0.25,0.24,0.13,0.37,0.37,0.35,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1,-2,-2,-2.88,-2.75,-1.27,-0.92,-0.13,0.25,0.36,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.11,0.11,0.12,0.12,0.12,0.12,0.22,0.24,0.23,0.12,0.08,-0.25,-0.75,-1.41,-4.05,-6,-6,-4.05,-1.75,-1.52,-1.38,-1.13,-0.93,-0.88,-0.88,-0.88,-0.40,-0.01,0.20,0.23,0.11,0,0,0.09,0.12,0.12,0.08,-0.13,-0.38,-0.50,-0.42,-0.04,0.12,0.12,0.12,0.09,0.08,0.11,0.25,-1,-0.75,-0.63,-0.63,-0.79,-0.64,-0.29,0,0.24,0.50,0.37,-0.50,-0.63,-0.63,-0.63,0.61,-0.89,-1.68,-1.75,-1.63,-1.50,-1.38,-1,-0.67,-0.30,0.09,0.37,0.62,0.20,-0.50,-1.28,-1.89,-2.15,-2.13,-1.91,-1.38,-0.75,-0.25,0.12,0.20,0.25,0.13,0.37,-0.38,-0.63,0.25,0.33,0.21,0.34,0.24,0.12,0.09,0,0,0,0,0,0,0,0,0,0,0,1,-1,-2,-2,-3,-2.90,-2.88,-1.75,-0.88,-0.04,0.37,0.37,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.21,0.12,0.12,0.12,0.12,0.12,0.12,0.12,0.12,0.12,0,-0.25,-0.76,-1.41,-4.03,-6,-6,-6,-4.86,-2.14,-3,-2.75,-1.63,-1.52,-1.38,-1.02,-0.50,0,0.23,0.22,0.11,0.07,0.07,0.10,0.12,0.12,0.09,-0.15,-0.41,-0.39,-0.25,0,0.12,0.12,0.10,0,0,0.08,0.47,0.37,0.32,0.25,0.35,0.37,-0.63,-0.18,-0.02,0.25,0.57,0.37,-0.50,-0.63,-0.63,0.60,0.62,-0.65,-0.75,-0.88,-1.13,-1.41,-1.53,-1.50,-1.38,-0.92,-0.51,-0.13,0.37,0.25,-0.40,-1.02,-1.63,-2.13,-3.03,-4.02,-3.77,-2.38,-0.91,-0.16,0,0.12,0.12,-0.25,-0.41,-0.63,-0.17,-0.15,0.12,0.12,0.22,0.60,0.25,0.12,0,0,0,0,0,0,0,0,0,0,1,-0.75,-1.01,-1.30,-2,-3,-3,-2.52,-1.66,-0.63,0.12,0.25,0.12,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.25,0.20,0.12,0.09,0.09,0.10,0.10,0.07,0,0,-0.13,-0.38,-0.75,-1.25,-1.67,-4.03,-6,-7,-10,-8,-6,-6,-3,-1.88,-1.65,-1.13,-0.51,-0.01,0.24,0.22,0.12,0.08,0.08,0.11,0.12,0.12,0.12,-0.01,-0.25,-0.27,-0.13,0.12,0.12,0.12,0,0,0,0,0,0,0,0.10,0.20,0.58,0.62,0.50,0.48,0.45,0.45,0.48,0.50,0.61,0.61,0.62,0.62,0.62,0.74,0.62,-0.43,-1,-1.42,-1.63,-1.63,-1.50,-1.17,-0.88,-0.28,0.21,0.12,-0.74,-1.75,-3.25,-4.88,-6,-6,-4.11,-2.13,-0.41,0,0.22,0.12,0.25,0.61,0.45,0.12,0.11,0,-0.12,-0.13,0.46,0.57,0.24,0,0,0,0,0,0,0,0,0,0,0.37,0,-0.04,-1.01,-2,-3,-3.14,-3.88,-3.38,-1.64,-0.88,-0.54,-0.25,0,0.45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.11,0.08,0,0,0,-0.01,-0.03,-0.13,-0.16,-0.25,-0.25,-0.50,-0.63,-0.79,-1.14,-1.66,-4.61,-10,-13,-13,-11,-8,-4.93,-1.88,-1.63,-1.03,-0.50,-0.04,0.24,0.12,0.12,0.09,0.10,0.12,0.12,0.12,0.12,0.12,0.09,0,0.12,0.21,0.12,0.11,0,0,0,0,0,-0.03,-0.04,-0.01,0.12,0.24,0.32,0.33,0.33,0.25,0.25,0.25,0.32,0.32,0.33,0.33,0.33,0.25,0.23,0.74,0.12,-0.43,-0.93,-1.38,-1.54,-1.75,-1.88,-1.77,-1.38,-0.88,-0.63,-0.49,-2.27,-4.01,-5.88,-7,-7,-5,-2.77,-0.38,0.34,0.62,0.47,0.33,0.32,0.35,0.35,0.25,0.10,-0.28,-0.38,-0.38,0.37,0.37,0.23,0.10,0.07,0,0,0,0,0,0,0,0.25,0.12,-0.18,-0.75,-1,-2,-3.90,-4.88,-4.75,-3.03,-1.63,-1.26,-0.88,-0.38,-0.03,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-0.13,0,0,0,-0.01,-0.13,-0.25,-0.38,-0.50,-0.51,-0.65,-0.75,-0.52,-0.13,-0.75,-1.13,-1.63,-6,-10,-12,-12,-7,-3.75,-1.43,-1.02,-0.68,-0.41,-0.17,0.07,0.12,0.12,0.12,0.11,0.12,0.12,0.21,0.22,0.23,0.23,0.23,0.23,0.21,0.12,0.12,0.09,0.07,0,0,0,0,0,0,0,0,0,0,0.11,0.10,0.08,0,0,0,0,0,0,0,0.12,0.12,0.35,0.11,-0.26,-0.76,-1.25,-1.75,-2.16,-2.38,-2.14,-2.67,-2.13,-2.42,-3.15,-4.74,-6,-7,-6,-5.50,-3.54,-1,-0.02,0.47,0.37,0.34,0.25,0.25,0.25,0.32,0.23,0.33,0.25,-0.25,0.33,0.09,0,0.12,0.20,0.25,0.21,0.12,0.12,0.70,0.63,0.82,0.37,0.25,0,0.12,-1,-1.91,-3.39,-5.50,-5.52,-3.39,-2.25,-1.89,-1.38,-0.66,-0.16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,0.12,0.10,0.10,0.09,0,-0.05,-0.26,-0.64,-0.65,-0.75,-0.92,-1.15,-0.63,-0.39,-0.63,-0.88,-1.14,-1.63,-7,-10,-9,-6,-1.40,-0.89,-0.38,-0.27,-0.30,-0.30,-0.13,0.12,0.25,0.22,0.20,0.13,0.22,0.23,0.23,0.23,0.22,0.21,0.21,0.20,0.12,0.12,0.12,0.12,0.12,0.12,0.10,0.07,0.08,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.25,0.25,-0.25,-0.75,-1.50,-1.88,-2.42,-3.27,-4.25,-5.16,-4.18,-4.53,-5.38,-6,-6,-6,-5.54,-4.17,-2.65,-1.25,0.01,0.33,0.25,0.23,0.12,0.12,0.21,0.25,0.36,0.25,-0.25,-0.38,-0.25,-0.27,-0.25,-0.02,0.12,0.12,0.25,0.50,0.25,-0.12,0.33,0.35,0.45,0.50,0,-0.75,-2.16,-3.79,-5.12,-5.50,-4.88,-3.86,-2.75,-1.75,-0.88,-0.18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.23,0.20,0.12,0.12,0.12,0,-0.14,-0.29,-0.41,-0.63,-0.88,-1.18,-0.87,-0.75,-0.63,-0.75,-0.79,-1.13,-4.41,-7,-7,-4.01,-0.92,-0.50,-0.13,0,-0.02,-0.25,-0.25,0.25,0.37,0.25,0.22,0.20,0.25,0.21,0.12,0.12,0.12,0.12,0.12,0.12,0.12,0.20,0.12,0.20,0.23,0.25,0.25,0.21,0.12,0.07,0,0,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.21,0.46,0.25,-0.04,-0.54,-1,-1.63,-3.01,-5.13,-6,-5.40,-5.50,-6,-6,-6,-6,-5.90,-4.91,-3.63,-2.18,-1,0.10,0.34,0.32,0.20,0.09,0.09,0.20,0.25,0.34,0.10,-0.13,-0.38,-0.68,-0.52,-0.38,-0.25,-0.13,0.37,0.35,-0.13,-0.13,0.08,0.37,0.37,0.25,0,-0.93,-2.63,-4.27,-5.64,-6,-6,-5.11,-3.75,-2.17,-1,-0.29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,1,1,0.12,0.12,0.12,0.12,0.12,0.12,0.07,-0.05,-0.13,-0.13,-0.50,-0.93,-1.38,-1,-0.75,-0.63,-0.67,-1.05,-1.63,-4.53,-4.53,-1.13,-0.42,-0.14,0.12,0.12,0.12,0.37,0.37,0.37,0.37,0.24,0.12,0,0.12,0.11,0.09,0,-0.01,0,0,0.09,0.11,0.08,0.08,0.08,0.21,0.45,0.35,0.23,-0.02,-0.13,-0.13,-0.13,-0.01,0.07,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0.20,0.25,0.21,0.21,0.24,-0.63,-1.61,-3.76,-5.88,-5.65,-6,-6,-6,-6,-6,-6,-5.63,-4.42,-3.01,-1.63,-0.39,0.12,0.57,0.33,0.12,0.08,0.08,0.20,0.37,0.13,0.12,-0.50,-0.75,-0.75,-0.75,-0.68,-0.63,-0.63,-0.67,-0.53,-0.39,-0.13,0.32,0.25,0.21,-0.61,-1.76,-3.50,-5.14,-6,-7,-7,-6,-4.76,-2.75,-1.02,0.08,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0.07,0.07,0.09,0.11,0.12,0.12,0.12,0.11,0.12,0.20,0.24,-0.66,-1.42,-1.38,-0.75,-0.63,-0.41,-1,-1.42,-1.90,-1.38,-0.88,-0.38,0.09,0.23,0.23,0.23,0.25,0.25,0.32,0.37,0.45,-0.50,-0.26,-0.13,-0.13,-0.13,-0.13,-0.13,-0.13,-0.03,0,0,0,0,-0.02,-0.13,-0.38,0.24,-0.13,-0.25,-0.37,-0.29,-0.16,-0.05,0.07,0.21,0.12,0.11,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.87,0.09,-0.75,-1.50,-3.63,-5,-6,-6,-6,-6,-6,-6,-6,-5.38,-3.92,-2.38,-0.88,-0.25,0.50,0.62,0.25,0.25,0.20,0.23,0.37,0.25,-0.25,-0.75,-0.89,-0.88,-0.92,-1.13,-1.13,-1.30,-1.29,-1.17,-0.68,-0.38,-0.13,-0.04,-1,-2,-3.26,-4.80,-6,-7,-8,-8,-7,-6,-3.80,-1.29,0.58,0.58,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0.08,0.10,0.12,0.12,0.21,0.37,0.10,-0.17,-0.62,-0.75,-0.88,-0.63,-0.68,-1,-1.38,-1.38,-1,-0.51,-0.13,0.25,0.22,0.12,0.10,0.07,0.12,0.12,0.37,0.57,-0.63,-0.29,-0.13,-0.13,-0.15,-0.13,-0.13,-0.13,-0.02,0,0,0,0,-0.05,-0.17,-0.38,-0.25,-0.41,-0.54,-0.63,-0.54,-0.40,-0.25,0,0.25,0.33,0.25,0.12,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.24,-0.13,-0.75,-1.27,-3.38,-5.16,-6,-6,-6,-6,-7,-7,-6,-5.25,-3.51,-1.18,-0.63,-0.17,0.25,0.46,0.75,0.87,0.24,0.25,0.70,-0.75,-1.29,-1.25,-1.13,-1.13,-1.14,-1.18,-1.41,-1.63,-1.63,-1.25,-1.01,-0.77,-1.42,-2.66,-3.66,-4.93,-6,-7,-8,-9,-9,-9,-7,-5.36,-2.28,-0.63,0.58,0.37,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,1,1,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.09,0.12,0.25,0.20,0.12,-0.13,-0.28,-0.41,-0.53,-0.75,-1.15,-1.38,-1.27,-0.75,-0.27,0,0.25,0.12,0,0,0,0,0.09,0.25,0.62,0.62,0,-0.01,-0.01,-0.02,-0.02,0,0.09,0,0,0,0.08,0,-0.01,-0.12,-0.25,-0.25,-0.53,-1.15,-0.89,-0.88,-0.77,-0.50,-0.13,0.12,0.25,0.37,0.33,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.24,-0.13,-0.30,-1,-3.26,-7,-6,-6,-6,-6,-7,-7,-6,-5.13,-3.12,-1.90,-1.75,-1.50,-1.01,-0.63,-0.37,-0.02,0.01,0.45,-0.90,-1.51,-1.68,-1.55,-1.50,-1.40,-1.54,-1.88,-2.36,-2.75,-3.13,-3.63,-4.02,-4.30,-5,-5.88,-6,-7,-9,-9,-10,-10,-10,-8,-6,-3.88,-0.90,0.62,0.62,0.22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,0,0,0,0,0,0,1,1,1,1,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.13,0.24,0.12,0.09,-0.13,-0.38,-0.65,-1.13,-1.75,-1.13,-0.50,0,0.25,0.22,0.11,0,0,0,0,0,0.12,0.24,0.32,0.13,0.10,0.09,0.07,0.08,0.10,0.20,0.12,0.12,0.12,0.12,0.09,0.07,0.07,0.23,-0.13,-0.41,-0.68,-0.91,-1.14,-1.18,-0.75,-0.50,-0.25,-0.26,0.35,0.46,0.25,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.37,0.25,0.25,-0.25,-0.89,-2.75,-4.17,-4.62,-4.92,-5.62,-6,-6,-7,-6,-5.77,-4.92,-4.14,-3.38,-2.63,-2,-1.53,-1.25,-0.91,-1.24,-1.61,-2,-2.15,-2.13,-2.01,-2,-2.18,-2.74,-3.42,-4.01,-4.51,-5.03,-5.54,-6,-6,-7,-8,-9,-10,-11,-11,-11,-10,-9,-7,-5.15,-1.38,-0.65,-0.13,0.25,0.34,0.33,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.37,0.08,-0.15,-0.50,-0.92,-1.13,-0.93,-0.40,0,0.21,0.12,0.09,0,0,0,0,0,0,0,0.07,0.12,0.12,0.12,0.11,0.11,0.12,0.12,0.12,0.12,0.12,0.12,0.12,0.12,0.20,0.25,0.12,-0.13,-0.38,-0.63,-0.88,-0.88,-0.63,-0.38,-0.25,-0.29,-0.38,0.45,0.25,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.22,0.50,0.33,-0.63,-1.17,-1.75,-2.68,-3.13,-3.63,-4.28,-5.02,-5.63,-6,-6,-7,-6,-5.13,-4.13,-3.43,-3,-2.63,-2.38,-2.41,-2.52,-2.75,-2.80,-3,-3,-3.13,-3.50,-4.13,-4.68,-5.25,-5.77,-6,-6,-7,-8,-8,-9,-10,-11,-12,-12,-12,-11,-10,-8,-6,-5.29,-1.63,-1,-0.38,0.09,0.32,0.34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.23,0.25,0.08,-0.25,-0.63,-0.88,-0.66,-0.29,0,0.12,0.12,0.08,0,0,0,0,0,0,0,0,0.08,0.12,0.12,0.12,0.12,0.11,0.09,0.08,0.08,0.08,0.10,0.11,0.12,0.12,0.20,0.12,0.10,-0.05,-0.25,-0.40,-0.52,-0.38,-0.18,-0.13,-0.26,-0.38,0.47,0.25,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,-0.76,-0.67,-0.88,-1.13,-1.38,-1.63,-2,-3.13,-4,-5.28,-6,-6,-5.88,-5.13,-4.63,-4.27,-4,-3.77,-3.55,-3.50,-3.63,-3.75,-4.11,-4.38,-4.67,-5.05,-5.50,-5.91,-6,-6,-7,-8,-8,-9,-10,-10,-11,-12,-12,-13,-12,-12,-10,-9,-8,-7,-4.15,-1.79,-1.18,-0.63,-0.16,-0.03,0.87,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.23,0.21,0.08,-0.38,-0.53,-0.50,-0.15,0,0.12,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.12,0.12,0.20,0.12,0,-0.04,-0.13,-0.02,0.07,0.25,0.37,0.50,0.24,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.82,0.72,-0.13,-0.39,-0.65,-1,-1.39,-1.76,-2.13,-3.38,-4.50,-5.12,-5.36,-5.26,-5.28,-5.30,-5.13,-5.01,-4.41,-4.38,-4.53,-4.88,-5.25,-5.65,-6,-6,-6,-6,-7,-7,-8,-8,-9,-10,-10,-11,-12,-13,-13,-13,-13,-12,-10,-9,-8,-6,-4.76,-2.50,-2,-1.50,-1.13,-0.75,-0.25,0.12,0.37,0.37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.22,0.33,0.25,0,-0.42,-0.50,-0.26,0.08,0.12,0.12,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.12,0.24,0.25,0.12,-0.03,0,0.12,0.45,0.37,0.25,0.12,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.12,0,0,-0.29,-0.75,-1.25,-1.66,-2.30,-3.11,-3.78,-4.26,-4.63,-5.02,-5.38,-5.38,-5.38,-4.75,-4.79,-5.25,-5.89,-6,-6,-7,-7,-7,-7,-7,-8,-8,-9,-9,-10,-11,-11,-12,-13,-13,-13,-13,-12,-10,-8,-8,-6,-4.66,-3.50,-2.55,-2.27,-1.89,-1.63,-1.13,-0.51,-0.05,0.25,0.97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.25,0.25,0,-0.38,-0.88,-0.41,-0.13,0.12,0.12,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.22,0.35,0.35,-0.38,-0.38,0.37,0.37,0.22,0.12,0,0,0,0.63,-0.63,0.63,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.22,0.34,0.25,0,-0.63,-1.25,-1.75,-2.25,-2.75,-3.18,-3.63,-4.03,-4.42,-4.54,-4.63,-4.36,-4.63,-5.36,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-9,-9,-10,-11,-11,-12,-13,-13,-13,-12,-11,-10,-9,-8,-7,-6,-5.25,-3.76,-2.90,-2.55,-2.26,-2,-1.38,-0.88,-0.38,0.07,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.24,0.22,0,-0.50,-0.78,-0.54,-0.17,0,0.12,0.11,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.25,0.46,0.45,-0.50,0.50,0.37,0.37,0.22,0.07,0,0.09,0.57,-0.62,-0.63,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.25,-0.13,-0.66,-1.25,-1.63,-1.99,-2.26,-2.62,-2.88,-3.01,-3.14,-3.14,-3.27,-3.66,-4.39,-5.13,-5.63,-5.77,-6,-6,-6,-6,-7,-7,-8,-8,-9,-10,-10,-11,-12,-12,-12,-12,-12,-11,-10,-9,-8,-8,-7,-6,-5.93,-4.99,-4.29,-3.26,-2.54,-2.13,-1.63,-1,-0.38,0.12,0.46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.23,0.12,-0.13,-0.52,-0.75,-0.63,-0.30,-0.13,0,0.09,0.11,0.09,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.32,0.60,0.61,0.62,0.62,0.73,0.23,0.12,0,0.12,0.50,-0.25,-0.50,-0.68,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.24,0.71,-0.27,-1,-1.18,-1.28,-1.41,-1.63,-1.64,-1.63,-1.49,-1.50,-1.86,-2.25,-2.90,-3.41,-3.86,-4.17,-4.50,-4.42,-4.92,-5.50,-6,-6,-7,-8,-9,-9,-10,-11,-11,-11,-11,-11,-11,-10,-10,-9,-9,-9,-8,-8,-7,-7,-6,-5.62,-4.03,-2.55,-2.17,-1.63,-1,-0.63,-0.25,0.70,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.24,0.23,-0.13,-0.50,-0.78,-0.75,-0.50,-0.25,-0.13,0,0.11,0.11,0.12,0.08,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0.12,0.75,-0.77,0.75,0.84,0.12,0.12,0.12,0.85,-0.51,-0.66,-0.63,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.83,0.75,-0.39,-0.63,-0.55,-0.40,-0.66,-0.88,-0.91,-0.63,-0.17,-0.25,0.12,-0.75,-1.13,-1.50,-1.74,-1.91,-2.74,-2.86,-2.25,-3.61,-5.04,-6,-6,-7,-8,-9,-10,-10,-10,-10,-10,-10,-10,-10,-9,-9,-9,-9,-9,-9,-9,-8,-8,-7,-5.49,-3.38,-2.63,-2.18,-1.66,-1.29,-0.91,-0.63,-0.54,-0.02,0.25,0.37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.23,0.37,0.12,-0.38,-0.88,-0.76,-0.64,-0.50,-0.25,-0.13,0,0.12,0.12,0.12,0.12,0.10,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.87,-0.88,-0.88,0.75,0.75,0.75,0.20,0.84,0.50,-0.53,-0.68,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.87,-0.88,-0.13,-0.13,0,0.25,0.09,-0.18,-0.16,0.12,0.37,0.24,0.37,0.34,-0.29,-0.63,-0.79,-0.88,-0.88,-1.13,-1.43,-1.77,-2.80,-4.29,-5.40,-6,-7,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-10,-10,-10,-10,-10,-9,-8,-8,-6,-4.12,-2.88,-2.63,-2.38,-2.02,-1.88,-1.66,-1.64,-0.88,-0.17,0.25,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.20,0.33,0.32,-0.15,-0.63,-0.88,-0.88,-0.75,-0.52,-0.38,-0.13,0,0.11,0.12,0.12,0.12,0.12,0.12,0.12,0.10,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.87,0.85,0.82,-0.38,-0.25,0.25,0.75,0.82,0.85,-0.90,-1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0.48,0.12,0.25,0.50,0.25,0.12,0.12,0.25,0.25,0.25,0.24,0.12,0,-0.14,-0.16,-0.13,-0.13,-0.25,-0.63,-1.13,-1.50,-2.49,-3.52,-4.41,-5,-6,-7,-8,-7,-7,-7,-7,-8,-8,-9,-9,-10,-10,-11,-11,-10,-10,-9,-8,-7,-5.89,-4.63,-3.89,-3.02,-2.68,-2.63,-2.63,-2.30,-1.63,-0.93,-0.05,0.37,0.62,0.50,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.24,0.37,0.25,-0.26,-0.63,-0.88,-0.90,-0.88,-0.67,-0.50,-0.26,-0.13,0,0.08,0.12,0.23,0.25,0.25,0.32,0.32,0.32,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.82,0.20,-0.18,-0.25,-0.79,-0.54,0.47,-0.63,-1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.20,0.25,0.21,0.21,0.21,0.25,0.25,0.12,0.12,0,0,0,0.12,0.20,0.12,0.12,0.25,0.12,-0.04,-0.50,-0.90,-1.25,-1.68,-2.18,-2.55,-3.26,-4.53,-5.49,-5.63,-5.78,-6,-6,-7,-7,-8,-9,-10,-11,-12,-11,-11,-10,-9,-9,-8,-7,-6,-5.64,-5.11,-4.43,-3.37,-2.93,-2.75,-2.25,-1.63,-0.78,-0.25,0.09,-0.15,-0.50,0.36,0.45,0.87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.32,0.37,0.12,-0.38,-0.75,-0.93,-1,-0.92,-0.78,-0.64,-0.50,-0.38,-0.17,0,0.20,0.24,0.37,0.37,0.50,0.60,0.62,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0.25,0.20,-0.38,-0.80,-0.50,-0.50,-0.63,-1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.11,0.12,0.12,0.12,0.12,-0.14,-0.43,-0.63,-0.88,-1,-1.25,-1.50,-2,-2.86,-3.41,-4,-4.41,-5,-5.87,-6,-8,-10,-11,-12,-12,-12,-11,-10,-10,-9,-9,-8,-8,-7,-6,-6,-5.74,-4.17,-3,-2.66,-2.25,-1.63,-1.13,-0.93,-1.03,-0.92,-0.75,-0.37,0.38,0.62,0.63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.25,0.25,0.07,-0.30,-0.63,-0.88,-0.93,-1,-1,-1,-0.88,-0.65,-0.38,0,0.12,-0.30,-0.38,-0.50,-0.63,0.60,0.33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0.82,0.82,0.84,0.45,-0.39,-0.63,-0.80,0.75,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.63,-0.63,-0.68,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0,-0.13,-0.25,-0.29,-0.38,-0.52,-0.76,-1.13,-1.50,-1.88,-2.38,-2.55,-3.38,-4.27,-5.87,-7,-9,-12,-13,-13,-11,-10,-10,-10,-10,-9,-9,-9,-9,-8,-7,-6,-5.61,-4.52,-3.68,-3.13,-2.64,-2.17,-1.88,-1.88,-1.75,-1.63,-1.25,-0.75,-0.63,0.62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.25,0.21,0,-0.25,-0.51,-0.75,-0.90,-1.14,-1.40,-1.38,-1.25,-1,-0.63,-0.25,0.25,0.35,0.37,-0.63,0.60,0.33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0.12,0.12,0.75,0.71,-0.75,-0.75,0.71,0.25,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.62,-0.63,-0.63,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0,0,0,0,0,-0.04,-0.01,-0.50,-0.65,-1,-1.38,-1.88,-2.15,-2.63,-4.05,-6,-9,-11,-12,-12,-10,-9,-9,-10,-10,-10,-10,-10,-10,-9,-8,-7,-6,-5.77,-4.92,-4.30,-4,-3.80,-3.13,-3.17,-3,-2.87,-2.50,-1.80,-1.05,-0.50,0.10,0.57,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.22,0.12,0,-0.15,-0.40,-0.66,-1,-1.50,-1.75,-1.75,-1.77,-1.25,-0.50,0.12,0.49,0.37,0.60,0.62,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.62,-0.50,-0.41,0.37,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.68,-0.63,0.63,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.12,0.24,0.24,-0.01,-0.01,0.49,-0.53,-1.13,-1.52,-1.79,-2.63,-4.39,-6,-8,-9,-9,-8,-8,-8,-9,-9,-10,-10,-10,-10,-10,-9,-8,-7,-6,-6,-6,-5.86,-5.87,-6,-6,-6,-5.37,-3.62,-2.89,-2.13,-1.38,-0.63,-0.25,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.12,0.12,0.12,-0.13,-0.40,-0.78,-1.30,-1.75,-2.01,-2,-1.88,-0.88,0.11,0.34,0.37,0.37,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.46,0,-0.13,0,0.22,0.12,0.09,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0.20,0.24,0.60,0.50,-0.51,-0.68,-1.02,-1.38,-2,-3.12,-4.26,-5.40,-5.64,-6,-6,-7,-8,-8,-9,-9,-9,-10,-9,-9,-8,-8,-7,-7,-7,-7,-7,-8,-9,-9,-9,-6,-3.75,-3.11,-2.50,-1.88,-1,-0.63,0.63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.20,0.25,0,-0.14,-0.50,-1,-1.50,-1.90,-2.02,-1.88,-1.13,-0.38,0.20,0.25,0.20,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.20,0.25,0.07,-0.03,0,0.11,0.12,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0.75,0.75,-0.03,-0.27,-0.50,-0.92,-1.38,-1.90,-2.17,-2.77,-3.51,-4.68,-5.68,-6,-7,-8,-8,-8,-9,-9,-9,-8,-8,-8,-8,-8,-8,-9,-10,-12,-11,-11,-8,-5.13,-3.75,-3.28,-2.63,-1.63,-0.66,0.62,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.12,0.22,0.12,0,-0.51,-1.13,-1.54,-1.88,-1.88,-1.25,-0.50,0,0.24,0.12,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0,-0.02,-0.04,0,0.09,0.10,0.08,0,0,0,0,0,0,0,0.63,0.62,0.63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.12,0.12,0.25,0.12,0.12,-0.13,-0.38,-0.91,-1.38,-1.80,-2,-2.13,-3.75,-5.54,-6,-6,-6,-7,-7,-8,-8,-8,-8,-8,-8,-9,-9,-10,-11,-13,-12,-12,-9,-6,-3.75,-3.41,-3,-1.88,-1.01,-0.37,0.21,0.37,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.20,0.25,0.23,0.11,-0.53,-1.13,-1.50,-2,-1.25,-0.64,-0.18,0.11,0.25,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0.12,-0.02,-0.13,-0.13,0,0.09,0.10,0,0,0,0,0,0,1,0.62,-0.62,0.62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.24,0.37,0.35,0.25,-0.25,-0.66,-1.18,-1.38,-1.50,-1.64,-2.63,-3.88,-4.50,-4.90,-5.41,-6,-6,-7,-8,-8,-8,-8,-8,-9,-10,-11,-13,-12,-11,-8,-5.87,-3.50,-3.13,-2.63,-1.88,-1.39,-0.88,-0.38,0.12,0.36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.20,0.25,0.23,0.09,-0.63,-1.13,-1.38,-1.17,-0.77,-0.37,0,0.37,0.22,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.02,-0.04,-0.04,0,0,0,0,0,0,0,0,0.09,0.12,0.12,0,-0.14,-0.25,-0.13,0,0.21,0.10,0,0,0,0,1,1,-0.68,-0.63,0.63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.25,0.48,0.25,-0.13,-0.63,-0.75,-0.75,-0.79,-1.25,-1.78,-2.28,-3.12,-3.68,-4.55,-5.63,-6,-7,-7,-8,-8,-8,-8,-8,-9,-10,-10,-9,-7,-4.29,-3,-2.79,-2,-1.75,-1.42,-1.16,-0.79,-0.38,0.12,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.22,0.25,0.22,0.12,-0.65,-1.13,-1.25,-1.01,-0.67,-0.25,0.25,0.32,0.12,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.09,0,-0.01,-0.13,-0.13,-0.04,0,0,0,0,0,0,0,0.12,0.12,0,-0.25,-0.42,-0.28,0,0.33,0.25,0.12,0,0,0,0.70,-0.63,-0.75,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.25,0.72,0.72,-0.18,-0.29,0,0,-0.50,-1.04,-1.50,-1.88,-2.50,-3.38,-4.42,-5.54,-6,-7,-7,-7,-7,-6,-6,-7,-7,-7,-6,-4.68,-2.62,-2.41,-2.13,-1.75,-1.62,-1.40,-1.16,-1,-0.63,-0.13,0.25,0.37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.22,0.25,0.12,-0.38,-0.88,-1.38,-1.52,-1.26,-0.66,0.12,0.25,0.25,0.10,0,0,0,0,0,0,0,0,0.07,0.12,0.12,0.08,-0.13,-0.15,-0.14,-0.25,-0.14,0,0,0,0,0,0,0,0.08,0.22,0.25,-0.25,-0.88,-0.51,0.12,0.25,0.49,0.36,0.12,0.12,0.07,0.62,-0.63,-0.63,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.23,0.75,-0.63,0.12,0.32,0.37,0,-0.38,-0.67,-1.13,-1.63,-2.39,-3.38,-4.29,-5.13,-5.63,-5.66,-5.37,-4.91,-4.63,-4.50,-4.30,-4.63,-4.38,-3.15,-2.16,-2,-1.92,-2.01,-1.62,-1.42,-1.38,-1.28,-1.13,-0.88,-0.50,0,0.37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.25,0.12,-0.75,-1.41,-1.93,-2,-1.13,-0.38,0.23,0.33,0.12,0,0,0,0,0,0,0,0,0.11,0.12,0.08,-0.13,-0.25,-0.25,-0.25,-0.13,-0.04,0.09,0.12,0,0,0,0,0,0,0,0.85,-0.54,-0.77,-0.91,-0.68,-0.40,0.37,0.37,0.58,0.60,0.62,0.50,-0.63,-0.75,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.25,0.62,0.62,0.50,0.25,0.22,0.12,0.12,0,0.12,-1,-1.88,-2.76,-2.75,-3.15,-3.65,-3.88,-3.12,-2.25,-1.88,-1.88,-1.80,-1.88,-1.80,-1.86,-1.99,-1.92,-2,-1.65,-1.42,-1.51,-1.38,-1.38,-1.30,-1.25,-0.91,-0.50,0.12,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0.98,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.22,0.32,0.10,-0.50,-1.26,-1.90,-1.91,-1.38,-0.55,0.12,0.36,0.22,0.08,0,0,0,0,0,0,0,0.12,0.20,-0.01,-0.54,-0.38,-0.38,-0.25,-0.02,0,0.12,0.25,0.25,0.12,0,0,0,0,0,1,0.84,-0.75,-1.66,-1.53,-1,-0.50,0.37,0,0.08,0.12,0.12,0.84,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.25,0.25,0.25,0.21,0.12,0.08,0.12,0.75,-0.79,-1.18,-2.14,-2.88,-2.65,-2.50,-1.68,-1.55,-1.53,-1.55,-1.63,-1.63,-1.63,-1.63,-1.74,-1.88,-1.99,-1.77,-1.40,-1.51,-1.40,-1.52,-2.04,-2.25,-2.13,-1.65,-1.05,-0.42,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0.10,0.12,0.12,0.24,0.25,0.24,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.12,-0.27,-0.91,-1.50,-1.91,-1.39,-0.75,0.20,0.34,0.25,0.12,0,0,0,0,0,0,0,0.12,0.22,0,-0.50,-0.38,-0.41,-0.42,-0.13,-0.02,0.12,0.32,0.50,0.11,0,0,0,0,0,0,0.96,-0.88,-1.77,-1.64,-1.63,-1.13,-0.77,-0.55,-0.42,-0.25,0.12,0.75,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.32,0.62,0.62,0.62,0.25,0.07,0,0,0.50,0.11,-1,-1.77,-2.89,-2.68,-0.75,-0.91,-0.78,-0.89,-1.13,-1.29,-1.39,-1.50,-1.50,-1.62,-1.75,-1.88,-1.77,-1.54,-1.54,-2.17,-2.92,-3.53,-3.93,-4.13,-3.65,-2.49,-1.05,-0.25,0.25,0.37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.08,0.25,0.62,0.62,0.62,0.32,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.21,0.21,0,-0.50,-1.13,-1.40,-1.38,-0.90,-0.28,0.32,0.37,0.23,0,0,0,0,0,0,0,0.10,0.24,0.12,-0.01,-0.13,-0.53,-0.75,-0.91,-0.63,-0.42,-0.62,0.37,0.70,0,0,0,0,0,0,1,-1,-1.13,-1.75,-1.75,-1.75,-1.53,-1.13,-0.88,-0.63,-0.13,0.75,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.24,0.62,0.62,-0.63,0.62,0.32,0,0,0,0.12,-0.03,-0.63,-1.29,-1.90,-1.78,-0.88,0.07,0.12,-0.15,-0.55,-0.88,-1.13,-1.29,-1.39,-1.54,-1.75,-1.92,-2.13,-1.86,-2.63,-4.14,-4.75,-5.55,-5.77,-6,-5.68,-4.75,-2.92,-0.93,-0.13,0.37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.33,0.25,0.12,0.25,0.25,0.24,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.23,0.12,0,-0.65,-1.13,-1.38,-1.25,-0.64,0.35,0.45,0.34,0.12,0,0,0,0,0,0,0,0.12,0.20,0.12,0.12,-0.15,-0.29,-0.38,-0.30,-0.38,-0.63,-1,0.62,-0.13,0,0,-0.02,-0.01,0.22,1,0.75,-0.55,-1.16,-1.68,-2.13,-2.13,-1.38,-1.17,-1.37,-0.66,0.75,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.32,0.58,-0.53,-0.52,0.50,0.34,0.11,0,0,0.12,0.11,-0.29,-0.88,-1.75,-1.75,-0.88,0,0.32,0.25,-0.01,-0.40,-0.79,-1.14,-1.38,-1.51,-1.75,-2.13,-2.63,-3.50,-4.50,-5.61,-6,-7,-7,-7,-7,-6,-4.75,-2.38,-0.64,0.12,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.32,0.22,0.13,0.12,0.20,0.25,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.20,0.25,0.12,-0.30,-0.88,-1.38,-1.39,-1,-0.40,0.11,0.32,0.23,0,0,0,0,0,0,0,0,0,0.12,0.12,0,-0.13,-0.13,-0.25,-0.28,-0.39,-0.80,0.62,-0.13,0,0,-0.01,-0.01,0.12,0,0.60,0.37,-0.91,-1.50,-1.63,-1.50,-1.13,-0.75,-0.50,-0.53,0.62,0.83,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.33,0.50,-0.50,-0.50,0.50,0.34,0.12,0,0,0.11,0.23,0.37,-0.75,-1.75,-1.68,-1.13,-0.27,0.25,0.50,0.37,-0.03,-0.55,-1.05,-1.41,-1.66,-2.55,-3.38,-4.50,-5.37,-6,-7,-8,-9,-9,-9,-8,-8,-6,-3.88,-1.49,-0.29,0.12,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.25,0.25,0.24,0.23,0.20,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.35,0.32,-0.75,-1.38,-1.63,-1.41,-0.88,-0.17,0.34,0.23,0,0,0,0,0,0,0,0,0,0,0,-0.02,-0.13,-0.13,-0.14,-0.25,-0.26,-0.05,0.57,-0.13,0,0.08,0.07,0,0,0.12,0.25,-0.13,-0.50,-1,-0.91,-0.75,-0.52,-0.01,-0.04,0.10,0.20,0.33,0.58,0.21,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.25,0.08,-0.16,-0.13,0.11,0.25,0.12,0.10,0,0,0.12,0.75,-0.75,-1.67,-1.66,-1.66,-0.63,0,0.37,0.50,0.12,-0.50,-1.13,-1.63,-2.99,-4.12,-5.02,-6,-7,-8,-9,-9,-10,-10,-10,-10,-9,-7,-5.03,-2.52,-0.77,-0.02,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.22,0.33,0.37,0.37,0.34,0.23,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.21,0.37,0.37,-0.50,-1.38,-1.75,-1.80,-1.38,-0.50,0.38,0.20,0.11,0,0,0,0,0,0,0,0,0,0,0,-0.15,-0.15,-0.14,-0.17,-0.14,-0.02,0,0,0.62,0.34,0.12,0.12,0.07,0.11,0.10,-0.02,-0.29,-0.50,-0.50,-0.25,-0.13,0.07,0.12,0.20,0.12,0.12,0.24,0.25,0.20,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,-0.13,-0.29,-0.26,0,0.12,0.12,0.11,0,0,0.12,0.75,-0.75,-0.75,-1.03,-1.03,-0.89,-0.63,0.21,0.11,-0.13,-0.76,-1.63,-3.17,-4.79,-5.86,-7,-8,-9,-9,-10,-11,-11,-12,-12,-11,-9,-8,-6,-3.75,-1.39,-0.51,-0.15,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.25,0.32,0.32,0.25,0.12,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.34,0.50,-0.50,-1.25,-2.13,-2.63,-2.29,-1.27,-0.25,0.76,0.07,0,0,0,0,0,0,0,0,0,0,0,-0.04,-0.13,-0.16,-0.15,-0.13,-0.12,-0.03,0.12,0.45,-0.62,-0.15,-0.15,-0.17,-0.04,0,-0.01,-0.16,-0.29,-0.25,-0.04,0,0.12,0.12,0.12,0.07,0,0,0.12,0.25,0.25,0.12,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.07,-0.18,-0.38,-0.38,-0.13,0.12,0.12,0.12,0,0,0.12,0.75,0,-0.25,-0.54,-0.89,-1.13,-1.15,-0.89,-0.79,-0.91,-2.17,-4.25,-6,-7,-8,-9,-9,-10,-11,-11,-12,-13,-13,-13,-12,-10,-8,-6,-4.50,-2.40,-0.79,-0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.21,0.23,0.23,0.21,0.12,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.23,0.74,0,-1.27,-2.53,-3.42,-3.26,-2.11,-0.67,0.13,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.12,-0.13,-0.13,-0.13,-0.05,-0.04,0.08,0.37,-0.12,-0.25,-0.25,-0.38,-0.38,-0.30,-0.38,-0.42,-0.50,-0.28,0,0.12,0.23,0.22,0.12,0,-0.13,-0.13,-0.05,0.08,0.25,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.09,-0.16,-0.29,-0.28,-0.05,0.08,0.12,0.11,0,0,0.12,0.07,0.11,0.07,-0.41,-0.88,-1.43,-1.88,-2,-2.11,-3.67,-5.38,-7,-9,-9,-10,-11,-11,-11,-12,-13,-13,-14,-14,-14,-13,-11,-9,-7,-5.38,-3.12,-1.25,-0.18,0.70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.12,0.12,0.12,0.12,0.12,0.12,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.20,-0.14,-1.25,-2.77,-4.11,-4.15,-2.88,-1.29,-0.13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.03,-0.03,0,0.11,0,-0.13,-0.15,-0.37,-0.40,-0.51,-0.75,-0.92,-0.89,-0.43,-0.01,0.20,0.21,0.12,0.12,0,-0.13,-0.25,-0.29,-0.25,0.11,0.35,0.37,0.21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0,-0.16,-0.25,-0.13,0.07,0.11,0.11,0,0,0.07,0.07,0,-0.13,-0.38,-1.05,-1.75,-2.79,-2.88,-4.26,-6,-8,-9,-10,-11,-12,-12,-12,-13,-13,-14,-14,-15,-15,-15,-14,-12,-10,-7,-6,-3.88,-1.66,-0.25,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.12,0.12,0.12,0.12,0.12,0.12,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,-0.25,-1.29,-3,-4.63,-5.12,-3.88,-2.13,-0.50,0.34,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,-0.02,-0.26,-0.54,-1.13,-1.38,-1.16,-0.55,0,0.25,0.22,0.12,0.12,0.10,-0.13,-0.29,-0.55,-0.50,-0.38,-0.13,0.10,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.08,-0.25,-0.38,-0.27,0,0.12,0.11,0.07,0,0,0.12,0,-0.04,-0.52,-1.16,-2,-2.77,-3.38,-5.13,-7,-9,-11,-12,-13,-13,-13,-13,-14,-14,-14,-15,-15,-15,-15,-14,-13,-10,-8,-6,-4.39,-2.28,-0.51,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.12,0.12,0.09,0.09,0.12,0.12,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.25,-1.41,-2.99,-4.51,-5.38,-4.52,-2.88,-1.05,0.34,0.22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.02,0,0,0,0.23,0.34,-0.63,-1,-1.38,-1.25,-0.55,0.21,0.25,0.23,0.12,0.12,0.12,0,-0.25,-0.50,-0.80,-0.75,-0.50,-0.25,0,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,-0.01,-0.25,-0.50,-0.50,-0.17,0.12,0.12,0.07,0,0,0,0.95,0.10,-0.50,-1.18,-2,-2.88,-3.77,-5.66,-8,-10,-12,-13,-13,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-14,-13,-11,-8,-6,-5.25,-2.75,-0.88,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.20,0.12,0.09,0.08,0.08,0.11,0.12,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.39,-1.51,-2.88,-4.25,-5.36,-5.03,-3.51,-1.75,0.25,0.34,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.02,-0.02,0,0,0.75,0.70,-0.63,-1.01,-1.16,-0.54,0.20,0.34,0.22,0.12,0.12,0.12,0.11,-0.13,-0.40,-0.75,-1.04,-1,-0.38,-0.02,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.07,-0.27,-0.63,-0.63,-0.30,0,0.11,0.07,0,0,0,1,0.49,-0.25,-1.01,-2.05,-2.76,-3.75,-6,-8,-11,-12,-13,-13,-13,-14,-14,-14,-15,-15,-15,-16,-15,-15,-14,-12,-10,-8,-7,-5.43,-3.62,-1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.20,0.12,0.07,0,0,0.12,0.12,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,-0.50,-1.39,-2.63,-3.90,-4.88,-5.15,-4.25,-2.30,0.09,0.37,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.02,-0.02,-0.01,0,0.12,0.75,0.50,-0.66,-1.38,-0.51,0.37,0.25,0.12,0.09,0.10,0.12,0.12,0.09,-0.25,-0.63,-1.13,-1.13,-0.43,0.12,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.10,-0.18,-0.51,-0.50,-0.38,-0.13,0.09,0,0,0,0,1,1,0.87,-0.80,-1.76,-2.75,-3.50,-5.88,-8,-10,-12,-12,-13,-13,-14,-14,-14,-15,-15,-16,-16,-16,-15,-14,-12,-10,-8,-7,-5.50,-3.65,-1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.20,0.12,0,-0.01,0,0.10,0.12,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,-0.37,-1.29,-2.38,-3.50,-4.52,-5.12,-4.63,-3.30,-0.13,0.46,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.50,-0.13,-0.39,-0.28,-0.04,0.12,0.12,0,0,0.08,0.12,0.22,0,-0.38,-0.75,-0.75,-0.50,-0.13,0.21,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,-0.01,-0.38,-0.41,-0.25,0,0.11,0,0,0,0,0,0,0.85,-0.77,-1.28,-2.13,-3.13,-5.17,-7,-9,-10,-11,-12,-13,-13,-14,-14,-15,-15,-16,-16,-15,-15,-13,-12,-9,-8,-7,-6,-3.75,-1.04,0.71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.12,0.11,-0.02,-0.13,-0.13,0,0.10,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.21,-0.38,-1.11,-2.02,-3.18,-4.38,-5.25,-5.12,-3.55,-1.38,-0.13,0.09,0.10,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.59,0.09,-0.13,-0.13,-0.12,0.12,0.09,0,0,0,0,0.12,0.12,0.09,-0.25,-0.63,-0.63,-0.38,0,0.20,0.12,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.22,0.33,-0.28,-0.38,-0.13,0,0.08,0,0,0,0,0,0,0.83,0.75,-0.80,-1.75,-2.88,-4.25,-6,-8,-9,-10,-11,-12,-13,-14,-14,-15,-16,-16,-16,-16,-15,-14,-12,-10,-9,-8,-6,-4.29,-1.50,0.62,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0.11,-0.13,-0.25,-0.25,-0.02,0.07,0.09,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.22,-0.26,-0.92,-1.77,-2.80,-3.88,-4.65,-4.75,-3.92,-1.75,-0.39,-0.13,0,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.20,0.12,0,-0.03,0,0.10,0.08,0,0,0,0,0.07,0.12,0.72,0.07,-0.42,-0.88,-0.68,-0.25,0.12,0.21,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0.08,-0.03,-0.13,-0.03,0.11,0.12,0.08,0,0,0,0,0,0.12,0.73,-0.63,-1.25,-2.38,-4.13,-5.38,-7,-9,-10,-11,-12,-13,-14,-15,-15,-16,-16,-16,-16,-15,-14,-12,-10,-9,-8,-7,-5.18,-2.01,-0.75,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.23,0.20,-0.13,-0.50,-0.25,-0.02,0.10,0.11,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,-0.25,-0.68,-1.41,-2.38,-3.40,-4.38,-4.63,-3.88,-2.15,-0.65,-0.25,0,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.08,0,0,0.08,0.11,0.12,0,0,0,0,0,0.12,0.24,0.21,-0.25,-0.67,-0.88,-0.38,0,0.23,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0.10,0,0,0,0.12,0.12,0.10,0,0,0,0,0,0.12,0.70,0.50,-0.75,-1.89,-3.54,-5.50,-6,-8,-10,-11,-12,-13,-14,-15,-15,-16,-16,-16,-16,-15,-14,-13,-11,-9,-8,-7,-5.75,-3.25,-0.75,0,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.23,0.25,-0.02,-0.15,-0.14,-0.01,0.10,0.11,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,-0.13,-0.49,-1.02,-1.92,-3.11,-4.13,-4.75,-4.25,-3.38,-0.93,-0.18,0.12,0.12,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0.12,0.07,0.07,0.10,0.12,0.11,0,0,0,0,0,0,0.12,0.24,0,-0.38,-0.63,-0.41,-0.16,0,0.12,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.12,0.12,0.09,0,-0.01,0.07,0.22,0.12,0,0,0,0,0,0.10,0.32,0.50,-0.43,-1.39,-2.80,-5.12,-7,-8,-10,-11,-12,-13,-14,-15,-16,-16,-17,-16,-16,-16,-15,-14,-12,-9,-8,-7,-5.93,-3.63,-1.25,-0.14,0.23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.25,0.37,0.11,-0.01,0,0.08,0.12,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,-0.03,-0.25,-0.66,-1.50,-2.76,-4.13,-5.13,-4.88,-2.91,-1.25,-0.43,0.12,0.34,0.22,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.20,0.23,0.12,0.07,0.07,0.12,0.20,0.12,0,0,0,0,0,0,0.11,0.22,0.25,-0.16,-0.42,-0.50,-0.38,-0.13,0.11,0.12,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.25,0.12,0.11,-0.01,-0.13,-0.13,0.08,0.12,0,0,0,0,0,0,0.25,0.22,-0.18,-0.90,-2.55,-4.90,-7,-8,-10,-11,-12,-13,-14,-15,-16,-16,-17,-17,-16,-16,-15,-14,-13,-11,-8,-7,-6,-3.43,-1.51,-0.16,0.21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.33,0.12,0.08,0.10,0.24,0.23,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.01,-0.05,-0.38,-1.16,-2.63,-4.41,-5.89,-5.65,-4,-1.54,-0.90,-0.25,0.25,0.32,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.23,0,0,0,0.12,0.12,0.12,0,0,0,0,0,0,0,0.12,0.25,-0.05,-0.38,-0.63,-0.50,-0.30,-0.14,0,0.09,0.10,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0.09,-0.13,-0.38,-0.27,0.10,0.20,0.12,0,0,0,0,0,0.20,0.20,0.07,-0.50,-2.25,-5.25,-7,-9,-10,-12,-13,-14,-15,-16,-16,-17,-17,-17,-16,-15,-15,-14,-13,-11,-8,-7,-6,-3.76,-1.51,-0.16,0.21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.20,0.12,0.11,0.12,0.24,0.12,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.10,0.12,0.12,0.12,0.12,0.07,-0.15,-0.92,-2.42,-4.63,-6,-7,-4.14,-2.04,-1.43,-0.75,0.21,0.57,0.35,0.20,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.24,0.25,0,-0.13,-0.13,-0.05,0.12,0.23,0.12,0,0,0,0,0,0,0,0,0.22,0,-0.25,-0.50,-0.53,-0.50,-0.38,-0.17,0,0.12,0.12,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.07,-0.04,-0.27,-0.50,-0.13,0.59,0.22,0,0,0,0,0,0.12,0.12,0.08,-0.38,-1.75,-4.88,-7,-9,-11,-12,-13,-14,-15,-16,-16,-17,-16,-16,-16,-15,-14,-14,-13,-11,-9,-6,-5.63,-4,-1.61,-0.14,0.23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.10,0.11,0.11,0.12,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.08,0.11,0.12,0.12,0.12,0.21,0.24,0.25,0.25,0.14,0.12,-0.13,-0.86,-2.25,-4.36,-6,-6,-3.54,-2.53,-2.18,-1.38,-0.63,0.46,0.46,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.23,0.25,0.21,-0.25,-0.37,-0.37,-0.18,0,0.20,0.12,0,0,0,0,0,0,0,0,0.12,0.10,-0.13,-0.38,-0.55,-0.67,-0.65,-0.43,-0.13,0.12,0.23,0.12,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.09,0.10,-0.17,-0.38,-0.25,0.62,0.12,0,0,0,0,0,0,0.12,0.12,-0.04,-1.41,-4.15,-7,-9,-11,-12,-14,-15,-15,-16,-16,-16,-16,-16,-15,-15,-14,-13,-13,-11,-10,-7,-5.76,-3.89,-1.53,0,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.10,0.11,0.11,0.11,0.11,0.20,0.25,0.21,0.24,0.21,0.12,0.20,0.13,-0.13,-0.40,-1,-2.14,-3.87,-5.15,-5.13,-3.75,-2.89,-2.50,-2.50,-1.25,-0.40,0.37,0.37,0.25,0.12,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.12,-0.13,-0.50,-0.66,-0.63,-0.38,-0.03,0.12,0.12,0,0,0,0,0,0,0,0,0.11,0.11,0.12,-0.17,-0.42,-0.80,-0.90,-0.79,-0.50,-0.13,0.21,0.25,0.20,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.24,-0.01,-0.26,-0.50,0.47,0.10,0.07,0,0,0,0,0,0.09,0.12,0.12,-1,-3.50,-6,-9,-11,-13,-14,-15,-16,-16,-16,-16,-16,-16,-15,-15,-14,-13,-13,-13,-11,-9,-6,-4.75,-1.49,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.12,0.11,0.08,0,0,0,0.12,0.12,0,0,-0.13,-0.26,-0.43,-0.63,-1,-1.42,-2,-3.27,-4.99,-5.13,-3.76,-2.89,-2.75,-2.25,-1.63,-0.88,0.34,0.37,0.37,0.25,0.12,0.09,0,0,0,0,0,0,0,0,0,0,0,0.23,0.25,-0.04,-0.50,-0.92,-1.25,-1.13,-0.63,-0.05,0.12,0.12,0,0,0,0,0,0,0,0,0,0.09,0.24,0.70,-0.16,-0.66,-1.04,-1.13,-0.88,-0.53,-0.26,-0.03,0.07,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.32,-0.13,-0.50,-0.25,0.08,0.12,0,0,0,0,0,0.07,0.12,0.33,-0.27,-3.05,-6,-8,-11,-12,-14,-15,-15,-16,-16,-16,-16,-15,-15,-14,-14,-13,-13,-13,-12,-10,-7,-5.63,-1.75,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.12,0.10,0,-0.13,-0.25,-0.27,-0.29,-0.26,-0.13,-0.15,-0.17,-0.38,-0.67,-1.16,-1.52,-1.88,-3,-4,-4.27,-4.65,-4.76,-5.13,-4.37,-2.88,-2.50,-1.90,-1.27,-0.63,0.37,0.34,0.25,0.25,0.12,0.08,0,0,0,0,0,0,0,0,0,0,0.23,0.12,-0.16,-0.75,-1.27,-1.52,-1.28,-0.68,-0.13,0.12,0.12,0.08,0,0,0,0,0,0,0,0,0,0.20,0.74,0.10,-0.38,-0.88,-1.17,-1.13,-0.88,-0.65,-0.38,-0.13,0,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.07,-0.13,-0.25,0.12,0.22,0.10,0,0,0,0,0,0.12,0.22,-0.13,-2.25,-5.74,-7,-10,-11,-13,-14,-15,-15,-16,-16,-16,-15,-15,-14,-14,-14,-13,-12,-12,-10,-8,-4.11,-2.12,0.76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.12,0.12,-0.02,-0.25,-0.41,-0.63,-0.68,-0.75,-0.68,-0.54,-0.40,-0.37,-0.50,-0.88,-1.50,-2.04,-3.14,-5.88,-6,-5.38,-6,-6,-6,-6,-4.29,-2.75,-2.25,-1.77,-1.25,-0.79,-0.25,0.22,0.37,0.25,0.12,0.09,0,0,0,0,0,0,0,0,0,0.22,0.23,-0.03,-0.79,-1.50,-1.88,-1.50,-0.88,-0.14,0.12,0.22,0.12,0.07,0,0,0,0,0,0,0,0,0.12,0.20,0.25,0,-0.41,-0.75,-1,-1.03,-1,-0.75,-0.38,0.07,0.20,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0,0.07,0.20,0.32,0.12,0,0,0,0,0,0.25,0.12,-0.28,-1.65,-4.53,-6,-8,-10,-12,-13,-14,-15,-15,-16,-15,-15,-14,-14,-13,-13,-13,-13,-11,-10,-7,-4.50,-1.54,-0.25,0.32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.12,0.07,-0.16,-0.50,-0.75,-1,-1.13,-1.16,-1.13,-1,-0.63,-0.38,-0.40,-1.43,-2.43,-3.74,-5.25,-6,-7,-7,-7,-7,-8,-6,-5.24,-3.61,-2.50,-2.05,-1.67,-1.25,-0.78,0.12,0.25,0.35,0.25,0.12,0.11,0,0,0,0,0,0,0,0,0.25,0.37,-0.01,-0.80,-1.63,-2.04,-1.75,-1,-0.25,0.12,0.25,0.20,0.12,0.08,0,0,0,0,0,0,0,0,0.11,0.25,0.25,0,-0.38,-0.65,-0.91,-0.92,-0.79,-0.52,-0.15,0.12,0.33,0.12,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.24,0.10,0,0.12,0.21,0.12,0.07,0,0,0,0,0.20,0.36,-0.54,-1.88,-3.90,-6,-8,-9,-11,-13,-14,-15,-15,-15,-15,-15,-14,-13,-13,-12,-12,-12,-10,-9,-6,-4.40,-1.68,-0.13,0.37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.12,0.12,0,-0.25,-0.63,-0.90,-1.18,-1.38,-1.50,-1.50,-1.40,-1,-0.52,-1.54,-2.43,-3.63,-5,-6,-7,-8,-8,-7,-7,-7,-6,-5.87,-5.38,-4.25,-2.49,-2.02,-1.67,-1.25,-0.75,0.12,0.21,0.24,0.25,0.12,0.10,0,0,0,0.07,0.08,0.12,0.25,0.37,0.25,0.08,-1,-1.76,-2.25,-1.93,-1.25,-0.27,0.10,0.23,0.23,0.21,0.12,0.08,0,0,0,0,0,0,0,0,0.12,0.25,0.25,0,-0.28,-0.63,-0.79,-0.90,-0.77,-0.50,-0.14,0.12,0.24,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.24,0.10,-0.02,0,0.12,0.21,0.11,0,0,0,0,0,0.75,-0.65,-1.88,-3.61,-5.63,-7,-9,-11,-12,-14,-15,-15,-15,-15,-15,-14,-13,-12,-11,-11,-10,-9,-7,-6,-4.41,-2,-0.25,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0.12,0,-0.17,-0.50,-0.88,-1.13,-1.38,-1.50,-1.51,-1.78,-1.38,-1.50,-2.80,-3.76,-4.75,-5.99,-7,-8,-8,-8,-8,-8,-7,-7,-6,-5.63,-4.75,-3.74,-2.37,-2.02,-1.75,-1.43,-0.88,-0.26,0.11,0.23,0.24,0.21,0.12,0.12,0.12,0.12,0.12,0.32,0.50,0.59,-0.16,-0.68,-1.25,-2.25,-2.75,-2.39,-1.50,-1,-0.16,0,0.20,0.25,0.25,0.21,0.12,0.08,0,0,0,0,0,0,0,0.12,0.23,0.22,0.07,-0.29,-0.63,-0.90,-1.01,-0.90,-0.63,-0.14,0.12,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.12,-0.01,-0.03,0.12,0.33,0.12,0,0,0,0,0,1,-1,-2,-3.52,-5.39,-7,-9,-10,-12,-14,-15,-15,-16,-16,-15,-14,-13,-12,-12,-11,-10,-8,-7,-5.63,-3.75,-1.90,-0.65,-0.05,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.12,0.12,-0.02,-0.26,-0.54,-0.88,-1.02,-1.15,-1.27,-1.50,-1.63,-3.04,-4.13,-4.90,-5.53,-6,-7,-8,-9,-9,-8,-8,-7,-7,-6,-6,-5.49,-4.67,-4,-3.25,-2.13,-2.25,-1.42,-0.80,-0.26,0.11,0.25,0.25,0.24,0.21,0.20,0.22,0.36,0.50,0.37,-0.17,-0.63,-1.13,-2.99,-4.04,-4.25,-3.63,-2.78,-1.50,-1.03,-0.52,0.23,0.37,0.37,0.35,0.25,0.12,0.12,0,0,0,0,0,0,0,0,0.20,0.25,-0.01,-0.38,-0.75,-1.13,-1.25,-1.13,-0.63,-0.13,0.25,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.23,0.08,-0.03,0.09,0.25,0.12,0.08,0,0,0,0,1,-1,-2,-3.63,-5.38,-7,-9,-10,-12,-14,-15,-16,-16,-16,-15,-15,-14,-13,-12,-12,-11,-9,-6,-4.27,-3,-1.91,-1.15,-0.51,0.08,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.12,0.12,0.11,-0.03,-0.25,-0.40,-0.55,-0.64,-0.79,-1.05,-1.41,-3.27,-4.13,-4.75,-5.25,-6,-7,-8,-9,-9,-8,-8,-8,-7,-7,-6,-6,-6,-5.68,-5.25,-3.24,-2.13,-1.68,-1.13,-0.55,0,0.21,0.25,0.22,0.12,0.12,0.10,0.25,0.25,-0.38,-0.75,-1.16,-4.15,-5.63,-6,-6,-5.25,-4.05,-2.88,-1.90,-1.38,-0.90,-0.39,0.33,0.25,0.32,0.25,0.24,0.12,0.10,0.07,0,0,0,0,0,0.12,0.32,0.12,-0.14,-0.50,-0.89,-1.17,-1.27,-1.01,-0.51,0.09,0.24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0.07,-0.02,-0.01,0.12,0.25,0.09,0,0,0,0.32,0.70,-1,-2,-3.75,-5.54,-7,-9,-11,-12,-14,-15,-16,-17,-17,-16,-15,-15,-14,-13,-12,-10,-8,-6,-3.38,-2.66,-2.27,-1.76,-1.17,-0.50,0.87,0.87,0.87,0.96,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.12,0.12,0.11,0,-0.13,-0.13,-0.25,-0.38,-0.63,-1.03,-1.62,-2.86,-3.40,-4.13,-5.12,-6,-7,-8,-8,-8,-8,-8,-7,-7,-7,-6,-7,-7,-7,-3.90,-2.02,-1.67,-1.26,-0.78,-0.38,0.11,0.12,0.10,-0.05,-0.13,-0.40,-0.50,-0.63,-0.93,-1.30,-5.01,-7,-8,-8,-8,-7,-5.87,-4.61,-3.38,-2.49,-1.78,-1.38,-0.88,-0.38,0.25,0.25,0.34,0.32,0.25,0.20,0.12,0.10,0.09,0.08,0.12,0.32,0.33,0.25,0,-0.30,-0.75,-1.15,-1.38,-1.30,-0.92,-0.38,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0,-0.13,-0.25,0.09,0.25,0.09,0,0,0.08,0.25,0.25,-0.75,-2,-3.88,-5.76,-7,-9,-11,-13,-14,-15,-16,-17,-17,-17,-16,-16,-15,-14,-12,-10,-8,-6,-3.90,-2.88,-2.66,-2.38,-1.88,-1.28,-0.88,-0.88,-0.88,-0.89,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.11,0.12,0.12,0.12,0.11,0.11,0,-0.04,-0.25,-0.43,-0.77,-1.43,-1.93,-2.64,-3.64,-5,-6,-7,-8,-8,-8,-8,-8,-7,-7,-6,-7,-8,-7,-3.75,-1.88,-1.63,-1.28,-1,-0.68,-0.50,-0.25,-0.25,-0.63,-0.78,-1.13,-1.75,-2.30,-3.25,-6,-8,-10,-11,-11,-10,-9,-7,-6,-5.38,-3.93,-2.87,-2.04,-1.68,-1.13,-0.63,0.25,0.36,0.46,0.37,0.34,0.34,0.34,0.33,0.34,0.37,0.47,0.35,0.10,-0.03,-0.29,-0.75,-1.18,-1.54,-1.63,-1.40,-0.64,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0,-0.14,-0.25,0.10,0.34,0.11,0,0,0.07,0.12,0.10,-0.80,-2,-4,-6,-7,-9,-11,-13,-14,-16,-17,-17,-17,-17,-17,-16,-16,-14,-13,-11,-9,-7,-4.93,-3.13,-2.91,-2.77,-2.40,-2.15,-2,-1.79,-1.13,0.87,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.10,0.11,0.12,0.12,0.12,0.12,0,0,-0.13,-0.30,-0.88,-1.50,-2.37,-3.43,-4.63,-5.87,-7,-8,-8,-8,-8,-7,-6,-6,-6,-5.99,-5.53,-2.75,-1.64,-1.50,-1.28,-1.13,-1,-0.88,-0.88,-0.93,-1.13,-1.50,-2.27,-3.75,-5.38,-7,-9,-11,-12,-13,-13,-11,-10,-9,-8,-7,-6,-4.89,-3.66,-2.38,-1.88,-1.38,-0.90,-0.42,0.37,0.37,0.37,0.48,0.48,0.48,0.50,0.59,0.37,-0.30,-0.38,-0.40,-1.01,-1.51,-1.88,-1.88,-1.93,-1.75,-1,0.37,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.70,-0.65,-0.63,0.62,0.35,0.12,0,0,0.08,0,-0.29,-1,-2,-4.28,-6,-8,-9,-11,-13,-15,-16,-17,-17,-17,-17,-17,-17,-16,-15,-14,-13,-11,-8,-6,-4.04,-3.27,-3.03,-2.78,-2.67,-2.79,-2.38,-1.52,-0.63,-0.02,0.33,0.50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0,0.12,0.23,0.25,0.24,0.21,0.10,-0.13,-0.63,-1.05,-1.87,-2.75,-4.13,-5.88,-7,-8,-8,-7,-6,-5.43,-4.77,-4.25,-3.75,-2.68,-1.55,-1.41,-1.38,-1.25,-1.25,-1.25,-1.25,-1.38,-1.43,-4.16,-4.25,-3.90,-6,-8,-10,-12,-13,-13,-14,-14,-12,-12,-11,-11,-9,-8,-6,-5.38,-4.38,-3.75,-3.13,-1.88,-1.38,-1,-0.63,-0.40,0.47,-0.50,-0.55,-0.63,-0.66,-0.88,-1.38,-1.66,-2.62,-3.01,-3.63,-4.03,-4,-2.79,-2.05,-1.38,-0.63,0.85,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.23,0.62,0.62,-0.63,0.62,0.62,0.23,0,0,0.12,-0.13,-0.50,-1.12,-2.88,-4.90,-6,-8,-9,-11,-13,-15,-16,-17,-18,-18,-18,-17,-17,-17,-16,-15,-14,-12,-10,-7,-5.25,-4.50,-3.93,-3.29,-2.93,-2.93,-2.75,-2.26,-1.53,-0.88,-0.03,0.20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.12,0.20,0.22,0.20,0.12,-0.25,-0.63,-1.01,-1.38,-1.75,-3.86,-6,-7,-6,-5.50,-4.50,-3.63,-3.04,-2.13,-1.43,-1.27,-1.16,-1.13,-1.13,-1.15,-1.25,-1.38,-1.50,-1.63,-4.37,-7,-7,-7,-9,-11,-11,-12,-13,-13,-13,-13,-13,-12,-12,-12,-11,-10,-8,-7,-6,-5.80,-5.50,-4.50,-3,-2,-1.66,-1.38,-1.30,-1.38,-1.65,-1.88,-2.25,-3.01,-3.38,-4.38,-5.53,-6,-7,-7,-7,-5.63,-3.38,-2,-0.77,0.75,0.24,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.33,0.62,-0.63,-0.63,0.62,0.25,0.08,0.08,0.12,-0.13,-0.64,-1.90,-3.63,-5.93,-7,-8,-9,-12,-14,-15,-17,-18,-18,-18,-18,-18,-17,-17,-17,-16,-15,-14,-11,-9,-7,-5.79,-5.01,-4.63,-4,-3.40,-3.25,-2.75,-2.39,-1.76,-0.75,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.12,0.12,0.12,-0.04,-0.38,-0.75,-1.13,-1.50,-1.80,-3,-3.13,-3.67,-3.50,-1.77,-1.52,-1.29,-1.13,-0.88,-0.77,-0.75,-0.77,-0.88,-1,-1.15,-1.38,-1.63,-1.78,-4.53,-7,-8,-8,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-13,-13,-12,-11,-9,-8,-8,-7,-7,-6,-5,-4.01,-3.38,-3.11,-3,-3.25,-3.62,-4.03,-4.54,-5.15,-5.88,-6,-7,-8,-8,-8,-8,-7,-5.36,-3.36,-1.16,0.62,0.62,0.23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.62,-0.42,-0.13,0.12,0.25,0.12,0.12,0.11,0.12,-1.13,-3.12,-4.53,-7,-8,-9,-10,-13,-15,-16,-17,-18,-18,-18,-18,-17,-17,-17,-17,-16,-16,-15,-13,-11,-10,-7,-6,-6,-5.25,-4.55,-3.87,-3.52,-2.91,-2.25,-1.15,-0.15,0.98,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.12,0.12,0,-0.17,-0.50,-0.88,-1.27,-1.63,-1.88,-1.91,-1.78,-1.63,-1.38,-1.01,-0.75,-0.51,-0.39,-0.41,-0.43,-0.54,-0.65,-1.13,-1.04,-1.26,-1.55,-1.88,-2.38,-5.55,-7,-8,-9,-10,-10,-10,-10,-9,-9,-10,-10,-11,-12,-13,-12,-11,-10,-9,-9,-9,-8,-7,-6,-5.65,-5,-4.66,-4.67,-5.05,-5.61,-6,-6,-7,-7,-8,-8,-9,-9,-9,-8,-7,-5.87,-3.79,-1.49,-0.64,0.62,0.35,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.23,0.49,0.24,0.12,0.24,0.25,0.24,0.25,0.10,-0.28,-1.50,-3.66,-5.80,-7,-9,-10,-12,-14,-16,-17,-18,-18,-18,-18,-17,-17,-16,-16,-16,-16,-16,-15,-14,-12,-11,-9,-7,-6,-6,-5.65,-5.11,-4.63,-3.99,-2.77,-1.77,-0.92,-1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.11,0.08,0,-0.04,-0.14,-0.38,-0.64,-1.01,-1.50,-1.89,-1.76,-1.50,-1.17,-0.78,-0.50,0,0.12,-0.03,-0.05,-0.13,-0.25,-0.68,-1.13,-1.13,-1.02,-1.38,-1.79,-1.67,-2.75,-4.63,-6,-7,-7,-7,-7,-7,-7,-7,-7,-8,-9,-10,-11,-11,-10,-10,-10,-10,-10,-9,-9,-7,-7,-6,-6,-6,-6,-7,-8,-8,-9,-9,-9,-9,-10,-10,-10,-9,-7,-6,-4.04,-2.05,-0.89,0.60,0.61,0.24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.24,0.34,0.32,0.25,0.23,0.12,0,-0.25,-0.65,-2.01,-4.30,-6,-8,-9,-11,-13,-16,-17,-18,-18,-18,-18,-17,-16,-16,-15,-15,-16,-16,-16,-15,-14,-13,-12,-11,-9,-8,-7,-7,-6,-6,-5.67,-4.37,-3.38,-2.17,-1.17,-0.63,-0.13,0.23,0.50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.11,0.09,0,-0.02,-0.13,-0.13,-0.29,-0.54,-0.88,-1.14,-1.28,-1.25,-1,-0.54,-0.26,0.12,0.62,0.70,0.34,0.12,0.10,0,-0.13,-0.13,-0.39,-0.52,-0.67,-0.79,-0.88,-1.25,-2.37,-3.53,-4.25,-4.68,-4.67,-4.63,-4.52,-4.38,-4.42,-4.87,-5.63,-6,-7,-8,-9,-9,-9,-10,-10,-10,-10,-9,-8,-7,-7,-7,-7,-8,-8,-9,-10,-10,-10,-10,-10,-10,-10,-10,-9,-7,-6,-4.15,-2.64,-1.14,-0.52,0.48,0.36,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.25,0.23,0.10,-0.02,-0.25,-0.42,-0.75,-1.13,-2.93,-5.12,-7,-8,-10,-11,-14,-17,-18,-18,-18,-17,-17,-16,-15,-15,-14,-14,-15,-15,-15,-15,-15,-14,-13,-12,-11,-10,-9,-9,-7,-7,-7,-6,-5.13,-3.88,-2.61,-1.53,-0.91,-0.38,0.12,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0.07,-0.01,-0.13,-0.15,-0.25,-0.38,-0.50,-0.65,-0.77,-0.79,-0.68,-0.43,-0.04,0.08,0.12,0.37,0.37,0.12,0.12,0.35,0.12,0.50,0.73,0.48,0.20,0.12,-0.25,-0.41,-0.75,-1.13,-1.25,-1.38,-1.38,-1.40,-1.50,-1.63,-1.76,-2.13,-3.14,-3.88,-4.62,-5.38,-6,-6,-7,-8,-9,-9,-10,-9,-9,-8,-8,-8,-8,-8,-9,-9,-10,-11,-11,-10,-10,-10,-10,-10,-9,-9,-7,-6,-4.24,-2.63,-1.50,0.37,0.37,0.37,0.22,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.20,0.25,0.11,-0.25,-0.50,-0.63,-0.79,-1.16,-2.13,-4.03,-5.93,-7,-8,-10,-11,-13,-16,-17,-17,-17,-17,-16,-15,-14,-13,-13,-13,-14,-14,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-9,-9,-8,-7,-6,-5,-3.77,-2.78,-1.75,-1.18,-0.43,0.87,0.87,0.87,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.20,0,-0.04,-0.15,-0.25,-0.30,-0.38,-0.38,-0.41,-0.41,-0.38,-0.14,-0.03,0.12,0.12,0.12,0.12,0.10,0.10,0.10,0.11,0.11,0.21,0.59,0.24,0.49,0.47,0.10,-0.13,-0.38,-0.55,-0.66,-0.75,-0.77,-0.88,-1,-1.05,-1.25,-1.50,-1.76,-2.43,-2.79,-2.65,-2.87,-4.37,-6,-7,-8,-8,-8,-8,-8,-8,-8,-8,-8,-9,-9,-10,-10,-11,-11,-10,-10,-10,-10,-10,-9,-8,-7,-6,-4.24,-2.51,-1.63,-0.63,0.33,0.37,0.36,0.22,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.24,0.25,0,-0.39,-0.88,-0.88,-1.13,-1.63,-3.38,-5.05,-6,-8,-9,-9,-10,-11,-13,-15,-15,-15,-15,-14,-14,-13,-12,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-11,-10,-9,-7,-6,-4.63,-3.63,-2.50,-1.88,-1.16,-0.63,-0.13,0.25,0.75,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.11,0.12,0.12,0.12,0.12,0.12,0.32,0.12,0,-0.12,-0.18,-0.43,-0.50,-0.38,-0.25,-0.15,-0.13,0.10,0.21,0.12,0.20,0.12,0.12,0.09,0.07,0,0.07,0.08,0.09,0.11,0.12,0.25,0.25,0.25,0.25,0.11,-0.01,-0.13,-0.25,-0.25,-0.27,-0.30,-0.50,-0.53,-0.75,-0.91,-1.13,-1.38,-1.53,-1.75,-1.91,-3,-4.39,-5.88,-6,-6,-6,-6,-6,-7,-7,-8,-8,-9,-9,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9,-8,-7,-6,-4.27,-2.67,-2.38,-1.40,-0.63,0.25,0.35,0.34,0.20,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.20,0.23,0.07,-0.27,-0.63,-0.88,-1.25,-2.66,-4.36,-6,-7,-8,-9,-9,-9,-10,-10,-12,-12,-13,-13,-12,-12,-11,-11,-11,-11,-11,-12,-12,-13,-13,-13,-14,-15,-15,-16,-16,-16,-15,-13,-11,-10,-8,-6,-5.63,-4.38,-3.42,-2.63,-1.93,-1.50,-1,-0.38,0.71,0.75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.12,0.20,0.22,0.23,0.23,0.23,0.25,0.25,-0.13,0,-0.05,-0.14,-0.27,-0.27,-0.18,-0.05,0.08,0.21,0.24,0.22,0.12,0.12,0.09,0.07,0,0,0,0,0,0,0.07,0.09,0.09,0.12,0.12,0.21,0.12,0.12,0.09,0,0,0,0,-0.01,-0.02,-0.17,-0.40,-0.51,-0.64,-0.88,-1.13,-1.26,-1.50,-2.24,-3.11,-3.74,-3.51,-4.12,-4.25,-5.17,-6,-7,-7,-8,-8,-9,-9,-9,-10,-10,-10,-10,-10,-10,-10,-10,-9,-7,-6,-4.50,-2.88,-2.63,-2.27,-1.38,-0.63,0.25,0.33,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.12,-0.04,-0.25,-0.50,-1.39,-3.50,-5.17,-6,-8,-8,-9,-8,-8,-8,-8,-8,-9,-10,-11,-11,-10,-10,-9,-9,-10,-10,-10,-11,-11,-11,-12,-13,-15,-16,-17,-17,-18,-16,-15,-13,-10,-9,-8,-6,-5.37,-4.38,-3.75,-3.13,-2.16,-1.75,-1.13,-0.75,0.75,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.22,0.20,0.12,0.12,0.23,0.25,0.25,0.25,0.21,0,0,-0.04,-0.05,-0.05,0,0.07,0.12,0.20,0.12,0.12,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.10,0.11,0.12,0.11,0.10,0.10,0.10,0.10,0.11,0.11,0.08,0,0.07,0.12,-0.25,-0.39,-0.63,-0.88,-1.16,-1.52,-1.88,-2.25,-2.38,-2.53,-3.11,-4.62,-6,-7,-7,-8,-8,-8,-9,-9,-9,-10,-10,-11,-11,-11,-10,-10,-8,-7,-4.75,-2.93,-2.88,-2.63,-2.27,-1.25,-0.38,0.23,0.33,0.21,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.23,0.12,0,-0.16,-1.88,-4.13,-5.77,-7,-8,-8,-8,-8,-7,-6,-5.13,-5.63,-6,-7,-7,-8,-8,-8,-8,-8,-9,-9,-9,-8,-9,-10,-11,-13,-14,-15,-17,-17,-18,-17,-15,-14,-12,-11,-10,-8,-6,-4.89,-4.50,-3.93,-3.25,-2.27,-2,-1.38,-0.88,-0.04,0.25,0.37,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.22,0.22,0.12,0,0,0.12,0.25,0.25,0.22,0.12,0.10,0.07,0,0.12,0.12,0.12,0.12,0.12,0.12,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.07,0.07,0.08,0.09,0.10,0.12,0.12,0.12,0.21,0.25,0.25,0.12,0,-0.15,-0.63,-1,-1.43,-1.88,-2.05,-2.25,-2.38,-3.27,-4.75,-5.63,-6,-6,-6,-7,-7,-8,-9,-9,-10,-11,-11,-12,-11,-11,-10,-8,-7,-5.25,-3.54,-2.87,-2.41,-1.75,-0.75,0.22,0.34,0.25,0.12,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.20,0.25,0.25,0.12,-0.50,-2.15,-4.25,-6,-7,-8,-8,-8,-7,-6,-4.88,-3.53,-2.26,-2.25,-2.50,-2.92,-5.51,-6,-7,-7,-7,-8,-8,-8,-7,-7,-8,-10,-12,-13,-15,-16,-16,-17,-16,-15,-14,-13,-13,-11,-10,-7,-5.38,-5,-4.61,-4,-2.92,-2.52,-2.18,-1.68,-0.88,-0.13,0.37,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0.20,0.12,0,-0.13,-0.03,0.12,0.23,0.22,0.12,0.12,0.12,0.12,0.12,0.12,0.12,0.11,0.10,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.10,0.12,0.12,0.12,0.25,0.33,0.36,0.32,-0.16,-0.54,-1,-1.41,-1.65,-1.88,-2.03,-2.18,-2.78,-3.50,-3.62,-3.50,-3.91,-5.04,-5.76,-7,-8,-9,-11,-12,-12,-13,-13,-12,-12,-11,-9,-7,-6,-3.53,-2.63,-2.25,-1.17,0.22,0.25,0.25,0.25,0.20,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.24,0.37,0.47,0.37,-0.42,-2.13,-4.25,-6,-8,-8,-9,-8,-7,-5.18,-2.55,-1.15,-0.88,-0.55,0.57,-1.13,-3.27,-4.89,-5.75,-6,-6,-6,-6,-6,-5.76,-6,-7,-8,-10,-12,-13,-14,-15,-16,-15,-15,-15,-14,-13,-12,-11,-9,-6,-5.75,-5.13,-4.38,-3.43,-2.91,-2.75,-2.38,-1.50,-0.65,0.12,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.20,0.12,0,-0.13,-0.13,0,0.12,0.21,0.12,0.11,0.08,0,0,0.07,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.09,0.07,0.12,0.12,0.23,0.12,-0.25,-0.63,-0.92,-1.17,-1.40,-1.63,-1.76,-1.91,-2.05,-2.17,-2.38,-2.93,-4,-4.63,-5.25,-7,-9,-11,-12,-13,-14,-14,-14,-14,-13,-12,-10,-8,-6,-2.79,-2.38,-1.65,-0.93,-0.38,0.20,0.23,0.23,0.12,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.37,0.37,0.37,-0.41,-2,-4.63,-6,-8,-9,-9,-8,-6,-3.54,-0.75,0.25,0.12,-0.25,0.48,-1,-2.11,-3.87,-4.80,-5.13,-5.38,-5.25,-4.63,-3.67,-4.17,-4.75,-5.43,-6,-8,-10,-11,-12,-13,-14,-14,-14,-14,-14,-14,-13,-11,-10,-8,-6,-6,-5,-3.66,-3.11,-2.92,-2.75,-2.13,-1.25,-0.30,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.20,0.12,0,-0.04,0,0.10,0.12,0.20,0.12,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.25,0.08,-0.13,-0.40,-0.67,-0.89,-1.13,-1.27,-1.41,-1.63,-1.75,-2,-2.25,-3.25,-4,-4.74,-6,-8,-11,-12,-14,-15,-15,-16,-16,-15,-14,-12,-10,-7,-5.36,-2.66,-2.27,-1.67,-1.13,-0.50,0.08,0.12,0.12,0.12,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.22,0.35,0.25,0.25,0.12,-0.50,-2.38,-4.93,-7,-8,-9,-9,-8,-6,-2.68,0.36,0.21,0.21,0.08,-0.63,-1.25,-2.13,-2.65,-3.43,-3.79,-3.79,-3.43,-3,-3.11,-3.24,-3.75,-4.13,-4.78,-5.63,-7,-8,-10,-11,-12,-13,-14,-14,-14,-14,-13,-12,-10,-9,-7,-6,-5.86,-4,-3.40,-3.54,-3.42,-2.88,-1.93,-1,0.12,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.20,0.12,0,0,0.09,0.12,0.22,0.12,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0.12,0.11,0,-0.25,-0.42,-0.63,-0.76,-0.88,-1,-1.18,-1.50,-1.78,-2.13,-2.87,-3.77,-4.86,-6,-9,-12,-14,-16,-16,-16,-15,-15,-15,-14,-12,-9,-7,-4.29,-2.63,-2.25,-1.75,-1.13,-0.63,-0.13,0,0.12,0.12,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.10,0,-0.04,-0.13,-0.13,-0.38,-0.86,-3.24,-6,-8,-9,-9,-9,-7,-5.41,-2.75,-1.16,0.25,0.10,-0.50,-1.01,-1.55,-2.13,-2.63,-2.64,-2.67,-2.75,-2.80,-3,-3,-3.02,-3.11,-3.28,-3.24,-3.50,-4.04,-5.74,-8,-9,-11,-12,-13,-13,-14,-13,-13,-12,-11,-10,-9,-8,-6,-5.27,-4.68,-4.38,-4.50,-4.37,-3.37,-1.93,-1.01,-0.30,0.10,0.32,0.23,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.21,0.12,0,0,0.12,0.24,0.21,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.12,0.12,0.12,0.12,-0.13,-0.18,-0.28,-0.38,-0.50,-0.64,-0.93,-1.26,-1.63,-2,-2.75,-3.64,-5.30,-7,-9,-12,-14,-14,-15,-14,-14,-14,-13,-12,-11,-9,-7,-5.18,-3,-2.16,-1.66,-1.13,-0.63,-0.13,0.12,0.21,0.12,0.11,0,0,0,0,0,0,0,0,0.12,0.24,0.25,0.25,0.25,0.22,0.12,0,-0.13,-0.39,-0.64,-0.80,-1.03,-1.75,-4.53,-7,-9,-10,-10,-9,-8,-5.91,-3.87,-1.92,-1,-0.80,-1.03,-1.50,-1.53,-1.75,-1.88,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2.13,-2.38,-2.66,-3.92,-6,-8,-9,-10,-11,-12,-13,-13,-13,-12,-11,-11,-10,-8,-7,-6,-6,-5.99,-6,-6,-5.37,-4.13,-2.36,-1.18,-0.53,0,0.25,0.23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.21,0.12,0,0.12,0.21,0.23,0.12,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.11,0.12,0.12,0.12,0.12,0.12,0.10,0,-0.13,-0.38,-0.63,-1,-1.43,-1.90,-2.93,-3.63,-5.03,-6,-7,-11,-13,-13,-13,-13,-13,-13,-12,-12,-10,-9,-7,-5.50,-3.26,-2.13,-1.63,-1.13,-0.63,-0.13,0.11,0.12,0.12,0.08,0,0,0,0,0,0,0.12,0.25,0.71,0.70,0.70,0.71,0.74,0.20,0,-0.25,-0.63,-1.25,-1.38,-1.63,-3.25,-6,-8,-10,-11,-11,-10,-8,-6,-4.26,-2.75,-1.54,-1.50,-1.63,-0.92,-0.79,-0.75,-0.75,-0.66,-0.75,-0.75,-0.88,-1,-1,-0.75,-0.88,-1.13,-1.29,-1.67,-2.25,-3.42,-5,-6,-8,-9,-10,-11,-12,-12,-12,-12,-11,-11,-10,-9,-8,-7,-7,-7,-7,-7,-6,-5.26,-3.40,-2.11,-1.16,-0.51,0,0.32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.20,0.20,0.20,0.12,0.21,0.12,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.12,0.12,0.12,0.12,0.11,0.09,-0.25,-0.38,-0.91,-1.50,-1.88,-2.53,-3.02,-3.41,-5.11,-8,-10,-11,-11,-11,-12,-12,-13,-13,-12,-10,-9,-7,-5.05,-2.87,-2.13,-1.67,-1.13,-0.55,-0.13,0.11,0.12,0.12,0,0,0,0,0.08,0.12,0.25,0.50,0.38,0.46,0.37,-0.13,0.73,0.22,0,-0.25,-0.63,-1.29,-1.54,-2.13,-4.65,-7,-9,-11,-11,-11,-10,-9,-6,-4.13,-2.52,-1.29,-0.75,-0.75,-0.38,0.12,0.11,0.46,0.71,0.74,0.75,0.87,0.97,0.98,0.62,0.20,-0.38,-0.53,-0.89,-1.51,-2.49,-4.11,-5.29,-6,-7,-9,-10,-11,-12,-12,-12,-12,-11,-10,-9,-9,-9,-8,-9,-9,-8,-7,-6,-4.11,-2.75,-1.75,-1.04,-0.50,-0.13,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.12,0.21,0.20,0.12,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.10,0.12,0.12,0.12,0.25,0.09,-0.13,-0.50,-0.88,-1.38,-1.75,-2.13,-2.38,-4.50,-7,-9,-9,-9,-10,-11,-12,-13,-13,-13,-12,-10,-8,-6,-3.36,-2.50,-2.13,-1.63,-1.04,-0.50,0,0.22,0.23,0.12,0.10,0.11,0.20,0.25,0.37,0.46,0.46,0.36,0.32,0.25,0.25,0.73,0.22,0.10,-0.13,-0.38,-0.76,-1.25,-2.65,-5.13,-7,-9,-10,-11,-11,-10,-8,-5.89,-3.38,-1.38,-0.63,0.58,0.72,0.50,0.22,0.23,0.25,0.24,0.21,0.12,0.07,0,0,0.25,0.12,0,-0.12,-0.16,-0.66,-1.05,-2.64,-4.14,-5.25,-6,-7,-9,-10,-12,-12,-12,-12,-11,-10,-9,-9,-10,-10,-10,-9,-9,-8,-6,-4.38,-2.88,-2,-1.38,-0.92,-0.63,-0.15,0.22,0.57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.10,0.12,0.11,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.20,0.12,0.08,-0.13,-0.29,-0.75,-1.14,-1.54,-2,-3.65,-6,-8,-8,-8,-8,-10,-11,-12,-13,-13,-12,-11,-10,-7,-5.38,-3.37,-2.53,-2.13,-1.53,-0.89,0,0.22,0.34,0.22,0.20,0.25,0.37,0.62,0.50,0.45,0.37,0.32,0.33,0.33,0.32,0.25,0.20,0.21,0,-0.14,-0.25,-1.02,-2.75,-5.16,-7,-9,-10,-10,-10,-9,-7,-4.38,-1.53,-0.67,0.57,0.62,0.12,0.09,0.12,0.12,0,0,0,0,0,0,0,0,0,0.12,0.24,0.12,-0.01,-0.17,-0.74,-2.64,-4.04,-4.86,-5.80,-8,-10,-12,-14,-14,-12,-10,-10,-10,-10,-10,-10,-10,-9,-9,-8,-6,-4.03,-2.50,-1.93,-1.50,-1.17,-1.01,-0.75,-0.38,-0.13,0.63,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.25,0.25,0.11,0,-0.50,-0.88,-1.38,-2.13,-4.75,-6,-7,-6,-7,-8,-10,-11,-12,-12,-12,-12,-11,-9,-7,-5.75,-3.88,-2.50,-2.01,-1.41,-0.75,0.24,0.33,0.35,0.32,0.37,0.50,0.62,0.12,0.11,0.12,0.37,0.46,0.50,0.25,0.12,0.07,0.12,0,-0.13,-0.39,-0.78,-2.38,-4.42,-6,-8,-9,-9,-8,-6,-4.75,-2,-0.68,0.71,0.60,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.22,0.37,0.20,-0.28,-1.25,-2.50,-3.42,-5.49,-7,-9,-11,-13,-13,-12,-11,-11,-11,-10,-10,-10,-9,-8,-7,-6,-4.92,-3.13,-2.13,-1.86,-1.50,-1.26,-1.17,-1.13,-0.78,-0.50,-0.40,0.82,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.22,0.24,0.25,0.08,0,-0.76,-1.38,-1.76,-3.40,-4.25,-3.91,-4.63,-7,-9,-10,-11,-12,-12,-13,-13,-12,-10,-7,-5.15,-3.25,-2.41,-2.13,-1.39,-0.63,0.36,0.37,0.37,0.37,0.23,0.11,0,-0.13,0.11,0.45,0.45,0.25,0.12,0,0,0.08,0,-0.12,-0.30,-0.75,-1.86,-3.80,-5.25,-6,-7,-7,-6,-4.17,-2.41,0.33,0.71,0.74,0.20,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.25,0.12,-0.38,-1.25,-2.02,-3.13,-5.25,-6,-8,-10,-12,-12,-12,-13,-12,-11,-11,-10,-9,-8,-7,-6,-4.86,-3.04,-2.04,-1.80,-1.63,-1.40,-1.36,-1.26,-1.25,-1.13,-0.92,-0.41,0.73,0.82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.25,0.25,0.24,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.12,0.25,0.25,0.20,-0.15,-0.54,-1,-1.50,-2,-2.30,-3.88,-6,-8,-9,-10,-11,-12,-13,-14,-13,-11,-8,-6,-4.38,-2.78,-2.55,-2.28,-1.41,-0.66,0.37,0.25,0.25,-0.13,-0.25,-0.16,-0.13,0.12,0.37,0.35,0.12,0,0,0,0,0.07,0,-0.25,-0.55,-1.37,-2.75,-4.25,-5.27,-5.68,-5.25,-3.74,-2.18,-0.51,0.25,0.24,0.20,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.24,0,-0.52,-1.38,-2.13,-3.52,-5.28,-6,-8,-9,-10,-11,-13,-14,-13,-11,-10,-9,-8,-6,-5.25,-3.53,-2.29,-1.75,-1.88,-1.64,-1.42,-1.38,-1.28,-1.28,-1.38,-1.39,-1.38,-0.88,-0.38,0.22,0.37,0.33,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.12,0.12,0.20,0.22,0.12,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.25,0.62,0.08,-0.18,-0.42,-0.88,-1.50,-2.13,-2.30,-5.38,-7,-8,-9,-10,-12,-13,-14,-13,-11,-9,-7,-5.25,-3.77,-2.90,-2.63,-2.38,-1.51,-1,-0.67,-0.55,-0.63,-0.51,-0.28,-0.13,0.25,0.37,0.25,0.12,0,0,0,0.09,0.12,0.12,0,-0.41,-1.17,-1.86,-2.80,-3.64,-3.75,-2.93,-1.63,-0.14,0.22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.32,0.10,-0.50,-1.29,-1.93,-3.40,-5.25,-6,-7,-8,-9,-11,-12,-13,-12,-10,-9,-9,-7,-5.25,-3.24,-1.63,-1.38,-1.75,-1.77,-1.63,-1.50,-1.49,-1.27,-1.36,-1.38,-1.41,-1.41,-1.25,-0.80,-0.38,0.22,0.37,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.12,0.12,0,0.12,0.12,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.13,0.07,-0.13,-0.25,-0.88,-1.38,-1.88,-2.88,-5.37,-6,-7,-9,-11,-13,-13,-13,-12,-10,-8,-6,-4.55,-3.41,-2.88,-2.63,-2.38,-1.89,-1.63,-1.50,-1.25,-0.89,-0.41,0.23,0.37,0.36,0.25,0.12,0,0,0.12,0.12,0.12,0.12,-0.05,-0.50,-1,-1.55,-1.76,-2.11,-1.78,-1.12,-0.05,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.33,0.25,-0.25,-0.75,-1.39,-2.75,-4.77,-6,-6,-7,-9,-10,-11,-11,-10,-10,-9,-7,-5.78,-3.51,-1.68,-1.28,-1.50,-1.75,-1.88,-1.78,-1.52,-1.43,-1.39,-1.38,-1.18,-1.25,-1.28,-1.25,-1.05,-0.77,-0.38,0.22,0.37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.11,0.12,0.10,0,0,0.08,0.12,0.11,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.12,0.12,0.12,0,-0.75,-1.29,-2.25,-3.61,-5,-6,-8,-10,-12,-13,-13,-11,-10,-8,-7,-5.89,-4.75,-3.37,-2.88,-2.65,-2.50,-2.38,-2.25,-2.13,-1.30,-0.63,0,0.25,0.32,0.25,0.12,0.09,0.12,0.24,0.21,0.09,-0.13,-0.38,-0.65,-1.01,-1.25,-1.27,-0.93,-0.30,0.13,0.37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.24,0.24,0.12,0.20,-0.91,-2,-4.03,-5.38,-6,-7,-9,-10,-11,-10,-9,-9,-8,-5.93,-3.75,-2.29,-1.75,-1.66,-1.88,-2,-2,-1.88,-1.52,-1.38,-1.50,-1.55,-1.15,-1.13,-1.25,-1.29,-1.30,-1.26,-0.89,-0.50,0.12,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.11,0.12,0.08,0,0,0.08,0.11,0.11,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.20,0.25,0.25,0.12,-0.13,-0.88,-1.50,-2.68,-4,-5.80,-7,-9,-11,-12,-12,-11,-10,-9,-8,-7,-5.93,-4.88,-3.63,-2.88,-2.79,-2.88,-2.80,-2.42,-2.13,-1.13,-0.39,0.12,0.25,0.33,0.33,0.33,0.37,0.25,0.07,-0.25,-0.50,-0.66,-0.88,-1.03,-1.01,-0.75,-0.30,0.25,0.25,0.33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.37,0.25,-0.67,-1.92,-2.87,-4.50,-6,-7,-8,-9,-9,-8,-8,-7,-6,-3.75,-2.50,-2.13,-1.88,-1.88,-1.90,-2.02,-1.93,-1.75,-1.75,-1.86,-1.63,-1.50,-1.51,-1.38,-1.38,-1.50,-1.55,-1.63,-1.63,-1.13,-0.50,-0.13,0.33,0.33,0.33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.11,0.07,0,0,0.08,0.11,0.11,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.22,0.21,-0.04,-0.50,-1.13,-1.68,-2.54,-4.18,-6,-7,-9,-11,-11,-11,-11,-10,-9,-8,-7,-6,-4.89,-4.25,-4.29,-4.37,-3.54,-3.25,-2.49,-1.67,-0.67,0.25,0.37,0.37,0.37,0.59,0.25,0.11,-0.28,-0.63,-0.88,-0.92,-1,-0.88,-0.68,-0.38,0.22,0.50,0.23,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.20,0.37,0.59,-0.67,-1.92,-2.75,-3.50,-4.74,-5.78,-6,-7,-7,-7,-6,-5.63,-3.77,-2.62,-2.13,-1.77,-1.77,-1.80,-1.92,-2.04,-1.88,-1.67,-1.88,-2.03,-1.76,-1.51,-1.29,-1.64,-1.65,-1.88,-1.88,-1.92,-2.05,-1.88,-1.41,-0.92,-0.38,0.11,0.37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.11,0.07,0,0,0.08,0.11,0.10,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.12,0.08,-0.25,-0.75,-1.30,-1.89,-2.38,-4.17,-6,-8,-10,-11,-11,-11,-10,-10,-9,-8,-7,-7,-7,-7,-6,-6,-4.13,-3.41,-2.24,-0.89,0.25,0.37,0.46,0.35,-0.52,0.37,-0.39,-0.75,-1,-1.13,-1,-0.80,-0.54,-0.28,0,0.25,0.23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.33,0.34,0.32,-0.90,-2,-2.78,-3.53,-4.37,-4.80,-5.54,-6,-6,-6,-5,-3.66,-2.61,-2.25,-1.88,-1.51,-1.50,-1.66,-1.78,-1.77,-1.53,-1.67,-2,-1.74,-2.50,-1.63,-1.36,-1.88,-2.16,-2.25,-2.28,-2.26,-2.50,-2.39,-2.25,-1.76,-1.15,-0.53,0.11,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.11,0,0,0,0.07,0.11,0.10,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0.12,-0.01,-0.28,-1,-1.63,-2.13,-2.52,-3.89,-6,-8,-10,-11,-11,-11,-10,-10,-9,-9,-10,-9,-9,-9,-7,-5.43,-4,-2.63,-1.16,0.23,0.34,0.47,0.35,-0.50,-0.88,-1,-1.16,-1.25,-1.25,-0.92,-0.54,-0.25,-0.03,0.25,0.32,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.35,0.22,-0.03,-0.63,-1.27,-2.25,-2.91,-3.38,-4.18,-4.67,-4.88,-5.11,-5,-4.38,-3.16,-2.75,-2.29,-1.93,-1.63,-1.38,-1.25,-1.39,-1.80,-1.75,-1.50,-1.51,-1.25,-1.75,-2.41,-1.66,-1,-2.13,-2.66,-3.25,-3.24,-3.13,-3.11,-2.88,-2.75,-2.38,-1.78,-1.18,-0.50,0.12,0.37,0.33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.12,0.11,0,0,0,0.08,0.11,0.10,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.12,0.12,-0.14,-0.65,-1.30,-1.88,-2.38,-2.63,-3.63,-7,-9,-11,-11,-11,-11,-11,-10,-11,-12,-11,-11,-10,-8,-6,-4.13,-2.88,-1.50,-0.43,0.34,0.47,0.37,-0.55,-1.51,-1.53,-1.54,-1.50,-1.39,-1,-0.52,-0.13,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.97,0.49,0.10,-0.63,-1.26,-2.01,-2.88,-3.12,-3.25,-3.75,-4.26,-4.50,-4.38,-3.90,-3.16,-2.43,-2.28,-2.01,-1.75,-1.39,-1.16,-1.14,-1.27,-1.63,-1.92,-1.64,-1.63,-2.13,-2.50,-2.75,-2.50,-2.27,-2.38,-3.68,-5.36,-5.30,-5.13,-5.01,-4.49,-3.54,-3.04,-2.30,-1.78,-1.16,-0.50,0.12,0.37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.12,0.08,0,0,0.10,0.12,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.12,0.12,-0.03,-0.50,-1.01,-1.63,-2.13,-2.43,-2.67,-5,-8,-10,-11,-12,-12,-12,-12,-13,-14,-14,-14,-11,-8,-5.88,-4.13,-2.90,-1.88,-0.92,0.37,0.37,0.37,-0.88,-1.63,-2.02,-1.88,-1.75,-1.63,-1.13,-0.63,-0.15,0.22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.63,-0.30,-0.88,-1.37,-2,-3,-3,-3.12,-3.25,-3.29,-3.51,-3.74,-3.50,-2.92,-2.38,-2.04,-1.88,-1.76,-1.63,-1.38,-1.18,-1.13,-1.25,-1.43,-1.75,-1.92,-2,-2.41,-3.03,-3.51,-3.52,-3.88,-4.77,-7,-7,-8,-8,-7,-6,-5.65,-4.62,-3.38,-2.38,-1.88,-1.25,-0.63,-0.13,0.87,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.12,0.12,0.10,0.11,0.12,0.12,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.12,0,-0.28,-0.75,-1.29,-1.79,-2.25,-2.63,-4.13,-7,-9,-11,-12,-13,-14,-15,-16,-16,-17,-16,-13,-10,-7,-5.79,-3.86,-2.54,-1.53,-0.67,0.50,-0.64,-1.38,-2.40,-3.26,-3.24,-2.41,-1.88,-1.29,-0.63,-0.13,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.62,-0.63,-1.63,-2.13,-2.55,-2.88,-3,-3.03,-3.16,-3.25,-3.25,-3.17,-2.88,-2.54,-2.11,-1.77,-1.63,-1.63,-1.50,-1.38,-1.27,-1.25,-1.30,-1.41,-1.66,-1.89,-2.41,-3.38,-4.15,-4.50,-5.37,-6,-8,-9,-10,-10,-11,-10,-9,-7,-6,-4.93,-3.49,-2.39,-2,-1.43,-0.89,-0.38,-0.05,0.25,0.58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.12,0.12,0.12,0.12,0.12,0.12,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.11,0,-0.16,-0.53,-1,-1.51,-2,-2.41,-3.62,-6,-8,-11,-13,-14,-15,-16,-18,-18,-18,-17,-15,-12,-9,-7,-6,-5.25,-3.28,-1.88,-1.28,-1.38,-2.88,-4.92,-5.78,-5.53,-4.38,-2.80,-1.76,-0.63,0.32,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.63,-0.63,-1.75,-2.53,-2.88,-3,-3,-3,-3.12,-3.04,-3,-2.88,-2.66,-2.37,-1.89,-1.66,-1.55,-1.52,-1.50,-1.40,-1.38,-1.40,-1.50,-1.63,-2,-2.91,-3.99,-4.92,-5.50,-6,-8,-9,-10,-11,-12,-13,-14,-13,-12,-10,-7,-5.77,-4.38,-3,-2.54,-2.13,-1.88,-1.38,-0.92,-0.28,0.12,0.84,0.73,0.70,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.12,0.12,0.12,0.12,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0,-0.13,-0.38,-0.75,-1.25,-1.77,-2.25,-2.93,-4.65,-6,-11,-15,-16,-16,-17,-18,-19,-19,-18,-16,-14,-11,-9,-8,-7,-6,-4.88,-4.13,-4,-5.51,-6,-8,-7,-6,-4,-1.79,-0.67,0.73,0.20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.99,-1,-2,-2.63,-3,-3,-3,-3,-2.78,-2.66,-2.50,-2.25,-2.30,-2.01,-1.50,-1.38,-1.30,-1.41,-1.50,-1.50,-1.43,-1.55,-2,-3.13,-4.38,-5.26,-5.75,-6,-7,-8,-10,-11,-12,-12,-13,-14,-15,-14,-13,-11,-8,-6,-4.75,-3.50,-2.88,-2.63,-2.42,-2.25,-1.88,-1.38,-1,-0.63,-0.25,0.11,0.32,0.73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.10,0.10,0.10,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.10,0,-0.13,-0.50,-1,-1.63,-2.13,-2.55,-3.43,-6,-11,-15,-16,-16,-17,-17,-18,-18,-18,-17,-15,-13,-11,-10,-9,-8,-7,-6,-6,-7,-9,-9,-9,-7,-5.05,-1.63,0.62,0.74,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.50,-0.68,-1.90,-2.63,-2.90,-2.91,-2.75,-2.50,-2.16,-1.93,-1.65,-1.28,-0.93,-0.67,-0.54,-0.63,-0.88,-1.17,-1.63,-1.50,-1.50,-2.13,-3.75,-5.68,-7,-7,-7,-8,-9,-10,-11,-12,-13,-13,-13,-13,-13,-13,-12,-11,-9,-7,-4.74,-3.54,-3.01,-2.88,-2.88,-2.76,-2.43,-2.15,-2,-1.63,-1.13,-0.75,-0.25,0.70,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.07,-0.25,-0.75,-1.38,-2,-2.50,-3.63,-6,-9,-13,-15,-15,-16,-16,-17,-17,-17,-16,-15,-14,-13,-12,-11,-10,-9,-9,-9,-9,-10,-10,-10,-7,-3.88,-0.91,0.71,0.75,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.08,-0.92,-1.93,-2.63,-2.88,-2.75,-2.38,-1.76,-1.38,-1.13,-0.88,-0.38,0.62,0.57,0.45,0.38,-0.38,-0.88,-1.38,-1.63,-2.04,-3.37,-5.40,-7,-8,-9,-9,-9,-9,-10,-11,-11,-12,-12,-12,-12,-12,-12,-11,-10,-9,-7,-6,-4.77,-3.88,-3.12,-3,-2.93,-2.78,-2.66,-2.63,-2.40,-1.88,-1.50,-1.02,-0.62,-0.04,0.45,0.96,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.20,0,-0.50,-1.15,-1.88,-2.41,-3.88,-6,-8,-11,-13,-14,-15,-15,-16,-16,-16,-16,-15,-14,-13,-13,-12,-12,-11,-10,-10,-10,-11,-10,-9,-6,-2.38,0.23,0.72,0.20,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.21,-0.38,-1.25,-2.04,-2.55,-2.63,-2.29,-1.66,-0.90,-0.38,-0.13,-0.14,0.12,0.72,0.37,0.37,0.37,0.59,-0.63,-1.30,-1.79,-2.74,-4.25,-6,-7,-8,-9,-9,-9,-9,-10,-10,-11,-11,-12,-12,-12,-12,-11,-11,-10,-9,-8,-7,-5.93,-5.04,-4.49,-3.91,-3.67,-3.50,-3.14,-2.91,-2.76,-2.53,-2.25,-1.88,-1.43,-1.01,-0.65,-0.90,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.20,0.12,-0.25,-0.91,-1.66,-2.26,-3.43,-5.50,-7,-10,-12,-13,-13,-14,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-11,-11,-11,-10,-9,-7,-4.38,-0.88,0.25,0.34,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.50,-0.54,-1.62,-2.04,-2.25,-2.13,-1.50,-0.88,-0.05,0.25,0.45,0.12,0.12,0.12,0.12,0.21,0.33,0.48,-0.55,-1.39,-2.13,-3,-4.50,-6,-7,-9,-10,-10,-9,-9,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-9,-8,-8,-7,-6,-5.99,-5.25,-4.99,-4.68,-4.38,-3.50,-3,-2.93,-2.75,-2.52,-2.26,-1.93,-1.54,-1.01,-0.41,0.12,0.37,0.37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.21,0.12,-0.13,-0.75,-1.43,-2.13,-2.52,-4.18,-6,-9,-11,-12,-13,-14,-14,-14,-15,-15,-15,-15,-15,-14,-14,-13,-12,-12,-11,-10,-9,-7,-5.50,-1.87,-0.55,0.61,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.87,-0.88,-1.88,-1.91,-1.88,-1.28,-0.63,-0.13,0.25,0.25,0.21,0,0,0,0,0.07,0.21,0.12,-0.64,-1.52,-2.25,-3,-4.25,-5.67,-7,-8,-9,-9,-9,-9,-9,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9,-9,-8,-8,-7,-7,-6,-6,-5.93,-5.40,-4.67,-3.80,-3,-2.88,-2.92,-3.05,-2.63,-1.99,-1.25,-0.54,-0.13,0.07,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.22,0.21,0,-0.50,-1.13,-1.88,-2.38,-2.75,-4.36,-7,-9,-11,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-14,-13,-12,-12,-11,-10,-8,-6,-2.99,-0.63,0.62,0.62,0.24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.87,-0.88,-1.88,-1.63,-1.15,-0.50,0.11,0.37,0.37,0.20,0.09,0,0,0,0,0,0.12,0.07,-0.68,-1.63,-2.29,-2.88,-3.63,-4.75,-6,-7,-8,-8,-8,-8,-9,-9,-10,-11,-11,-11,-12,-12,-11,-11,-11,-11,-10,-10,-9,-9,-9,-8,-8,-8,-7,-7,-6,-5.36,-4.55,-3.66,-3.89,-4,-3.91,-3.75,-2.89,-1.75,-1.13,-0.88,-0.63,-0.25,0.22,0.50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1,-1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.20,0.22,0.12,0,-0.88,-1.63,-2.25,-2.68,-3.77,-6,-8,-11,-13,-14,-14,-14,-14,-14,-15,-16,-17,-16,-14,-13,-12,-11,-11,-10,-7,-4.65,-1.25,0.58,0.60,0.35,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.12,-0.65,-1.38,-1.38,-0.75,0.09,0.32,0.34,0.12,0,0,0,0,0,0,0,0.11,0,-0.63,-1.50,-2.14,-2.75,-3.13,-3.38,-4.42,-5.55,-6,-6,-7,-8,-8,-9,-10,-10,-11,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9,-9,-8,-7,-6,-5.63,-5.29,-5.51,-6,-6,-5.14,-3.90,-3.02,-2.15,-1.65,-1.13,-0.63,-0.01,0.96,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.24,0.34,0.25,-0.54,-1.26,-1.88,-2.50,-3.50,-5.26,-7,-12,-14,-15,-15,-15,-15,-15,-16,-17,-17,-16,-14,-12,-11,-11,-12,-11,-7,-3.40,-0.25,0.58,0.35,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.24,0.49,0,-0.68,-1.26,-1.01,-0.38,0.21,0.25,0.10,0,0,0,0,0,0,0,0,0,0.24,-0.30,-1.03,-1.76,-2.38,-2.75,-2.88,-3.13,-4.11,-4.75,-6,-7,-7,-8,-8,-9,-10,-11,-12,-13,-13,-13,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-9,-9,-8,-8,-7,-7,-8,-8,-8,-8,-6,-5,-3.88,-2.88,-2.05,-1.50,-0.90,-0.90,1,1,1,0.12,0.25,0.24,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.35,0.50,-0.25,-0.90,-1.63,-2.25,-3.15,-4.26,-6,-11,-14,-15,-15,-15,-15,-15,-16,-17,-17,-16,-15,-13,-12,-12,-12,-10,-7,-3.13,0.01,0.37,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.25,0.24,-0.38,-0.79,-1.13,-0.63,-0.16,0.12,0.12,0,0,0,0,0,0,0,0,0,0,0.34,0.12,-0.50,-1.13,-1.75,-2.26,-2.38,-2.50,-3.13,-3.75,-4.75,-6,-6,-6,-7,-8,-9,-11,-12,-13,-14,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9,-9,-9,-9,-10,-10,-11,-11,-10,-7,-5.67,-4.13,-2.88,-2.27,-1.88,-1.38,-0.88,-0.26,0.12,0.23,0.59,0.60,0.37,0.23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.23,0.70,0.25,-0.54,-1.28,-2,-2.50,-3.55,-5.63,-9,-13,-15,-15,-15,-14,-15,-15,-16,-17,-16,-15,-14,-13,-12,-12,-10,-6,-1.63,0.25,0.25,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.12,-0.38,-0.77,-1,-0.88,-0.38,0.22,0.35,0.12,0,0,0,0,0,0,0,0,0,0,0.33,0.37,0.11,-0.38,-1.02,-1.64,-1.88,-2,-2.16,-2.50,-3,-3.75,-4.41,-5.04,-5.63,-7,-8,-10,-11,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-11,-11,-12,-13,-13,-12,-10,-8,-6,-4.50,-2.87,-2.50,-2.25,-1.89,-1.39,-1,-0.67,-0.53,0.58,0.60,0.70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.84,-0.50,-0.88,-1.50,-1.93,-2.30,-3.38,-6,-10,-13,-14,-13,-13,-13,-14,-15,-16,-16,-15,-14,-13,-12,-11,-8,-4.25,-0.75,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,-0.38,-1.01,-1.43,-1.38,-0.75,-0.13,0.22,0.22,0.07,0,0,0,0,0,0,0,0,0,0,0.11,0.25,0.25,0.22,-0.38,-0.90,-1.13,-1.38,-1.55,-1.75,-2,-2.25,-2.75,-3.25,-3.63,-4.38,-6,-8,-10,-12,-13,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-11,-11,-11,-12,-12,-13,-14,-14,-13,-12,-10,-9,-7,-4.61,-3,-2.75,-2.54,-2.25,-2,-1.63,-1.16,-0.79,-0.63,0.60,0.75,0.73,0.25,0.22,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.75,0.46,-0.26,-0.76,-1.25,-1.64,-2,-3.13,-6,-10,-12,-11,-11,-12,-13,-14,-15,-15,-15,-14,-12,-11,-9,-6,-2.38,0.83,0.20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.21,0.23,-0.13,-0.63,-1.50,-1.65,-1.43,-0.63,-0.02,0.33,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.20,0.50,0.24,-0.02,-0.38,-0.64,-0.88,-1.02,-1.38,-1.75,-2.17,-2.51,-2.75,-2.88,-3.88,-5.61,-7,-9,-10,-11,-11,-11,-11,-12,-12,-12,-12,-13,-12,-12,-12,-12,-12,-11,-11,-11,-12,-12,-13,-14,-14,-14,-14,-13,-11,-10,-8,-6,-4.63,-3.05,-3,-2.88,-2.68,-2.27,-2,-1.75,-1.25,-0.75,-0.25,0.62,0.62,0.62,0.22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.23,0.48,0.25,0.08,-0.51,-1,-1.50,-1.92,-3.37,-7,-9,-10,-10,-10,-11,-12,-13,-14,-14,-13,-11,-9,-6,-4.05,-1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.32,0.22,-0.39,-0.88,-1.63,-1.65,-1.13,-0.38,0.10,0.22,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0.35,-0.13,-0.25,-0.38,-0.63,-1.18,-1.75,-2.17,-2.38,-2.51,-2.93,-3.53,-5,-6,-8,-9,-9,-9,-10,-10,-11,-10,-11,-11,-12,-12,-12,-12,-11,-11,-11,-12,-12,-13,-13,-14,-14,-14,-14,-13,-12,-10,-9,-7,-6,-4.88,-4.13,-3.26,-3.12,-2.88,-2.75,-2.38,-2.13,-1.63,-1.13,-0.68,-0.18,0.62,0.73,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.23,0.25,0.20,-0.05,-0.43,-1.01,-1.55,-2.88,-5.50,-7,-8,-8,-9,-10,-12,-13,-13,-13,-12,-11,-9,-6,-4.13,-1.01,0.87,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.87,0.13,-0.37,-0.77,-1.18,-1.55,-1.42,-0.75,-0.13,0.22,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.23,0.22,0.12,0.12,-0.17,-0.63,-1.18,-1.63,-1.77,-1.89,-2.04,-2.51,-2.66,-3.74,-5,-5.93,-6,-7,-7,-7,-7,-7,-8,-9,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-14,-14,-14,-14,-13,-11,-10,-9,-8,-7,-6,-5.38,-4.75,-3.75,-3.99,-3.40,-3.64,-4.25,-3.13,-2,-1.64,-1.13,-0.75,-0.25,0.08,0.32,0.23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.12,0.21,0.11,-0.25,-0.67,-1.25,-2.67,-5.38,-7,-7,-7,-9,-10,-11,-12,-13,-12,-12,-10,-8,-6,-3.90,-1.50,0.08,0.12,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.33,0.62,-0.38,-0.88,-1.25,-1.63,-1.50,-1.13,-0.38,0.24,0.35,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0.25,0.23,0,-0.28,-0.50,-0.75,-1,-1,-1.43,-1.89,-2.13,-2.50,-3.02,-3.63,-4.13,-4.25,-4.14,-4.25,-4.63,-5.25,-6,-9,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-13,-13,-12,-11,-10,-9,-8,-7,-7,-6,-6,-6,-5.99,-6,-6,-6,-5.50,-3.39,-2.38,-2.01,-1.63,-1.13,-0.52,0,0.25,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.10,-0.13,-0.43,-0.91,-2.30,-4.38,-6,-7,-8,-10,-11,-12,-12,-13,-12,-11,-10,-8,-6,-4.13,-1.75,-0.16,0.84,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.25,0.23,0.09,-0.52,-1.50,-1.75,-1.63,-1.38,-0.67,0,0.24,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.84,0.84,0.86,0.87,0.98,1,0.50,-0.68,-1.25,-1.51,-1.75,-1.88,-2,-2.13,-2.50,-2.93,-3.11,-3,-2.91,-4.03,-6,-8,-10,-11,-10,-10,-10,-10,-11,-11,-12,-12,-12,-12,-11,-11,-10,-9,-9,-8,-8,-7,-7,-7,-7,-7,-8,-8,-7,-6,-4.91,-3,-2.63,-2.28,-1.88,-1.25,-0.63,-0.16,0.87,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.10,0,-0.25,-0.63,-1.50,-3.50,-5.03,-5.75,-8,-11,-11,-12,-12,-12,-11,-10,-9,-7,-5.75,-3.75,-1.62,-0.25,0.82,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.11,0.12,0.12,0.10,0,0.08,0.11,0.20,0.24,0.07,-0.26,-0.76,-1.38,-1.63,-1.54,-0.88,-0.40,0.50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.58,-0.38,-0.63,-0.88,-1.13,-1.25,-1.39,-1.63,-1.88,-2.13,-2.30,-2.51,-2.68,-2.76,-4.15,-6,-7,-8,-9,-9,-9,-9,-10,-10,-11,-10,-10,-10,-10,-9,-9,-9,-8,-8,-8,-8,-8,-8,-8,-8,-9,-9,-8,-8,-7,-5.41,-3.89,-3,-2.41,-2,-1.50,-0.88,-0.88,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.10,-0.02,-0.28,-0.75,-1.92,-3.50,-4.38,-6,-9,-10,-11,-11,-11,-9,-8,-7,-6,-4.40,-2.74,-1.25,-0.39,0.62,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0.08,0.10,0.12,0.12,0.21,0.24,0.23,0.21,0.20,0.20,0.25,0.37,0.13,-0.14,-0.50,-0.89,-1.28,-1.38,-1,-0.39,0.34,0.46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.71,0.48,-0.13,-0.38,-0.53,-0.63,-0.88,-1.13,-1.29,-1.55,-1.88,-2.13,-2.28,-2.50,-2.63,-3.52,-4.75,-5.75,-6,-6,-7,-7,-7,-8,-9,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-9,-9,-9,-9,-9,-9,-9,-8,-7,-4.88,-3.75,-3,-2.42,-1.66,-0.90,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.12,-0.03,-0.29,-0.88,-2,-2.75,-3.76,-7,-9,-9,-9,-8,-7,-6,-5.25,-4.13,-3,-1.75,-1.29,-0.63,0.37,0.70,0.25,0.12,0,0,0,0,0.07,0.10,0.10,0.11,0.12,0.12,0.12,0.21,0.25,0.24,0.25,0.23,0.25,0.25,0.34,0.37,0.48,0.08,-0.29,-0.65,-1.02,-1.25,-1.13,-0.52,0.37,0.37,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.20,0.12,-0.13,-0.18,-0.38,-0.63,-0.75,-1,-1.25,-1.50,-1.67,-1.91,-2.13,-2.18,-2.38,-3.03,-3.52,-4.03,-4.50,-4.91,-5,-5.11,-5.38,-5.50,-5.50,-5.78,-6,-6,-6,-6,-7,-7,-7,-8,-8,-8,-9,-9,-9,-10,-10,-10,-10,-10,-9,-8,-6,-5.80,-4.53,-3.13,-1.50,-0.55,0.22,0.37,0.33,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.12,0.12,-0.13,-0.53,-1.13,-1.87,-2.43,-3.75,-5.52,-6,-5.67,-4.99,-4.26,-3.63,-3.02,-2.39,-1.67,-1.51,-1.29,-0.88,-0.38,0.33,0.73,0.12,0.07,0,0,0.12,0.25,0.23,0.21,0.21,0.12,0.12,0.20,0.12,0.12,-0.13,-0.13,-0.13,-0.01,0,0.33,0,0.10,-0.28,-0.54,-0.88,-1.04,-1.14,-1.15,-0.25,0.83,0.23,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.11,0,0,-0.13,-0.25,-0.30,-0.50,-0.63,-0.76,-0.88,-1.15,-1.38,-1.50,-1.39,-1.38,-1.55,-1.88,-2.24,-2.38,-2.43,-2.43,-2.63,-3,-3.25,-3.25,-3.64,-4.64,-5.11,-5.41,-5.78,-6,-6,-7,-8,-8,-9,-9,-9,-9,-10,-11,-11,-11,-11,-11,-10,-9,-7,-5.16,-3,-1.50,-0.63,0.22,0.37,0.33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.20,0.11,-0.15,-0.65,-1.38,-2,-2.53,-2.88,-2.86,-2.14,-1.25,-1.24,-1.26,-1.63,-1.50,-1.43,-1.39,-1.29,-1.05,-0.75,-0.25,0,0.12,0.58,1,0.87,0.74,0.45,0.25,0.20,0.11,-0.13,-0.13,-0.13,-0.25,-0.41,-0.66,-0.80,-0.88,-0.75,-0.67,-0.63,-0.63,-0.66,-0.75,-0.89,-1,-1.05,-1.03,-0.75,-0.25,0.20,0.32,0.22,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.01,-0.04,-0.13,-0.17,-0.25,-0.16,-0.28,-0.50,-0.63,-0.63,-0.53,-0.54,-0.66,-0.80,-0.91,-0.92,-0.88,-1.25,-1.88,-2.63,-2.65,-2.77,-3.02,-3.65,-4,-4.29,-4.75,-5.50,-6,-7,-7,-8,-8,-8,-9,-10,-11,-11,-12,-12,-13,-13,-13,-10,-7,-4.62,-2.62,-1.40,-0.63,0.11,0.22,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.23,0.37,0.32,0.23,-0.92,-1.88,-2.38,-2.01,-1.30,-0.13,0.75,0.83,-0.63,-1.28,-1.28,-1.38,-1.38,-1.38,-1.25,-1.03,-0.67,-0.50,-0.38,-0.38,-0.53,-0.50,-0.30,0.08,-0.26,-0.38,-0.50,-0.63,-0.64,-0.75,-1,-1.17,-1.42,-1.63,-1.63,-1.63,-1.63,-1.63,-1.50,-1.39,-1.29,-1.25,-1.14,-1.13,-0.91,-0.63,-0.25,0.12,0.24,0.12,0.62,0.87,0.99,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.12,0.07,-0.03,-0.03,0,-0.03,-0.15,-0.25,-0.38,-0.25,-0.03,-0.15,-1.26,-1.88,-2.29,-2.25,-2.27,-2.40,-2.75,-2.27,-3,-3.53,-4.75,-5.75,-6,-6,-7,-7,-8,-9,-10,-11,-12,-13,-14,-16,-15,-12,-8,-5.89,-3.50,-2.17,-1.25,-0.38,0.12,0.12,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.21,0.37,0.47,-0.75,-1.88,-2.51,-2.01,-1,0.36,0.83,0.74,-0.13,-0.66,-1.04,-1.25,-1.38,-1.43,-1.40,-1.29,-1.13,-1,-1,-1.05,-1.30,-1.37,-1.17,-1.04,-1,-1.03,-1.13,-1.25,-1.38,-1.50,-1.76,-2.15,-2.50,-2.75,-2.74,-3,-3,-4.77,-3,-2.25,-1.75,-1.50,-1.28,-1.13,-0.93,-0.68,-0.39,-0.38,-0.28,-0.25,-0.25,-0.50,-0.88,-0.63,-0.55,0.50,0.36,0.25,0.37,0.20,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.10,0.12,0.22,0.25,0.20,0.12,0.12,0.12,0.08,0,0,0.09,0.47,0.12,-0.75,-1.50,-1.37,-1.18,-1.02,-1,-1.01,-1.30,-1.75,-2.25,-2.50,-3.53,-4.24,-4.75,-5.43,-6,-7,-8,-9,-10,-12,-13,-15,-17,-16,-13,-10,-7,-4.63,-3.18,-1.88,-1,-0.13,0.85,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.84,-0.88,-1.88,-2.89,-2.93,-1,1,0.12,0.75,0.21,-0.38,-0.78,-1.25,-1.40,-1.51,-1.52,-1.50,-1.38,-1.38,-1.38,-1.54,-1.68,-1.92,-1.80,-1.75,-1.64,-1.75,-1.89,-2.16,-2.50,-2.88,-3.37,-3.75,-4.04,-4.25,-4.25,-4.50,-5.40,-7,-6,-2.75,-1.91,-1.63,-1.38,-1.25,-1.03,-0.88,-0.67,-0.75,-0.75,-0.75,-0.80,-1,-1.13,-1.02,-0.75,-0.51,-0.13,0,0.25,0.25,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.10,0.10,0.09,0.08,0.07,0,0.08,0.36,0.62,-0.88,-0.50,-0.38,0.25,0.32,0.45,0.75,-0.14,-0.92,-1.50,-1.88,-1.88,-2.38,-2.88,-3.54,-4.52,-5.74,-6,-8,-9,-11,-13,-15,-17,-16,-14,-11,-8,-6,-4.67,-3,-1.67,-0.67,0.85,0.87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.63,-0.63,-1.30,-2,-2,-1,1,0,0.12,0.25,-0.04,-0.55,-1.02,-1.38,-1.53,-1.63,-1.53,-1.40,-1.38,-1.39,-1.63,-1.75,-2.15,-2.29,-2.25,-2.25,-2.65,-3.24,-3.75,-4.13,-4.50,-4.87,-5.28,-5.62,-5.75,-5.76,-6,-6,-8,-5.50,-3.62,-2,-1.63,-1.39,-1.25,-1.17,-1.16,-1.17,-1.16,-1.16,-1.16,-1.25,-1.26,-1.38,-1.25,-1.28,-1.30,-1.13,-0.76,-0.25,0.12,0.36,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,0.87,0.62,0.48,0.45,0.34,0.32,0.12,0.22,-0.17,-0.64,-0.88,-0.89,-1.13,-1.38,-1.75,-2.25,-4.13,-5.38,-6,-7,-9,-12,-15,-16,-16,-14,-12,-10,-8,-6,-5.13,-3.93,-1.41,-0.29,0.22,0.33,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.62,0.57,-0.88,-2,-2,-1,1,0,0,0.62,0.24,-0.37,-0.88,-1.25,-1.53,-1.64,-1.63,-1.50,-1.18,-1.25,-1.63,-1.75,-2.24,-2.50,-2.66,-3.88,-4.75,-5.25,-5.55,-5.75,-5.93,-6,-6,-6,-6,-6,-6,-7,-5.63,-4.88,-2.50,-1.88,-1.53,-1.29,-1.18,-1.25,-1.38,-1.50,-1.63,-1.64,-1.52,-1.50,-1.41,-1.25,-1.63,-1.75,-1.92,-1.90,-1.67,-1.13,-0.43,0.12,0.25,0.21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.12,0.12,0.12,0,0.11,0.35,0.12,-0.01,-0.13,-0.14,-0.41,-0.75,-1.16,-1.75,-2.52,-3.53,-4.41,-5.62,-7,-10,-14,-15,-16,-14,-12,-11,-9,-8,-7,-5.39,-2.52,-0.91,-0.13,0.21,0.21,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0,0,0,0,0,0.32,0.58,-0.63,-1.88,-1.80,-0.80,0.83,0.12,0,0.20,0.32,-0.05,-0.63,-1.15,-1.63,-1.75,-1.75,-1.68,-1.75,-1.75,-2,-2.55,-4.38,-5.13,-5.75,-6,-6,-7,-7,-7,-7,-7,-7,-7,-7,-6,-6,-5.50,-4.63,-2.50,-2,-1.63,-1.27,-1.03,-1,-1,-1.13,-1.27,-1.39,-1.38,-1.18,-1.13,-1.38,-1.40,-1.25,-1.50,-1.88,-2.03,-1.93,-1.63,-0.92,-0.27,0.21,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.22,0.12,0.12,0.09,-0.03,-0.25,-0.63,-1.15,-1.75,-2.39,-3.01,-3.86,-5.13,-8,-11,-14,-14,-14,-13,-12,-11,-9,-8,-6,-4.43,-1.88,-0.38,0.20,0.32,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.25,1.60,1.60,0.25,0,0,0,0,0,0.85,-0.77,-1.75,-1.75,-0.75,0.73,0.23,0.12,0.22,0.37,0.23,-0.38,-1,-1.39,-1.79,-1.88,-1.91,-2.13,-2.62,-3.90,-5.30,-6,-7,-8,-8,-8,-8,-8,-8,-7,-7,-7,-6,-6,-5.63,-4.75,-3.90,-2.61,-1.77,-1.54,-1.16,-0.88,-0.64,-0.63,-0.63,-0.63,-0.67,-0.68,-0.63,-0.40,-0.25,-0.25,-0.50,-0.50,-0.65,-1,-1.41,-1.75,-1.65,-1.25,-0.53,0.07,0.37,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.11,0.11,0.10,0.11,0.07,-0.13,-0.54,-1.05,-1.63,-2,-2.38,-3.15,-5.62,-9,-11,-12,-13,-13,-12,-11,-10,-9,-7,-6,-4.13,-1.86,-0.13,0.23,0.22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,1.74,-0.01,1.99,1.74,0.12,0,0,0.07,0.25,0.57,-0.53,-1.54,-1.63,-0.88,0.62,0.71,0.23,0.22,0.23,0.71,-0.25,-0.75,-1.25,-1.75,-2.02,-2.25,-2.61,-4.62,-6,-7,-8,-9,-9,-9,-9,-9,-9,-8,-7,-6,-6,-5.75,-4.99,-4,-3.25,-2.50,-1.63,-1.17,-0.88,-0.63,-0.38,-0.25,-0.15,-0.13,-0.13,-0.04,-0.02,0.07,0.35,0.87,1.09,1.11,0.25,0.12,-0.13,-0.63,-1.16,-1.50,-1.38,-0.67,-0.04,0.25,0.23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.12,-0.02,-0.38,-0.75,-1.16,-1.75,-2.38,-3.90,-6,-8,-9,-11,-12,-12,-11,-10,-9,-8,-7,-6,-3.88,-0.87,0.23,0.49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.35,1.87,0.12,0.12,1.87,1.25,0.12,0,0.12,0.33,0.37,-0.52,-1.40,-1.51,-1.13,-0.63,0.62,0.25,0.09,0.12,0.73,0.25,-0.38,-1,-1.67,-2.17,-2.53,-4.66,-6,-8,-9,-10,-10,-10,-10,-9,-9,-8,-7,-6,-5.77,-4.88,-4.11,-3.28,-2.38,-1.88,-1.38,-0.88,-0.41,-0.38,-0.03,0.12,0.12,0.12,0.12,0.22,0.25,0.25,0.25,0.34,0.07,0,0,0.32,0.37,0.35,-0.13,-0.79,-1.38,-1.38,-0.75,-0.01,0.36,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.20,0.20,0.12,-0.05,-0.38,-1,-1.75,-2.50,-3.67,-4.62,-7,-9,-10,-11,-11,-10,-10,-9,-8,-7,-5.55,-2.26,-0.38,0.12,0.23,0.22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.21,1.75,2,0,-0.25,1.09,0.22,0.09,0.12,0.12,-0.13,-0.63,-1.18,-1.42,-1.41,-0.63,0.62,0.25,0.10,0.12,0.36,0.50,0.45,-0.79,-1.75,-2.66,-4.65,-6,-7,-9,-10,-10,-10,-10,-9,-9,-8,-7,-6,-5.30,-4.25,-3.36,-2.30,-1.38,-1.13,-0.88,-0.55,-0.38,-0.14,0,0.20,0.25,0.25,0.25,0.25,0.23,0.12,0,0,0,0,0,0,0,0.12,0.34,0.09,-0.63,-1.26,-1.27,-0.68,0,0.50,0.24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0.21,0.37,0.20,-0.13,-0.88,-1.50,-2.25,-3,-4.25,-7,-9,-10,-11,-10,-10,-10,-9,-8,-6,-4.05,-1.43,-0.25,0.12,0.32,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.35,1.62,1.62,1.35,0.83,0.25,0.12,0.11,0,-0.17,-0.50,-0.92,-1.25,-1.25,-0.55,0.62,0.35,0.12,0.20,0.25,0.37,0.50,-0.74,-2.61,-4.42,-6,-7,-8,-9,-10,-10,-10,-9,-8,-7,-6,-5.77,-4.75,-3.63,-2.77,-1.63,-1.03,-0.75,-0.50,-0.30,-0.13,-0.01,0,0.10,0.12,0.12,0.12,0.11,0.08,0,0,0,0,0,0,0,0,0,0,0.25,0,-0.52,-1.25,-1.25,-0.55,0.34,0.37,0.20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.22,0.25,0.24,0.12,-0.63,-1.30,-2.13,-2.66,-5.50,-7,-9,-10,-10,-10,-10,-10,-9,-7,-5.86,-3.50,-1.15,-0.16,0.25,0.20,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0,0.21,0.12,0.12,0.11,0,-0.13,-0.38,-0.66,-0.93,-1.13,-0.53,0.61,0.37,0.32,0.34,0.37,0.49,0.37,-1.88,-3.79,-5.63,-7,-8,-9,-10,-10,-10,-9,-8,-7,-6,-5.11,-4,-3,-2.15,-1.53,-0.91,-0.27,-0.18,-0.05,0,0.12,0.10,0.09,0.09,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.71,-0.63,-1.50,-1.43,-0.63,0.49,0.37,0.20,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.37,0.58,0.73,-0.88,-1.75,-2.50,-3.43,-6,-8,-9,-10,-11,-11,-11,-10,-9,-7,-5.05,-2.77,-0.68,0,0.12,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.12,0.12,0,-0.18,-0.26,-0.88,-0.88,-0.50,0.32,0.62,0.72,0.62,0.50,0.37,-1.02,-3.02,-4.90,-6,-8,-9,-10,-10,-10,-9,-8,-7,-5.79,-4.40,-3.15,-2.03,-1.41,-1.14,-0.79,-0.29,0.12,0.20,0.25,0.12,0.12,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.50,0.35,-0.75,-1.50,-1.50,-0.75,0.48,0.59,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.24,0.70,-0.54,-1.50,-1.79,-2.77,-4.87,-6,-8,-10,-11,-12,-12,-12,-11,-9,-6,-3.99,-1.50,-0.63,-0.05,0.10,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.12,0.07,-0.13,-0.40,-0.78,-1,-0.87,-0.41,0.71,0.38,-0.26,-0.55,-1.39,-2.66,-4.26,-5.99,-7,-8,-9,-10,-10,-9,-8,-7,-5.53,-3.88,-1.92,-1,-0.77,-0.63,-0.42,-0.13,0.12,0.37,0.22,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.45,-0.38,-1,-1.64,-1.63,-1.13,-0.63,0.62,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.62,-0.53,-0.50,-1,-1.88,-3.75,-5.78,-7,-10,-11,-13,-13,-13,-12,-10,-7,-5.02,-2.36,-1,-0.25,0.11,0.12,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.12,0.12,0,-0.29,-0.77,-1.16,-1.38,-1.15,-0.90,-0.92,-1.25,-1.93,-2.89,-4.13,-5.52,-6,-8,-9,-10,-10,-10,-9,-7,-5.25,-3.39,-1.30,-0.52,-0.26,-0.13,0.07,0.13,0.33,0.32,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,-0.41,-1.16,-1.88,-1.93,-1.63,-0.63,0.62,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.24,0.70,0.50,0.46,0.20,-1,-2.88,-4.99,-7,-9,-11,-13,-13,-13,-12,-11,-8,-6,-3.13,-1.38,-0.65,-0.13,0.11,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.12,0.12,0.11,0.08,-0.75,-1.54,-2,-2.13,-2,-2,-2.50,-3.30,-4.30,-5.50,-6,-7,-9,-9,-10,-10,-9,-8,-5.68,-3.36,-0.63,-0.25,0.12,0.25,0.50,0.75,0.75,0.62,0.37,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,-0.38,-1.13,-1.93,-2.63,-1.91,-0.88,0.62,0.25,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.24,0.36,0.46,0.12,-0.54,-1.68,-4.25,-6,-9,-11,-12,-13,-13,-13,-11,-9,-6,-4.26,-1.78,-1,-0.38,0,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.12,0.23,0.22,-0.13,-0.75,-1.63,-2.67,-2.90,-2.89,-2.93,-3.75,-4.63,-5.64,-6,-7,-9,-9,-10,-10,-10,-9,-6,-4.38,-0.93,-0.13,0.25,0.73,0.75,0.87,0.99,0.96,0.87,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,-0.05,-1.01,-1.88,-2.63,-2.63,-1.13,0.08,0.12,0.12,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.37,0.12,-0.50,-1.26,-3,-6,-8,-10,-12,-13,-13,-13,-11,-9,-7,-5.37,-2.64,-1.38,-0.64,-0.13,0.12,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.21,0.12,0,-0.38,-0.88,-1.77,-2.67,-2.92,-3.01,-3.76,-4.99,-5.93,-6,-8,-9,-9,-10,-11,-11,-10,-8,-5.75,-3.05,-0.99,0.25,0.75,0.87,0.87,0.97,0.99,0.99,0.98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,-0.25,-0.91,-1.75,-2.25,-2.13,-1.40,-0.63,-0.01,0.32,0.23,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.11,0.12,0.12,0.12,0.10,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.11,-0.51,-1.38,-2.43,-4.88,-7,-9,-11,-12,-13,-12,-11,-10,-8,-6,-3.80,-1.78,-0.88,-0.01,0.34,0.22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.10,-0.13,-0.38,-1.13,-1.92,-2.75,-3.03,-3.75,-5.28,-6,-7,-8,-9,-10,-10,-11,-11,-11,-11,-8,-5.63,-3.37,-1.24,0.12,0.83,0.87,0.97,0.99,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.33,0.21,-0.38,-1.01,-1.66,-2.04,-2.02,-1.63,-1.03,-0.50,0.12,0.22,0.25,0.12,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0.12,0.12,0.12,0.12,0.20,0.12,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,-0.04,-0.66,-1.50,-2.49,-4.05,-6,-8,-11,-12,-13,-13,-12,-10,-8,-6,-5,-2.41,-1.25,-0.38,0.20,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.22,0.20,-0.13,-0.50,-0.90,-1.50,-2.16,-2.75,-3.75,-5.03,-6,-7,-8,-9,-10,-11,-11,-11,-11,-11,-11,-9,-6,-3.54,-1.25,0.08,0.87,0.96,0.98,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.24,0.25,0.12,-0.54,-1.16,-1.75,-2.13,-2.13,-1.88,-1.41,-1,-0.38,-0.13,0.12,0.21,0.24,0.12,0,0,0,0,0,0,0,0,0,0.12,0.23,0.25,0.25,0.23,0.12,0.10,0.08,0.12,0.21,0.23,0.12,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.20,-0.88,-1.68,-2.41,-3.54,-5.61,-8,-10,-12,-13,-13,-12,-10,-9,-7,-5.76,-3.38,-1.89,-1.16,-0.53,0.25,0.75,0.87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,-0.01,-0.28,-0.77,-1.39,-2,-2.61,-3.65,-4.78,-6,-7,-9,-10,-10,-11,-12,-12,-12,-11,-11,-11,-9,-7,-3.27,-1.18,0,0.95,0.98,0.99,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.20,0.12,-0.15,-0.75,-1.38,-1.90,-2.25,-2.30,-2.13,-1.75,-1.40,-1.05,-0.65,-0.30,0,0.25,0.25,0.07,0,0,0,0,0,0,0,0.11,0.23,0.70,0.62,0.35,0.09,0,-0.16,-0.25,-0.14,0.09,0.23,0.23,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.25,-0.13,-0.92,-1.88,-2.51,-3.50,-5.63,-7,-10,-12,-13,-13,-12,-11,-9,-7,-6,-4.37,-2.78,-2.01,-1.39,-0.80,-0.13,0.12,0.25,0.34,0.37,0.37,0.33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.08,-0.16,-0.52,-1.05,-1.76,-2.74,-3.86,-4.90,-6,-8,-9,-10,-11,-12,-12,-12,-12,-12,-12,-11,-9,-8,-5.75,-3.03,-1.03,0,0.98,0.99,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,-0.25,-0.75,-1.38,-1.88,-2.18,-2.25,-2.05,-1.75,-1.50,-1.38,-1.18,-0.88,-0.28,0.21,0.48,0.25,0.12,0.10,0.21,0.25,0.25,0.25,0.25,0.25,0.37,0.61,-0.63,-0.30,-0.13,-0.15,-0.29,-0.75,-0.30,-0.03,0.20,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.08,0.08,0.12,0.25,0.25,-0.25,-1.01,-1.88,-2.99,-4.15,-5.50,-7,-10,-13,-14,-14,-12,-11,-9,-7,-6,-4.40,-3.13,-2.66,-2.14,-1.63,-0.88,-0.28,-0.13,0,-0.03,-0.13,-0.13,-0.13,0.20,0.25,0.32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,-0.01,-0.27,-0.68,-1.29,-2.65,-3.88,-5,-6,-8,-9,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-9,-6,-4.89,-2.50,-1.02,0.12,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,-0.13,-0.53,-1.14,-1.67,-2.02,-2.13,-1.88,-1.52,-1.25,-1.05,-1.16,-1.01,-0.63,-0.17,0.25,0.62,0.34,0.25,0.23,0.20,0.37,0.37,0.37,0.12,0.23,0.12,-0.54,-0.38,-0.13,-0.13,-0.25,-0.25,-0.25,-0.13,0.20,0.34,0.24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.32,0.21,0.20,0.20,0.25,0.35,0.25,-0.16,-1.04,-1.90,-3.37,-4.43,-5,-7,-11,-13,-14,-14,-13,-11,-9,-8,-6,-4.24,-3.38,-3,-2.63,-2.18,-1.42,-0.88,-0.63,-0.50,-0.54,-0.55,-0.63,-0.50,-0.25,0.12,0.37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.20,-0.05,-0.38,-0.88,-2,-3.25,-4.54,-6,-8,-10,-11,-12,-12,-13,-13,-13,-12,-12,-11,-12,-12,-7,-5.18,-3.88,-2.16,-1.01,0.09,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.21,0.12,-0.26,-0.88,-1.41,-1.79,-1.88,-1.63,-1.17,-0.63,-0.38,-0.63,-0.75,-0.75,-0.52,-0.25,0.62,0.25,0.22,0,-0.02,-0.29,-0.25,-0.15,0,0.11,0.12,0.47,0.37,0.21,0.09,0.07,0,0.12,0.24,-0.38,0.47,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.16,1.25,1.12,0.48,0.37,0.25,0.25,0.25,0.25,0.25,-0.17,-1,-2,-3.36,-4.26,-4.52,-7,-11,-14,-15,-14,-13,-11,-10,-8,-6,-4,-3.38,-3,-2.88,-2.55,-2,-1.25,-0.80,-0.75,-0.92,-0.76,-1,-1.14,-1,-0.40,-0.14,-0.02,0.22,0.22,0.22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.25,-0.13,-0.50,-1.25,-2.50,-3.75,-5.13,-7,-9,-11,-11,-12,-12,-13,-13,-12,-12,-11,-10,-10,-8,-5.52,-4.16,-3.13,-2.04,-1.01,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.20,0.34,-0.01,-0.55,-1.13,-1.51,-1.63,-1.38,-0.88,-0.13,0.23,-0.13,-0.38,-0.68,-1.01,-0.88,-0.66,0.12,0.12,-0.25,-0.54,-0.88,-0.88,-0.50,-0.13,0.07,0.21,0.37,0.25,0.24,0.20,0.12,0.20,0.25,0.37,0.50,0.62,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.27,1.37,-1.42,-0.64,0.70,0.37,0.25,0.12,0.12,0.07,-0.27,-0.88,-1.75,-2.90,-3.40,-4.16,-6,-11,-14,-14,-14,-13,-11,-10,-8,-6,-4.37,-3.25,-3,-2.89,-2.63,-2.03,-1.25,-0.66,-0.50,-0.54,-0.54,-0.78,-1.03,-1.17,-0.63,-0.40,-0.30,0.07,0.25,0.50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.24,0.25,-0.15,-0.50,-1.54,-2.88,-4.39,-6,-8,-9,-10,-11,-12,-12,-12,-12,-11,-11,-10,-9,-8,-6,-4.26,-3.11,-3,-2.12,-1.01,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.24,0.10,-0.38,-0.88,-1.15,-1.28,-1.14,-0.75,-0.13,0.33,0.33,0.08,-0.50,-1,-1.66,-0.75,0.13,-0.13,-0.66,-1.25,-1.38,-1,-0.54,-0.13,0.21,0.25,0.12,0.11,0.12,0.12,0.12,0.12,0.12,0.22,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.30,1.37,1.45,-0.88,-0.87,-0.50,-0.39,-0.05,0,-0.03,-0.25,-0.68,-1.42,-2.13,-3,-3.75,-6,-11,-14,-15,-14,-13,-11,-10,-8,-6,-4.37,-3.01,-2.88,-2.53,-2.01,-1.25,-0.52,0,0,-0.05,-0.13,-0.16,-0.38,-0.50,-0.40,-0.50,-0.66,-0.50,-0.13,-0.02,0,0.11,0.24,0.37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0,-0.38,-0.88,-1.90,-4.14,-5.67,-6,-8,-10,-11,-11,-11,-11,-11,-11,-10,-10,-9,-8,-6,-5.50,-4.16,-3.01,-3,-2.16,-1.01,0.12,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.12,-0.15,-0.55,-1.01,-1.18,-1.13,-0.88,-0.50,0,0.37,0.37,0.50,-0.88,-1.68,-1.18,-0.89,-0.93,-1.25,-1.43,-1.42,-1.16,-0.43,0.20,0.24,0.20,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.27,-0.38,1.47,-0.75,-0.88,-0.77,-0.63,-0.15,-0.03,0,-0.13,-0.41,-1.13,-2,-3,-3.75,-7,-11,-13,-14,-14,-13,-12,-10,-8,-5.88,-4,-3,-2.66,-2.13,-1.37,-0.50,0.07,0.96,0.87,0.12,0.12,0.12,0.12,-0.02,-0.02,-0.13,-0.18,-0.27,-0.25,-0.27,-0.25,-0.13,0,0.07,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.12,-0.13,-0.51,-1.13,-3.05,-5.04,-6,-7,-8,-10,-10,-10,-9,-9,-9,-9,-9,-9,-8,-7,-6,-5,-3.88,-3,-3,-3,-1.05,0.62,0.70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.21,0.57,-0.41,-0.93,-1.14,-1.18,-1.04,-0.75,-0.38,0,0.50,0.25,-0.63,-1.13,-1.77,-1.78,-1.88,-1.76,-1.50,-1.13,-0.65,-0.25,0.25,0.25,0.12,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,-0.27,-0.43,0.85,-0.68,-0.88,-0.64,-0.25,0,0.12,0.25,-0.16,-0.91,-2,-3,-3.50,-6,-10,-12,-14,-14,-13,-12,-10,-8,-6,-3.61,-3,-2.27,-1.41,-0.63,0.11,0.36,0,0,0,0,0,0,0,0.12,0.12,0.22,0,-0.14,-0.41,-0.50,-0.25,-0.16,-0.18,-0.25,-0.28,-0.55,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.12,-0.16,-0.66,-1.75,-3.64,-5.50,-6,-7,-8,-9,-9,-9,-8,-7,-7,-8,-8,-9,-8,-7,-6,-4.68,-3.75,-3,-3,-3,-1.13,0.59,0.37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.49,-0.38,-0.75,-1.13,-1.25,-1.25,-1.02,-0.75,-0.38,0,0.12,0.32,-1,-1.88,-2.77,-2.63,-2.50,-1.43,-0.76,-0.25,0.25,0.36,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.03,0.74,-0.25,-0.64,-0.53,-0.25,0,0.20,0.11,0,-1.13,-2,-3,-3.03,-6,-9,-12,-13,-13,-13,-12,-10,-8,-6,-3.61,-3,-1.75,-0.64,0.10,0.37,0.25,0,0,0,0,0,0,0,0.08,0.12,0.37,0.37,0,-0.13,-0.25,-0.17,-0.16,-0.25,-0.42,-0.75,-0.28,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.21,0.25,0,-0.65,-2.17,-4.02,-5.27,-6,-7,-7,-7,-7,-6,-5.67,-5.05,-4.88,-6,-8,-9,-8,-7,-5.88,-4.61,-3.75,-3,-3,-2.88,-1.13,0.37,0.32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.22,0.48,0.35,-0.42,-0.92,-1.25,-1.29,-1.25,-1.13,-0.88,-0.63,-0.25,0.25,-1.04,-2,-2.88,-2.80,-2.55,-1.41,-0.40,0,0.36,0.37,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.70,0.36,-0.02,-0.27,-0.25,0.08,0.33,0.08,-0.50,-1.17,-2,-3.74,-5,-7,-9,-11,-13,-13,-13,-11,-10,-8,-6,-4.25,-3,-1.26,-0.13,0.36,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0.08,0,0,0,-0.13,-0.25,-0.02,0.12,0.46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.34,0.37,0.12,-0.67,-2.30,-4.65,-6,-6,-6,-6,-6,-5.40,-4.37,-3.15,-2.38,-3,-5.13,-6,-8,-9,-7,-5.75,-4.68,-4.02,-3.38,-3.24,-2.78,-1.03,0.62,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.22,0.37,0.36,-0.16,-0.77,-1.14,-1.38,-1.38,-1.38,-1.38,-1.30,-1.13,-1.13,-1.13,-2.13,-2.88,-2.91,-2.75,-1.50,0,0.21,0.50,0.46,0.33,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.21,0.62,0.34,-0.38,-0.17,0.11,0.37,0,-0.63,-1.65,-2.74,-5.26,-6,-8,-10,-11,-12,-12,-12,-11,-9,-8,-6,-4.24,-3,-1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.46,0.37,0.24,0.12,0.12,0,-0.13,-0.14,-0.04,0.25,0.87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.50,0.46,0.37,-1,-3.52,-6,-7,-8,-8,-7,-5.63,-4.54,-2.79,-0.63,-1.17,-1.99,-4.01,-5.89,-7,-7,-7,-5.88,-5.13,-4.63,-4.24,-3.87,-3.27,-1.11,0.62,0.33,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.24,0.50,0.37,-0.28,-0.75,-1.13,-1.29,-1.41,-1.50,-1.63,-1.75,-1.75,-1.80,-2.13,-2.88,-2.88,-3,-2.78,-1.62,-0.88,0.45,0.75,0.75,0.75,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.58,-0.13,-0.13,-0.13,0.12,0.50,0,-0.75,-1.76,-4.75,-6,-7,-9,-10,-11,-11,-12,-11,-10,-9,-8,-6,-3.49,-3,-1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.37,0.25,0.24,0,-0.25,-0.43,-0.42,0,0.87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.13,0.12,-0.14,-0.75,-2.67,-4.53,-6,-8,-8,-8,-7,-6,-3.38,-1.63,-0.13,-0.55,-1.38,-3.25,-5,-6,-6,-6,-6,-5.93,-5.42,-5.13,-4.55,-3.63,-1.75,0.50,0.25,0.22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.23,0.62,-0.53,-0.50,-0.68,-1,-1.25,-1.42,-1.63,-1.79,-2.04,-2.25,-2.38,-2.63,-2.88,-3,-3,-2.75,-2.68,-1.38,-1,-0.77,-0.77,0.75,0.20,0.12,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.22,0,-0.05,0.08,0.36,0,-0.79,-2.62,-5.63,-7,-9,-9,-10,-11,-11,-11,-11,-10,-9,-7,-5.99,-3.43,-3,-1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.50,0.37,0.24,-0.13,-0.50,-0.79,-0.66,-0.29,0,0.25,0.23,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.09,-0.13,-0.54,-1.75,-4,-5.66,-6,-7,-8,-8,-7,-5.88,-2.75,0.20,0.60,0.32,-1.14,-2.25,-4.65,-6,-7,-7,-7,-7,-6,-6,-5.37,-4.12,-2.29,-0.78,0.20,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.75,-0.75,-0.26,-0.51,-0.91,-1.25,-1.40,-1.63,-1.88,-2.17,-2.40,-2.63,-2.80,-2.92,-3,-3,-3,-2.75,-2.66,-2.02,-1.76,-0.89,0.75,0.75,0.83,0.87,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.36,0.50,0,-0.25,-0.27,-0.17,-0.38,-1.05,-3.40,-6,-8,-9,-10,-11,-11,-11,-11,-11,-10,-9,-8,-6,-4.25,-3,-1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.37,-0.13,-0.63,-1.13,-1,-0.76,-0.38,0,0.21,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,-0.01,-0.28,-0.76,-2.29,-4.66,-6,-6,-7,-7,-7,-6,-5.13,-1.92,0.24,0.62,-0.63,-1.13,-1.88,-2.76,-4.50,-6,-8,-9,-8,-7,-6,-6,-4.75,-3.12,-1.50,-0.25,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.87,0.83,0.62,-0.25,-0.77,-1.13,-1.38,-1.54,-1.88,-2.25,-2.50,-2.75,-2.88,-3,-3,-3,-3,-3,-2.88,-2.68,-2.76,-1.25,-1.01,-0.79,-0.88,-0.75,-0.50,0.25,0.33,0.22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.12,-0.25,-0.65,-0.88,-1,-1.13,-1.63,-4.13,-6,-9,-10,-11,-11,-11,-11,-11,-11,-10,-9,-8,-6,-4.17,-3,-1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.50,0.21,-0.38,-1,-1.13,-1.18,-0.88,-0.30,0.11,0.21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,-0.05,-0.38,-0.88,-2.38,-4.53,-6,-6,-7,-7,-6,-6,-4.79,-1.75,0.38,0.71,-0.67,-1.03,-1.78,-2.40,-3.25,-6,-8,-10,-10,-9,-7,-6,-5.38,-3.75,-2.04,-0.75,-0.13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.01,-0.67,-1.01,-1.15,-1.38,-1.66,-2.13,-2.39,-2.67,-2.88,-2.92,-3,-3,-3,-3,-3,-2.92,-2.78,-2.77,-2.13,-2,-1.90,-1.75,-1.18,-0.25,0.32,0.37,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.12,-0.38,-0.88,-1.30,-1.63,-1.75,-2.36,-3,-4.29,-7,-8,-10,-11,-11,-11,-11,-11,-11,-11,-10,-9,-7,-4.55,-2.75,-1,0.71,0.13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,-1,-0.88,-1.28,-0.90,-0.53,-0.17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,-0.13,-0.43,-0.91,-2,-4.13,-5.66,-6,-7,-7,-6,-5.41,-3.54,-1.25,0.62,0.62,0.60,-0.80,-1.64,-2.37,-3.50,-6,-8,-11,-11,-9,-8,-7,-5.74,-4.25,-2.38,-1,-0.13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0.34,-0.38,-0.66,-0.88,-0.93,-1.38,-1.88,-2.25,-2.50,-2.65,-2.79,-2.90,-3,-3,-3,-3,-3,-3,-2.89,-2.80,-2.88,-2.63,-2.40,-1.88,-0.91,-0.02,0.37,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.85,-0.03,-0.55,-1.25,-1.78,-2.15,-2.75,-4.17,-5.63,-6,-8,-9,-10,-10,-11,-11,-11,-12,-11,-11,-10,-9,-7,-4.63,-2.66,-1,0.50,0.33,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,-0.38,-1.13,-1,-0.75,-0.38,0,0.10,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,-0.01,-0.18,-0.52,-0.90,-1.50,-3.40,-5,-6,-6,-6,-6,-4.50,-2.50,0.50,-0.63,0.59,0.50,-0.63,-1.63,-2.29,-3.91,-6,-8,-10,-10,-9,-8,-6,-5.61,-4.13,-2.27,-1.02,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1,-1,1,0.62,0.23,-0.01,-0.25,-0.38,-0.79,-1.29,-1.75,-2,-2.28,-2.53,-2.75,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.41,-1.54,-0.63,0.12,0.37,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.75,0.12,-0.63,-1.50,-2.13,-2.39,-3.75,-6,-8,-9,-9,-9,-10,-10,-11,-11,-11,-12,-12,-12,-11,-8,-6,-4.03,-2.51,-1,0.46,0.45,0.24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.35,0.37,-0.03,-0.63,-1,-0.88,-0.50,-0.05,0.12,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.12,-0.25,-0.62,-1,-1.50,-2.25,-4.51,-5.89,-6,-6,-5.75,-4.13,-1.38,0.08,-0.25,0.21,0.57,-0.63,-1.68,-2.63,-4.14,-6,-9,-10,-10,-9,-8,-6,-5.04,-3.50,-3,-1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1,-1,1,0.50,0.34,0.32,0.12,0,-0.26,-0.65,-1.03,-1.39,-1.75,-2.13,-2.50,-2.75,-2.89,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.75,-2.30,-1.41,-0.63,0.12,0.37,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.37,-0.50,-1.38,-1.90,-2.16,-3.40,-6,-8,-10,-10,-10,-10,-10,-10,-10,-11,-12,-11,-10,-9,-6,-4.38,-3.36,-2.25,-1.03,0.37,0.50,0.62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.32,0,-0.42,-1.01,-1,-0.75,-0.17,0.12,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.13,-0.30,-0.63,-1.01,-1.55,-2.87,-3.80,-5,-6,-6,-5.86,-4.40,-2.88,-1.74,-1.13,-0.53,0.59,-0.92,-1.88,-2.92,-4.29,-7,-9,-10,-10,-9,-7,-6,-4.53,-3.13,-2.38,-1.25,0.33,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1,1,1,0.20,0.22,0.32,0.25,0.21,0.08,-0.13,-0.38,-0.68,-1.13,-1.63,-2.13,-2.63,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.75,-2.25,-1.30,-0.50,0.12,0.25,0.21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.32,0.62,-0.38,-1.25,-1.67,-1.88,-2.28,-4.25,-6,-8,-9,-9,-9,-9,-9,-9,-9,-9,-9,-8,-6,-3.90,-3.05,-2.52,-1.90,-1.13,-0.61,-0.50,0.62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.24,0.12,-0.25,-0.88,-1.13,-1,-0.50,0,0.12,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.13,-0.28,-0.64,-1.13,-1.91,-3.25,-4.26,-6,-7,-7,-7,-7,-6,-3.88,-3.38,-2.63,-1.86,-1.78,-2.25,-3.14,-4.88,-7,-9,-10,-10,-9,-7,-5.50,-4.04,-2.78,-2.25,-1.38,-0.13,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.87,0.83,0.75,0.21,0.12,0.10,0.09,0.12,0.12,0.12,0.12,0.07,-0.13,-0.38,-1,-1.75,-2.38,-2.78,-2.93,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.64,-2,-0.90,0.08,0.37,0.32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.20,0.35,0.12,-0.38,-1,-1.38,-1.30,-1.25,-1.74,-2.89,-4.05,-5.54,-6,-7,-6,-6,-6,-6,-5.92,-5.41,-4.12,-2.50,-1.76,-2.03,-1.92,-1.66,-1.38,-1,-0.42,0.71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.23,-0.13,-0.66,-1.18,-1.29,-0.79,-0.25,0.07,0.12,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.13,-0.38,-0.75,-1.25,-2.25,-3.54,-5.75,-7,-8,-9,-9,-10,-9,-8,-6,-6,-5.38,-3.92,-3.38,-4,-5.88,-8,-9,-10,-10,-9,-7,-5,-3.63,-2.75,-2.25,-1.27,-0.14,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.22,0.25,0.25,0.12,0,0,0,0,0.07,0.12,0.12,0.24,0.37,0.12,-0.50,-1.38,-2.25,-2.66,-2.89,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.25,-1.30,-0.15,0.20,0.32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.23,0.25,0,-0.39,-0.88,-1,-0.75,-0.40,-0.50,-1.13,-1.63,-2.14,-2.77,-2.90,-3.11,-3.04,-3.75,-3.63,-3.37,-2.63,-1.63,-1.39,-1.75,-1.65,-1.63,-1.55,-1.51,-1.54,-0.38,0.83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.35,0,-0.50,-1.13,-1.30,-0.93,-0.51,-0.03,0.23,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.13,-0.38,-0.76,-1.38,-2.38,-4.17,-6,-8,-9,-10,-12,-13,-13,-11,-10,-9,-8,-7,-6,-5.89,-9,-10,-10,-10,-10,-8,-6,-4.63,-3.29,-2.63,-1.88,-1,-0.13,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.34,0.25,0.12,0,0,0,0,0,0,0,0,0.24,0.62,-0.25,-1.15,-2,-2.50,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.41,-1.53,-0.25,0.35,0.21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.24,0.25,-0.01,-0.41,-0.75,-0.75,-0.25,0.32,0.12,-0.63,-1.25,-1.50,-1.39,-1.25,-1.39,-1.39,-1.88,-2.63,-2.75,-1.88,-1.30,-1.50,-1.63,-1.65,-1.54,-1.50,-1.52,-1.63,-0.50,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.25,0,-0.63,-1,-0.88,-0.63,-0.26,-0.01,0.10,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0,-0.25,-0.75,-1.39,-2.27,-4.50,-6,-8,-10,-12,-14,-15,-15,-15,-16,-13,-11,-10,-9,-10,-13,-13,-11,-10,-9,-8,-6,-4.30,-3.05,-2.30,-1.54,-0.68,0.21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.23,0.62,0.61,0.59,0.35,0.12,0,0,0,0,0,0,0,0.12,0.74,-0.13,-0.88,-1.68,-2.38,-2.75,-2.91,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.63,-1.88,-1,0,0.47,0.20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.23,0.25,0,-0.39,-0.75,-0.75,-0.15,0.36,0.12,-0.54,-1.25,-1.50,-1.50,-1.43,-1.13,-1.05,-1.27,-1.88,-2.25,-1.88,-1.25,-1.25,-1.75,-1.80,-1.88,-1.13,-1.25,-1.91,-0.75,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.87,0.75,-0.50,-0.65,-0.63,-0.38,-0.15,0,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,-0.01,-0.75,-1.50,-2.13,-4.24,-6,-8,-10,-14,-16,-17,-17,-19,-19,-16,-14,-13,-12,-12,-12,-11,-10,-10,-9,-7,-5.90,-4.05,-3.36,-1.75,-1.02,-0.63,0.87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.62,-0.63,0.58,0.58,0.25,0,0,0,0,0,0,0,0,0.08,0.12,-0.54,-1.41,-2,-2.50,-2.76,-2.92,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.27,-1.50,-0.25,0.25,0.37,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.25,0,-0.41,-0.88,-0.92,-0.63,-0.13,-0.26,-0.88,-1.42,-1.67,-1.75,-1.63,-1.38,-1.25,-1.66,-1.51,-1.63,-1.50,-1.42,-1.49,-1.61,-2.13,-1.65,-1.14,-1.41,-2.05,-0.75,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.87,0.73,-0.25,-0.39,-0.54,-0.50,-0.27,-0.13,0,0.23,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.21,0.11,-0.64,-1.50,-2.25,-3.25,-6,-8,-12,-16,-18,-19,-19,-19,-19,-18,-16,-15,-14,-13,-13,-13,-11,-10,-9,-7,-5.63,-3.66,-3.38,-1.68,-0.38,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.62,-0.63,-0.63,0.58,0.33,0,0,0,0,0,0,0,0,0,0.37,-0.13,-0.77,-1.50,-2.13,-2.54,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.66,-2,-0.90,-0.01,0.37,0.33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.22,0,-0.50,-1.05,-1.27,-1.13,-0.88,-0.93,-1.38,-1.63,-1.66,-1.75,-1.99,-1.75,-2.05,-1.63,-1.25,-1.55,-1.41,-1.25,-1.50,-1.54,-1.76,-1.49,-1.50,-1.52,-1.27,-0.63,0.57,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.87,0.74,0.62,-0.38,-0.26,-0.38,-0.38,-0.25,-0.04,0.20,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.25,-0.63,-1.63,-2.30,-3.36,-5.86,-9,-12,-16,-19,-20,-20,-19,-19,-19,-17,-16,-15,-15,-15,-14,-14,-12,-10,-8,-6,-3.91,-2.64,-1.66,-0.65,0.07,0.37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.23,0.62,0.61,-0.63,0.59,0.33,0,0,0,0,0,0,0,0,0,0.74,0.25,-0.04,-0.88,-1.63,-2.25,-2.66,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.43,-1.55,-0.63,0.22,0.33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0,-0.63,-1.25,-1.51,-1.64,-1.41,-1.50,-1.55,-1.63,-1.52,-1.51,-2,-1.75,-1.63,-1.50,-1.50,-2.01,-1.75,-1.50,-1.50,-1.75,-1.62,-1.63,-1.63,-1.50,-1.25,-0.63,0.12,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.96,0.12,0.74,0.49,0.37,-0.29,-0.27,-0.28,-0.15,0.12,0.21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.25,0.60,-0.63,-1.75,-2.87,-4.36,-5.64,-9,-13,-17,-20,-20,-20,-19,-19,-19,-18,-17,-16,-16,-16,-16,-15,-14,-11,-9,-6,-3.93,-2.25,-1.63,-0.91,-0.28,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.62,-0.64,0.62,0.33,0,0,0,0,0,0,0,0,0,0,0.25,0.37,-0.26,-1.14,-1.90,-2.42,-2.75,-2.90,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.77,-2.25,-1.38,-0.25,0.33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.07,-0.25,-0.68,-1.25,-1.53,-1.75,-1.63,-1.75,-1.75,-1.63,-1.42,-1.25,-1.41,-1.75,-1.63,-1.67,-2,-1.88,-1.63,-1.67,-1.68,-1.88,-1.87,-1.75,-1.68,-1.51,-1.18,-0.64,0.11,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0.10,0.24,0.62,0.50,-0.04,-0.38,-0.18,0,0.11,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1,-2,-3.63,-4.89,-7,-9,-13,-17,-20,-20,-20,-20,-19,-19,-19,-18,-17,-17,-17,-17,-16,-14,-11,-8,-6,-4.18,-2.36,-1.76,-1.15,-0.55,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.22,0.73,-0.75,0.71,0.25,0,0,0,0,0,0,0,0,0,0,0,1,0.75,-0.76,-1.64,-2.13,-2.63,-2.80,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.66,-2,-0.89,0.12,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0,-0.25,-0.75,-1.17,-1.43,-1.41,-1.29,-1.64,-1.88,-1.78,-1.54,-1.42,-1.39,-1.64,-1.75,-1.63,-1.55,-1.41,-1.67,-1.88,-1.88,-2.04,-2.01,-1.88,-1.75,-1.52,-1.17,-0.64,0.07,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.87,0.12,-0.17,-0.17,-0.04,0.08,0.12,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.83,-0.80,-2,-3.64,-5.79,-8,-10,-13,-17,-20,-20,-20,-20,-19,-19,-19,-18,-18,-18,-18,-17,-17,-14,-10,-8,-6,-4.13,-2.54,-2.04,-1.50,-0.76,-0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.83,-0.79,0.75,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0.83,-0.75,-0.77,-1.38,-1.88,-2.63,-2.75,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.43,-1.63,-0.62,0.62,0.63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.21,0.25,-0.13,-0.65,-1.25,-1.51,-1.43,-1.25,-1.64,-2.25,-2.38,-2.25,-1.93,-1.75,-1.78,-1.63,-1.41,-1.54,-1.51,-1.79,-2.29,-2.13,-2.15,-2.01,-2,-1.88,-1.63,-1.18,-0.66,-0.01,0.62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.48,0,-0.13,-0.16,-0.04,0.12,0.12,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.23,0.73,-0.75,-1.91,-3.54,-6,-8,-11,-13,-17,-20,-20,-20,-20,-19,-19,-19,-18,-18,-17,-17,-17,-16,-14,-10,-7,-5.79,-3.86,-2.88,-2.50,-1.78,-1,-0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.87,0.75,0.37,-0.50,-1.13,-1.41,-2.63,-2.78,-2.93,-3,-3,-3,-3,-3,-3,-3,-3,-2.78,-2.25,-1.25,-0.25,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.21,0.62,0.62,-0.67,-1.38,-1.75,-1.80,-1.65,-2.04,-2.63,-2.76,-2.88,-2.50,-2.25,-2,-1.75,-2.13,-2.50,-2.63,-2.87,-2.87,-2.53,-2.50,-2.26,-2.15,-2,-1.67,-1.27,-0.75,-0.16,0.50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.38,-0.28,-0.02,0.20,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.25,0.25,-0.64,-1.88,-3.25,-6,-8,-11,-13,-17,-20,-20,-20,-20,-19,-19,-19,-18,-17,-16,-16,-16,-15,-12,-10,-7,-4.89,-3.54,-3.12,-2.88,-2.04,-1.04,-0.17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.37,0.09,-0.29,-1.18,-2,-2.63,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.66,-1.88,-0.91,0.12,0.87,0.11,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.35,0.62,-0.66,-1.75,-1.66,-2.27,-2.55,-2.75,-3.05,-4,-4.63,-5.28,-4.13,-2.88,-3.41,-3.75,-4.13,-5.13,-7,-6,-4.88,-4.12,-2.64,-2.38,-2.14,-1.88,-1.50,-0.90,-0.30,0.24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.10,-0.54,-0.75,-0.30,0.20,0.35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.12,0.12,-0.64,-1.78,-3,-5.25,-8,-11,-14,-16,-19,-20,-19,-19,-19,-18,-17,-16,-16,-15,-15,-15,-14,-12,-9,-6,-4.43,-3.38,-3.15,-2.52,-1.88,-1.13,-0.38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.13,0.12,-0.30,-0.93,-1.80,-2.50,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.63,-1.51,-0.63,0.83,0.83,0.12,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.34,0.62,-0.66,-0.75,-1.25,-1.88,-3,-3.17,-4.18,-5.93,-8,-8,-8,-6,-6,-6,-7,-9,-12,-12,-9,-7,-5.13,-2.63,-2.38,-2.13,-1.75,-1.26,-0.63,-0.13,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.50,-0.52,-1.13,-0.75,0,0.50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.10,0.07,-0.25,-0.75,-1.63,-2.68,-5.43,-9,-12,-14,-16,-18,-19,-19,-19,-18,-17,-16,-15,-14,-14,-14,-14,-14,-12,-9,-6,-3.92,-3.25,-2.79,-2.50,-1.79,-1,-0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,-0.13,-0.88,-1.88,-2.51,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.88,-1.25,-0.79,0.75,0.75,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.62,0.62,0.72,-0.63,-1.38,-2.13,-2.88,-4.12,-5.93,-8,-9,-8,-8,-8,-8,-9,-11,-13,-15,-13,-10,-8,-4.88,-2.74,-2.38,-2.13,-1.55,-0.88,-0.25,0.35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1,-1.63,-0.88,-0.13,0.12,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.09,-0.25,-0.78,-1.51,-3.03,-5.99,-8,-12,-15,-16,-17,-18,-19,-18,-17,-16,-15,-14,-14,-14,-14,-14,-14,-12,-10,-6,-3.89,-2.99,-2.67,-2.17,-1.50,-0.67,-0.13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.24,-0.04,-0.75,-1.63,-2.38,-2.78,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.80,-2.77,-1.28,-0.39,0.38,0.21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.25,0.50,0.21,-0.79,-1.63,-2.13,-2.79,-3.88,-4.63,-7,-8,-9,-10,-10,-11,-12,-13,-13,-12,-11,-9,-6,-3.74,-2.63,-2.38,-1.88,-1.13,-0.38,0.23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1,-1.38,-1.03,-0.25,0.12,0.22,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.12,0.09,-0.25,-0.79,-1.75,-3.51,-5.89,-9,-12,-14,-16,-16,-18,-18,-17,-16,-15,-14,-14,-13,-14,-14,-14,-14,-12,-10,-7,-4.02,-2.99,-2.50,-1.76,-0.92,-0.13,0.22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.23,0.22,0.37,0.25,0.25,0.11,0,0,0,0.24,0.10,-0.38,-1.27,-2.13,-2.67,-2.93,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.76,-1.90,-0.88,0.37,0.22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.46,0.25,-0.03,-0.77,-1.50,-2.13,-2.63,-3.13,-6,-7,-9,-10,-10,-11,-12,-12,-12,-11,-10,-8,-6,-4.14,-2.88,-2.63,-2.13,-1.38,-0.52,0,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1,-1.50,-1.13,-0.38,0.12,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.20,0.11,-0.25,-0.90,-2.03,-3.78,-6,-9,-12,-14,-15,-17,-18,-18,-17,-16,-15,-14,-13,-13,-13,-14,-14,-13,-11,-9,-7,-4.25,-3.01,-2.38,-1.38,-0.26,0.37,0.33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.22,0.32,0.49,0.25,0.25,0.21,0.32,0.23,0,0,0,0.25,0.32,-0.04,-1.05,-2,-2.63,-2.90,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.43,-1.30,-0.50,0.12,0.12,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.24,0.32,-0.25,-0.88,-1.50,-2.04,-3.54,-5.38,-7,-8,-10,-11,-11,-12,-12,-12,-11,-10,-8,-6,-3.99,-2.90,-2.68,-2.25,-1.63,-0.90,-0.30,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1,-1.38,-1.25,-0.53,-0.13,0.12,0.12,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.21,0.08,-0.30,-1,-2.25,-3.75,-6,-9,-12,-14,-16,-17,-18,-18,-17,-16,-15,-14,-13,-13,-13,-14,-14,-13,-11,-9,-6,-4.36,-3.15,-3,-1.03,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.32,0.12,0.07,-0.13,-0.25,-0.13,0.25,0.37,0.12,0,0,0.25,0.35,-0.04,-1.02,-1.90,-2.63,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.76,-1.75,-0.77,-0.04,0.83,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.23,0.50,0.25,-0.13,-0.88,-1.54,-3.24,-5,-6,-8,-10,-11,-12,-12,-12,-12,-12,-10,-9,-7,-5.03,-3.17,-2.77,-2.42,-1.88,-1.25,-0.63,0,0.20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1,-0.63,-0.50,-0.38,-0.13,0.09,0.12,0.20,0.12,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0.12,-0.04,-0.52,-1.26,-2.26,-3.61,-6,-9,-12,-14,-16,-17,-18,-18,-18,-17,-15,-14,-13,-13,-13,-13,-13,-12,-11,-9,-6,-3.89,-3.14,-3.03,-1.01,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.12,-0.02,-0.25,-0.50,-0.78,-0.63,-0.01,0.37,0.32,0,0.07,0.33,0.12,-0.38,-1.25,-2.02,-2.63,-2.89,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.78,-2,-1.17,-0.25,0.86,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.22,0.25,0.21,-0.38,-1.18,-2.89,-4.74,-6,-8,-10,-11,-12,-13,-13,-13,-12,-11,-9,-7,-5.68,-3.63,-2.93,-2.67,-2.16,-1.50,-0.78,-0.25,0.21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0.57,0.07,0.08,0.12,0.12,0.12,0.23,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0.09,-0.28,-0.90,-1.64,-2.42,-4.68,-7,-9,-12,-15,-17,-18,-18,-18,-18,-17,-16,-15,-14,-13,-13,-13,-12,-12,-10,-8,-5.64,-3.42,-2.88,-2.04,-0.88,0.25,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.20,0,-0.25,-0.51,-0.88,-1.28,-1,-0.50,0.12,0.37,0.08,0.25,0.37,0.10,-0.63,-1.53,-2.25,-2.66,-2.90,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.39,-1.75,-0.76,0.87,0.97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.21,0.37,-0.38,-1.04,-2.65,-4.50,-6,-8,-10,-11,-12,-13,-13,-14,-13,-12,-10,-8,-6,-4.43,-3.25,-2.75,-2.38,-1.79,-1.15,-0.55,0,0.23,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.25,0.20,0.12,0.21,0.24,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.18,-0.52,-1.26,-2.01,-3.38,-5.30,-7,-10,-12,-14,-16,-17,-18,-18,-18,-17,-16,-15,-14,-12,-12,-12,-12,-10,-8,-7,-5.15,-3.29,-2.53,-1.63,-0.50,0.21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.20,0,-0.25,-0.62,-1,-1.37,-1.54,-1.13,-0.50,0.12,0.87,0.12,0.58,0.21,-0.89,-1.88,-2.50,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.63,-1.50,-0.65,0,0.24,0.25,0.25,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0,-0.38,-1.03,-2.49,-4.38,-6,-8,-10,-11,-13,-14,-14,-14,-14,-13,-11,-9,-7,-5.14,-3.80,-2.89,-2.55,-2.13,-1.55,-1,-0.30,0.25,0.23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.83,0.75,0.75,0.82,0.07,0,0,0.32,0.25,0.25,0.12,0.08,0,0.12,0.20,0.20,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.03,-0.29,-0.75,-1.42,-2.50,-4.02,-6,-8,-10,-12,-15,-16,-17,-18,-18,-18,-18,-17,-16,-15,-13,-13,-11,-11,-9,-8,-6,-4.64,-3.41,-2.30,-1.26,-0.17,0.20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.11,-0.15,-0.51,-1,-1.50,-2,-1.88,-1.25,-0.50,0.87,0.83,0.60,-0.63,-1.40,-2.18,-2.75,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.68,-2.25,-1.55,-0.93,-0.38,0.10,0.25,0.24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.08,-0.40,-1.05,-2.37,-4.25,-6,-8,-10,-12,-13,-14,-15,-15,-14,-13,-11,-9,-8,-6,-4.86,-3.14,-2.88,-2.50,-2.01,-1.42,-0.79,-0.01,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.20,0.50,-0.43,-0.43,0.50,0.21,0,0,0.12,0.34,0.32,0.32,0.33,0.12,0.12,0.25,0.25,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.09,0,-0.25,-0.77,-1.63,-2.74,-4.77,-6,-8,-11,-13,-15,-16,-17,-17,-18,-18,-18,-17,-16,-15,-15,-13,-12,-10,-9,-7,-5.90,-4.28,-3.30,-2.17,-1.14,0,0.37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.32,-0.02,-0.38,-0.88,-1.50,-2.25,-2.27,-2,-1.38,-0.88,-0.88,-0.90,-1.38,-2,-2.75,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.65,-2.27,-1.75,-1.13,-0.38,0.21,0.49,0.33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.32,0.12,-0.41,-1.17,-2.17,-4.13,-6,-8,-10,-12,-13,-14,-15,-15,-15,-14,-12,-10,-9,-7,-6,-4.89,-3.13,-2.75,-2.43,-2,-1.38,-0.75,-0.16,0.25,0.22,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.37,-0.38,-0.38,0.37,0.25,0,0,0,0,0,1,0.37,0.23,0.12,0.24,0.25,0.12,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.20,0.25,0.25,-0.75,-1.68,-3.52,-5.13,-6,-9,-11,-13,-15,-16,-17,-17,-17,-18,-17,-17,-16,-15,-15,-13,-12,-10,-9,-7,-5.55,-3.88,-3,-2.25,-1.30,-0.13,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.23,0.12,-0.13,-0.62,-1.26,-2,-2.25,-2.29,-2,-1.90,-1.88,-1.88,-2.13,-2.63,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.90,-2.75,-2.38,-1.75,-0.89,-0.13,0.37,0.34,0.87,0.87,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.71,0.25,-0.75,-1.41,-2.25,-4.14,-6,-8,-10,-12,-14,-15,-15,-16,-15,-14,-13,-11,-10,-8,-7,-6,-4.38,-3.75,-3.37,-2.88,-2.25,-1.42,-0.76,0,0.25,0.25,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.13,0.12,0,0,0.37,0.25,0,0,0,0,0,0,0.37,0.25,0.25,0.25,0.25,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.25,0.34,0.37,0.21,-0.75,-2,-3.65,-5.27,-7,-10,-12,-14,-16,-16,-17,-17,-17,-17,-17,-16,-15,-15,-14,-12,-11,-9,-8,-6,-4.79,-3.55,-2.52,-2.13,-1.25,-0.38,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.34,0.24,-0.13,-0.63,-1.13,-1.52,-1.88,-2.26,-2.41,-2.50,-2.50,-2.63,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.93,-2.75,-2.25,-1.38,-0.50,0.11,0.20,-0.88,0.84,0.12,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.24,0.37,0.50,-0.38,-1.05,-1.75,-2.50,-4.41,-6,-8,-10,-12,-14,-15,-16,-16,-16,-15,-13,-12,-11,-10,-9,-8,-6,-4.88,-4.38,-3.88,-3.16,-2.50,-1.61,-0.67,0,0.25,0.33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.21,0.12,0,0.12,0.46,0.23,0,0,0,0,0,0,0.11,0.12,0.12,0.12,0.12,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.25,0.25,0.09,-0.12,-0.25,-1.01,-2.36,-3.77,-6,-8,-10,-13,-15,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-13,-11,-10,-8,-7,-5.50,-4.27,-3,-2.42,-2,-1.13,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0.75,0.33,-0.53,-1.14,-1.77,-2.25,-2.50,-2.67,-2.78,-2.89,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.50,-1.76,-0.93,-0.38,-0.29,-0.75,0.73,0.74,0.24,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.11,0.20,0.24,0.23,0.12,-0.88,-1.51,-2.05,-2.88,-4.90,-6,-9,-11,-13,-15,-16,-17,-17,-16,-15,-14,-13,-12,-11,-10,-10,-8,-6,-5.14,-4.67,-4.11,-3.50,-2.75,-1.63,-0.63,0.08,0.33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.34,0.22,0.10,0.07,0.12,0.25,0.12,0,0,0,0,0,0,0,0,0.09,0.09,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.22,0.12,-0.17,-0.50,-0.93,-1.51,-2.65,-5.18,-7,-9,-12,-14,-15,-16,-16,-16,-15,-15,-14,-13,-13,-13,-13,-12,-10,-8,-6,-5.80,-4.50,-3.50,-2.50,-1.90,-1.64,-0.79,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.37,0.35,0.10,-0.38,-0.89,-1.39,-1.88,-2.25,-2.63,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.75,-2.04,-1.39,-0.50,-0.88,-0.75,-0.40,0.12,0.36,0.37,0.25,0.12,0,0,0,0,0,0,0,0,0.07,0.08,0.09,0.12,0.12,0.24,0.07,-0.38,-0.88,-1.29,-2.13,-2.75,-3.75,-5.74,-7,-10,-12,-14,-16,-17,-18,-18,-17,-16,-15,-14,-13,-13,-12,-11,-10,-8,-6,-5.41,-5,-4.29,-3.76,-2.75,-1.41,-0.50,0,0.12,0.08,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,-0.01,-0.13,-0.13,0,0.12,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.21,0.25,0,-0.50,-1,-1.50,-2.13,-4.04,-6,-8,-10,-13,-14,-15,-15,-15,-15,-14,-13,-12,-12,-11,-11,-11,-10,-8,-6,-5.63,-4.63,-3.75,-2.64,-1.63,-1.29,-1.13,-0.38,0.22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.24,0.25,0.12,-0.13,-0.42,-1.13,-1.75,-2.38,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.38,-1.88,-1.53,-1.42,-1.38,-1.01,-0.51,-0.13,0.24,0.33,0.37,0.22,0.11,0,0.07,0.11,0.11,0.11,0.11,0.10,0,0,0.07,0.10,0.12,-0.38,-1,-1.79,-2.55,-3.50,-3.88,-4.78,-6,-8,-11,-13,-15,-17,-18,-18,-18,-18,-17,-16,-15,-14,-14,-13,-13,-11,-10,-8,-6,-5.89,-5.25,-4.75,-4.05,-2.65,-1.15,0.22,0.12,-0.03,0,0.23,0.11,0,0,0,0,0,0,0,0,0,1,-1,-1,-0.63,-0.77,-0.38,0.12,0.37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.24,0.23,0,-0.68,-1.38,-2,-3.24,-5.26,-7,-9,-11,-13,-15,-15,-16,-15,-14,-14,-13,-11,-10,-10,-9,-8,-8,-6,-4.86,-4.38,-3.75,-2.68,-1.51,-1,-0.50,-0.13,0.12,0.34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.23,0.37,0.34,0.25,-0.38,-1.25,-2.04,-2.66,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.93,-2.65,-2.38,-2.16,-2.13,-2,-1.75,-1.38,-0.88,-0.38,-0.13,0.25,0.33,0.37,0.25,0.22,0.12,0.12,0.12,0,-0.03,-0.14,-0.25,-0.27,-0.26,-0.38,-0.99,-1.88,-3,-4.16,-4.50,-5.05,-5.89,-7,-9,-12,-14,-16,-17,-18,-18,-18,-18,-17,-16,-16,-15,-15,-14,-13,-12,-11,-10,-8,-7,-6,-5.63,-5.25,-4.41,-2.24,-1.28,-0.64,-0.40,-0.13,0.24,0.24,0.08,0,0,0,0,0,0,0,0,1,-1,-1,-2,-2,-1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.25,0.25,-0.13,-0.75,-1.63,-2.52,-4.50,-6,-8,-10,-11,-13,-14,-15,-15,-14,-14,-13,-12,-10,-9,-9,-7,-6,-5.14,-3.63,-3.63,-3.29,-2.43,-1.50,-0.88,-0.38,0.12,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.36,0.33,-0.30,-1.05,-1.88,-2.52,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3.01,-3.02,-3.02,-3.02,-3.01,-3,-3,-3,-3,-2.88,-2.75,-2.63,-2.55,-2.50,-2.38,-2.13,-1.80,-1.38,-0.88,-0.30,-0.13,0.09,0.12,0,-0.13,-0.13,-0.17,-0.27,-0.42,-0.63,-0.79,-1.01,-1.28,-1.50,-2.39,-3.63,-4.52,-5.13,-5.51,-6,-6,-8,-10,-13,-15,-17,-18,-18,-19,-18,-18,-17,-17,-16,-15,-15,-15,-15,-13,-12,-11,-10,-9,-8,-6,-6,-5.30,-4.38,-2.90,-1.86,-1.01,-0.52,0.12,0.37,0.25,0,0,0,0,0,0,0,0,1,1,-1,-2,-2,-1.25,-0.25,0.33,0.37,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.21,0.47,0.25,-0.76,-1.75,-3.38,-5.29,-7,-8,-10,-11,-13,-14,-14,-14,-14,-13,-12,-11,-10,-9,-8,-6,-4.38,-2.86,-2.64,-2.39,-2.04,-1.53,-0.88,-0.25,0.12,0.36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.23,-0.02,-0.50,-1.14,-1.88,-2.50,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3.01,-3.16,-3.40,-3.55,-3.68,-3.65,-3.50,-3.28,-3.13,-3,-3,-3,-2.92,-2.89,-2.88,-2.77,-2.75,-2.63,-2.43,-2.15,-1.88,-1.39,-1.01,-0.75,-0.75,-0.79,-0.92,-1,-1,-1.13,-1.25,-1.52,-1.99,-2.43,-2.88,-3.38,-4.36,-5.28,-6,-6,-6,-6,-7,-9,-11,-13,-15,-17,-18,-18,-19,-18,-18,-18,-17,-16,-16,-15,-15,-15,-14,-13,-12,-11,-11,-9,-8,-6,-6,-5.17,-4.26,-3.13,-1.88,-1.13,-0.38,-0.02,0.25,1,0,0,0,0,0,0,0,0,1,-1,-1.27,-1.38,-1.13,-0.63,-0.16,0.21,0.22,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.37,0.59,-0.66,-2.13,-4,-6,-7,-9,-10,-12,-13,-14,-14,-14,-13,-13,-12,-10,-9,-8,-6,-4.67,-2.78,-2.13,-1.90,-1.66,-1.38,-1,-0.38,0.07,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.12,0.12,-0.16,-0.63,-1.25,-1.89,-2.50,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3.17,-3.63,-4.11,-4.51,-4.93,-5.13,-5.13,-4.88,-4.38,-3.86,-3.52,-3.36,-3.17,-3.15,-3.11,-3,-2.93,-2.90,-2.88,-2.79,-2.68,-2.52,-2.27,-2.13,-2.13,-2.11,-2.13,-2.14,-2.17,-2.13,-2.36,-2.49,-2.92,-3.50,-4.13,-4.63,-5.25,-6,-6,-7,-7,-7,-8,-9,-10,-12,-14,-16,-17,-18,-18,-19,-19,-18,-18,-17,-16,-16,-15,-15,-15,-14,-14,-13,-13,-12,-11,-9,-8,-6,-6,-5.25,-4.38,-3.12,-1.92,-1.13,-0.68,-0.30,0.87,0.75,0.73,0.73,0.75,0.11,0,0,0,1,-1,-0.75,-1,-1.01,-0.87,-0.42,0.12,0.24,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.34,0.62,-0.66,-2.36,-4.50,-6,-8,-9,-11,-13,-14,-14,-13,-13,-13,-13,-11,-11,-10,-8,-5.75,-3.64,-2.25,-1.41,-1.25,-1,-0.75,-0.28,0.21,0.35,0.34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.12,0.08,-0.25,-0.63,-1.38,-2,-2.55,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3.25,-3.87,-4.40,-5.11,-5.67,-6,-6,-6,-6,-5.63,-5.13,-4.50,-4.11,-3.77,-3.63,-3.66,-3.63,-3.38,-3.16,-3.03,-2.93,-2.91,-2.90,-2.92,-3,-2.99,-3,-3.11,-3.13,-3.25,-3.55,-3.77,-4.01,-4.55,-5,-5.52,-6,-6,-7,-8,-8,-8,-9,-9,-10,-12,-13,-15,-16,-17,-18,-19,-19,-19,-18,-18,-17,-16,-16,-15,-15,-15,-15,-15,-14,-14,-13,-12,-11,-9,-8,-6,-6,-5.61,-4.42,-3.27,-2.36,-1.88,-1.40,-1,-0.67,-0.53,-0.43,0.45,0.50,0.12,0.09,0,1,1,-0.25,-0.75,-1.02,-1,-0.65,-0.13,0.12,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.33,0.58,-0.65,-2.50,-4.62,-6,-8,-10,-12,-13,-13,-13,-13,-13,-13,-13,-12,-11,-10,-7,-5.38,-3.13,-1.38,-0.76,-0.63,-0.38,-0.25,0.12,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0,-0.13,-0.50,-1.05,-1.54,-2.25,-2.75,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3.15,-3.75,-4.50,-5.17,-6,-6,-6,-7,-7,-7,-6,-6,-5.99,-5.50,-5.28,-5.03,-4.88,-4.79,-4.63,-4.28,-3.99,-3.62,-3.38,-3.42,-3.42,-3.51,-3.55,-3.68,-3.99,-4.38,-4.75,-5.04,-5.25,-5.88,-6,-6,-7,-7,-8,-9,-9,-9,-10,-10,-11,-12,-13,-14,-15,-17,-18,-18,-19,-19,-19,-19,-18,-17,-16,-16,-15,-15,-15,-15,-15,-15,-15,-14,-13,-12,-11,-9,-7,-6,-6,-5.26,-4.49,-3.75,-3.28,-3.02,-2.13,-1.88,-1.63,-1,-0.41,0.09,0.25,0.25,0.25,0,1,-0.03,-0.87,-1.25,-1.25,-0.93,-0.43,0.08,0.12,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.33,0.59,-0.64,-2.50,-5.13,-6,-8,-10,-12,-13,-13,-13,-11,-12,-13,-13,-12,-11,-9,-7,-4.76,-2.25,-0.50,-0.28,-0.25,-0.04,0,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.17,-0.64,-1.50,-2.04,-2.63,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3.41,-4.25,-4.93,-5.90,-6,-7,-7,-7,-8,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-5.88,-5.30,-4.67,-4.25,-4.13,-4.25,-4.63,-5.25,-5.88,-6,-6,-6,-6,-7,-8,-8,-9,-9,-9,-10,-11,-11,-11,-12,-13,-13,-14,-15,-16,-17,-18,-18,-19,-19,-19,-19,-18,-17,-16,-15,-16,-16,-16,-16,-16,-16,-16,-15,-14,-13,-12,-11,-9,-7,-6,-6,-5.13,-4.39,-3.75,-3.25,-2.76,-2.63,-2.38,-1.65,-1,-0.27,0.22,0.37,0.37,1,1,-0.50,-1.16,-1.66,-1.75,-1.38,-0.63,0,0.21,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.62,-0.64,-2.50,-5.25,-6,-7,-10,-12,-13,-14,-13,-12,-12,-13,-13,-12,-10,-8,-6,-3.75,-1,-0.05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.13,-0.64,-1.50,-2.55,-2.63,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3.13,-3.75,-4.62,-5.38,-6,-7,-7,-8,-9,-9,-10,-10,-10,-10,-9,-9,-9,-9,-9,-9,-8,-8,-7,-6,-6,-6,-6,-6,-7,-8,-8,-8,-9,-9,-9,-10,-10,-11,-11,-11,-12,-12,-12,-13,-14,-15,-15,-16,-16,-17,-17,-18,-18,-18,-19,-19,-20,-20,-18,-15,-14,-15,-15,-16,-16,-17,-17,-16,-15,-15,-14,-13,-12,-10,-9,-8,-7,-6,-5.29,-4.50,-3.89,-3.18,-2.88,-2.68,-2.18,-1.63,-0.88,-0.25,0,0.12,1,-1,-1,-2,-2,-3,-1.92,-0.78,0.08,0.36,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.50,0.37,-0.90,-2.53,-4.89,-6,-8,-10,-13,-14,-15,-14,-13,-13,-12,-12,-10,-9,-8,-5.77,-2.67,-0.14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.21,0.20,-0.50,-1.30,-2,-2.50,-2.75,-2.90,-3,-3,-3,-3,-3,-3,-3,-3.25,-3.92,-4.79,-5.68,-6,-7,-8,-9,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-9,-8,-8,-8,-8,-9,-9,-10,-10,-11,-11,-11,-11,-12,-12,-13,-13,-13,-13,-14,-14,-15,-16,-17,-17,-17,-17,-17,-17,-17,-17,-18,-18,-19,-20,-19,-17,-16,-15,-14,-14,-15,-16,-17,-16,-16,-16,-15,-15,-14,-13,-12,-11,-9,-8,-7,-6,-5.27,-4.50,-3.75,-3.25,-2.88,-2.55,-2,-1.18,-0.55,-0.26,-0.30,-1,-1,-2,-2,-3,-3,-3,-1.15,-0.13,0.34,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.37,-0.39,-1.25,-2.54,-4.63,-6,-8,-10,-13,-14,-14,-14,-14,-13,-13,-11,-10,-9,-7,-4.88,-2.25,0.48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.24,0.12,-0.25,-0.88,-1.52,-2.13,-2.55,-2.88,-3,-3,-3,-3,-3,-3,-3,-3.26,-4,-4.89,-6,-7,-9,-10,-10,-11,-12,-13,-13,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-16,-16,-17,-18,-18,-18,-18,-18,-17,-17,-17,-16,-17,-18,-19,-19,-18,-17,-16,-15,-13,-14,-15,-16,-16,-16,-16,-16,-16,-15,-14,-13,-12,-11,-9,-8,-6,-6,-5.36,-4.50,-3.88,-3.30,-2.64,-2,-1.13,-0.50,-0.25,-0.14,-0.75,-1.13,-1.89,-2.88,-3,-3,-3,-1.76,-0.75,0.07,0.25,0.23,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.46,-0.62,-1.55,-2.54,-4.66,-7,-9,-11,-13,-14,-14,-14,-14,-14,-13,-12,-10,-9,-7,-4.77,-1.88,0.20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.23,0.35,0.37,-0.28,-1.05,-1.89,-2.42,-2.75,-2.88,-3,-3,-3,-3,-3,-3,-3.26,-4.15,-5.49,-7,-9,-10,-12,-12,-13,-14,-14,-15,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-13,-13,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-17,-17,-17,-17,-17,-17,-18,-19,-19,-19,-19,-18,-17,-17,-17,-17,-18,-18,-19,-19,-19,-18,-17,-16,-14,-13,-14,-15,-15,-16,-16,-16,-16,-16,-15,-14,-13,-12,-11,-9,-8,-7,-6,-5.36,-4.64,-4.25,-3.38,-2.13,-0.79,-0.03,0.33,0.25,0.62,-1.14,-2.02,-2.75,-3,-3,-3,-2.17,-1.29,-0.50,0.08,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.24,0.46,-0.67,-1.88,-3.42,-5,-6,-9,-11,-13,-14,-14,-14,-14,-14,-13,-12,-11,-9,-7,-4.28,-2.26,-0.63,0.35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.23,0.35,0.37,-0.29,-1.13,-1.66,-2.13,-2.38,-2.63,-2.79,-3,-3,-3,-3,-3.01,-3.49,-4.67,-6,-8,-10,-12,-13,-14,-15,-15,-16,-16,-17,-17,-17,-17,-17,-17,-17,-16,-16,-15,-15,-15,-15,-15,-15,-15,-16,-16,-17,-17,-17,-17,-18,-18,-18,-18,-18,-18,-18,-18,-19,-19,-20,-20,-20,-20,-20,-19,-19,-19,-19,-19,-19,-19,-20,-20,-19,-18,-17,-16,-15,-15,-14,-14,-15,-16,-16,-17,-17,-16,-16,-15,-14,-13,-12,-11,-9,-8,-7,-6,-5.99,-5.54,-4.88,-2.43,-0.03,0.36,0.57,0.50,-0.63,-1.38,-2.25,-2.76,-3,-3,-3,-2.63,-1.88,-0.88,-0.13,0.25,0.22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,-0.12,-0.75,-2,-3.75,-4.92,-7,-9,-11,-13,-14,-14,-14,-14,-13,-12,-12,-10,-8,-6,-4.54,-2.52,-0.77,0.20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.21,0.12,-0.16,-0.67,-1.16,-1.50,-1.68,-1.88,-2.02,-2.67,-2.75,-3,-3,-3,-3.25,-4,-5.66,-7,-9,-12,-13,-15,-16,-16,-17,-17,-17,-18,-18,-17,-17,-18,-18,-18,-17,-17,-17,-17,-17,-17,-17,-17,-17,-18,-18,-18,-18,-19,-19,-19,-20,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-17,-17,-17,-16,-16,-15,-15,-16,-16,-17,-17,-17,-17,-16,-15,-14,-13,-12,-11,-9,-8,-7,-7,-6,-6,-3.62,-2.93,-2.25,-1.88,-1.50,-1.63,-2.02,-2.63,-2.88,-3,-3,-3,-2.80,-2.02,-1.01,-0.18,0.12,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,-0.16,-0.80,-2.25,-3.99,-5.13,-6,-9,-11,-13,-14,-15,-15,-14,-13,-12,-11,-9,-8,-6,-4.61,-2.43,-0.86,-0.13,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.22,0,-0.50,-1.25,-1.30,-1.28,-1.18,-1.13,-1.28,-1.38,-2.66,-2.80,-3,-3.01,-3.66,-5.04,-6,-8,-10,-12,-14,-15,-16,-17,-18,-18,-18,-18,-18,-18,-18,-18,-18,-19,-18,-18,-18,-18,-18,-18,-18,-18,-19,-19,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-18,-18,-17,-16,-16,-16,-17,-17,-17,-18,-17,-17,-16,-15,-14,-13,-12,-10,-9,-8,-8,-7,-7,-6,-4.89,-4.04,-3.17,-2.91,-2.87,-2.89,-3.37,-3.75,-3.75,-3.50,-3.02,-3,-2.25,-1.13,-0.25,0.12,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.22,0.12,-0.88,-2.37,-4.02,-5.12,-7,-8,-11,-13,-15,-16,-16,-15,-14,-12,-10,-8,-7,-6,-4.13,-2.03,-1.15,-0.26,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,-0.05,-0.65,-1.38,-1.38,-1.01,-0.66,-0.63,-0.63,-1.25,-1.88,-2.67,-2.88,-3.15,-4.50,-5.88,-7,-9,-11,-12,-14,-15,-17,-17,-18,-18,-18,-17,-17,-18,-18,-18,-19,-19,-19,-19,-18,-19,-19,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-17,-17,-17,-17,-18,-18,-18,-18,-17,-16,-15,-14,-13,-11,-10,-9,-9,-8,-7,-7,-6,-6,-4.99,-4.28,-4.30,-4.74,-4.80,-5.11,-5.11,-4.80,-4.28,-3.51,-2.40,-1.13,-0.13,0.37,0.24,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.32,-0.13,-0.99,-2.26,-3.92,-5.24,-6,-8,-11,-13,-15,-16,-17,-16,-14,-13,-10,-8,-6,-5.13,-3.30,-2.24,-1.63,-0.75,0.75,0.87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.35,0,-0.66,-1.26,-1.13,-0.75,-0.25,-0.14,-0.27,-0.75,-1.40,-2.25,-2.75,-3.49,-5.15,-6,-8,-9,-11,-12,-14,-15,-16,-17,-17,-17,-17,-17,-17,-17,-18,-19,-19,-19,-20,-19,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-17,-17,-17,-19,-19,-19,-18,-17,-16,-15,-14,-13,-12,-11,-10,-10,-9,-8,-8,-8,-7,-6,-5.67,-6,-6,-6,-6,-6,-5.86,-5.38,-4.63,-2.90,-1.40,-0.41,0.12,0.24,0.12,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.25,0.23,-0.13,-1.13,-2.13,-3.53,-4.92,-6,-8,-12,-14,-16,-17,-17,-17,-15,-13,-11,-9,-6,-4,-2.89,-2.54,-2.15,-1.30,-0.68,0.75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.25,0.33,-0.13,-0.67,-1.16,-0.88,-0.50,-0.13,0.12,0,-0.12,-1.25,-2.13,-2.76,-3.93,-5.63,-7,-8,-10,-11,-12,-13,-15,-16,-17,-17,-17,-17,-17,-17,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-17,-17,-17,-18,-19,-19,-19,-18,-17,-16,-15,-14,-13,-12,-12,-11,-10,-10,-9,-9,-8,-7,-8,-8,-8,-7,-7,-7,-7,-6,-5.55,-3.93,-1.88,-1.02,-0.38,0.10,0.12,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.20,0.37,0.07,-0.54,-1.30,-2.25,-3,-4.87,-7,-11,-14,-15,-17,-18,-18,-18,-16,-14,-11,-10,-7,-4.03,-3.13,-3,-2.78,-1.88,-0.78,0.74,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.25,0,-0.27,-0.75,-1,-0.75,-0.25,0.12,0.37,0.62,-0.38,-1.28,-2.13,-2.80,-4.25,-6,-7,-9,-10,-12,-13,-14,-15,-16,-17,-17,-18,-18,-18,-18,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-17,-17,-17,-18,-19,-19,-18,-18,-17,-16,-15,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-10,-10,-10,-9,-9,-8,-8,-7,-6,-5.16,-3.03,-1.65,-0.78,-0.05,0.24,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.25,0.23,0,-0.75,-1.63,-2.40,-4,-6,-9,-10,-13,-16,-18,-19,-18,-17,-16,-14,-11,-9,-7,-5.75,-4.37,-3.18,-2.88,-2.25,-1.25,-0.38,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.21,-0.13,-0.41,-0.75,-1.25,-0.50,0.07,0.25,0.24,0.74,-0.75,-1.76,-2.25,-3.13,-4.38,-6,-7,-9,-11,-12,-13,-15,-16,-17,-18,-18,-18,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-17,-16,-16,-18,-18,-18,-18,-18,-18,-17,-16,-15,-15,-14,-14,-14,-14,-13,-12,-12,-12,-12,-12,-12,-12,-11,-10,-9,-8,-7,-6,-4.13,-2.25,-1.17,-0.25,0.25,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.23,0.09,-0.38,-1.05,-1.88,-3.24,-5.36,-7,-8,-11,-15,-18,-20,-20,-20,-20,-18,-14,-10,-8,-8,-7,-5.75,-4.18,-3,-2.50,-1.68,-0.80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.09,0.08,0,-0.38,-0.64,-0.89,-0.88,-0.38,0.58,0.25,0.12,0.83,-0.88,-1.88,-2.89,-3.51,-4.38,-6,-7,-9,-11,-12,-14,-15,-16,-18,-18,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-18,-17,-16,-16,-17,-17,-18,-18,-18,-18,-17,-16,-16,-16,-16,-16,-15,-15,-14,-14,-14,-14,-14,-14,-13,-13,-11,-10,-9,-7,-6,-4.65,-3,-1.63,-0.75,0,0.25,0.12,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,-0.17,-0.65,-1.30,-2.25,-3.77,-6,-9,-10,-13,-15,-18,-19,-19,-19,-19,-18,-15,-13,-10,-9,-8,-7,-5.89,-4,-3,-2.13,-1.13,-0.13,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.07,-0.04,-0.29,-0.63,-1,-1.17,-1.02,-0.38,0.75,0.12,0.12,0.83,-0.80,-1.92,-2.88,-3.75,-4.50,-6,-8,-9,-11,-13,-14,-16,-17,-18,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-17,-16,-16,-17,-18,-18,-19,-18,-18,-17,-17,-17,-17,-17,-17,-16,-16,-16,-15,-15,-15,-15,-14,-13,-12,-11,-9,-8,-6,-4.63,-3.41,-2.38,-1.29,-0.49,0.12,0.36,0.12,0.33,0.33,0.22,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0,-0.27,-0.80,-1.50,-2.51,-4.50,-7,-10,-12,-14,-16,-17,-19,-19,-19,-19,-18,-16,-14,-12,-11,-9,-8,-6,-5.13,-3.37,-2.17,-1.38,-0.38,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.08,-0.16,-0.63,-1.13,-1.50,-1.63,-1.27,-0.38,0.75,0.22,0.22,0.73,-0.75,-2,-2.88,-3.92,-5.04,-6,-8,-10,-11,-13,-15,-16,-18,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-18,-17,-17,-17,-18,-19,-19,-18,-18,-18,-17,-17,-18,-18,-18,-18,-17,-17,-17,-16,-16,-16,-15,-14,-13,-12,-10,-8,-6,-5.01,-4.25,-3,-2.03,-1.25,-0.39,-0.16,-0.25,-0.03,0.11,0.23,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.10,0,-0.38,-0.88,-1.55,-2.63,-5.25,-9,-11,-12,-14,-16,-17,-18,-18,-19,-18,-18,-17,-16,-14,-13,-11,-9,-7,-5.66,-3.88,-2.63,-1.65,-0.88,-0.02,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.12,-0.25,-0.88,-1.51,-2.05,-2.18,-1.68,-0.55,0.75,0.23,0.25,0.62,-0.67,-2,-3,-4.51,-5.86,-7,-8,-10,-12,-14,-15,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-18,-18,-18,-18,-18,-19,-18,-18,-18,-17,-17,-18,-18,-19,-19,-19,-18,-18,-17,-17,-16,-15,-15,-14,-12,-11,-9,-7,-6,-5.39,-4.39,-3.38,-2.16,-1.50,-1.15,-1.13,-0.77,-0.25,0.12,0.33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,-0.01,-0.38,-1,-1.75,-3,-6,-10,-12,-13,-14,-16,-17,-18,-18,-18,-18,-18,-17,-16,-16,-15,-13,-11,-9,-6,-4.40,-3.01,-2.02,-1.25,-0.39,0.24,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,-0.13,-0.91,-1.75,-2.41,-2.64,-1.76,-0.66,0.50,0.25,0.62,0.62,-0.90,-2.02,-3.55,-5.38,-6,-8,-9,-11,-13,-14,-16,-17,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-19,-18,-18,-18,-18,-18,-17,-17,-18,-18,-18,-19,-19,-19,-19,-18,-18,-17,-16,-16,-15,-14,-13,-11,-10,-9,-7,-6,-5.66,-4.65,-3.65,-2.63,-2.36,-2.13,-1.88,-1.14,-0.38,0.25,-0.04,-0.02,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.20,0,-0.42,-1.25,-2,-3.63,-7,-10,-11,-13,-14,-16,-17,-17,-18,-18,-18,-17,-17,-17,-17,-16,-15,-13,-10,-7,-5.41,-3.25,-2.39,-1.63,-0.77,-0.04,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,-0.13,-0.88,-1.79,-2.52,-2.88,-2.03,-1.13,0.37,0.72,0.62,-0.63,-1.38,-2.80,-4.50,-6,-7,-9,-11,-12,-14,-16,-17,-18,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-18,-18,-17,-17,-17,-17,-17,-18,-18,-19,-19,-19,-19,-19,-18,-17,-17,-16,-15,-14,-13,-12,-11,-10,-9,-8,-7,-6,-5,-4,-3.36,-3.13,-2.77,-2.03,-1.14,-0.30,0.83,0.96,0.98,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.23,0,-0.63,-1.53,-2.74,-4.55,-7,-9,-11,-13,-15,-16,-17,-18,-18,-18,-18,-17,-17,-17,-18,-17,-16,-14,-11,-8,-5.92,-3.67,-2.75,-2,-1.02,0,0.37,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.22,-0.16,-1,-1.88,-2.50,-2.88,-2.38,-1.75,-1.13,-0.75,-0.90,-1.38,-2.38,-3.79,-5.50,-7,-9,-11,-12,-14,-15,-17,-18,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-17,-17,-17,-17,-17,-18,-19,-19,-19,-19,-19,-19,-18,-17,-17,-16,-15,-15,-14,-13,-12,-11,-10,-9,-8,-7,-6,-5.13,-4.16,-4,-3.54,-3,-2.27,-1.66,-1.03,-0.50,-0.25,-0.15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.21,0.12,-0.25,-1.13,-2.27,-3.87,-6,-7,-9,-12,-14,-15,-17,-18,-18,-18,-18,-18,-17,-17,-17,-17,-17,-16,-14,-12,-9,-6,-4,-3.14,-2.38,-1.26,-0.13,0.25,0.21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.12,-0.25,-1.03,-1.88,-2.50,-2.88,-2.75,-2.78,-2.13,-2,-2,-2.27,-3.52,-4.88,-6,-8,-10,-12,-14,-16,-17,-18,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-18,-17,-16,-16,-16,-17,-17,-18,-19,-19,-19,-19,-19,-19,-18,-18,-17,-16,-16,-15,-15,-14,-13,-12,-12,-11,-10,-9,-8,-6,-5.28,-4.88,-4.50,-4.13,-3.80,-3,-2.50,-1.80,-1.17,-0.63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0,-0.66,-1.64,-3.13,-4.79,-6,-8,-10,-13,-15,-16,-18,-18,-18,-18,-18,-18,-17,-17,-17,-17,-17,-16,-15,-12,-9,-6,-4.14,-3.13,-2.50,-1.54,-0.38,0.22,0.35,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.12,-0.25,-1,-1.90,-2.54,-2.88,-3,-2.88,-2.88,-2.78,-2.75,-3.14,-4.38,-6,-7,-9,-12,-13,-15,-17,-18,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-18,-17,-16,-16,-16,-17,-18,-18,-19,-19,-19,-19,-19,-19,-19,-18,-18,-17,-16,-16,-16,-15,-15,-14,-14,-14,-13,-12,-10,-9,-7,-6,-5.75,-5.25,-4.75,-4,-3.26,-2.75,-2.01,-1.29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,-0.18,-1.13,-2.37,-3.91,-5.64,-8,-10,-12,-14,-16,-18,-18,-19,-19,-18,-18,-17,-17,-16,-16,-16,-16,-15,-14,-11,-8,-6,-4.50,-3.12,-2.63,-1.91,-0.92,-0.14,0.25,0.21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.24,0.24,0.13,-0.88,-2,-2.63,-3,-3,-3,-3,-3.01,-3.04,-3.76,-5.36,-7,-8,-11,-13,-15,-17,-18,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-17,-16,-17,-17,-18,-18,-18,-19,-19,-19,-19,-19,-19,-19,-18,-18,-17,-17,-17,-17,-17,-16,-17,-16,-16,-15,-13,-11,-9,-8,-7,-6,-5.68,-5.04,-4.38,-3.43,-2.66,-1.76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,-0.17,-1.62,-3,-4.65,-7,-9,-11,-13,-15,-17,-18,-19,-19,-19,-18,-18,-17,-17,-16,-16,-16,-15,-14,-12,-10,-8,-6,-4.51,-3.28,-2.75,-2.05,-1.25,-0.29,0.21,0.36,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.24,0.21,-0.78,-1.90,-2.63,-3,-3,-3,-3.02,-3.05,-3.25,-4.29,-6,-7,-9,-11,-14,-16,-18,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-18,-17,-17,-18,-18,-18,-18,-18,-18,-19,-19,-20,-19,-19,-19,-18,-17,-18,-18,-18,-18,-19,-18,-18,-19,-18,-17,-14,-12,-10,-8,-7,-6,-5.93,-5.16,-4.13,-3.24,-2.13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.60,-0.30,-2.13,-3.75,-5.63,-7,-10,-12,-14,-16,-18,-19,-19,-19,-19,-18,-17,-17,-16,-16,-16,-15,-15,-14,-12,-9,-7,-6,-4.75,-3.51,-2.63,-2.25,-1.53,-0.64,0,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.32,-0.03,-0.75,-1.63,-2.63,-2.88,-3,-3.01,-3.05,-3.13,-3.49,-4.77,-6,-8,-10,-13,-15,-17,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-18,-18,-18,-18,-18,-18,-18,-18,-19,-20,-20,-19,-19,-18,-18,-18,-18,-19,-20,-19,-19,-19,-19,-19,-19,-18,-15,-13,-11,-9,-9,-8,-6,-5,-3.76,-2.39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.32,0.50,-0.88,-2.67,-4.50,-6,-8,-10,-12,-15,-17,-18,-19,-19,-19,-18,-18,-17,-17,-16,-16,-16,-15,-15,-14,-12,-10,-8,-6,-4.68,-3.50,-2.75,-2.26,-1.75,-0.93,-0.15,0.59,0.21,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,-0.13,-0.67,-1.43,-2.28,-2.68,-2.88,-3.04,-3.12,-3.13,-3.75,-5.18,-7,-9,-12,-14,-16,-18,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-18,-18,-18,-19,-19,-19,-19,-19,-19,-18,-18,-18,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-18,-16,-14,-13,-12,-11,-9,-7,-5.16,-2.88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.32,0.48,-1.29,-3.37,-5.25,-6,-8,-10,-13,-15,-17,-18,-19,-19,-18,-18,-17,-17,-16,-16,-16,-16,-16,-15,-14,-13,-11,-9,-6,-5.30,-3.53,-2.87,-2.42,-1.92,-1.38,-0.63,0.07,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.20,-0.13,-0.62,-1.25,-1.92,-2.41,-2.76,-3,-3.13,-3.25,-4.16,-5.88,-8,-10,-12,-15,-17,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-20,-20,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-17,-16,-15,-13,-11,-9,-7,-5.16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.36,-1.64,-3.88,-5.88,-7,-9,-11,-14,-16,-17,-18,-18,-18,-17,-17,-16,-16,-16,-16,-16,-16,-16,-16,-15,-14,-13,-10,-7,-6,-4.29,-3,-2.63,-2.25,-1.66,-1.03,-0.50,0,0.34,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.09,-0.27,-0.88,-1.52,-2.13,-2.65,-3,-3.13,-3.50,-4.66,-6,-8,-11,-13,-15,-17,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-18,-17,-15,-13,-11,-9,-6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.21,0.35,0.32,-1.89,-4.25,-6,-8,-9,-11,-14,-16,-17,-18,-18,-17,-16,-16,-15,-15,-15,-15,-16,-16,-16,-16,-17,-16,-15,-12,-9,-7,-5.78,-3.88,-2.79,-2.50,-2.13,-1.63,-1.02,-0.26,0.25,0.33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0.09,-0.54,-1.25,-1.90,-2.62,-3.12,-3.13,-3.87,-5.05,-6,-9,-11,-13,-15,-17,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-17,-15,-13,-10,-8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.25,0.49,0,-2.13,-4.43,-6,-8,-9,-12,-14,-15,-16,-17,-17,-16,-15,-15,-14,-14,-14,-15,-15,-16,-16,-17,-17,-17,-15,-12,-10,-8,-7,-5.75,-4.25,-3.38,-2.88,-2.27,-1.51,-0.79,0.09,0.37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.21,0.12,-0.50,-1.13,-1.77,-2.55,-2.99,-3.25,-4.04,-5.28,-7,-8,-11,-13,-15,-17,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-16,-14,-11,-9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.32,0.50,-0.38,-2.25,-4.75,-7,-8,-10,-12,-13,-15,-15,-16,-16,-15,-14,-13,-13,-12,-13,-14,-14,-15,-15,-15,-15,-15,-14,-12,-10,-9,-8,-7,-6,-5.28,-4.30,-3.38,-2.50,-1.41,-0.66,0.21,0.98,0,0.08,0.09,0.09,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,-0.03,-0.40,-1.01,-1.75,-2.51,-2.92,-3.38,-4.14,-5.36,-7,-8,-10,-13,-15,-17,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-18,-15,-12,-10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.32,0.59,-0.50,-2.50,-5,-7,-9,-10,-12,-13,-14,-15,-15,-15,-14,-13,-12,-11,-10,-11,-12,-14,-13,-12,-12,-13,-12,-12,-11,-10,-9,-9,-8,-7,-6,-5.78,-4.76,-3.67,-2.36,-1.42,-0.63,0.73,0.62,0.12,0.20,0.20,0.12,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,-0.12,-0.38,-0.91,-1.63,-2.38,-2.79,-3.28,-4.13,-5.28,-6,-8,-10,-12,-15,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-17,-14,-11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.22,0.62,-0.63,-2.75,-5.37,-8,-9,-10,-11,-12,-13,-14,-14,-14,-13,-11,-10,-9,-9,-9,-9,-9,-9,-8,-8,-9,-9,-9,-9,-9,-9,-9,-8,-8,-7,-7,-6,-4.89,-3.75,-2.29,-1.50,-0.75,0.11,-0.15,-0.13,0.10,0.21,0.23,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0,-0.18,-0.75,-1.43,-2.14,-2.64,-3.24,-4,-5.11,-6,-8,-9,-12,-14,-16,-18,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-16,-13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.33,0.62,-0.75,-2.75,-5.63,-8,-9,-10,-11,-12,-12,-13,-14,-13,-12,-10,-8,-7,-7,-6,-6,-5.38,-5.25,-4.40,-3.78,-4.75,-6,-7,-7,-8,-8,-8,-8,-8,-8,-8,-7,-6,-4.88,-3.38,-2.13,-1.50,-1.13,-0.88,-0.67,-0.38,0,0.25,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.08,-0.13,-0.55,-1.15,-1.88,-2.38,-2.87,-3.65,-4.74,-6,-7,-9,-11,-14,-16,-17,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-17,-14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.34,0.50,-0.80,-2.88,-5.75,-8,-8,-9,-10,-11,-11,-12,-12,-12,-10,-8,-7,-6,-5.39,-4.42,-3.37,-2.40,-2.25,-1.51,-0.76,-1.41,-3.52,-4.86,-5.79,-6,-7,-7,-8,-8,-8,-8,-7,-6,-5.99,-4.64,-3.36,-2.25,-1.88,-1.65,-1.42,-1.13,-0.53,0,0.25,0.35,0.33,0.22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0,-0.25,-0.75,-1.38,-2,-2.42,-3.27,-4.40,-5.38,-6,-8,-11,-13,-15,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-18,-14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.25,0.32,-0.77,-2.75,-5.37,-7,-8,-9,-10,-10,-11,-11,-11,-10,-9,-7,-6,-4.91,-3.66,-2.66,-1.63,-0.79,-0.62,0.37,0.50,0.12,-1.24,-2.75,-3.78,-4.74,-5.51,-6,-6,-7,-8,-8,-8,-7,-6,-5.68,-4.63,-3.63,-2.79,-2.38,-2.29,-1.88,-1.26,-0.63,-0.13,0,0.22,0.23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.12,-0.25,-0.88,-1.50,-2.13,-2.80,-3.88,-4.78,-6,-8,-10,-12,-14,-17,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-18,-16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.25,0.25,-0.51,-2.50,-4.75,-7,-7,-8,-9,-9,-10,-10,-10,-10,-8,-6,-5.25,-3.63,-2.30,-1.42,-0.64,-0.13,0.11,0.33,0.25,0.32,0,-1.13,-2.03,-2.89,-3.78,-4.75,-5.67,-6,-7,-8,-8,-7,-7,-6,-5.75,-4.89,-4.15,-3.65,-2.78,-2.42,-2,-1.50,-1.04,-0.63,0,0.25,0.12,0.12,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.25,0.12,-0.27,-0.92,-1.64,-2.38,-3.18,-4.27,-5.25,-7,-9,-12,-14,-17,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.23,0.12,-2.02,-4,-6,-7,-9,-9,-9,-9,-9,-9,-10,-8,-6,-4.13,-2.30,-1.25,-0.63,-0.05,0.10,0.10,0.07,0.08,0.12,0.33,0.07,-0.50,-1.13,-2,-3.03,-4.25,-5.51,-6,-7,-7,-7,-7,-7,-6,-6,-5.38,-4.66,-3.89,-2.88,-2.55,-2.26,-2,-1.63,-0.88,0.07,0.75,0.75,0.20,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.22,0.37,0.12,-0.38,-1.14,-1.92,-2.52,-3.53,-4.55,-6,-8,-11,-14,-16,-18,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.32,0.33,-0.13,-1.63,-3.25,-4.89,-6,-7,-8,-8,-8,-9,-8,-8,-7,-5.16,-2.92,-1.28,-0.51,0,0.09,0,0,0,0,0,0.20,0.32,0.25,0.12,-0.13,-1.03,-2.63,-4.13,-5.50,-6,-7,-7,-7,-7,-7,-6,-6,-5.76,-4.99,-4.02,-2.88,-2.88,-2.75,-2.37,-1.67,-0.88,-0.75,0.74,0.75,0.21,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.25,0,-0.63,-1.40,-2.18,-3.13,-4.01,-5.65,-8,-11,-13,-16,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.22,0.35,0.25,-0.38,-1.30,-2.42,-3.67,-4.93,-6,-6,-7,-7,-7,-6,-6,-5.52,-3.55,-1.02,-0.38,-0.01,0.12,0.08,0,0,0,0,0,0,0,1,0.74,0.62,0.58,-0.49,-2.64,-4.13,-5.28,-6,-6,-7,-7,-8,-7,-7,-6,-6,-5.38,-3.75,-3.89,-3.88,-3.38,-2.62,-1.90,-1.25,-0.75,0.73,0.75,0.20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.20,0.37,0.08,-0.26,-1.25,-2,-2.79,-4.01,-5.50,-7,-10,-13,-15,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-18,-16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.11,-0.04,-0.39,-1.04,-1.75,-2.51,-3.38,-4.25,-4.88,-5.17,-5.25,-5.13,-4.54,-4.01,-2.91,-1.43,-0.63,0,0.09,0.08,0,0,0,0,0,0,0,0,0,0.25,0.37,0.48,0.25,-1.26,-2.66,-4,-5.24,-6,-7,-8,-8,-8,-8,-8,-7,-7,-6,-6,-5.53,-4.88,-4.13,-3.12,-2.13,-1.25,-0.75,0.74,0.21,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.34,0.10,-0.38,-1.13,-2,-2.88,-3.89,-5.43,-7,-10,-12,-15,-17,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-18,-15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.10,0.08,-0.03,-0.25,-0.50,-0.88,-1.25,-1.52,-2.04,-2.68,-3.17,-3.38,-3.25,-2.68,-2.53,-2,-1.75,-0.88,0,0.12,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0.22,0.50,-0.12,-1.28,-2.55,-4.17,-5.79,-7,-8,-8,-9,-9,-9,-9,-8,-8,-7,-7,-6,-5.25,-4.17,-3,-1.92,-1,0.12,0.08,0.21,0.24,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.33,0.08,-0.38,-1.01,-1.93,-3,-3.76,-5.25,-7,-9,-12,-15,-17,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-17,-14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.11,0,-0.16,-0.39,-0.65,-0.88,-1,-0.90,-1.16,-1.65,-2.13,-2.02,-1.30,-1.01,-1.38,-1.37,-1,-0.38,0.25,0.36,0.20,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.62,0.35,-0.38,-1.38,-3.38,-5.16,-6,-8,-8,-9,-10,-10,-10,-10,-10,-9,-8,-7,-6,-5,-3.63,-2.63,-1.53,-0.88,-0.40,-0.14,0.10,0.33,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.24,0.22,-0.25,-0.87,-1.68,-3.03,-3.64,-4.87,-6,-9,-12,-14,-16,-18,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-16,-13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.12,0.22,0,-0.28,-0.63,-0.88,-1.03,-1.25,-0.25,-0.26,-1.50,-1.63,-1.38,-0.88,-0.76,-1.04,-1.03,-0.63,0.37,0.35,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0.83,0.23,-0.38,-1.02,-2.53,-4.50,-6,-7,-8,-9,-10,-11,-12,-12,-11,-11,-9,-8,-7,-5.63,-4.12,-2.67,-2.13,-1.52,-1.13,-0.67,-0.29,0.09,0.32,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.33,-0.53,-1.38,-2.38,-3.63,-4.63,-6,-9,-11,-13,-16,-17,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-16,-14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.22,0.21,-0.13,-0.50,-0.79,-1.13,-1.38,-1.16,-0.90,-1.17,-2,-1.27,-0.93,-0.75,-0.75,-1.13,-1.25,-0.39,0.50,0.37,0.21,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0.87,0.25,-0.27,-0.88,-2.13,-4.03,-5.49,-6,-7,-8,-10,-11,-12,-13,-13,-12,-11,-9,-7,-6,-4.16,-2.78,-2.38,-2.04,-1.64,-1.29,-0.75,-0.18,0.25,0.32,0.21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.13,-0.25,-1.13,-2,-3.25,-4.37,-6,-8,-11,-13,-15,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-17,-15,-13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.20,0.20,0.11,-0.27,-0.64,-1.02,-1.38,-1.64,-1.27,-1.27,-1.88,-1,-0.75,-0.53,-0.55,-0.88,-1.13,-1.75,-0.28,0.75,0.34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.96,0.25,-0.13,-0.50,-1.25,-3.11,-4.51,-5.63,-6,-7,-9,-11,-13,-13,-13,-13,-11,-9,-7,-5.63,-3.78,-2.67,-2.54,-2.38,-1.93,-1.29,-0.75,-0.38,-0.02,0.12,0.24,0.20,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.21,-0.15,-0.90,-1.88,-3.02,-4.16,-6,-8,-10,-12,-14,-16,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-17,-15,-13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.23,0.11,-0.13,-0.43,-0.88,-1.38,-1.64,-2.25,-2.63,-2.38,-1.88,-1.02,-0.79,-0.88,-0.88,-0.93,-1.01,-0.75,-0.13,0.75,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.45,0.25,-0.13,-0.29,-1.63,-3.25,-4.50,-5.26,-5.88,-7,-9,-11,-12,-13,-12,-11,-9,-6,-4.63,-2.99,-2.25,-2.13,-1.88,-1.43,-1,-0.63,-0.38,-0.13,0.09,0.25,0.58,0.22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.22,-0.13,-0.88,-1.88,-2.65,-3.90,-5.66,-7,-9,-11,-13,-15,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-17,-15,-13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.20,0,-0.25,-0.65,-1.13,-2.13,-3.29,-4.13,-4.38,-4.13,-3.75,-3.13,-2.54,-2.01,-1.51,-1.12,-0.77,-0.38,0.20,0.48,0.24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.20,0.37,0.25,0.25,-0.38,-1.74,-3.13,-4,-4.17,-5,-6,-8,-9,-10,-10,-9,-7,-5.01,-2.88,-1.61,-1.25,-1.13,-1,-0.80,-0.63,-0.38,-0.25,-0.13,0,0.25,0.37,0.37,0.23,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.20,-0.04,-0.75,-1.63,-2.29,-3.38,-5.05,-7,-9,-11,-12,-14,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-18,-16,-14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.21,-0.04,-0.40,-0.88,-2.26,-3.54,-4.64,-5.25,-5.51,-5.63,-5.42,-4.88,-4.13,-3.26,-2.30,-1.41,-0.63,-0.15,0.20,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.21,0.50,0.11,-0.66,-1.88,-2.67,-2.77,-2.78,-3.76,-5.74,-6,-7,-6,-5.77,-4.27,-2.38,-1.16,-0.50,0,-0.04,-0.26,-0.25,-0.25,-0.13,-0.04,0,0,0.21,0.32,0.48,0.72,0.83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.08,-0.41,-1.15,-1.91,-2.75,-4.26,-6,-8,-10,-12,-14,-15,-16,-18,-18,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-17,-14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.25,-0.13,-0.52,-1.75,-3.63,-4.75,-5.75,-6,-6,-6,-6,-6,-5.50,-4.54,-3.29,-1.91,-0.50,0.10,0.25,0.22,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.62,-0.42,-1.13,-1.63,-2,-2.13,-2.15,-2.64,-3.54,-3.54,-2.88,-2.38,-1.74,-1.65,-0.63,0.46,0.33,0.50,0.22,0.12,0.08,0.09,0.12,0.12,0.11,0,0.13,0.23,0.12,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.12,-0.13,-0.75,-1.50,-2.27,-3.67,-5.63,-7,-9,-11,-13,-15,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-18,-15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.23,0.12,-0.25,-0.78,-2.64,-4.25,-5.50,-6,-7,-7,-7,-7,-7,-6,-5.63,-4.25,-2.50,-0.39,0.12,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.45,-0.13,-0.75,-1.25,-1.63,-1.78,-1.88,-1.80,-1.63,-1.16,-0.88,-1,-1.50,-0.77,-0.13,0.37,0.50,0.59,0.45,0.35,0.25,0.25,0.25,0.25,0.25,0.34,0.13,0.12,0.20,0.20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.21,0,-0.50,-1.15,-1.88,-3.25,-4.79,-7,-9,-11,-13,-14,-16,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0,-0.25,-1.75,-3.30,-5,-6,-7,-7,-8,-8,-8,-7,-7,-6,-4.67,-2.88,-0.87,0.12,0.24,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,0,-0.41,-0.89,-1.38,-1.53,-1.63,-1.53,-1.38,-1.05,-1,-1,-0.90,-0.51,0.62,0.48,0.36,0.62,0.48,0.50,0.37,0.37,0.36,0.37,0.37,0.37,0.32,0.24,0.25,0.25,0.12,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.12,0,-0.38,-1,-1.67,-2.75,-4.26,-6,-8,-10,-12,-14,-16,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,-0.12,-0.50,-2.16,-3.89,-5.53,-6,-7,-8,-8,-8,-8,-8,-7,-6,-5.02,-3.14,-1.42,0.12,0.21,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.12,-0.17,-0.64,-1.13,-1.38,-1.43,-1.42,-1.38,-1.13,-1,-1,-0.88,-0.63,-0.38,-0.26,-0.39,-0.68,0.58,0.50,0.37,0.25,0.22,0.25,0.33,0.37,0.37,0.37,0.37,0.37,0.50,0.61,0.25,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0,-0.26,-0.80,-1.50,-2.28,-3.78,-5.88,-8,-10,-12,-14,-15,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-18,-18,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,-0.13,-0.63,-2.50,-4.27,-5.90,-7,-7,-7,-8,-8,-8,-8,-7,-6,-5.18,-3.38,-1.63,-0.02,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.21,0.35,0.12,-0.43,-0.88,-1.17,-1.38,-1.38,-1.38,-1.38,-1.25,-1.13,-1.01,-0.90,-0.88,-1,-1.25,-0.90,-0.65,-0.50,-0.38,-0.25,-0.17,-0.25,0.20,0.12,0.12,0.20,0.22,0.11,0.12,0.22,0.50,0.20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0,-0.14,-0.63,-1.29,-2,-3.38,-5.52,-7,-9,-11,-13,-15,-16,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-18,-18,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,-0.17,-0.78,-2.80,-4.75,-6,-7,-7,-8,-8,-8,-8,-8,-7,-6,-5.25,-3.37,-1.53,-0.01,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.21,-0.13,-0.63,-0.93,-1.25,-1.38,-1.50,-1.54,-1.51,-1.38,-1.25,-1.13,-1.13,-1.38,-1.51,-1.63,-1.26,-1.27,-0.63,-0.50,-0.63,-0.67,-0.63,-0.41,-0.28,-0.04,-0.13,-0.15,-0.13,0,0.25,0.24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.12,-0.25,-1.03,-1.92,-3.15,-5.12,-7,-9,-11,-12,-14,-16,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-18,-18,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.22,0.37,-0.13,-0.91,-3.25,-5.18,-6,-8,-8,-8,-8,-8,-8,-8,-7,-6,-5.13,-3,-1.25,0.11,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.23,0.25,0.12,-0.25,-0.63,-1,-1.29,-1.53,-1.75,-1.88,-1.65,-1.50,-1.30,-1.38,-1.63,-1.88,-1.79,-1.55,-1,-0.66,-0.28,-0.79,-1.55,-1.38,-1.25,-0.88,-0.63,-0.50,-0.39,-0.26,-0.13,0.09,0.12,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,-0.13,-0.88,-1.88,-2.92,-4.63,-6,-8,-10,-12,-14,-15,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.25,0.21,-0.28,-2,-3.80,-5.68,-7,-8,-8,-9,-9,-9,-9,-9,-8,-6,-4.76,-2.52,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.32,0.23,-0.26,-0.75,-1.16,-1.53,-1.90,-2.13,-2.04,-1.93,-2.13,-2.29,-2.39,-2.40,-2.14,-1.75,-1.04,-0.53,-0.67,-0.88,-1.52,-1.28,-1.27,-1.26,-1.15,-0.92,-0.67,-0.41,-0.15,0,0.12,0.12,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,-0.02,-0.75,-1.65,-2.67,-4.13,-6,-7,-9,-11,-13,-15,-17,-18,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.37,0.22,-0.75,-2.68,-4.50,-6,-7,-9,-9,-9,-9,-9,-9,-9,-8,-6,-4.63,-2.13,0.37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.25,0.45,-0.02,-0.50,-1,-1.50,-2,-2.38,-2.53,-3.13,-3.51,-3.61,-3.87,-3.88,-3.68,-2.54,-1.50,-1.25,-1,-0.88,-0.75,-0.88,-1.14,-1.50,-1.63,-1.50,-1,-0.63,-0.25,-0.02,0.12,0.22,0.22,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.20,0.08,-0.38,-1.38,-2.41,-3.79,-5.50,-7,-8,-10,-12,-14,-16,-18,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.24,0.62,0.25,-1.66,-3.38,-5.13,-6,-8,-9,-9,-10,-10,-10,-9,-9,-8,-7,-4.88,-1.65,0.62,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.12,0.12,-0.25,-0.75,-1.38,-2,-2.43,-3.53,-5,-4.92,-5.25,-5.63,-6,-5.66,-4.65,-3.50,-2.02,-1.38,-0.77,-0.42,-0.63,-1.25,-1.67,-2,-1.88,-1.18,-0.67,-0.38,-0.13,0.07,0.12,0.35,0.23,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.24,0.12,-0.40,-1.13,-2.13,-3.66,-5,-6,-7,-10,-12,-14,-15,-17,-18,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.25,-0.52,-2.40,-4.01,-5.63,-7,-8,-9,-9,-10,-10,-10,-10,-10,-9,-7,-5.39,-2.50,0.46,0.33,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0,-0.40,-1.04,-1.66,-2.63,-4.75,-6,-7,-6,-8,-8,-7,-6,-5.24,-3.87,-2.50,-1.13,-0.38,-1.02,-1.50,-1.89,-2.13,-2,-1.14,-0.63,-0.28,-0.13,-0.01,0.08,0.21,0.25,0.12,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.33,0.37,-0.13,-0.88,-1.75,-3.64,-4.63,-5.64,-7,-9,-11,-13,-14,-16,-17,-18,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.24,0.09,-1.04,-2.91,-4.50,-6,-7,-8,-10,-10,-10,-10,-10,-10,-10,-9,-8,-5.75,-2.76,-0.25,0.32,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,-0.13,-0.75,-1.39,-2.61,-4.17,-6,-6,-8,-10,-11,-10,-8,-7,-5.50,-3.90,-2,-1.51,-1.63,-2,-2.13,-2.28,-1.50,-0.88,-0.38,-0.14,-0.05,-0.04,0,0.10,0.12,0.12,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.83,0.50,-0.52,-1.40,-2.53,-4.29,-5.50,-6,-8,-10,-12,-13,-15,-16,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.20,0,-1.26,-3.13,-4.77,-6,-8,-9,-10,-10,-11,-11,-10,-10,-10,-9,-7,-5.28,-2.63,-0.65,0.22,0.12,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.23,0.12,-0.38,-1.05,-2.24,-3.75,-5.17,-6,-9,-10,-12,-12,-10,-9,-7,-5.75,-4.13,-2.17,-2.18,-2.88,-2.75,-1.75,-1,-0.38,0,0.07,0,-0.05,-0.13,0,0.11,0.12,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.21,0.37,0.37,0,-1.05,-2.03,-3.75,-5.24,-6,-7,-9,-10,-12,-13,-15,-16,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,-0.13,-1.18,-3.03,-4.90,-6,-8,-9,-11,-11,-11,-11,-11,-10,-10,-8,-6,-4.62,-2.25,-0.63,0.12,0.12,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.21,0.25,-0.13,-0.75,-1.64,-3.03,-4.75,-6,-8,-10,-12,-13,-12,-11,-9,-7,-6,-4.25,-3.03,-3,-2.88,-1.63,-0.40,-0.13,0.32,0.22,0.08,-0.13,-0.25,-0.17,-0.01,0.10,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.32,-0.13,-0.89,-1.88,-3.29,-4.74,-5.76,-7,-8,-9,-11,-12,-14,-16,-17,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,-0.13,-1,-2.88,-4.88,-6,-8,-10,-11,-11,-12,-12,-11,-10,-10,-8,-6,-4.02,-2,-0.66,0.07,0.12,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.25,0.12,-0.30,-1.13,-2.38,-3.76,-5.76,-7,-9,-11,-13,-13,-12,-11,-10,-8,-6,-4.61,-3.52,-3,-1.38,-0.15,0.21,0.25,0.24,0.10,-0.16,-0.65,-0.38,-0.14,0,0.09,0.12,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.23,0.25,-0.05,-0.76,-1.64,-2.86,-4.25,-5,-6,-7,-8,-10,-11,-13,-15,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,-0.13,-0.75,-2.75,-4.68,-6,-8,-10,-11,-12,-13,-13,-12,-11,-10,-8,-6,-4,-2.04,-0.76,-0.03,0.12,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.24,0.22,-0.14,-0.88,-1.55,-2.77,-4.55,-6,-8,-10,-12,-13,-13,-13,-12,-10,-8,-6,-4.26,-2.75,-1.18,0.62,0.32,0.12,0.21,0.11,-0.16,-0.39,-0.50,-0.30,-0.13,0.08,0.12,0.12,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.25,0.07,-0.50,-1.38,-2.40,-3.75,-4.66,-5.38,-6,-7,-9,-11,-13,-15,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,-0.13,-0.67,-2.54,-4.54,-6,-8,-10,-11,-12,-13,-12,-12,-11,-9,-7,-6,-4.13,-2.16,-0.88,-0.13,0.12,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,0.12,-0.02,-0.50,-1.18,-1.88,-2.78,-4.50,-6,-8,-11,-13,-13,-14,-13,-12,-10,-7,-5.63,-3.38,-1.03,1,0,0.09,0.12,0.21,-0.03,-0.39,-0.64,-0.50,-0.25,0,0.20,0.21,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.24,0.25,-0.15,-1,-2.13,-3.29,-4.15,-4.75,-5.75,-6,-8,-10,-12,-14,-16,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.10,-0.13,-0.75,-2.50,-4.38,-6,-8,-10,-11,-13,-13,-13,-12,-11,-9,-8,-6,-4.25,-2.25,-0.63,-0.01,0.12,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.10,-0.01,-0.29,-0.88,-1.63,-2.29,-2.78,-4.86,-7,-10,-12,-14,-15,-14,-13,-11,-9,-6,-4.13,-1.51,1,0,0,0.12,0.12,0,-0.26,-0.75,-0.75,-0.30,-0.04,0.12,0.23,0.25,0.22,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0,-0.63,-1.76,-2.93,-3.88,-4.25,-4.80,-6,-8,-10,-12,-14,-16,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,-0.01,-0.75,-2.42,-4.38,-6,-8,-10,-11,-13,-14,-13,-13,-11,-10,-8,-6,-4.30,-2.03,-0.29,0.11,0.12,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0,-0.13,-0.25,-0.65,-1.30,-2,-2.51,-3.64,-6,-9,-12,-14,-15,-15,-14,-12,-10,-7,-4.75,-1.99,0.86,0,0,0,0.22,0.20,-0.05,-0.38,-0.40,-0.29,-0.18,-0.13,0.07,0.12,0.34,0.34,0.12,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.25,0,-0.51,-1.30,-2.41,-3.63,-4.01,-4.50,-5.77,-7,-9,-11,-14,-16,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,-0.05,-0.75,-2.50,-4.38,-6,-8,-10,-11,-12,-13,-13,-13,-12,-10,-8,-6,-4.63,-2.03,0,0.12,0.22,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,-0.03,-0.18,-0.50,-0.93,-1.63,-2.16,-3.25,-5.25,-8,-12,-14,-15,-14,-14,-12,-10,-7,-5.13,-2.26,0.75,0,0,0,0.22,0.25,0.12,0,-0.16,-0.27,-0.30,-0.38,-0.38,-0.17,0.21,0.34,0.75,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.33,0.10,-0.38,-1.13,-2,-3.25,-3.74,-4.40,-5.75,-7,-9,-11,-13,-15,-17,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.21,0.23,-0.75,-2.50,-4.40,-6,-8,-10,-11,-12,-13,-14,-13,-13,-11,-9,-7,-5.13,-1.89,-0.50,0.25,0.24,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.13,-0.53,-1.25,-2.03,-2.74,-4.54,-6,-10,-14,-14,-14,-14,-12,-10,-8,-5.41,-2.51,0.50,-0.13,0,0,0.23,0.25,0.12,-0.01,-0.13,-0.29,-0.42,-0.63,-0.90,-0.67,-0.53,-0.25,0.38,0.83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.24,0.12,-0.26,-1,-1.91,-2.88,-3.27,-4.26,-5.63,-7,-9,-11,-13,-15,-17,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.12,-0.75,-2.54,-4.50,-6,-8,-10,-11,-12,-13,-14,-14,-13,-12,-11,-9,-5.92,-2.40,-0.75,0.20,0.23,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.12,-0.17,-1,-1.99,-2.75,-3.26,-5.75,-9,-13,-13,-13,-13,-12,-10,-8,-5.63,-2.87,0.25,0.08,0,0.12,0.50,0.12,0,-0.13,-0.25,-0.29,-0.50,-0.75,-0.93,-1.14,-1.26,-0.66,-0.25,0.62,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.25,-0.13,-0.88,-1.88,-2.65,-3.01,-4,-5.26,-6,-9,-11,-13,-15,-17,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.20,-0.04,-0.88,-2.63,-4.51,-6,-8,-10,-11,-12,-13,-14,-14,-13,-13,-12,-9,-6,-3.29,-0.90,0.24,0.23,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.12,-0.67,-1.50,-2.24,-2.86,-4.38,-7,-10,-11,-12,-12,-11,-9,-7,-5.63,-3.15,-0.63,-0.05,0.12,0.20,0.36,0,-0.18,-0.26,-0.26,-0.29,-0.42,-0.64,-0.91,-1.25,-1.38,-1.15,-0.68,-0.15,0.25,0.24,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.12,-0.03,-0.80,-1.65,-2.52,-2.91,-4.03,-5.15,-6,-8,-11,-13,-15,-17,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,-0.17,-1.18,-2.63,-4.50,-6,-8,-10,-10,-12,-13,-13,-13,-13,-12,-11,-9,-6,-3.25,-1,0.22,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.71,-0.16,-1,-1.80,-2.39,-3.63,-6,-8,-9,-10,-10,-10,-9,-7,-5.42,-3.43,-1.63,-0.55,-0.02,0.20,0.22,-0.25,-0.50,-0.50,-0.38,-0.25,-0.28,-0.50,-0.76,-1.13,-1.63,-1.63,-1.38,-0.64,0,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.32,0.12,-0.15,-0.67,-1.30,-2.14,-2.87,-3.88,-5.13,-6,-8,-11,-13,-15,-17,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,-0.17,-1.25,-2.67,-4.37,-6,-7,-9,-10,-11,-12,-12,-12,-12,-11,-9,-8,-5.80,-3.04,-0.87,0.25,0.32,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.36,-0.38,-1.14,-2.04,-3.12,-4.63,-6,-8,-8,-9,-8,-7,-6,-5.03,-3.63,-2.05,-1.25,0,0.87,0.11,-0.75,-1,-0.75,-0.38,-0.38,-0.38,-0.50,-0.63,-1,-1.63,-2.02,-1.88,-1,-0.15,0.20,0.22,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.12,-0.13,-0.63,-1.13,-1.89,-2.66,-3.65,-5,-6,-8,-10,-13,-15,-16,-18,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.12,-0.25,-1.25,-2.50,-4.04,-5.76,-7,-9,-9,-10,-11,-11,-11,-11,-10,-9,-7,-5.13,-2.37,-0.51,0.25,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.62,0.45,-0.75,-1.65,-2.40,-4,-5.16,-6,-7,-7,-7,-6,-5.50,-4.50,-3.62,-3.13,-1.75,-1.27,-1.13,-1,-1.29,-1.43,-1.25,-0.88,-0.63,-0.42,-0.38,-0.42,-0.75,-1.50,-1.90,-2,-1.25,-0.41,0.12,0.24,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.24,0.25,0.12,-0.38,-1.13,-1.88,-2.63,-3.63,-4.75,-6,-8,-10,-12,-14,-16,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.21,-0.13,-1.01,-2.18,-3.65,-5.29,-6,-8,-8,-9,-10,-10,-10,-9,-9,-8,-6,-4.55,-1.77,0.25,0.37,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.32,0.45,-0.38,-1.38,-1.92,-3,-4.37,-5.13,-5.74,-5.92,-5.75,-5.14,-4.42,-3.76,-3.30,-3.30,-3.27,-2.16,-2,-2,-2,-2,-1.79,-1.38,-0.89,-0.50,-0.25,-0.13,-0.38,-0.93,-1.50,-1.75,-1.38,-0.76,-0.14,0.23,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.22,0.21,-0.02,-0.50,-1.17,-1.88,-2.75,-3.54,-4.50,-5.88,-8,-10,-12,-13,-15,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-20,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.22,0.11,-0.75,-1.79,-3.16,-4.75,-6,-7,-7,-8,-9,-9,-9,-9,-9,-7,-6,-4,-1.37,0.37,0.46,0.25,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.75,-0.16,-1.13,-1.76,-2.37,-3.25,-4,-4.50,-4.64,-4.40,-3.86,-3.24,-3,-3.13,-3.13,-3.13,-3,-3,-2.63,-2.63,-2.51,-2.29,-1.88,-1.18,-0.40,0.23,0.37,0.12,-0.41,-1,-1.38,-1.41,-1.13,-0.63,0,0.24,0.25,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.21,0.20,-0.04,-0.53,-1.25,-1.92,-2.75,-3.52,-4.38,-5.50,-7,-9,-11,-12,-14,-15,-16,-17,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.37,-0.38,-1.38,-2.64,-4.13,-5.50,-6,-7,-7,-8,-8,-8,-8,-8,-6,-5.25,-3.54,-1.25,0.45,0.50,0.23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.75,0.21,-1.13,-1.76,-2.25,-2.63,-3.01,-3.38,-3.54,-3.41,-3.13,-3,-3,-3,-3,-3,-3,-3,-3,-2.91,-2.88,-2.65,-2.25,-1.63,-0.76,0,0.48,0.50,-0.04,-0.38,-1.15,-1.53,-1.50,-1.13,-0.53,0,0.25,0.21,0.09,0,0,0,0,0,0,0,0,0,0,0,0.10,0.12,0.21,0,-0.42,-1.15,-1.91,-2.74,-3.50,-4.25,-5.24,-6,-8,-10,-11,-13,-14,-15,-16,-17,-18,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.25,-0.14,-0.88,-2,-3.25,-4.50,-5.63,-6,-6,-7,-7,-7,-6,-6,-5.38,-4.25,-3.12,-1.50,-0.55,0.58,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.83,-0.53,-1.18,-1.88,-2.14,-2.38,-2.54,-2.75,-2.87,-2.92,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.63,-2.03,-1.26,-0.30,0.57,0.82,0.32,-0.38,-1.13,-1.75,-2,-1.75,-1.05,-0.29,0.12,0.34,0,0,0,0,0,0,0,0,0,0,0,0,0,0.21,0.25,0.22,-0.13,-0.88,-1.88,-2.63,-3.49,-3.92,-4.75,-6,-7,-8,-10,-11,-13,-14,-15,-16,-17,-17,-17,-18,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-18,-18,-18,-18,-18,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.23,0.25,-0.25,-1,-1.68,-2.39,-3.16,-4.38,-5.50,-6,-6,-6,-5.76,-4.90,-4.13,-3.38,-2.80,-1.65,-0.75,0.72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.88,-0.78,-1.50,-1.13,-1.88,-1.75,-1.75,-1.88,-2.15,-2.63,-2.92,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.89,-2.88,-1.88,-0.88,0.85,0.87,0.75,-0.38,-1,-0.91,-1.63,-1.63,-0.67,-0.16,-0.25,0.72,0,0,0,0,0,0,0,0,0,0,0,0,0,0.37,0.47,0.47,0.22,-0.30,-0.89,-1.41,-2.13,-2.79,-3.88,-4.51,-5.52,-7,-8,-9,-10,-11,-13,-15,-15,-16,-16,-17,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-17,-17,-17,-17,-17,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-18,];
}

function getTileMap()
{
	return [0,1,2,3,2,3,3,2,1,2,2,2,2,1,1,1,1,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,2,3,5,5,5,5,5,5,2,2,1,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,2,6,6,6,6,6,6,6,6,6,6,4,4,6,4,4,4,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,2,0,3,2,3,3,3,3,4,4,4,4,1,1,1,1,1,1,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,2,2,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,4,6,4,6,4,6,4,6,4,4,4,6,4,4,4,4,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,6,4,4,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,4,4,2,2,2,3,4,3,3,3,4,6,6,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,1,2,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,0,6,0,6,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,2,2,4,4,4,4,3,3,6,6,6,6,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,6,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,4,6,6,6,6,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,4,4,4,4,6,6,6,2,4,3,3,4,3,3,3,3,6,6,6,6,1,1,1,1,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,0,0,0,0,0,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,0,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,6,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,0,0,0,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,4,6,4,4,4,4,4,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,6,6,4,4,4,7,7,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,3,3,3,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,7,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,4,4,4,4,6,6,6,6,6,6,6,4,6,3,3,0,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,3,3,4,3,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,4,4,4,4,6,6,6,6,6,6,4,6,3,0,0,0,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,3,3,4,4,4,3,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,3,3,6,6,6,6,6,6,1,1,1,1,1,6,6,6,6,1,1,1,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,4,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,4,4,4,4,6,4,6,4,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,4,4,4,4,4,4,6,6,6,6,4,6,6,3,0,6,6,4,4,4,6,6,6,6,6,6,4,4,6,6,6,6,4,6,3,3,3,4,3,3,3,6,6,6,6,6,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,1,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,6,6,6,6,1,1,1,6,6,3,3,3,6,6,6,6,6,6,6,6,6,4,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,6,0,0,0,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,4,4,4,4,4,6,6,6,6,4,6,6,6,6,6,6,4,4,4,4,6,6,6,6,4,4,4,4,6,4,6,6,3,3,3,3,6,6,3,3,3,3,6,6,6,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,1,1,1,3,3,3,3,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,6,6,0,0,0,6,6,6,6,4,4,4,4,4,4,4,4,4,6,4,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,4,4,4,4,4,4,6,6,6,4,6,6,6,6,6,4,6,4,4,4,6,6,6,6,6,4,4,4,6,6,6,3,3,3,3,6,6,6,3,1,1,1,3,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,1,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,1,1,1,3,3,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,6,0,0,0,0,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,4,4,4,4,4,4,4,6,6,6,4,4,6,6,6,4,4,4,3,4,6,6,6,6,6,6,4,4,4,6,6,6,3,3,3,6,6,6,6,1,1,1,1,1,6,6,6,6,6,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,4,4,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,4,4,4,6,6,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,0,0,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,6,6,4,4,4,3,6,6,6,4,6,6,6,4,4,4,6,6,6,6,3,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,1,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,4,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,4,4,4,6,4,6,6,6,6,6,0,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,4,4,4,3,3,3,6,4,4,3,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,1,1,1,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,4,6,6,6,6,6,3,3,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,6,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,4,4,4,4,4,4,4,4,4,6,6,6,4,6,3,3,3,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,1,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,3,3,3,6,6,4,4,4,6,6,3,3,3,3,6,6,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,3,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,3,3,3,6,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,3,3,3,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,4,4,4,4,4,4,4,4,4,6,6,4,6,4,6,6,6,6,6,6,6,6,6,6,4,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,6,6,6,4,6,6,6,6,6,3,3,3,3,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,4,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,3,6,6,6,6,6,6,4,4,4,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,3,3,3,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,3,3,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,3,3,3,6,6,6,6,6,6,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,3,6,6,6,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6,3,6,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,3,3,6,6,3,3,3,3,6,6,6,6,6,6,4,6,6,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,4,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,6,3,6,3,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,1,1,1,1,3,0,3,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,0,0,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6,3,3,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,0,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,1,1,1,1,1,0,0,0,6,6,6,6,4,4,6,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,6,6,6,6,6,6,6,6,6,6,6,3,6,3,6,3,3,3,3,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,1,1,1,0,0,0,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,3,3,3,3,3,3,3,1,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,0,0,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,3,3,6,0,0,3,3,3,3,3,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,0,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,1,3,3,3,3,3,1,1,1,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,1,1,1,6,6,3,3,3,1,3,3,6,6,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,0,0,6,6,6,6,6,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,6,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,7,7,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,1,6,6,1,6,3,3,4,3,3,3,3,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,4,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,0,0,0,0,6,6,6,6,6,3,3,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,0,3,3,3,3,3,3,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,1,1,1,6,4,4,4,3,3,3,3,6,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,6,6,6,6,6,6,6,4,6,6,4,4,4,4,4,4,6,3,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,3,3,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,6,6,0,0,0,3,3,3,3,6,6,6,0,0,0,1,6,6,6,6,6,6,6,1,6,1,1,6,6,6,6,6,6,6,3,3,3,6,6,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,1,6,6,6,4,3,3,3,3,3,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,3,3,3,6,6,6,6,6,4,4,4,6,6,4,4,4,4,6,3,3,3,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,6,6,0,0,0,0,6,6,3,6,6,6,0,0,0,0,0,6,6,6,6,6,1,1,1,1,1,1,1,1,6,6,6,6,6,3,3,3,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,7,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,3,3,3,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,3,3,3,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,4,4,4,4,4,4,4,6,6,6,6,6,0,0,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,1,1,1,1,6,1,1,1,1,1,6,6,6,6,3,3,3,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,3,3,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,7,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,3,3,3,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,3,3,3,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,4,4,4,4,6,6,6,4,4,4,4,4,4,4,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,1,1,1,1,6,6,6,1,1,1,6,6,6,6,6,3,3,3,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,1,1,3,3,3,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,3,3,3,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,3,3,3,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,4,6,4,4,6,4,4,4,4,4,4,4,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,1,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,1,1,1,1,1,3,3,3,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,1,3,3,3,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,3,3,3,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,0,0,6,6,6,3,6,6,1,1,1,1,1,1,1,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,6,6,6,6,6,6,6,6,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,1,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,1,1,1,1,1,3,3,3,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,1,3,1,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,3,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,3,3,3,1,1,1,6,1,0,1,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,6,1,6,1,6,6,6,6,6,6,6,6,6,6,3,3,3,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,1,1,3,3,3,3,6,4,6,6,4,4,4,4,4,4,4,4,4,4,7,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,3,3,1,1,1,6,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,4,4,4,4,4,1,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,6,6,3,6,4,4,4,6,6,4,4,4,4,4,4,4,4,7,7,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,3,1,1,1,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,1,1,1,6,6,0,0,0,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,1,1,1,1,1,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6,6,1,6,6,6,6,0,0,0,3,3,3,3,3,4,4,4,6,6,6,6,6,6,6,6,6,6,6,0,0,6,6,6,6,6,6,6,6,6,3,3,6,0,0,0,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,1,1,1,1,1,6,3,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,3,3,3,4,4,4,4,4,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,1,6,6,6,6,6,0,0,0,0,0,6,6,0,0,0,0,0,0,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,7,4,7,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,1,1,1,1,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,3,4,4,4,4,6,4,6,6,6,6,4,6,6,0,0,0,0,0,0,0,6,6,1,1,1,6,6,0,0,0,0,0,0,0,0,0,6,0,6,0,0,0,6,6,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,7,7,4,7,7,7,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,3,6,6,6,6,6,6,6,0,0,0,0,6,4,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,6,1,1,1,6,6,0,0,0,0,6,6,6,0,0,0,0,6,6,6,0,6,6,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,7,4,4,7,7,7,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,6,6,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,3,3,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,4,6,6,0,0,6,6,0,0,0,6,6,1,6,6,6,6,0,0,6,6,0,0,0,6,0,6,6,6,6,6,6,6,6,0,0,6,0,0,0,0,0,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,0,6,6,1,1,1,6,6,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,1,1,1,1,1,6,6,6,6,6,3,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,4,4,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,1,1,1,0,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,1,1,1,1,1,1,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,4,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,4,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,1,1,1,0,0,6,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,6,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,4,6,6,6,6,4,4,6,4,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,0,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,4,6,6,6,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,0,1,1,1,1,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,0,0,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,3,3,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,1,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,0,0,0,1,1,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,3,3,3,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,4,4,4,1,1,1,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,0,0,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,3,3,3,3,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,1,1,1,1,1,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,3,3,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,3,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,1,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,4,4,4,4,6,6,6,6,6,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,6,3,3,3,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,4,4,4,4,4,4,6,6,6,6,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,6,6,6,6,3,3,3,3,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,4,4,6,6,6,6,6,6,6,6,0,0,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6,6,6,4,4,4,4,4,4,4,6,6,6,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,3,3,3,3,3,6,6,6,1,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,6,3,3,3,3,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,0,0,0,0,6,0,0,0,0,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,0,0,0,0,0,6,4,6,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,4,4,4,4,4,6,6,6,6,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,6,3,3,6,6,6,1,1,1,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,3,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,6,6,6,0,0,0,6,6,6,0,0,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,0,0,0,0,0,0,0,4,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,4,6,6,6,6,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,6,6,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,6,6,6,6,6,6,6,6,6,1,1,1,1,6,1,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,4,4,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,0,0,0,0,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,4,6,6,6,6,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,1,6,3,3,3,6,6,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,0,0,6,0,6,6,6,6,6,0,0,0,0,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,4,6,6,4,6,6,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,1,1,1,3,3,3,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,0,0,0,0,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,4,4,4,6,4,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,1,3,3,3,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,6,0,0,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,0,0,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,6,6,0,0,0,0,1,1,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,0,0,6,6,6,6,6,6,0,0,6,6,6,6,6,6,6,6,6,4,4,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,3,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,6,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,6,0,0,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,0,0,0,0,0,0,1,1,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,0,0,0,0,0,0,6,6,4,6,0,0,0,0,0,6,6,6,6,6,6,6,4,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,4,4,6,6,6,3,3,3,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,6,6,6,6,6,6,6,0,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,0,0,0,0,0,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,6,6,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,4,4,6,4,6,4,4,6,6,6,3,3,3,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,4,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,0,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,6,6,0,0,0,0,0,0,0,0,6,6,6,6,6,6,4,6,6,4,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,3,6,6,6,6,6,6,6,6,6,6,6,6,0,6,4,4,6,6,6,6,6,6,6,4,4,6,6,6,6,3,3,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,3,3,3,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,6,6,6,3,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,0,0,6,6,6,0,0,0,6,6,6,6,6,6,6,0,0,6,6,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,0,0,0,0,6,6,6,6,0,6,6,6,6,6,6,6,4,4,4,4,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,4,4,6,6,6,6,6,6,6,4,4,6,6,6,6,3,3,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,4,4,4,3,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,3,3,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,0,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,3,6,6,6,6,6,6,6,6,6,6,6,6,6,0,4,4,4,6,6,6,6,6,4,6,4,4,6,6,6,6,3,1,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,3,3,3,4,3,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,0,4,4,4,6,6,6,6,4,6,6,4,4,4,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,3,3,3,3,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,0,0,6,0,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,4,6,6,6,4,4,4,6,6,6,1,1,1,1,3,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,1,1,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,4,0,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,3,3,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,6,6,3,1,1,3,3,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,3,3,3,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,0,0,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,4,4,4,4,4,6,6,6,6,3,3,6,6,6,6,6,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,3,3,3,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,1,1,0,0,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,3,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,6,6,6,6,6,6,4,4,6,6,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,3,3,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,0,6,6,6,6,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,6,6,6,6,6,3,6,6,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,0,0,6,6,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,3,3,3,4,4,4,4,3,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,6,6,6,6,6,6,3,3,3,3,3,3,3,3,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,4,4,4,4,0,4,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,3,3,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,1,1,1,1,1,1,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,3,3,3,3,3,3,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,3,3,6,6,4,4,4,4,4,3,6,6,6,6,6,6,6,1,1,1,1,1,1,1,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,0,6,0,0,0,0,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,4,4,4,4,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,3,3,3,6,6,6,6,4,6,6,4,4,4,4,4,3,3,6,6,6,1,1,1,4,1,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,6,6,6,6,3,3,3,3,6,6,6,6,6,1,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,6,3,6,6,6,6,6,6,6,6,6,4,4,4,4,4,3,3,6,6,6,6,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,3,3,6,3,3,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,1,1,1,1,6,1,6,6,6,6,6,6,6,6,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,3,3,3,1,1,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,3,6,6,6,6,6,6,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,6,6,6,6,6,6,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,6,0,6,0,6,6,6,6,6,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,3,3,3,3,3,3,3,1,1,1,1,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,4,4,4,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,1,1,1,1,1,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,6,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,3,3,3,3,3,3,3,3,1,1,1,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,3,3,3,3,3,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,4,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,4,4,4,6,3,3,1,1,1,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,3,3,3,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6,6,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,0,0,0,0,0,0,6,6,6,6,6,6,1,1,6,6,4,4,4,6,6,6,6,6,6,6,4,4,6,3,3,3,1,3,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,3,3,3,3,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,7,7,7,4,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,4,4,4,6,6,6,6,6,6,6,4,4,6,3,3,3,3,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,3,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,4,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,4,4,4,6,6,6,6,6,6,6,4,4,4,6,3,3,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,3,3,3,3,6,3,3,3,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,6,6,6,4,4,4,4,6,6,6,6,4,4,4,4,4,6,3,3,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,3,0,3,3,3,3,3,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,4,4,4,4,4,6,3,3,6,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,0,0,0,6,3,3,1,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,6,6,4,4,6,6,6,6,6,6,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,0,0,0,6,3,1,1,1,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,3,3,6,4,4,6,6,6,6,6,6,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,3,3,3,1,1,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,6,6,6,6,6,6,6,6,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,3,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,3,3,6,6,3,3,3,3,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,4,3,3,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,6,6,6,1,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,0,0,0,0,3,3,1,1,1,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,3,3,3,6,6,6,6,6,4,4,4,4,6,4,6,6,6,6,4,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,3,3,3,6,3,3,3,3,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,3,4,4,4,3,3,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,0,0,0,0,3,3,1,1,1,1,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,6,6,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,3,1,1,1,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,3,4,3,3,3,3,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,1,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,0,0,6,1,1,1,1,1,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,3,3,6,6,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,4,6,4,6,6,6,6,4,6,6,6,6,4,6,4,4,4,4,4,4,4,6,6,6,6,6,6,6,1,6,1,1,1,1,1,1,3,3,3,1,1,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,3,6,6,6,3,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,3,3,3,6,1,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,1,1,4,1,1,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,3,1,1,1,1,1,3,3,3,3,3,1,1,1,6,6,1,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,3,4,4,4,6,6,6,6,6,6,6,6,6,4,4,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,6,0,6,0,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,3,3,3,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,3,4,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,3,3,3,3,0,6,3,3,0,0,0,1,6,1,1,1,1,1,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,1,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,0,0,6,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,3,3,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,3,3,3,0,0,0,3,3,3,0,0,6,6,6,6,6,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,1,1,1,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,0,0,0,0,0,6,6,6,6,6,6,6,0,0,0,6,0,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,3,3,3,0,0,3,0,0,3,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,1,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,0,0,0,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,0,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,0,0,3,3,3,0,3,3,3,3,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,4,4,4,4,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,0,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,0,3,3,3,3,3,3,3,0,0,0,6,6,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,3,0,3,3,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,1,1,6,6,6,0,0,0,0,0,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,3,3,3,3,3,3,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,1,1,1,1,1,0,0,0,6,0,6,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,3,3,3,6,3,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,0,0,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,1,1,3,1,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,0,0,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,3,6,6,6,6,6,6,6,6,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,4,4,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,0,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,4,4,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,6,0,3,3,0,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6,6,6,6,6,6,3,3,3,3,3,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,6,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,0,0,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,4,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,3,3,3,3,3,3,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,4,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,3,3,3,6,3,3,3,3,6,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,3,3,6,6,0,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,3,6,3,3,3,3,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,3,3,3,3,3,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,3,3,3,3,3,0,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,6,4,6,6,6,6,6,6,6,6,0,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,4,3,3,3,3,6,0,0,0,6,6,6,6,6,6,4,4,4,6,4,4,4,4,4,4,4,4,4,4,6,6,6,0,0,0,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,3,3,3,6,0,0,0,0,6,6,6,6,6,6,4,4,4,3,6,3,4,4,4,4,4,4,4,4,6,6,6,0,0,0,6,6,6,1,1,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,0,0,0,6,6,6,6,6,6,6,4,4,4,3,3,3,3,3,4,4,4,4,4,4,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,3,0,6,6,6,6,6,6,6,6,4,4,4,3,3,3,3,3,3,3,3,3,3,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,3,3,6,6,6,6,6,6,6,6,6,3,3,3,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,0,0,0,0,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,3,3,3,3,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,3,3,6,6,6,6,6,6,6,6,6,3,3,3,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,0,0,0,3,3,3,3,3,3,3,3,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,3,3,3,3,6,6,6,6,6,0,0,0,6,6,6,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,0,6,6,6,6,6,6,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,3,6,3,6,3,3,3,6,6,6,6,0,0,0,0,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,3,6,6,3,6,0,0,0,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,3,3,3,3,3,3,3,3,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,3,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,3,6,6,3,3,3,6,0,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,3,3,3,6,3,6,6,6,6,3,6,6,6,6,6,6,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,4,4,6,3,3,3,3,3,6,6,6,6,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,3,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,0,0,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,3,3,3,3,3,6,6,6,6,4,6,6,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,0,0,0,0,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,3,3,3,6,6,6,6,6,4,4,6,6,4,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,3,1,1,1,1,6,6,0,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,3,1,1,0,0,0,0,0,6,6,6,6,6,6,3,3,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,6,6,6,6,3,6,6,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,0,0,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,2,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,6,6,6,6,6,3,3,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,4,4,4,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,2,2,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,3,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,4,4,4,6,6,6,6,6,3,3,3,3,6,3,0,0,0,6,3,6,6,6,4,4,6,6,6,6,3,3,3,6,6,6,6,0,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,4,4,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,0,0,4,4,4,6,6,6,6,6,6,6,6,6,6,6,0,0,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,4,4,4,4,4,6,6,6,6,3,3,3,3,3,0,0,6,3,3,3,6,4,4,4,4,6,3,3,3,3,3,6,0,0,0,0,0,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,0,0,6,6,6,6,6,6,4,4,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,0,0,4,4,4,4,4,6,6,6,6,6,6,6,6,6,0,0,4,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,1,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,6,0,0,0,3,3,3,3,6,6,4,4,6,3,3,3,3,3,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,6,6,6,0,0,3,3,3,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,0,0,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,6,6,6,6,6,6,6,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,0,0,0,3,6,3,3,6,6,6,6,6,6,3,3,3,3,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,3,3,3,3,3,6,6,6,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,0,0,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,0,0,6,4,4,4,4,4,4,4,4,6,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,3,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,4,4,4,4,4,6,6,6,6,6,6,6,3,3,3,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,6,6,6,6,3,3,3,3,3,3,3,3,3,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,6,6,6,4,4,4,4,6,6,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,6,6,6,3,3,3,3,3,6,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,6,6,6,6,3,3,3,3,3,3,3,3,6,6,6,6,6,6,4,4,0,0,4,4,4,4,4,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,6,6,6,6,6,4,4,4,6,6,6,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,6,6,6,6,6,6,6,6,3,3,3,6,3,4,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,6,3,3,3,3,3,3,6,6,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,0,3,3,3,3,6,6,6,6,6,6,6,6,6,6,1,1,6,6,6,6,6,6,6,0,0,0,0,0,0,0,6,6,6,3,3,6,3,3,3,3,6,6,6,6,6,6,6,4,0,0,0,4,4,4,4,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,4,4,4,4,4,6,6,6,6,6,4,4,4,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,6,4,6,6,6,6,3,3,3,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,6,6,3,3,3,3,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,0,0,0,0,3,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,3,3,6,3,3,3,6,6,6,6,6,6,6,6,0,0,0,4,6,6,6,4,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,4,4,4,4,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,3,3,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,0,0,0,0,6,0,0,6,0,0,6,6,6,6,6,1,1,1,1,1,6,6,6,6,6,0,0,0,0,0,0,6,6,6,3,3,6,3,3,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,4,0,0,4,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,6,6,6,6,6,4,6,6,4,6,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,0,0,0,0,0,0,0,0,0,6,6,6,6,6,1,1,1,1,1,1,6,6,6,0,0,0,0,0,0,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,0,0,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,6,6,6,6,4,6,4,6,6,6,6,6,6,6,6,0,0,6,0,0,0,6,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,3,3,3,3,3,3,3,3,3,3,0,6,0,0,6,0,0,0,0,6,6,6,6,6,6,1,1,1,1,1,6,6,0,0,0,0,0,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,4,4,6,6,6,6,0,0,0,0,1,1,1,1,6,6,0,0,0,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,6,1,6,6,6,6,4,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,6,6,6,6,6,4,4,4,4,6,4,6,6,6,0,0,0,0,0,0,0,6,6,6,6,1,1,1,6,6,1,3,6,6,6,6,6,6,6,3,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,3,3,3,3,3,3,3,3,3,3,3,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,1,1,1,6,6,0,0,0,0,6,6,6,6,3,3,3,3,6,6,6,6,6,1,1,1,1,1,1,1,6,6,3,3,3,6,6,6,6,3,3,6,6,6,6,3,3,6,4,4,6,6,6,0,0,0,0,0,1,1,1,1,6,6,0,0,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,4,0,0,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,6,6,6,4,4,6,6,0,0,0,0,0,0,6,6,6,6,1,1,1,1,1,3,3,3,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,3,6,6,6,6,6,3,3,3,3,3,3,3,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,1,1,1,6,6,0,0,0,6,6,6,6,6,3,3,3,3,6,6,6,6,1,1,1,1,3,3,3,1,1,1,3,3,3,6,6,6,6,6,6,6,6,3,3,3,3,6,4,4,6,6,6,6,0,0,0,6,6,6,1,1,6,0,0,0,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,4,0,0,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,4,4,4,4,4,6,6,6,6,4,4,4,4,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,4,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,0,0,0,6,6,6,6,6,6,1,1,6,3,3,3,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,3,3,3,1,1,1,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,4,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,4,4,4,4,4,6,6,6,4,4,4,4,6,6,6,1,1,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,4,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,3,3,3,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,3,3,3,1,1,1,1,6,6,4,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,0,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,4,4,4,4,4,4,6,6,6,4,4,4,4,6,6,6,1,1,1,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,4,4,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,3,3,3,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,4,4,4,6,6,6,6,3,3,3,6,6,6,6,6,4,4,6,6,6,6,6,6,6,4,4,6,6,0,0,6,6,6,0,0,0,6,6,6,4,4,4,4,4,6,6,1,1,1,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,4,4,4,4,4,6,6,6,4,4,4,6,6,6,6,4,6,1,4,6,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,3,3,3,6,6,6,6,1,1,1,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,4,6,6,6,6,6,3,3,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,0,0,0,6,6,6,6,4,4,4,6,1,1,1,1,1,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,4,4,4,4,4,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,3,3,3,6,6,6,6,6,6,1,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,3,3,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,0,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,6,6,6,6,6,4,4,6,4,6,6,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,4,4,4,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,6,6,6,0,0,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,4,4,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,4,4,4,4,4,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,6,6,6,4,4,4,4,4,6,6,6,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,6,6,0,0,3,3,3,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,4,4,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,3,3,3,6,6,6,6,6,0,6,6,6,6,6,6,6,4,4,4,4,4,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,0,0,0,0,6,0,0,0,0,0,3,3,3,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,0,6,6,6,6,3,3,3,3,3,3,0,0,0,0,6,6,6,6,6,6,6,4,4,4,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,1,1,1,1,1,6,6,6,6,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,3,3,3,3,3,3,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,4,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,3,1,6,0,0,0,6,6,6,6,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,6,6,6,6,6,6,6,6,4,0,0,0,0,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,0,0,3,3,0,0,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,3,3,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,4,4,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,3,3,3,3,3,3,3,3,3,6,0,0,0,6,6,6,6,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,6,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,0,0,0,0,0,6,3,3,6,6,0,0,0,0,6,0,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,3,3,3,3,3,6,6,6,6,6,6,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,4,6,6,6,4,4,6,6,6,6,6,6,3,3,3,3,3,3,3,3,3,1,6,0,0,0,6,6,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,0,0,0,0,0,3,3,3,3,6,6,6,0,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,3,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,4,4,4,6,6,6,6,6,6,3,3,3,6,3,3,3,3,1,1,6,0,0,0,3,3,3,3,3,0,0,0,0,0,0,3,3,0,0,0,0,0,0,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,3,3,3,3,3,3,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,1,1,3,3,3,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,0,0,0,0,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,0,0,6,6,3,3,3,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,6,6,1,3,3,3,3,3,6,0,0,6,3,3,3,3,3,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,6,6,6,6,6,6,6,3,3,3,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,4,4,4,4,4,4,4,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,0,0,0,0,0,0,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,0,0,0,0,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,3,6,1,1,1,3,3,3,3,0,0,6,6,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,4,4,4,4,4,4,6,6,1,1,1,1,6,6,4,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,0,0,0,0,0,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,0,0,0,0,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,3,6,1,1,1,1,3,3,3,0,0,0,0,6,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,4,4,4,4,4,4,6,6,1,6,6,6,4,4,4,6,6,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,0,0,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,0,0,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,4,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,3,3,3,6,1,1,1,6,1,3,3,0,6,6,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,6,6,6,0,0,0,6,6,6,3,3,6,0,0,0,0,0,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,4,7,7,7,7,7,7,4,4,4,4,4,4,4,6,6,6,6,6,6,4,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,1,1,1,6,6,6,3,0,6,6,0,0,0,0,0,0,0,0,6,6,6,6,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,3,3,1,1,1,1,0,0,3,3,0,0,0,0,0,0,0,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,1,1,1,6,6,6,6,0,6,6,6,6,0,6,6,0,0,6,6,6,6,6,6,0,0,0,0,0,0,0,1,1,1,1,1,1,3,3,3,3,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,1,6,6,6,6,6,0,6,6,6,6,0,6,6,0,0,6,6,6,0,6,6,0,0,0,0,0,0,0,1,1,1,0,3,3,3,3,3,3,1,6,1,1,1,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,0,0,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,6,6,4,3,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,0,0,0,0,0,0,0,6,6,6,0,0,6,6,0,0,0,0,0,0,1,1,0,0,3,3,3,1,0,1,1,1,6,1,1,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,0,0,0,0,3,3,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,0,0,0,0,0,6,6,0,0,6,6,0,0,6,6,0,0,0,0,0,0,0,0,0,3,3,3,1,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,3,3,3,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,2,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,0,6,6,6,6,0,0,6,3,3,3,3,6,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,4,4,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,0,0,4,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,0,6,6,6,6,0,3,3,3,3,3,3,3,6,0,6,6,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,4,4,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,0,6,6,0,0,3,3,3,3,6,3,3,3,3,0,6,6,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,3,3,3,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,1,6,6,6,6,0,6,6,6,3,3,3,3,6,6,6,3,3,3,6,0,6,6,0,0,0,3,3,3,3,0,0,0,0,0,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,0,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,0,0,0,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,6,6,6,0,6,6,6,3,3,3,6,6,6,0,6,6,6,6,6,6,6,0,0,3,3,3,3,3,3,3,3,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,6,6,6,6,6,6,6,4,4,4,4,4,6,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,6,6,3,3,3,3,3,3,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,0,0,0,0,1,1,1,1,3,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,1,1,6,6,6,0,6,6,6,6,6,6,6,6,6,0,0,6,6,6,6,6,6,0,0,3,3,3,3,3,3,3,3,3,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,6,3,3,3,6,3,3,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,3,3,6,6,3,3,3,3,3,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,0,1,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,0,0,1,1,1,1,3,3,3,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,6,6,0,6,6,6,0,6,6,6,6,0,0,0,0,6,6,6,6,6,0,3,3,3,0,3,3,3,3,3,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,3,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,1,1,1,3,3,3,6,6,3,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,1,1,1,1,3,3,3,3,1,1,1,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,1,6,6,6,0,6,6,6,0,0,0,6,6,6,6,0,0,6,6,6,6,6,6,3,3,0,0,0,3,3,3,4,6,6,4,4,4,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,4,4,6,4,4,4,4,4,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,1,3,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,3,3,3,3,1,1,1,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,6,6,0,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,0,6,6,3,3,6,0,0,0,0,3,6,6,6,4,4,4,0,0,0,0,0,0,0,0,0,6,1,1,1,1,1,1,6,6,6,6,6,0,0,0,0,0,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,3,3,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,0,0,6,6,0,0,0,0,0,0,0,6,6,6,6,6,0,0,0,3,3,6,0,0,0,0,6,6,6,4,4,4,0,0,0,0,0,0,0,0,3,3,3,1,1,1,1,1,1,6,6,6,6,6,0,0,0,0,6,6,6,6,4,4,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,0,0,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,6,6,6,0,0,4,4,6,6,6,6,6,0,0,0,3,3,3,1,1,3,3,1,1,6,6,6,6,0,0,0,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,3,3,3,6,6,6,6,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,6,6,4,4,0,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,3,3,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,4,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,6,6,4,4,4,0,6,6,6,4,4,6,6,6,0,0,6,6,6,6,0,0,0,6,6,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,4,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,3,3,3,3,3,1,1,1,6,1,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,6,6,4,4,4,0,6,6,0,4,4,0,6,6,0,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,3,3,3,3,3,3,1,1,1,1,1,1,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,0,0,6,6,0,0,0,0,0,3,3,3,6,6,0,0,0,0,0,0,3,3,3,6,6,6,6,6,4,4,4,4,4,4,6,6,6,4,4,6,6,6,6,6,3,3,6,4,4,4,6,6,6,4,4,6,6,6,6,6,6,6,6,6,3,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,3,3,3,3,3,3,6,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,1,1,1,1,1,6,6,1,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,0,0,0,0,0,0,0,3,3,3,6,0,0,0,0,0,0,0,3,3,3,6,6,6,6,6,6,4,4,4,4,6,6,6,6,4,4,6,6,6,3,3,3,3,4,4,4,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,3,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,4,4,4,4,4,4,4,4,6,4,4,4,6,3,3,3,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,1,1,1,1,1,1,6,6,1,1,1,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,0,0,0,0,0,0,6,6,0,0,4,6,6,4,4,4,6,6,6,6,0,3,3,3,6,6,0,0,0,0,0,0,0,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,4,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,1,1,1,1,1,1,6,6,6,6,1,6,6,0,0,0,0,0,0,0,0,0,0,0,4,4,6,6,6,0,0,0,0,1,1,1,1,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,6,6,6,4,4,4,4,3,3,3,3,6,6,6,6,6,3,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,1,1,6,6,6,6,6,6,1,1,1,6,0,0,0,0,0,0,0,0,3,3,3,4,4,6,6,6,0,0,0,0,1,1,1,1,1,0,0,0,6,6,6,6,6,6,4,3,3,6,6,0,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,0,0,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,1,6,6,0,0,0,0,0,0,0,0,3,3,3,4,4,4,4,4,0,0,0,0,1,1,1,1,1,1,0,6,6,6,6,6,6,4,4,3,3,6,6,0,6,6,0,0,0,0,0,0,0,0,0,0,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,3,3,4,4,6,3,3,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,1,1,1,1,0,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,1,1,1,6,0,0,0,0,0,0,0,3,3,3,0,4,4,4,4,4,0,0,0,0,0,0,0,1,1,1,0,6,6,6,0,0,6,6,0,3,3,6,6,6,6,6,0,0,0,0,0,1,1,0,0,0,3,1,1,1,1,6,6,6,6,6,6,6,6,6,6,3,3,4,4,4,3,3,3,3,3,6,6,6,6,6,3,3,6,6,6,6,6,6,4,4,4,4,4,4,6,6,1,1,1,1,1,0,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,3,6,6,6,6,6,6,6,6,1,1,1,6,0,0,0,0,0,0,0,3,3,0,4,6,6,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,3,3,3,6,6,6,0,0,1,1,1,1,1,1,0,0,0,3,1,1,1,1,1,1,6,6,6,6,6,6,6,6,3,3,6,4,4,3,3,3,3,3,3,3,3,3,3,3,3,6,6,6,6,6,6,6,4,4,4,4,4,6,1,1,1,1,0,0,0,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,4,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,0,0,0,0,0,0,3,3,3,0,4,6,6,6,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,3,3,1,1,1,1,1,3,3,1,1,1,3,3,0,3,3,3,6,6,1,1,1,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,1,1,1,6,0,0,0,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,3,3,6,3,3,3,3,3,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,0,0,0,0,0,3,3,3,3,3,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,3,3,1,1,1,1,1,3,3,1,1,1,3,3,3,3,3,0,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,4,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,0,0,0,0,0,3,3,3,3,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,1,1,1,1,3,3,1,1,0,0,0,0,0,0,0,0,6,3,3,3,0,0,0,3,3,3,0,0,0,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,0,0,0,0,0,3,3,3,3,6,6,6,6,6,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,1,3,3,3,3,0,0,0,0,0,0,0,6,6,3,3,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,1,1,1,1,1,1,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,3,3,3,1,3,3,3,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,0,0,0,0,0,0,0,0,4,6,6,4,4,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,1,1,3,3,3,0,0,0,0,0,3,3,6,6,3,0,0,0,0,0,0,0,0,0,0,0,3,3,6,6,0,0,0,0,0,0,0,6,6,6,6,1,1,1,1,1,1,1,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,6,6,3,3,3,0,1,1,3,3,3,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,0,0,0,0,0,0,0,0,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,1,1,1,3,3,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,6,6,6,6,6,1,1,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,3,0,0,0,3,3,3,3,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,0,0,0,0,0,0,0,0,4,4,4,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,3,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,3,3,6,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,0,0,0,0,3,3,3,3,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,4,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,0,0,0,0,0,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,0,0,6,6,6,0,0,0,0,0,0,0,0,0,6,6,6,3,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,0,0,0,0,3,1,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,0,0,0,0,0,0,0,0,0,0,0,0,6,6,0,6,6,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,0,0,0,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,3,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,3,3,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,0,6,3,1,1,1,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,4,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,1,3,3,1,6,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,0,0,0,0,0,0,0,0,0,0,6,6,6,6,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,3,3,3,3,3,3,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,3,3,3,3,6,3,3,6,6,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,4,4,4,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,0,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,6,6,6,6,6,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,0,0,3,3,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,6,6,6,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,6,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,4,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,0,4,4,6,6,6,4,4,4,4,4,4,4,4,4,0,6,6,4,6,6,0,0,1,1,1,1,3,3,6,6,0,0,0,0,4,4,4,6,6,0,0,3,3,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,1,4,1,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,6,3,3,6,6,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,3,4,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,1,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,0,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,6,6,4,6,6,0,0,1,1,1,1,3,3,6,6,6,6,0,0,0,4,6,6,0,0,0,0,0,3,3,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,1,1,1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,0,6,6,0,6,6,0,6,6,6,6,6,6,0,0,0,0,0,4,4,6,6,0,6,6,0,0,1,1,6,1,3,3,3,1,6,6,6,0,0,0,6,0,0,0,0,0,0,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,4,3,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,6,6,3,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,1,1,1,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,0,6,6,6,6,6,0,0,6,6,6,6,0,0,0,0,0,6,6,0,6,6,4,4,1,1,6,3,3,3,3,3,0,6,6,6,6,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,3,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,4,4,4,4,4,4,7,7,4,4,4,4,4,4,4,4,4,4,4,6,6,3,6,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,1,1,1,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,0,6,6,0,6,6,0,0,0,0,0,0,0,6,6,6,4,4,1,1,0,3,3,3,3,3,3,1,6,6,6,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,6,6,3,3,3,6,4,6,6,4,4,4,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,1,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,0,0,6,6,0,0,0,0,0,0,6,6,0,0,0,0,0,0,3,3,6,0,3,3,3,1,6,6,0,0,0,0,0,0,0,0,1,1,1,6,3,3,3,3,3,3,3,3,3,6,4,4,4,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,6,6,6,6,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,0,0,0,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,3,3,3,1,6,0,0,0,0,0,0,0,6,6,6,6,6,3,3,3,3,3,3,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,4,6,6,6,6,6,6,6,6,6,4,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,6,6,4,4,6,6,6,0,0,0,6,6,6,3,3,1,6,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,4,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,4,6,3,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,6,6,6,0,6,6,6,6,6,6,6,3,3,3,0,0,0,0,0,0,6,6,4,4,6,6,6,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,3,3,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,6,6,6,0,0,6,6,6,6,6,6,3,3,3,3,0,0,0,0,0,6,6,6,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,4,1,1,1,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,4,4,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,3,3,3,0,3,3,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,3,3,3,3,3,0,0,0,0,0,6,6,4,4,0,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,4,1,1,1,1,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,3,3,3,3,3,0,0,0,0,6,6,4,4,4,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,6,4,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,3,3,3,3,3,0,6,6,0,6,6,0,4,4,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,4,4,4,4,4,6,6,4,4,4,6,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,3,6,3,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,6,6,6,6,6,0,6,6,6,6,6,4,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,0,3,3,3,3,3,3,6,0,6,6,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,6,6,4,4,4,4,4,4,4,4,4,4,4,6,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,3,3,3,3,4,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,0,0,3,3,3,6,6,6,4,4,4,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,4,4,4,6,6,6,0,0,0,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,0,0,0,3,3,3,3,6,0,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,4,6,6,6,6,0,0,0,0,0,0,6,6,4,4,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,3,3,3,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,0,0,0,0,3,3,3,6,3,4,4,4,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,6,6,6,6,6,0,6,3,3,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,4,4,4,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,3,3,3,3,0,0,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,4,4,4,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,3,3,3,3,4,3,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,0,0,6,6,3,3,3,3,4,4,4,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,4,4,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,6,6,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,0,0,4,4,0,4,6,6,4,0,0,0,0,0,0,0,6,6,0,0,0,6,6,0,0,0,0,0,0,3,3,3,3,3,0,1,1,1,1,1,1,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,3,3,3,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,4,4,4,4,4,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,0,0,0,0,0,0,0,0,6,6,6,6,6,0,4,4,0,4,4,0,0,0,4,4,0,6,6,6,6,0,0,0,6,6,0,0,6,6,0,0,0,0,0,0,3,3,3,3,3,1,1,1,1,1,1,1,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,6,6,6,3,3,6,3,3,3,3,0,0,0,0,0,6,6,6,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,3,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,4,7,4,7,7,4,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,0,0,0,0,0,0,0,0,6,6,4,0,0,4,4,4,0,0,0,0,0,0,4,4,4,6,6,6,6,0,0,0,6,6,0,6,6,0,0,0,0,0,0,0,3,3,3,3,3,1,1,1,0,0,1,1,1,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,6,6,6,3,3,3,1,1,3,3,0,0,0,0,0,0,0,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,4,7,4,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,0,0,0,0,0,0,0,0,4,4,0,6,6,6,0,0,0,0,0,6,6,6,0,0,0,0,0,0,0,6,6,6,6,3,6,6,6,6,6,6,1,1,6,0,0,0,6,6,6,6,6,6,6,6,3,3,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,4,4,4,6,6,3,3,3,1,1,1,1,6,3,0,0,0,0,0,6,6,6,6,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,7,7,4,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,0,0,0,0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,0,0,0,4,4,4,0,6,6,6,0,0,0,0,0,6,6,6,6,0,0,0,6,6,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,0,0,0,6,6,0,6,6,6,6,6,3,3,3,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,3,3,3,3,1,1,1,1,3,3,3,3,6,6,6,6,6,6,6,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,4,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,6,6,6,6,0,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,0,0,0,0,0,0,0,4,4,4,4,6,6,6,4,6,6,6,4,4,4,4,4,4,4,0,6,6,0,0,0,0,0,0,0,0,6,6,6,0,6,6,6,6,6,4,4,0,4,4,0,4,4,4,4,4,0,0,0,0,0,6,6,0,6,6,6,6,6,3,3,3,3,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,3,3,3,3,3,3,0,0,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,6,6,6,6,0,0,0,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,0,0,0,0,0,0,0,4,4,3,4,6,6,6,4,6,6,6,4,4,4,4,4,0,0,0,6,6,0,0,0,0,0,0,0,0,6,6,6,6,6,6,4,4,4,4,4,0,4,4,0,0,0,0,0,4,4,4,4,6,6,6,6,0,0,6,6,6,6,6,3,3,3,3,6,3,3,3,3,3,3,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,6,0,0,0,0,0,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,0,0,0,0,0,0,0,4,4,4,4,6,6,6,0,0,6,6,6,4,4,0,0,0,0,0,4,4,0,0,0,0,0,0,0,0,0,6,6,6,6,0,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,0,0,0,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,3,0,0,0,0,0,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,0,0,0,0,0,0,0,4,4,6,6,6,6,6,0,0,6,6,6,4,4,0,0,0,0,0,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,0,6,6,6,0,0,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,3,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,4,6,6,6,6,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,0,0,0,0,0,0,0,0,0,0,4,4,0,0,0,0,0,0,6,6,6,0,0,6,6,6,6,6,6,3,3,3,3,3,3,3,3,3,3,0,0,0,0,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,3,1,0,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,0,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,4,6,6,6,0,3,3,0,6,6,6,6,6,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,0,0,0,0,0,0,0,4,4,4,0,0,0,0,0,0,6,6,6,0,0,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,0,0,0,0,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,3,3,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,0,0,0,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,3,3,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,6,6,6,6,6,6,4,4,0,6,6,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,0,0,0,0,0,0,4,4,4,0,0,0,0,0,0,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,3,4,1,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,0,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,3,3,3,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,6,6,6,6,6,6,6,4,4,0,6,6,3,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,6,6,0,0,0,0,0,0,0,0,6,6,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,0,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,3,3,3,3,0,0,0,0,0,0,0,0,3,3,3,3,6,3,3,3,6,6,6,6,6,6,6,6,4,4,6,6,6,3,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,0,0,0,0,0,6,6,0,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,1,1,4,1,4,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,0,0,0,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,3,3,3,3,0,0,0,0,0,0,0,0,3,3,3,6,6,6,3,3,6,6,6,6,6,6,6,6,6,4,4,6,6,6,3,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,4,6,6,4,4,4,0,6,6,6,0,6,6,6,0,0,0,0,0,0,6,0,6,0,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,1,1,1,1,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,0,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,3,3,3,3,0,0,0,0,0,0,0,0,0,6,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,4,6,6,6,3,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,4,6,6,6,4,4,4,4,4,4,4,4,6,6,6,0,0,0,0,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,1,6,6,6,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,3,3,3,3,3,0,0,0,0,0,0,0,0,6,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,4,4,0,0,0,0,0,0,0,0,0,1,1,3,3,3,1,0,0,0,0,0,0,0,0,0,0,0,4,6,6,6,6,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,3,3,3,3,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,1,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,4,4,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,3,3,3,3,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,6,6,0,4,4,0,0,0,0,0,0,0,3,3,3,0,1,3,3,1,1,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,3,3,3,3,0,0,0,0,0,0,0,6,6,6,6,6,0,6,6,6,0,0,6,6,6,6,6,6,6,0,6,6,0,0,0,0,0,3,3,3,3,3,3,3,3,3,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,0,0,0,0,0,6,6,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,3,3,3,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,0,0,6,6,6,0,0,0,3,3,3,6,0,0,0,3,3,3,3,0,3,3,3,3,3,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,0,0,0,0,0,3,3,3,3,3,6,3,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,3,3,6,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,0,0,0,0,3,3,3,3,3,3,3,3,3,6,6,6,4,6,6,6,6,6,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,3,3,3,3,3,6,0,0,0,0,0,0,0,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,3,3,3,0,3,3,3,3,3,3,3,3,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,0,0,0,0,0,3,3,3,3,3,6,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,3,3,3,3,3,3,0,0,0,0,0,0,0,0,6,6,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,3,3,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,0,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,1,3,3,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,6,6,6,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,0,0,0,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,0,0,0,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,0,0,0,0,0,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,0,0,0,3,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,0,0,0,3,3,3,6,6,6,6,6,6,6,6,4,6,6,6,6,6,3,3,3,0,3,3,3,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,1,6,3,3,3,6,6,6,6,6,6,6,6,4,4,4,1,6,6,6,3,3,3,6,6,3,3,3,6,3,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,3,3,3,3,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,0,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,0,0,6,1,1,1,6,6,6,6,6,6,4,4,6,6,4,4,4,1,1,1,6,6,6,3,3,6,1,1,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,3,3,3,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,0,6,6,6,6,6,0,0,0,0,6,6,6,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,0,0,0,0,1,1,1,4,6,6,6,6,6,6,6,6,4,4,4,4,1,1,1,1,6,3,3,3,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,3,6,6,6,0,0,0,0,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,6,0,6,6,6,6,6,0,0,0,0,0,6,6,6,0,0,0,0,0,1,1,1,1,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,4,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,0,0,6,6,1,4,4,4,4,6,6,6,6,6,6,6,4,4,6,6,1,1,1,1,1,3,3,6,1,1,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,6,6,6,6,6,0,0,0,0,0,0,6,6,0,0,0,0,0,0,1,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,4,6,6,6,6,6,6,1,1,1,1,1,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,0,0,0,0,0,0,0,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,1,1,6,0,0,6,6,6,6,6,0,0,0,0,6,0,6,6,0,0,0,0,0,0,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,4,4,4,1,6,6,4,4,4,6,6,6,6,4,6,1,1,1,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,1,1,6,0,0,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,0,0,0,0,6,0,0,0,0,6,6,6,0,0,0,0,0,0,0,6,0,0,0,0,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,6,1,4,1,1,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,0,0,0,0,0,0,6,6,6,0,0,0,0,6,6,4,4,4,4,4,4,4,6,6,6,6,0,0,0,6,6,6,6,0,6,6,6,6,0,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,0,0,4,6,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,3,3,6,6,4,4,4,4,4,4,4,4,4,6,6,6,0,0,6,6,6,6,0,0,6,6,6,0,0,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,4,4,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,3,3,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,0,0,6,6,6,0,0,0,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,4,6,0,0,0,6,6,6,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,0,0,0,0,0,0,0,0,0,0,0,3,6,6,6,4,4,4,4,4,4,4,4,4,4,6,6,6,0,0,6,6,6,0,0,0,0,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,3,6,6,6,6,6,4,4,4,4,4,4,4,6,6,6,6,0,0,0,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,3,3,3,6,6,6,6,6,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,3,6,6,6,6,6,6,6,6,4,4,4,0,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,3,3,3,6,6,6,6,6,6,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,6,6,6,6,6,6,6,3,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,0,6,3,6,6,6,6,6,3,3,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,0,0,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,0,0,0,3,3,3,6,6,6,6,3,3,3,3,3,3,3,3,3,3,6,3,3,3,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,0,0,0,0,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,0,0,0,3,3,3,3,3,3,6,6,6,6,6,3,3,3,3,3,3,3,3,3,3,3,3,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,4,6,6,6,3,3,3,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,0,3,3,3,3,3,3,3,3,6,6,6,6,6,6,3,3,6,3,3,3,3,3,3,1,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,4,4,6,6,3,3,3,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,0,0,0,0,6,3,3,0,0,3,3,3,3,3,3,3,3,3,3,3,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,6,6,6,3,3,4,6,6,6,6,6,6,6,6,6,6,3,3,3,3,0,0,1,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,4,4,0,6,6,3,3,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,4,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,6,6,6,4,6,4,4,4,6,1,1,6,6,6,6,6,6,6,6,6,0,0,0,0,1,1,6,6,6,6,3,3,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,4,4,0,0,0,4,4,4,0,0,6,6,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,4,4,4,4,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,6,4,4,4,6,4,6,1,1,1,1,1,6,6,6,6,6,6,0,0,0,0,0,1,1,1,6,3,3,3,3,3,3,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,4,4,4,6,6,4,4,4,4,0,6,6,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,4,4,4,4,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,6,6,6,4,6,6,6,6,6,1,1,1,1,1,6,6,6,6,0,0,0,0,0,0,1,1,1,3,3,3,3,3,3,3,3,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,4,4,6,6,6,4,4,4,4,6,6,0,0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,6,6,6,4,4,4,4,4,0,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,4,6,4,4,4,4,4,4,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,6,0,0,0,0,1,1,1,6,3,3,3,3,3,3,3,3,3,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,4,6,6,6,6,4,4,4,6,6,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,6,6,6,4,4,4,4,4,4,0,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,6,4,4,4,4,6,6,6,4,4,4,4,4,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,4,6,6,6,6,6,6,6,6,6,6,3,6,6,6,6,3,3,3,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,4,4,4,6,6,6,0,4,6,6,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,0,4,4,4,4,0,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,4,4,4,4,4,6,6,6,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,4,4,4,4,6,6,0,0,6,6,0,3,3,0,0,0,0,0,0,0,0,6,6,0,0,6,6,4,4,4,4,4,4,4,0,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,4,4,4,4,4,6,6,6,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,4,4,4,0,0,0,6,6,0,3,3,0,0,0,0,0,0,0,0,6,6,0,0,0,4,4,4,4,4,4,4,0,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,4,4,4,4,4,6,6,6,6,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,6,6,6,4,4,4,0,4,4,3,0,3,3,0,0,0,0,0,0,0,6,6,6,4,0,4,4,4,4,4,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,6,6,6,6,3,3,3,3,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,3,6,6,6,3,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,6,6,6,6,4,4,0,4,4,3,3,3,3,0,0,0,0,0,0,6,6,6,4,4,4,4,4,4,4,0,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,3,3,3,3,3,3,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,3,3,3,0,0,6,6,6,6,3,4,4,0,3,3,3,3,0,0,0,0,0,6,6,6,4,4,4,4,4,4,0,0,0,6,6,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,3,3,3,3,3,3,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,3,3,3,0,0,0,6,6,6,4,4,4,3,3,3,3,3,0,0,0,0,6,6,6,6,4,4,4,4,4,6,6,0,0,0,0,6,6,6,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,4,4,4,4,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,3,3,3,3,3,3,3,3,4,3,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,3,3,3,3,3,3,0,0,0,0,4,4,4,3,3,0,0,0,0,0,0,0,6,6,6,6,4,4,4,0,6,6,6,6,0,0,0,0,0,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,4,4,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,3,3,3,6,3,3,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,0,3,3,0,0,0,0,4,4,4,0,0,0,0,0,0,0,6,6,6,6,6,4,4,4,4,6,6,2,3,3,3,0,0,0,0,6,6,6,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,3,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,0,3,3,0,0,0,6,6,6,6,6,6,0,0,0,0,0,6,6,6,4,4,4,4,4,0,2,3,3,3,3,3,0,6,6,0,0,6,6,0,0,0,0,6,6,6,6,6,6,0,0,0,0,6,6,6,6,6,4,4,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,3,3,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,4,6,6,6,6,3,3,3,3,6,6,6,6,6,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,0,3,3,3,3,0,0,0,6,6,6,6,6,6,0,0,0,0,0,6,6,0,4,4,4,4,3,3,3,3,3,3,3,3,6,6,6,0,0,6,6,0,0,0,0,6,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,3,3,6,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,4,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,4,3,3,3,3,6,6,6,6,6,6,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,0,0,0,0,3,3,3,3,3,3,3,3,6,6,6,6,6,0,0,0,0,0,0,0,6,6,6,6,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,0,0,0,0,0,6,6,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,0,3,3,3,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,1,1,1,1,1,3,3,1,1,1,1,1,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,3,3,3,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,1,1,1,0,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,3,3,3,0,0,3,3,3,3,6,0,0,0,0,0,0,0,0,6,6,6,0,1,3,3,6,6,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,3,3,0,0,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,1,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,3,3,3,3,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,3,3,3,0,6,6,6,6,6,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,4,4,4,4,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,3,3,0,3,3,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,6,6,6,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,3,3,3,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,4,4,4,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,3,3,3,3,3,0,0,1,1,1,3,3,1,1,0,0,0,0,0,0,0,0,0,4,4,6,6,0,0,0,0,0,0,0,6,6,0,0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,4,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,6,6,6,6,6,6,0,0,0,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,3,3,3,3,3,0,1,1,1,3,3,1,1,0,0,0,0,0,0,0,3,3,4,4,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,0,0,0,0,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,3,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,3,3,0,3,3,3,3,3,3,3,3,1,1,1,0,0,0,0,0,0,3,3,4,4,3,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,4,4,3,3,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,0,3,3,3,3,3,3,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,3,3,3,3,3,3,3,3,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,3,3,3,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,3,3,3,3,3,3,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,6,6,3,3,3,3,3,3,3,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,3,3,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,6,6,6,3,3,3,3,3,3,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,3,3,0,6,6,6,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,7,7,7,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,3,3,0,6,6,6,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,4,4,4,4,4,4,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,4,4,4,6,6,6,6,0,0,0,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,7,7,7,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,3,3,3,0,6,6,0,0,0,0,0,3,3,0,0,0,0,0,0,6,6,6,4,4,4,4,0,4,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,0,0,6,6,6,0,0,0,0,0,6,3,3,3,6,6,6,6,6,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,4,4,7,7,7,7,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,4,4,4,4,4,4,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,3,3,0,0,0,0,0,6,6,0,0,0,3,3,0,0,0,0,6,6,6,4,0,4,4,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,0,0,0,0,6,0,0,0,0,0,0,3,3,3,6,6,6,6,6,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,3,3,4,4,4,4,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,0,0,3,3,3,0,0,0,6,6,6,6,6,4,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,0,0,0,0,0,6,0,0,0,0,0,0,3,3,3,3,6,6,6,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,1,1,1,6,6,6,6,3,3,3,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,6,6,6,0,0,0,0,6,6,6,0,0,3,3,0,0,0,0,6,6,6,6,4,6,6,4,0,0,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,0,0,6,6,0,0,0,0,0,3,3,3,3,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,1,1,1,1,6,4,3,3,3,3,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,6,6,6,6,6,6,0,0,0,0,6,6,0,0,0,0,3,3,0,0,6,6,6,6,4,4,4,4,4,4,0,0,0,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,3,3,3,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,3,3,1,1,1,1,6,1,3,3,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,6,6,6,6,6,6,0,0,0,0,6,6,0,0,0,0,3,3,3,0,6,6,6,6,0,0,4,4,4,4,0,0,0,0,0,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,0,6,6,6,0,0,0,3,3,3,3,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,4,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,3,3,3,3,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,0,0,0,4,4,4,4,4,4,0,0,0,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,0,6,6,6,0,0,3,3,3,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,3,3,3,6,1,1,1,1,1,0,0,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,6,6,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,0,0,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,0,3,3,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,4,7,7,7,4,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,6,6,1,1,0,0,0,0,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,6,6,3,0,0,6,6,6,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,6,6,6,6,4,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,0,6,6,0,3,3,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,3,3,3,3,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,3,6,6,6,1,1,0,6,6,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,0,0,0,0,0,6,6,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,0,0,0,3,3,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,3,3,3,3,6,6,6,6,0,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,3,3,6,6,1,1,1,6,6,6,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,0,6,6,6,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,4,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,3,6,6,6,1,1,1,6,6,6,0,3,3,3,0,0,0,1,1,1,1,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,0,0,0,4,6,6,0,0,0,0,0,0,0,0,0,0,0,4,4,0,6,6,6,6,6,6,6,6,4,4,4,3,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,6,6,6,6,6,1,1,1,1,1,0,0,0,3,3,0,0,0,1,1,3,3,3,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,0,0,6,6,6,6,6,6,6,6,4,3,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,3,3,3,3,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,6,6,6,0,0,3,3,3,1,1,0,0,0,0,0,0,0,0,3,3,3,3,1,1,1,1,1,1,0,0,3,3,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,3,3,3,3,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,6,6,3,3,0,3,3,3,1,1,0,0,0,0,0,0,0,0,3,3,3,3,1,1,1,1,1,1,1,0,3,3,0,0,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,3,3,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,0,6,6,3,3,0,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,0,0,0,3,3,1,1,1,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,0,6,6,3,3,0,1,1,1,3,3,3,0,0,0,0,0,1,1,1,1,1,3,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,0,6,6,0,0,0,3,1,1,0,3,3,3,3,0,0,0,1,1,1,3,3,3,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,6,6,0,0,0,3,3,0,0,0,0,3,3,0,0,0,0,3,3,3,3,0,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,6,6,0,0,3,3,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,1,1,1,0,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,6,6,6,0,3,3,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,1,1,1,0,0,6,6,6,6,0,0,6,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,3,3,0,1,1,0,0,0,6,6,0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,3,3,6,6,6,6,3,0,0,0,0,0,0,0,0,0,0,3,3,0,0,3,3,3,1,1,0,0,0,6,6,0,0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,4,4,4,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,3,6,6,6,6,3,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,4,4,4,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,3,3,6,6,3,0,0,0,0,0,0,0,0,0,0,0,6,3,3,3,3,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,4,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,6,6,6,6,6,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,2,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,0,2,6,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,];
}

function getTilePallet()
{
	return ["tropic_cliff_grass","tropic_plants","tropic_grass_c","tropic_grass_plants","tropic_dirt_a","tropic_beach_dry","tropic_dirt_a_plants","tropic_cliff_a",];
}
