"""Generated client library for serverless version v1alpha1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.serverless.v1alpha1 import serverless_v1alpha1_messages as messages


class ServerlessV1alpha1(base_api.BaseApiClient):
  """Generated client library for service serverless version v1alpha1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://serverless.googleapis.com/'

  _PACKAGE = u'serverless'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = u'v1alpha1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'ServerlessV1alpha1'
  _URL_VERSION = u'v1alpha1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new serverless handle."""
    url = url or self.BASE_URL
    super(ServerlessV1alpha1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.extensions_k8s_api_versions_v1 = self.ExtensionsK8sApiVersionsV1Service(self)
    self.extensions_k8s_api_versions = self.ExtensionsK8sApiVersionsService(self)
    self.extensions_k8s_api = self.ExtensionsK8sApiService(self)
    self.extensions_k8s_apis = self.ExtensionsK8sApisService(self)
    self.extensions_k8s_groups_serving_knative_dev = self.ExtensionsK8sGroupsServingKnativeDevService(self)
    self.extensions_k8s_groups_serving_knative = self.ExtensionsK8sGroupsServingKnativeService(self)
    self.extensions_k8s_groups_serving = self.ExtensionsK8sGroupsServingService(self)
    self.extensions_k8s_groups = self.ExtensionsK8sGroupsService(self)
    self.extensions_k8s = self.ExtensionsK8sService(self)
    self.extensions = self.ExtensionsService(self)
    self.namespaces_configurations = self.NamespacesConfigurationsService(self)
    self.namespaces_kube_system_services = self.NamespacesKubeSystemServicesService(self)
    self.namespaces_kube_system = self.NamespacesKubeSystemService(self)
    self.namespaces_revisions = self.NamespacesRevisionsService(self)
    self.namespaces_routes = self.NamespacesRoutesService(self)
    self.namespaces_services = self.NamespacesServicesService(self)
    self.namespaces = self.NamespacesService(self)
    self.projects_locations_configurations = self.ProjectsLocationsConfigurationsService(self)
    self.projects_locations_revisions = self.ProjectsLocationsRevisionsService(self)
    self.projects_locations_routes = self.ProjectsLocationsRoutesService(self)
    self.projects_locations_services = self.ProjectsLocationsServicesService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)
    self.v1alpha1 = self.V1alpha1Service(self)

  class ExtensionsK8sApiVersionsV1Service(base_api.BaseApiService):
    """Service class for the extensions_k8s_api_versions_v1 resource."""

    _NAME = u'extensions_k8s_api_versions_v1'

    def __init__(self, client):
      super(ServerlessV1alpha1.ExtensionsK8sApiVersionsV1Service, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists v1 Api resources.

      Args:
        request: (ServerlessExtensionsK8sApiVersionsV1ListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ApiResourceList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'serverless.extensions.k8s.api.versions.v1.list',
        ordered_params=[],
        path_params=[],
        query_params=[u'timeout'],
        relative_path=u'v1alpha1/extensions/k8s/api/versions/v1',
        request_field='',
        request_type_name=u'ServerlessExtensionsK8sApiVersionsV1ListRequest',
        response_type_name=u'ApiResourceList',
        supports_download=False,
    )

  class ExtensionsK8sApiVersionsService(base_api.BaseApiService):
    """Service class for the extensions_k8s_api_versions resource."""

    _NAME = u'extensions_k8s_api_versions'

    def __init__(self, client):
      super(ServerlessV1alpha1.ExtensionsK8sApiVersionsService, self).__init__(client)
      self._upload_configs = {
          }

  class ExtensionsK8sApiService(base_api.BaseApiService):
    """Service class for the extensions_k8s_api resource."""

    _NAME = u'extensions_k8s_api'

    def __init__(self, client):
      super(ServerlessV1alpha1.ExtensionsK8sApiService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists Api versions.

      Args:
        request: (ServerlessExtensionsK8sApiListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ApiVersions) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'serverless.extensions.k8s.api.list',
        ordered_params=[],
        path_params=[],
        query_params=[u'timeout'],
        relative_path=u'v1alpha1/extensions/k8s/api',
        request_field='',
        request_type_name=u'ServerlessExtensionsK8sApiListRequest',
        response_type_name=u'ApiVersions',
        supports_download=False,
    )

  class ExtensionsK8sApisService(base_api.BaseApiService):
    """Service class for the extensions_k8s_apis resource."""

    _NAME = u'extensions_k8s_apis'

    def __init__(self, client):
      super(ServerlessV1alpha1.ExtensionsK8sApisService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists Apis.

      Args:
        request: (ServerlessExtensionsK8sApisListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ApiGroupList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'serverless.extensions.k8s.apis.list',
        ordered_params=[],
        path_params=[],
        query_params=[u'timeout'],
        relative_path=u'v1alpha1/extensions/k8s/apis',
        request_field='',
        request_type_name=u'ServerlessExtensionsK8sApisListRequest',
        response_type_name=u'ApiGroupList',
        supports_download=False,
    )

  class ExtensionsK8sGroupsServingKnativeDevService(base_api.BaseApiService):
    """Service class for the extensions_k8s_groups_serving_knative_dev resource."""

    _NAME = u'extensions_k8s_groups_serving_knative_dev'

    def __init__(self, client):
      super(ServerlessV1alpha1.ExtensionsK8sGroupsServingKnativeDevService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists serverless v1alpha1 resources.

      Args:
        request: (ServerlessExtensionsK8sGroupsServingKnativeDevListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ApiResourceList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'serverless.extensions.k8s.groups.serving.knative.dev.list',
        ordered_params=[],
        path_params=[],
        query_params=[u'labelSelector', u'timeout'],
        relative_path=u'v1alpha1/extensions/k8s/groups/serving.knative.dev',
        request_field='',
        request_type_name=u'ServerlessExtensionsK8sGroupsServingKnativeDevListRequest',
        response_type_name=u'ApiResourceList',
        supports_download=False,
    )

  class ExtensionsK8sGroupsServingKnativeService(base_api.BaseApiService):
    """Service class for the extensions_k8s_groups_serving_knative resource."""

    _NAME = u'extensions_k8s_groups_serving_knative'

    def __init__(self, client):
      super(ServerlessV1alpha1.ExtensionsK8sGroupsServingKnativeService, self).__init__(client)
      self._upload_configs = {
          }

  class ExtensionsK8sGroupsServingService(base_api.BaseApiService):
    """Service class for the extensions_k8s_groups_serving resource."""

    _NAME = u'extensions_k8s_groups_serving'

    def __init__(self, client):
      super(ServerlessV1alpha1.ExtensionsK8sGroupsServingService, self).__init__(client)
      self._upload_configs = {
          }

  class ExtensionsK8sGroupsService(base_api.BaseApiService):
    """Service class for the extensions_k8s_groups resource."""

    _NAME = u'extensions_k8s_groups'

    def __init__(self, client):
      super(ServerlessV1alpha1.ExtensionsK8sGroupsService, self).__init__(client)
      self._upload_configs = {
          }

  class ExtensionsK8sService(base_api.BaseApiService):
    """Service class for the extensions_k8s resource."""

    _NAME = u'extensions_k8s'

    def __init__(self, client):
      super(ServerlessV1alpha1.ExtensionsK8sService, self).__init__(client)
      self._upload_configs = {
          }

  class ExtensionsService(base_api.BaseApiService):
    """Service class for the extensions resource."""

    _NAME = u'extensions'

    def __init__(self, client):
      super(ServerlessV1alpha1.ExtensionsService, self).__init__(client)
      self._upload_configs = {
          }

  class NamespacesConfigurationsService(base_api.BaseApiService):
    """Service class for the namespaces_configurations resource."""

    _NAME = u'namespaces_configurations'

    def __init__(self, client):
      super(ServerlessV1alpha1.NamespacesConfigurationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a configuration.

      Args:
        request: (ServerlessNamespacesConfigurationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Configuration) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/configurations/{configurationsId}',
        http_method=u'GET',
        method_id=u'serverless.namespaces.configurations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'apis/serving.knative.dev/v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessNamespacesConfigurationsGetRequest',
        response_type_name=u'Configuration',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list configurations.

      Args:
        request: (ServerlessNamespacesConfigurationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListConfigurationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/configurations',
        http_method=u'GET',
        method_id=u'serverless.namespaces.configurations.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'apis/serving.knative.dev/v1alpha1/{+parent}/configurations',
        request_field='',
        request_type_name=u'ServerlessNamespacesConfigurationsListRequest',
        response_type_name=u'ListConfigurationsResponse',
        supports_download=False,
    )

  class NamespacesKubeSystemServicesService(base_api.BaseApiService):
    """Service class for the namespaces_kube_system_services resource."""

    _NAME = u'namespaces_kube_system_services'

    def __init__(self, client):
      super(ServerlessV1alpha1.NamespacesKubeSystemServicesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists serverless v1alpha1 resources.

      Args:
        request: (ServerlessNamespacesKubeSystemServicesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ApiResourceList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'serverless.namespaces.kube-system.services.list',
        ordered_params=[],
        path_params=[],
        query_params=[u'labelSelector', u'timeout'],
        relative_path=u'apis/serving.knative.dev/v1alpha1/namespaces/kube-system/services',
        request_field='',
        request_type_name=u'ServerlessNamespacesKubeSystemServicesListRequest',
        response_type_name=u'ApiResourceList',
        supports_download=False,
    )

  class NamespacesKubeSystemService(base_api.BaseApiService):
    """Service class for the namespaces_kube_system resource."""

    _NAME = u'namespaces_kube_system'

    def __init__(self, client):
      super(ServerlessV1alpha1.NamespacesKubeSystemService, self).__init__(client)
      self._upload_configs = {
          }

  class NamespacesRevisionsService(base_api.BaseApiService):
    """Service class for the namespaces_revisions resource."""

    _NAME = u'namespaces_revisions'

    def __init__(self, client):
      super(ServerlessV1alpha1.NamespacesRevisionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a revision.

      Args:
        request: (ServerlessNamespacesRevisionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/revisions/{revisionsId}',
        http_method=u'DELETE',
        method_id=u'serverless.namespaces.revisions.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'orphanDependents'],
        relative_path=u'apis/serving.knative.dev/v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessNamespacesRevisionsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get informationabout a revision.

      Args:
        request: (ServerlessNamespacesRevisionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Revision) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/revisions/{revisionsId}',
        http_method=u'GET',
        method_id=u'serverless.namespaces.revisions.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'apis/serving.knative.dev/v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessNamespacesRevisionsGetRequest',
        response_type_name=u'Revision',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list revisions.

      Args:
        request: (ServerlessNamespacesRevisionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRevisionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/revisions',
        http_method=u'GET',
        method_id=u'serverless.namespaces.revisions.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'apis/serving.knative.dev/v1alpha1/{+parent}/revisions',
        request_field='',
        request_type_name=u'ServerlessNamespacesRevisionsListRequest',
        response_type_name=u'ListRevisionsResponse',
        supports_download=False,
    )

  class NamespacesRoutesService(base_api.BaseApiService):
    """Service class for the namespaces_routes resource."""

    _NAME = u'namespaces_routes'

    def __init__(self, client):
      super(ServerlessV1alpha1.NamespacesRoutesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a route.
This will cause the route to stop serving traffic.

      Args:
        request: (ServerlessNamespacesRoutesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Route) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/routes/{routesId}',
        http_method=u'GET',
        method_id=u'serverless.namespaces.routes.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'apis/serving.knative.dev/v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessNamespacesRoutesGetRequest',
        response_type_name=u'Route',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list routes.

      Args:
        request: (ServerlessNamespacesRoutesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRoutesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/routes',
        http_method=u'GET',
        method_id=u'serverless.namespaces.routes.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'apis/serving.knative.dev/v1alpha1/{+parent}/routes',
        request_field='',
        request_type_name=u'ServerlessNamespacesRoutesListRequest',
        response_type_name=u'ListRoutesResponse',
        supports_download=False,
    )

  class NamespacesServicesService(base_api.BaseApiService):
    """Service class for the namespaces_services resource."""

    _NAME = u'namespaces_services'

    def __init__(self, client):
      super(ServerlessV1alpha1.NamespacesServicesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Rpc to create a service.

      Args:
        request: (ServerlessNamespacesServicesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/services',
        http_method=u'POST',
        method_id=u'serverless.namespaces.services.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'apis/serving.knative.dev/v1alpha1/{+parent}/services',
        request_field=u'service',
        request_type_name=u'ServerlessNamespacesServicesCreateRequest',
        response_type_name=u'Service',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a service.
This will cause the Service to stop serving traffic and will delete the
child entities like Routes, Configurations and Revisions.

      Args:
        request: (ServerlessNamespacesServicesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/services/{servicesId}',
        http_method=u'DELETE',
        method_id=u'serverless.namespaces.services.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'orphanDependents'],
        relative_path=u'apis/serving.knative.dev/v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessNamespacesServicesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a service.

      Args:
        request: (ServerlessNamespacesServicesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/services/{servicesId}',
        http_method=u'GET',
        method_id=u'serverless.namespaces.services.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'apis/serving.knative.dev/v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessNamespacesServicesGetRequest',
        response_type_name=u'Service',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list services.

      Args:
        request: (ServerlessNamespacesServicesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListServicesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/services',
        http_method=u'GET',
        method_id=u'serverless.namespaces.services.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'apis/serving.knative.dev/v1alpha1/{+parent}/services',
        request_field='',
        request_type_name=u'ServerlessNamespacesServicesListRequest',
        response_type_name=u'ListServicesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Rpc to update a service.
Only the metadata and spec are modifiable but after the Update request,
Google Serverless Engine will work to make the ServiceStatus match the
requested ServiceSpec.
May use metadata.resourceVersion to enforce update from last read for
concurrency control.

      Args:
        request: (ServerlessNamespacesServicesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/services/{servicesId}',
        http_method=u'PATCH',
        method_id=u'serverless.namespaces.services.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'apis/serving.knative.dev/v1alpha1/{+name}',
        request_field=u'httpBody',
        request_type_name=u'ServerlessNamespacesServicesPatchRequest',
        response_type_name=u'Service',
        supports_download=False,
    )

    def ReplaceService(self, request, global_params=None):
      r"""Rpc to replace a service.
Only the metadata and spec are modifiable but after the Replace request,
Google Serverless Engine will work to make the ServiceStatus match the
requested ServiceSpec.
May use metadata.resourceVersion to enforce update from last read for
concurrency control.

      Args:
        request: (ServerlessNamespacesServicesReplaceServiceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('ReplaceService')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceService.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/services/{servicesId}',
        http_method=u'PUT',
        method_id=u'serverless.namespaces.services.replaceService',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'apis/serving.knative.dev/v1alpha1/{+name}',
        request_field=u'service',
        request_type_name=u'ServerlessNamespacesServicesReplaceServiceRequest',
        response_type_name=u'Service',
        supports_download=False,
    )

  class NamespacesService(base_api.BaseApiService):
    """Service class for the namespaces resource."""

    _NAME = u'namespaces'

    def __init__(self, client):
      super(ServerlessV1alpha1.NamespacesService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsLocationsConfigurationsService(base_api.BaseApiService):
    """Service class for the projects_locations_configurations resource."""

    _NAME = u'projects_locations_configurations'

    def __init__(self, client):
      super(ServerlessV1alpha1.ProjectsLocationsConfigurationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a configuration.

      Args:
        request: (ServerlessProjectsLocationsConfigurationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Configuration) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/configurations/{configurationsId}',
        http_method=u'GET',
        method_id=u'serverless.projects.locations.configurations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsConfigurationsGetRequest',
        response_type_name=u'Configuration',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list configurations.

      Args:
        request: (ServerlessProjectsLocationsConfigurationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListConfigurationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/configurations',
        http_method=u'GET',
        method_id=u'serverless.projects.locations.configurations.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'v1alpha1/{+parent}/configurations',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsConfigurationsListRequest',
        response_type_name=u'ListConfigurationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsRevisionsService(base_api.BaseApiService):
    """Service class for the projects_locations_revisions resource."""

    _NAME = u'projects_locations_revisions'

    def __init__(self, client):
      super(ServerlessV1alpha1.ProjectsLocationsRevisionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a revision.

      Args:
        request: (ServerlessProjectsLocationsRevisionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/revisions/{revisionsId}',
        http_method=u'DELETE',
        method_id=u'serverless.projects.locations.revisions.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'orphanDependents'],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsRevisionsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get informationabout a revision.

      Args:
        request: (ServerlessProjectsLocationsRevisionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Revision) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/revisions/{revisionsId}',
        http_method=u'GET',
        method_id=u'serverless.projects.locations.revisions.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsRevisionsGetRequest',
        response_type_name=u'Revision',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list revisions.

      Args:
        request: (ServerlessProjectsLocationsRevisionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRevisionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/revisions',
        http_method=u'GET',
        method_id=u'serverless.projects.locations.revisions.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'v1alpha1/{+parent}/revisions',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsRevisionsListRequest',
        response_type_name=u'ListRevisionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsRoutesService(base_api.BaseApiService):
    """Service class for the projects_locations_routes resource."""

    _NAME = u'projects_locations_routes'

    def __init__(self, client):
      super(ServerlessV1alpha1.ProjectsLocationsRoutesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a route.
This will cause the route to stop serving traffic.

      Args:
        request: (ServerlessProjectsLocationsRoutesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Route) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/routes/{routesId}',
        http_method=u'GET',
        method_id=u'serverless.projects.locations.routes.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsRoutesGetRequest',
        response_type_name=u'Route',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list routes.

      Args:
        request: (ServerlessProjectsLocationsRoutesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRoutesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/routes',
        http_method=u'GET',
        method_id=u'serverless.projects.locations.routes.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'v1alpha1/{+parent}/routes',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsRoutesListRequest',
        response_type_name=u'ListRoutesResponse',
        supports_download=False,
    )

  class ProjectsLocationsServicesService(base_api.BaseApiService):
    """Service class for the projects_locations_services resource."""

    _NAME = u'projects_locations_services'

    def __init__(self, client):
      super(ServerlessV1alpha1.ProjectsLocationsServicesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Rpc to create a service.

      Args:
        request: (ServerlessProjectsLocationsServicesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/services',
        http_method=u'POST',
        method_id=u'serverless.projects.locations.services.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha1/{+parent}/services',
        request_field=u'service',
        request_type_name=u'ServerlessProjectsLocationsServicesCreateRequest',
        response_type_name=u'Service',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a service.
This will cause the Service to stop serving traffic and will delete the
child entities like Routes, Configurations and Revisions.

      Args:
        request: (ServerlessProjectsLocationsServicesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/services/{servicesId}',
        http_method=u'DELETE',
        method_id=u'serverless.projects.locations.services.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'orphanDependents'],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsServicesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a service.

      Args:
        request: (ServerlessProjectsLocationsServicesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/services/{servicesId}',
        http_method=u'GET',
        method_id=u'serverless.projects.locations.services.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsServicesGetRequest',
        response_type_name=u'Service',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list services.

      Args:
        request: (ServerlessProjectsLocationsServicesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListServicesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/services',
        http_method=u'GET',
        method_id=u'serverless.projects.locations.services.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'v1alpha1/{+parent}/services',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsServicesListRequest',
        response_type_name=u'ListServicesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Rpc to update a service.
Only the metadata and spec are modifiable but after the Update request,
Google Serverless Engine will work to make the ServiceStatus match the
requested ServiceSpec.
May use metadata.resourceVersion to enforce update from last read for
concurrency control.

      Args:
        request: (ServerlessProjectsLocationsServicesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/services/{servicesId}',
        http_method=u'PATCH',
        method_id=u'serverless.projects.locations.services.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field=u'httpBody',
        request_type_name=u'ServerlessProjectsLocationsServicesPatchRequest',
        response_type_name=u'Service',
        supports_download=False,
    )

    def ReplaceService(self, request, global_params=None):
      r"""Rpc to replace a service.
Only the metadata and spec are modifiable but after the Replace request,
Google Serverless Engine will work to make the ServiceStatus match the
requested ServiceSpec.
May use metadata.resourceVersion to enforce update from last read for
concurrency control.

      Args:
        request: (ServerlessProjectsLocationsServicesReplaceServiceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('ReplaceService')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceService.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/services/{servicesId}',
        http_method=u'PUT',
        method_id=u'serverless.projects.locations.services.replaceService',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field=u'service',
        request_type_name=u'ServerlessProjectsLocationsServicesReplaceServiceRequest',
        response_type_name=u'Service',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = u'projects_locations'

    def __init__(self, client):
      super(ServerlessV1alpha1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(ServerlessV1alpha1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

  class V1alpha1Service(base_api.BaseApiService):
    """Service class for the v1alpha1 resource."""

    _NAME = u'v1alpha1'

    def __init__(self, client):
      super(ServerlessV1alpha1.V1alpha1Service, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists serverless v1alpha1 resources.

      Args:
        request: (ServerlessListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ApiResourceList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'serverless.list',
        ordered_params=[],
        path_params=[],
        query_params=[u'labelSelector', u'timeout'],
        relative_path=u'apis/serving.knative.dev/v1alpha1',
        request_field='',
        request_type_name=u'ServerlessListRequest',
        response_type_name=u'ApiResourceList',
        supports_download=False,
    )
