/**
 * @author: Bruno Massa http://drupal.org/user/67164
 * @file slideshow_creator.js
 * The main Javacript for this module
 */

/**
 * Initialize the module's JS functions
 *
 * See http://drupal.org/node/756722
 */

(function ($) {

  Drupal.behaviors.ssc = {
    attach: function (context) {
      if (typeof(window['ssc_settings']) != 'undefined' ) {
        for (var ss in ssc_settings) {
          if (ssc_settings.hasOwnProperty(ss)) {
	    if ( ! ssc_settings[ss].hasOwnProperty('before') ) {
              ssc_settings[ss].before = Drupal.ssc_before;
	    }
	    if (
	      ssc_settings[ss].hasOwnProperty('ssc') &&
		ssc_settings[ss].ssc.hasOwnProperty('pager')
	    ) {
	      eval('Drupal.ssc_pagerfn_' + ssc_settings[ss].ssc.pager + '(ssc_settings[ss], ss)');
	    } else {
	      $("#ssc-content-" + ss).cycle(ssc_settings[ss]);
	    }
          }
        }
      }
    }
  };

  Drupal.ssc_pagerfn_thum = function(ssc_setting, ss) {
    if ( ! ssc_setting.hasOwnProperty('pager') ) {
      ssc_setting.pager = '#ssc-nav-' +ss;
    }
    var width = '50px';
    if (ssc_setting.ssc.hasOwnProperty('thumx')) {
      width = ssc_setting.ssc.thumx;
    }
    var height = '40px';
    if (ssc_setting.ssc.hasOwnProperty('thumy')) {
      height = ssc_setting.ssc.thumy;
    }
    if ( ! ssc_setting.hasOwnProperty('pagerAnchorBuilder') ) {
      ssc_setting.pagerAnchorBuilder = function(idx, slide) {
	return '<li><a href="#"><img src="' +
	  slide.getElementsByTagName('img')[0].src +
	  '" width="' + width + '" height="' + height + '" /></a></li>';
      }
    }
    var pos = 'before';
    if (ssc_setting.ssc.hasOwnProperty('pager_pos')) {
      pos = ssc_setting.ssc.pager_pos;
    }
    if (ssc_setting.ssc.hasOwnProperty('eval_fn')) {
      var ssc_eval_fn = ssc_setting.ssc.eval_fn;
      delete ssc_setting.ssc;
      ssc_eval_fn(ss,ssc_setting);
    } else {
      delete ssc_setting.ssc;
      eval(
	'$("#ssc-content-" + ss).' + pos +
	'(\'<ul class="ssc-nav" id="ssc-nav-\' +ss+ \'">\').cycle(ssc_setting)'
      );
    }
  }

  Drupal.ssc_before = function() {
    var sscid = this.id.replace(/ssc-slide-/, "").replace(/-.*/, "");
    var slide = parseInt(this.id.replace(/ssc-slide-.*-/, ""), 10) + 1;
    $("#ssc-current-" + sscid).html(slide);
  };

}(jQuery));
