'\"
'\" Generated from file 'tcllib_coroutine\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2010-2015 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>
'\"
.TH "coroutine" n 1\&.1\&.3 tcllib "Coroutine utilities"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
coroutine \- Coroutine based event and IO handling
.SH SYNOPSIS
package require \fBTcl  8\&.6\fR
.sp
package require \fBcoroutine  1\&.1\&.3\fR
.sp
\fBcoroutine::util after\fR \fIdelay\fR
.sp
\fBcoroutine::util await\fR \fIvarname\fR\&.\&.\&.
.sp
\fBcoroutine::util create\fR \fIarg\fR\&.\&.\&.
.sp
\fBcoroutine::util exit\fR ?\fIstatus\fR?
.sp
\fBcoroutine::util gets\fR \fIchan\fR ?\fIvarname\fR?
.sp
\fBcoroutine::util gets_safety\fR \fIchan\fR \fIlimit\fR \fIvarname\fR
.sp
\fBcoroutine::util global\fR \fIvarname\fR\&.\&.\&.
.sp
\fBcoroutine::util read\fR \fB-nonewline\fR \fIchan\fR ?\fIn\fR?
.sp
\fBcoroutine::util update\fR ?\fBidletasks\fR?
.sp
\fBcoroutine::util vwait\fR \fIvarname\fR
.sp
.BE
.SH DESCRIPTION
The \fBcoroutine\fR package provides coroutine-aware
implementations of various event- and channel related commands\&. It can
be in multiple modes:
.IP [1]
Call the commands through their ensemble, in code which is
explicitly written for use within coroutines\&.
.IP [2]
Import the commands into a namespace, either directly, or
through \fBnamespace path\fR\&. This allows the use from within code
which is not coroutine-aware per se and restricted to specific
namespaces\&.
.PP
A more agressive form of making code coroutine-oblivious than point 2
above is available through the package \fBcoroutine::auto\fR,
which intercepts the relevant builtin commands and changes their
implementation dependending on the context they are run in, i\&.e\&.
inside or outside of a coroutine\&.
.SH API
All the commands listed below are synchronous with respect to the
coroutine invoking them, i\&.e\&. this coroutine blocks until the result
is available\&. The overall eventloop is not blocked however\&.
.TP
\fBcoroutine::util after\fR \fIdelay\fR
This command delays the coroutine invoking it by \fIdelay\fR
milliseconds\&.
.TP
\fBcoroutine::util await\fR \fIvarname\fR\&.\&.\&.
This command is an extension form of the \fBcoroutine::util vwait\fR
command (see below) which waits on a write to one of many named
namespace variables\&.
.TP
\fBcoroutine::util create\fR \fIarg\fR\&.\&.\&.
This command creates a new coroutine with an automatically assigned
name and causes it to run the code specified by the arguments\&.
.TP
\fBcoroutine::util exit\fR ?\fIstatus\fR?
This command exits the current coroutine, causing it to return
\fIstatus\fR\&. If no status was specified the default \fI0\fR is
returned\&.
.TP
\fBcoroutine::util gets\fR \fIchan\fR ?\fIvarname\fR?
This command reads a line from the channel \fIchan\fR and returns it
either as its result, or, if a \fIvarname\fR was specified, writes it
to the named variable and returns the number of characters read\&.
.TP
\fBcoroutine::util gets_safety\fR \fIchan\fR \fIlimit\fR \fIvarname\fR
This command reads a line from the channel \fIchan\fR up to size \fIlimit\fR
and stores the result in \fIvarname\fR\&. Of \fIlimit\fR is reached before the
set first newline, an error is thrown\&. The command returns the number of
characters read\&.
.TP
\fBcoroutine::util global\fR \fIvarname\fR\&.\&.\&.
This command imports the named global variables of the coroutine into
the current scope\&. From the technical point of view these variables
reside in level \fB#1\fR of the Tcl stack\&. I\&.e\&. these are not the
regular global variable in to the global namespace, and each coroutine
can have their own set, independent of all others\&.
.TP
\fBcoroutine::util read\fR \fB-nonewline\fR \fIchan\fR ?\fIn\fR?
This command reads \fIn\fR characters from the channel \fIchan\fR and
returns them as its result\&. If \fIn\fR is not specified the command
will read the channel until EOF is reached\&.
.TP
\fBcoroutine::util update\fR ?\fBidletasks\fR?
This command causes the coroutine invoking it to run pending events or
idle handlers before proceeding\&.
.TP
\fBcoroutine::util vwait\fR \fIvarname\fR
This command causes the coroutine calling it to wait for a write to
the named namespace variable \fIvarname\fR\&.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIcoroutine\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
after, channel, coroutine, events, exit, gets, global, green threads, read, threads, update, vwait
.SH CATEGORY
Coroutine
.SH COPYRIGHT
.nf
Copyright (c) 2010-2015 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>

.fi