/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.helper;

import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lib.uno.helper.MultiTypeInterfaceContainer;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.uno.Type;

public class ComponentBase
extends WeakBase
implements XComponent {
    private static final boolean DEBUG = false;
    protected MultiTypeInterfaceContainer listenerContainer = new MultiTypeInterfaceContainer();
    protected boolean bInDispose = false;
    protected boolean bDisposed = false;
    static final Type EVT_LISTENER_TYPE = new Type(XEventListener.class);

    protected void preDisposing() {
    }

    protected void postDisposing() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        boolean bl = false;
        ComponentBase componentBase = this;
        synchronized (componentBase) {
            if (!this.bInDispose && !this.bDisposed) {
                bl = true;
                this.bInDispose = true;
            }
        }
        if (bl) {
            try {
                this.preDisposing();
                this.listenerContainer.disposeAndClear(new EventObject(this));
                this.postDisposing();
            }
            finally {
                componentBase = this;
                synchronized (componentBase) {
                    this.bDisposed = true;
                    this.bInDispose = false;
                }
            }
        }
    }

    public void removeEventListener(XEventListener xEventListener) {
        this.listenerContainer.removeInterface(EVT_LISTENER_TYPE, xEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(XEventListener xEventListener) {
        boolean bl = false;
        ComponentBase componentBase = this;
        synchronized (componentBase) {
            if (this.bDisposed || this.bInDispose) {
                bl = true;
            } else {
                this.listenerContainer.addInterface(EVT_LISTENER_TYPE, xEventListener);
            }
        }
        if (bl) {
            xEventListener.disposing(new EventObject(this));
        }
    }

    protected void finalize() throws Throwable {
        if (!this.bInDispose && !this.bDisposed) {
            this.dispose();
        }
        super.finalize();
    }
}

