'\"
'\" Generated from file 'idx_container\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2009 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>
'\"
.TH "doctools::idx" n 2 tcllib "Documentation tools"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
doctools::idx \- Holding keyword indices
.SH SYNOPSIS
package require \fBdoctools::idx  ?2?\fR
.sp
package require \fBTcl  8\&.4\fR
.sp
package require \fBdoctools::idx::structure \fR
.sp
package require \fBsnit \fR
.sp
\fB::doctools::idx\fR \fIobjectName\fR
.sp
\fBobjectName\fR \fBmethod\fR ?\fIarg arg \&.\&.\&.\fR?
.sp
\fIobjectName\fR \fBdestroy\fR
.sp
\fIobjectName\fR \fBkey add\fR \fIname\fR
.sp
\fIobjectName\fR \fBkey remove\fR \fIname\fR
.sp
\fIobjectName\fR \fBkey references\fR \fIname\fR
.sp
\fIobjectName\fR \fBkeys\fR
.sp
\fIobjectName\fR \fBreference add\fR \fItype\fR \fIkey\fR \fIname\fR \fIlabel\fR
.sp
\fIobjectName\fR \fBreference remove\fR \fIname\fR
.sp
\fIobjectName\fR \fBreference label\fR \fIname\fR
.sp
\fIobjectName\fR \fBreference keys\fR \fIname\fR
.sp
\fIobjectName\fR \fBreference type\fR \fIname\fR
.sp
\fIobjectName\fR \fBreferences\fR
.sp
\fIobjectName\fR \fBtitle\fR
.sp
\fIobjectName\fR \fBtitle\fR \fItext\fR
.sp
\fIobjectName\fR \fBlabel\fR
.sp
\fIobjectName\fR \fBlabel\fR \fItext\fR
.sp
\fIobjectName\fR \fBimporter\fR
.sp
\fIobjectName\fR \fBimporter\fR \fIobject\fR
.sp
\fIobjectName\fR \fBexporter\fR
.sp
\fIobjectName\fR \fBexporter\fR \fIobject\fR
.sp
\fIobjectName\fR \fBdeserialize =\fR \fIdata\fR ?\fIformat\fR?
.sp
\fIobjectName\fR \fBdeserialize +=\fR \fIdata\fR ?\fIformat\fR?
.sp
\fIobjectName\fR \fBserialize\fR ?\fIformat\fR?
.sp
.BE
.SH DESCRIPTION
This package provides a class to contain and programmatically
manipulate keyword indices
.PP
This is one of the three public pillars the management of keyword
indices resides on\&. The other two pillars are
.IP [1]
\fIExporting keyword indices\fR, and
.IP [2]
\fIImporting keyword indices\fR
.PP
.PP
For information about the \fBConcepts\fR of keyword indices, and
their parts, see the same-named section\&.
For information about the data structure which is used to encode
keyword indices as values see the section
\fBKeyword index serialization format\fR\&.
This is the only format directly known to this class\&. Conversions from
and to any other format are handled by export and import manager
objects\&. These may be attached to a container, but do not have to be,
it is merely a convenience\&.
.SH CONCEPTS
.IP [1]
A \fIkeyword index\fR consists of a (possibly empty) set of \fIkeywords\fR\&.
.IP [2]
Each keyword in the set is identified by its name\&.
.IP [3]
Each keyword has a (possibly empty) set of \fIreferences\fR\&.
.IP [4]
A reference can be associated with more than one keyword\&.
.IP [5]
A reference not associated with at least one keyword is not possible
however\&.
.IP [6]
Each reference is identified by its target, specified as either an url
or symbolic filename, depending on the type of reference (\fBurl\fR,
or \fBmanpage\fR)\&.
.IP [7]
The type of a reference (url, or manpage) depends only on the
reference itself, and not the keywords it is associated with\&.
.IP [8]
In addition to a type each reference has a descriptive label as
well\&. This label depends only on the reference itself, and not the
keywords it is associated with\&.
.PP
A few notes
.IP [1]
Manpage references are intended to be used for references to the
documents the index is made for\&. Their target is a symbolic file name
identifying the document, and export plugins may replace symbolic with
actual file names, if specified\&.
.IP [2]
Url references are intended on the othre hand are inteded to be used
for links to anything else, like websites\&. Their target is an url\&.
.IP [3]
While url and manpage references share a namespace for their
identifiers, this should be no problem, given that manpage identifiers
are symbolic filenames and as such they should never look like urls,
the identifiers for url references\&.
.PP
.SH API
.SS "PACKAGE COMMANDS"
.TP
\fB::doctools::idx\fR \fIobjectName\fR
This command creates a new container object with an associated Tcl
command whose name is \fIobjectName\fR\&. This \fIobject\fR command is
explained in full detail in the sections \fBObject command\fR
and \fBObject methods\fR\&. The object command will be created
under the current namespace if the \fIobjectName\fR is not fully
qualified, and in the specified namespace otherwise\&.
.PP
.SS "OBJECT COMMAND"
All objects created by the \fB::doctools::idx\fR command have the
following general form:
.TP
\fBobjectName\fR \fBmethod\fR ?\fIarg arg \&.\&.\&.\fR?
The method \fBmethod\fR and its \fIarg\fR'uments determine the
exact behavior of the command\&.
See section \fBObject methods\fR for the detailed
specifications\&.
.PP
.SS "OBJECT METHODS"
.TP
\fIobjectName\fR \fBdestroy\fR
This method destroys the object it is invoked for\&.
.TP
\fIobjectName\fR \fBkey add\fR \fIname\fR
This method adds the keyword \fIname\fR to the index\&. If the keyword
is already known nothing is done\&. The result of the method is the
empty string\&.
.TP
\fIobjectName\fR \fBkey remove\fR \fIname\fR
This method removes the keyword \fIname\fR from the index\&. If the
keyword is already gone nothing is done\&. Any references for whom this
keyword was the last association are removed as well\&.  The result of
the method is the empty string\&.
.TP
\fIobjectName\fR \fBkey references\fR \fIname\fR
This method returns a list containing the names of all references
associated with the keyword \fIname\fR\&. An error is thrown in the
keyword is not known to the index\&. The order of the references in the
list is undefined\&.
.TP
\fIobjectName\fR \fBkeys\fR
This method returns a list containing the names of all keywords known
to the index\&. The order of the keywords in the list is undefined\&.
.TP
\fIobjectName\fR \fBreference add\fR \fItype\fR \fIkey\fR \fIname\fR \fIlabel\fR
This method adds the reference \fIname\fR to the index and associates
it with the keyword \fIkey\fR\&.
The other two arguments hold the \fItype\fR and \fIlabel\fR of the
reference, respectively\&.
The type has to match the stored information, should the reference
exist already, i\&.e\&. this information is immutable after the reference
is known\&. The only way to change it is delete and recreate the
reference\&.
The label on the other hand is automatically updated to the value of
the argument, overwriting any previously stored information\&.
Should the reference exists already it is simply associated with the
\fIkey\fR\&.  If that is true already as well nothing is done, but the
\fIlabel\fR updated to the new value\&.  The result of the method is the
empty string\&.
.sp
The \fItype\fR argument has be to one of \fBmanpage\fR or \fBurl\fR\&.
.TP
\fIobjectName\fR \fBreference remove\fR \fIname\fR
The reference \fIname\fR is removed from the index\&. All associations
with keywords are released and the relevant reference labels removed\&.
The result of the method is the empty string\&.
.TP
\fIobjectName\fR \fBreference label\fR \fIname\fR
This method returns the label associated with the reference
\fIname\fR\&. An error is thrown if the reference is not known\&.
.TP
\fIobjectName\fR \fBreference keys\fR \fIname\fR
This method returns a list containing the names of all keywords
associated with the reference \fIname\fR\&. An error is thrown in the
reference is not known to the index\&. The order of the keywords in the
list is undefined\&.
.TP
\fIobjectName\fR \fBreference type\fR \fIname\fR
This method returns the type of the reference \fIname\fR\&. An error is
thrown in the reference is not known to the index\&.
.TP
\fIobjectName\fR \fBreferences\fR
This method returns a list containing the names of all references
known to the index\&. The order of the references in the list is
undefined\&.
.TP
\fIobjectName\fR \fBtitle\fR
Returns the currently defined title of the keyword index\&.
.TP
\fIobjectName\fR \fBtitle\fR \fItext\fR
Sets the title of the keyword index to \fItext\fR, and returns it as
the result of the command\&.
.TP
\fIobjectName\fR \fBlabel\fR
Returns the currently defined label of the keyword index\&.
.TP
\fIobjectName\fR \fBlabel\fR \fItext\fR
Sets the label of the keyword index to \fItext\fR, and returns it as
the result of the command\&.
.TP
\fIobjectName\fR \fBimporter\fR
Returns the import manager object currently attached to the container,
if any\&.
.TP
\fIobjectName\fR \fBimporter\fR \fIobject\fR
Attaches the \fIobject\fR as import manager to the container, and
returns it as the result of the command\&.
Note that the \fIobject\fR is \fInot\fR put into ownership of the
container\&. I\&.e\&., destruction of the container will \fInot\fR destroy
the \fIobject\fR\&.
.sp
It is expected that \fIobject\fR provides a method named
\fBimport text\fR which takes a text and a format name, and
returns the canonical serialization of the keyword index contained in
the text, assuming the given format\&.
.TP
\fIobjectName\fR \fBexporter\fR
Returns the export manager object currently attached to the container,
if any\&.
.TP
\fIobjectName\fR \fBexporter\fR \fIobject\fR
Attaches the \fIobject\fR as export manager to the container, and
returns it as the result of the command\&.
Note that the \fIobject\fR is \fInot\fR put into ownership of the
container\&. I\&.e\&., destruction of the container will \fInot\fR destroy
the \fIobject\fR\&.
.sp
It is expected that \fIobject\fR provides a method named
\fBexport object\fR which takes the container and a format name,
and returns a text encoding keyword index stored in the container, in
the given format\&. It is further expected that the \fIobject\fR will
use the container's method \fBserialize\fR to obtain the
serialization of the keyword index from which to generate the text\&.
.TP
\fIobjectName\fR \fBdeserialize =\fR \fIdata\fR ?\fIformat\fR?
This method replaces the contents of the index object with the index
contained in the \fIdata\fR\&. If no \fIformat\fR was specified it is
assumed to be the regular serialization of a keyword index\&.
.sp
Otherwise the object will use the attached import manager to convert
the data from the specified format to a serialization it can handle\&.
In that case an error will be thrown if the container has no import
manager attached to it\&.
.sp
The result of the method is the empty string\&.
.TP
\fIobjectName\fR \fBdeserialize +=\fR \fIdata\fR ?\fIformat\fR?
This method behaves like \fBdeserialize =\fR in its essentials,
except that it merges the keyword index in the \fIdata\fR to its
contents instead of replacing it\&.
The method will throw an error if merging is not possible, i\&.e\&. would
produce an invalid index\&. The existing content is left unchanged in
that case\&.
.sp
The result of the method is the empty string\&.
.TP
\fIobjectName\fR \fBserialize\fR ?\fIformat\fR?
This method returns the keyword index contained in the object\&. If no
\fIformat\fR is not specified the returned result is the canonical
serialization of its contents\&.
.sp
Otherwise the object will use the attached export manager to convert
the data to the specified format\&.
In that case an error will be thrown if the container has no export
manager attached to it\&.
.PP
.SH "KEYWORD INDEX SERIALIZATION FORMAT"
Here we specify the format used by the doctools v2 packages to
serialize keyword indices as immutable values for transport,
comparison, etc\&.
.PP
We distinguish between \fIregular\fR and \fIcanonical\fR
serializations\&. While a keyword index may have more than one regular
serialization only exactly one of them will be \fIcanonical\fR\&.
.PP
.TP
regular serialization
.RS
.IP [1]
An index serialization is a nested Tcl dictionary\&.
.IP [2]
This dictionary holds a single key, \fBdoctools::idx\fR, and its
value\&. This value holds the contents of the index\&.
.IP [3]
The contents of the index are a Tcl dictionary holding the title of
the index, a label, and the keywords and references\&. The relevant keys
and their values are
.RS
.TP
\fBtitle\fR
The value is a string containing the title of the index\&.
.TP
\fBlabel\fR
The value is a string containing a label for the index\&.
.TP
\fBkeywords\fR
The value is a Tcl dictionary, using the keywords known to the index
as keys\&. The associated values are lists containing the identifiers of
the references associated with that particular keyword\&.
.sp
Any reference identifier used in these lists has to exist as a key in
the \fBreferences\fR dictionary, see the next item for its
definition\&.
.TP
\fBreferences\fR
The value is a Tcl dictionary, using the identifiers for the
references known to the index as keys\&. The associated values are
2-element lists containing the type and label of the reference, in
this order\&.
.sp
Any key here has to be associated with at least one keyword,
i\&.e\&. occur in at least one of the reference lists which are the values
in the \fBkeywords\fR dictionary, see previous item for its
definition\&.
.RE
.IP [4]
The \fItype\fR of a reference can be one of two values,
.RS
.TP
\fBmanpage\fR
The identifier of the reference is interpreted as symbolic file name,
refering to one of the documents the index was made for\&.
.TP
\fBurl\fR
The identifier of the reference is interpreted as an url, refering to
some external location, like a website, etc\&.
.RE
.RE
.TP
canonical serialization
The canonical serialization of a keyword index has the format as
specified in the previous item, and then additionally satisfies the
constraints below, which make it unique among all the possible
serializations of the keyword index\&.
.RS
.IP [1]
The keys found in all the nested Tcl dictionaries are sorted in
ascending dictionary order, as generated by Tcl's builtin command
\fBlsort -increasing -dict\fR\&.
.IP [2]
The references listed for each keyword of the index, if any, are
listed in ascending dictionary order of their \fIlabels\fR, as
generated by Tcl's builtin command \fBlsort -increasing -dict\fR\&.
.RE
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIdoctools\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
HTML, TMML, conversion, docidx markup, documentation, formatting, generation, index, json, keyword index, latex, manpage, markup, nroff, parsing, plugin, reference, tcler's wiki, text, url, wiki
.SH CATEGORY
Documentation tools
.SH COPYRIGHT
.nf
Copyright (c) 2009 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>

.fi