/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.authentication;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.SessionDialog;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.authentication.ContextAuthenticationPanel;
import org.zaproxy.zap.extension.httppanel.HttpPanelResponse;
import org.zaproxy.zap.model.Context;

public class PopupFlagLoggedOutIndicatorMenu
extends ExtensionPopupMenuItem {
    private static final long serialVersionUID = -3162691875698199510L;
    private String selectedText = null;
    private int contextId;

    public PopupFlagLoggedOutIndicatorMenu(Context ctx) {
        this.contextId = ctx.getIndex();
        this.setText(Constant.messages.getString("authentication.popup.indicator.loggedOut", ctx.getName()));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupFlagLoggedOutIndicatorMenu.this.performAction();
            }
        });
    }

    public void performAction() {
        SessionDialog sessionDialog = View.getSingleton().getSessionDialog();
        sessionDialog.recreateUISharedContexts(Model.getSingleton().getSession());
        Context uiSharedContext = sessionDialog.getUISharedContext(this.contextId);
        uiSharedContext.getAuthenticationMethod().setLoggedOutIndicatorPattern(Pattern.quote(this.getSelectedText()));
        View.getSingleton().showSessionDialog(Model.getSingleton().getSession(), ContextAuthenticationPanel.buildName(this.contextId), false);
    }

    @Override
    public boolean isSubMenu() {
        return true;
    }

    @Override
    public String getParentMenuName() {
        return Constant.messages.getString("context.flag.popup");
    }

    @Override
    public int getParentMenuIndex() {
        return 1;
    }

    @Override
    public boolean isEnableForComponent(Component invoker) {
        if (invoker instanceof JTextComponent) {
            boolean responsePanel;
            JTextComponent txtComponent = (JTextComponent)invoker;
            boolean bl = responsePanel = SwingUtilities.getAncestorOfClass(HttpPanelResponse.class, txtComponent) != null;
            if (!responsePanel) {
                this.selectedText = null;
                return false;
            }
            this.selectedText = txtComponent.getSelectedText();
            if (this.selectedText == null || this.selectedText.length() == 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            return true;
        }
        this.selectedText = null;
        return false;
    }

    public String getSelectedText() {
        return this.selectedText;
    }
}

