/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.io.SafeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UniFileLoader
extends MultiFileLoader {
    private static final long serialVersionUID = -6190649471408985837L;
    public static final String PROP_EXTENSIONS = "extensions";

    @Deprecated
    protected UniFileLoader(Class<? extends DataObject> clazz) {
        super(clazz);
    }

    protected UniFileLoader(String string) {
        super(string);
    }

    @Override
    protected FileObject findPrimaryFile(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return null;
        }
        return this.getExtensions().isRegistered(fileObject) ? fileObject : null;
    }

    @Override
    protected abstract MultiDataObject createMultiObject(FileObject var1) throws DataObjectExistsException, IOException;

    @Override
    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        return new FileEntry(multiDataObject, fileObject);
    }

    @Override
    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        StringBuilder stringBuilder = new StringBuilder("Error in data system. Please reopen the bug #17014 with the following message: ");
        stringBuilder.append("\n  DataLoader:");
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("\n  DataObject:");
        stringBuilder.append(multiDataObject);
        stringBuilder.append("\n  PrimaryEntry:");
        stringBuilder.append(multiDataObject.getPrimaryEntry());
        stringBuilder.append("\n  PrimaryFile:");
        stringBuilder.append(multiDataObject.getPrimaryFile());
        stringBuilder.append("\n  SecondaryFile:");
        stringBuilder.append(fileObject);
        stringBuilder.append("\n");
        throw new UnsupportedOperationException(stringBuilder.toString());
    }

    @Override
    final DataObject checkCollision(DataObject dataObject, FileObject fileObject) {
        return null;
    }

    @Override
    final void checkConsistency(MultiDataObject multiDataObject) {
    }

    @Override
    final void checkFiles(MultiDataObject multiDataObject) {
    }

    public void setExtensions(ExtensionList extensionList) {
        this.putProperty(PROP_EXTENSIONS, extensionList, true);
    }

    public ExtensionList getExtensions() {
        ExtensionList extensionList = (ExtensionList)this.getProperty(PROP_EXTENSIONS);
        if (extensionList == null) {
            extensionList = new ExtensionList();
            this.putProperty(PROP_EXTENSIONS, extensionList, false);
        }
        return extensionList;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.getProperty(PROP_EXTENSIONS));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        SafeException safeException;
        try {
            super.readExternal(objectInput);
            safeException = null;
        }
        catch (SafeException safeException2) {
            safeException = safeException2;
        }
        this.setExtensions((ExtensionList)objectInput.readObject());
        if (safeException != null) {
            throw safeException;
        }
    }
}

