/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.util.Arrays;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FuncSlotAcc;
import org.apache.solr.search.facet.SlotAcc;

abstract class DoubleFuncSlotAcc
extends FuncSlotAcc {
    double[] result;
    double initialValue;

    public DoubleFuncSlotAcc(ValueSource values, FacetContext fcontext, int numSlots) {
        this(values, fcontext, numSlots, 0.0);
    }

    public DoubleFuncSlotAcc(ValueSource values, FacetContext fcontext, int numSlots, double initialValue) {
        super(values, fcontext, numSlots);
        this.initialValue = initialValue;
        this.result = new double[numSlots];
        if (initialValue != 0.0) {
            this.reset();
        }
    }

    @Override
    public int compare(int slotA, int slotB) {
        return Double.compare(this.result[slotA], this.result[slotB]);
    }

    @Override
    public Object getValue(int slot) {
        return this.result[slot];
    }

    @Override
    public void reset() {
        Arrays.fill(this.result, this.initialValue);
    }

    @Override
    public void resize(SlotAcc.Resizer resizer) {
        this.result = resizer.resize(this.result, this.initialValue);
    }
}

