/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.LongDocValues;
import org.apache.lucene.queries.function.valuesource.SortedSetFieldSource;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueLong;
import org.apache.solr.legacy.LegacyNumericUtils;
import org.apache.solr.schema.LongValueFieldType;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieField;

@Deprecated
public class TrieLongField
extends TrieField
implements LongValueFieldType {
    public TrieLongField() {
        this.type = NumberType.LONG;
    }

    @Override
    public Object toNativeType(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        try {
            if (val instanceof String) {
                return Long.parseLong((String)val);
            }
        }
        catch (NumberFormatException e) {
            Double v = Double.parseDouble((String)val);
            return v.longValue();
        }
        return super.toNativeType(val);
    }

    @Override
    protected ValueSource getSingleValueSource(SortedSetSelector.Type choice, SchemaField f) {
        return new SortedSetFieldSource(f.getName(), choice){

            public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
                1 thisAsSortedSetFieldSource = this;
                SortedSetDocValues sortedSet = DocValues.getSortedSet((LeafReader)readerContext.reader(), (String)this.field);
                final SortedDocValues view = SortedSetSelector.wrap((SortedSetDocValues)sortedSet, (SortedSetSelector.Type)this.selector);
                return new LongDocValues((ValueSource)thisAsSortedSetFieldSource){
                    private int lastDocID;

                    private boolean setDoc(int docID) throws IOException {
                        if (docID < this.lastDocID) {
                            throw new IllegalArgumentException("docs out of order: lastDocID=" + this.lastDocID + " docID=" + docID);
                        }
                        if (docID > view.docID()) {
                            this.lastDocID = docID;
                            return docID == view.advance(docID);
                        }
                        return docID == view.docID();
                    }

                    public long longVal(int doc) throws IOException {
                        if (this.setDoc(doc)) {
                            BytesRef bytes = view.binaryValue();
                            assert (bytes.length > 0);
                            return LegacyNumericUtils.prefixCodedToLong(bytes);
                        }
                        return 0L;
                    }

                    public boolean exists(int doc) throws IOException {
                        return this.setDoc(doc);
                    }

                    public FunctionValues.ValueFiller getValueFiller() {
                        return new FunctionValues.ValueFiller(){
                            private final MutableValueLong mval = new MutableValueLong();

                            public MutableValue getValue() {
                                return this.mval;
                            }

                            public void fillValue(int doc) throws IOException {
                                if (this.setDoc(doc)) {
                                    this.mval.exists = true;
                                    this.mval.value = LegacyNumericUtils.prefixCodedToLong(view.binaryValue());
                                } else {
                                    this.mval.exists = false;
                                    this.mval.value = 0L;
                                }
                            }
                        };
                    }
                };
            }
        };
    }
}

