/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.FloatDocValues;
import org.apache.lucene.queries.function.valuesource.SortedSetFieldSource;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueFloat;
import org.apache.solr.legacy.LegacyNumericUtils;
import org.apache.solr.schema.FloatValueFieldType;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieField;

@Deprecated
public class TrieFloatField
extends TrieField
implements FloatValueFieldType {
    public TrieFloatField() {
        this.type = NumberType.FLOAT;
    }

    @Override
    public Object toNativeType(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return Float.valueOf(((Number)val).floatValue());
        }
        if (val instanceof String) {
            return Float.valueOf(Float.parseFloat((String)val));
        }
        return super.toNativeType(val);
    }

    @Override
    protected ValueSource getSingleValueSource(SortedSetSelector.Type choice, SchemaField f) {
        return new SortedSetFieldSource(f.getName(), choice){

            public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
                1 thisAsSortedSetFieldSource = this;
                SortedSetDocValues sortedSet = DocValues.getSortedSet((LeafReader)readerContext.reader(), (String)this.field);
                final SortedDocValues view = SortedSetSelector.wrap((SortedSetDocValues)sortedSet, (SortedSetSelector.Type)this.selector);
                return new FloatDocValues((ValueSource)thisAsSortedSetFieldSource){
                    private int lastDocID;

                    private boolean setDoc(int docID) throws IOException {
                        if (docID < this.lastDocID) {
                            throw new IllegalArgumentException("docs out of order: lastDocID=" + this.lastDocID + " docID=" + docID);
                        }
                        if (docID > view.docID()) {
                            return docID == view.advance(docID);
                        }
                        return docID == view.docID();
                    }

                    public float floatVal(int doc) throws IOException {
                        if (this.setDoc(doc)) {
                            BytesRef bytes = view.binaryValue();
                            assert (bytes.length > 0);
                            return NumericUtils.sortableIntToFloat((int)LegacyNumericUtils.prefixCodedToInt(bytes));
                        }
                        return 0.0f;
                    }

                    public boolean exists(int doc) throws IOException {
                        return this.setDoc(doc);
                    }

                    public FunctionValues.ValueFiller getValueFiller() {
                        return new FunctionValues.ValueFiller(){
                            private final MutableValueFloat mval = new MutableValueFloat();

                            public MutableValue getValue() {
                                return this.mval;
                            }

                            public void fillValue(int doc) throws IOException {
                                if (this.setDoc(doc)) {
                                    this.mval.exists = true;
                                    this.mval.value = NumericUtils.sortableIntToFloat((int)LegacyNumericUtils.prefixCodedToInt(view.binaryValue()));
                                } else {
                                    this.mval.exists = false;
                                    this.mval.value = 0.0f;
                                }
                            }
                        };
                    }
                };
            }
        };
    }
}

