/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.util.HashSet;
import java.util.Set;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrDocumentFetcher;

public class RetrieveFieldsOptimizer {
    private final Set<String> storedFields;
    private final Set<String> dvFields;

    RetrieveFieldsOptimizer(Set<String> storedFields, Set<String> dvFields) {
        this.storedFields = storedFields;
        this.dvFields = dvFields;
    }

    void optimize(SolrDocumentFetcher docFetcher) {
        this.optimize(docFetcher.getDvsCanSubstituteStored());
    }

    void optimize(Set<String> dvsCanSubstituteStored) {
        if (this.storedFields == null) {
            return;
        }
        if (!dvsCanSubstituteStored.containsAll(this.storedFields)) {
            return;
        }
        this.dvFields.addAll(this.storedFields);
        this.storedFields.clear();
    }

    boolean returnStoredFields() {
        return this.storedFields == null || !this.storedFields.isEmpty();
    }

    boolean returnDVFields() {
        return !this.dvFields.isEmpty();
    }

    Set<String> getStoredFields() {
        return this.storedFields;
    }

    Set<String> getDvFields() {
        return this.dvFields;
    }

    public static RetrieveFieldsOptimizer create(SolrDocumentFetcher docFetcher, ReturnFields returnFields) {
        Set<String> storedFields = RetrieveFieldsOptimizer.calcStoredFieldsForReturn(docFetcher, returnFields);
        Set<String> dvFields = RetrieveFieldsOptimizer.calcDocValueFieldsForReturn(docFetcher, returnFields);
        return new RetrieveFieldsOptimizer(storedFields, dvFields);
    }

    private static Set<String> calcStoredFieldsForReturn(SolrDocumentFetcher docFetcher, ReturnFields returnFields) {
        HashSet<String> storedFields = new HashSet<String>();
        Set<String> fnames = returnFields.getLuceneFieldNames();
        if (returnFields.wantsAllFields()) {
            return null;
        }
        if (returnFields.hasPatternMatching()) {
            for (String s : docFetcher.getAllStored()) {
                if (!returnFields.wantsField(s)) continue;
                storedFields.add(s);
            }
        } else if (fnames != null) {
            storedFields.addAll(fnames);
        }
        storedFields.remove("score");
        return storedFields;
    }

    private static Set<String> calcDocValueFieldsForReturn(SolrDocumentFetcher docFetcher, ReturnFields returnFields) {
        HashSet<String> result = new HashSet<String>();
        if (returnFields.wantsAllFields()) {
            result.addAll(docFetcher.getNonStoredDVs(true));
            Set<String> fieldNames = returnFields.getLuceneFieldNames(true);
            if (fieldNames != null) {
                for (String fl : fieldNames) {
                    if (!docFetcher.getNonStoredDVs(false).contains(fl)) continue;
                    result.add(fl);
                }
            }
        } else if (returnFields.hasPatternMatching()) {
            for (String s : docFetcher.getNonStoredDVs(true)) {
                if (!returnFields.wantsField(s)) continue;
                result.add(s);
            }
        } else {
            Set<String> fnames = returnFields.getLuceneFieldNames();
            if (fnames != null) {
                result.addAll(fnames);
                result.retainAll(docFetcher.getNonStoredDVs(false));
            }
        }
        return result;
    }
}

