/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.cloud.autoscaling.AlreadyExistsException;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.client.solrj.cloud.autoscaling.BadVersionException;
import org.apache.solr.client.solrj.cloud.autoscaling.DistribStateManager;
import org.apache.solr.client.solrj.cloud.autoscaling.PolicyHelper;
import org.apache.solr.client.solrj.cloud.autoscaling.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.VersionedData;
import org.apache.solr.cloud.OverseerCollectionMessageHandler;
import org.apache.solr.cloud.rule.ReplicaAssigner;
import org.apache.solr.cloud.rule.Rule;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ReplicaPosition;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.util.NumberUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Assign {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static int incAndGetId(DistribStateManager stateManager, String collection, int defaultValue) {
        String path = "/collections/" + collection;
        try {
            if (!stateManager.hasData(path)) {
                try {
                    stateManager.makePath(path);
                }
                catch (AlreadyExistsException alreadyExistsException) {
                    // empty catch block
                }
            }
            if (!stateManager.hasData(path = path + "/counter")) {
                try {
                    stateManager.createData(path, NumberUtils.intToBytes(defaultValue), CreateMode.PERSISTENT);
                }
                catch (AlreadyExistsException alreadyExistsException) {}
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error creating counter node in Zookeeper for collection:" + collection, (Throwable)e);
        }
        catch (IOException | KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error creating counter node in Zookeeper for collection:" + collection, e);
        }
        while (true) {
            try {
                int version = 0;
                int currentId = 0;
                VersionedData data = stateManager.getData(path, null);
                if (data != null) {
                    currentId = NumberUtils.bytesToInt(data.getData());
                    version = data.getVersion();
                }
                byte[] bytes = NumberUtils.intToBytes(++currentId);
                stateManager.setData(path, bytes, version);
                return currentId;
            }
            catch (BadVersionException e) {
                continue;
            }
            catch (IOException | KeeperException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error inc and get counter from Zookeeper for collection:" + collection, e);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error inc and get counter from Zookeeper for collection:" + collection, (Throwable)e);
            }
            break;
        }
    }

    public static String assignNode(DistribStateManager stateManager, DocCollection collection) {
        int defaultValue = Assign.defaultCounterValue(collection, false);
        String coreNodeName = "core_node" + Assign.incAndGetId(stateManager, collection.getName(), defaultValue);
        while (collection.getReplica(coreNodeName) != null) {
            coreNodeName = "core_node" + Assign.incAndGetId(stateManager, collection.getName(), defaultValue);
        }
        return coreNodeName;
    }

    public static String assignShard(DocCollection collection, Integer numShards) {
        Map sliceMap;
        if (numShards == null) {
            numShards = 1;
        }
        String returnShardId = null;
        Map map = sliceMap = collection != null ? collection.getActiveSlicesMap() : null;
        if (sliceMap == null) {
            return "shard1";
        }
        ArrayList shardIdNames = new ArrayList(sliceMap.keySet());
        if (shardIdNames.size() < numShards) {
            return "shard" + (shardIdNames.size() + 1);
        }
        HashMap<String, Integer> map2 = new HashMap<String, Integer>();
        for (String shardId : shardIdNames) {
            int cnt = ((Slice)sliceMap.get(shardId)).getReplicasMap().size();
            map2.put(shardId, cnt);
        }
        Collections.sort(shardIdNames, (o1, o2) -> {
            Integer one = (Integer)map2.get(o1);
            Integer two = (Integer)map2.get(o2);
            return one.compareTo(two);
        });
        returnShardId = (String)shardIdNames.get(0);
        return returnShardId;
    }

    private static String buildCoreName(String collectionName, String shard, Replica.Type type, int replicaNum) {
        return String.format(Locale.ROOT, "%s_%s_replica_%s%s", collectionName, shard, type.name().substring(0, 1).toLowerCase(Locale.ROOT), replicaNum);
    }

    private static int defaultCounterValue(DocCollection collection, boolean newCollection) {
        if (newCollection) {
            return 0;
        }
        int defaultValue = collection.getReplicas().size();
        if (collection.getReplicationFactor() != null) {
            defaultValue = Math.max(defaultValue, collection.getReplicationFactor() * collection.getSlices().size());
        }
        return defaultValue * 20;
    }

    public static String buildCoreName(DistribStateManager stateManager, DocCollection collection, String shard, Replica.Type type, boolean newCollection) {
        Slice slice = collection.getSlice(shard);
        int defaultValue = Assign.defaultCounterValue(collection, newCollection);
        int replicaNum = Assign.incAndGetId(stateManager, collection.getName(), defaultValue);
        String coreName = Assign.buildCoreName(collection.getName(), shard, type, replicaNum);
        while (Assign.existCoreName(coreName, slice)) {
            replicaNum = Assign.incAndGetId(stateManager, collection.getName(), defaultValue);
            coreName = Assign.buildCoreName(collection.getName(), shard, type, replicaNum);
        }
        return coreName;
    }

    public static String buildCoreName(DistribStateManager stateManager, DocCollection collection, String shard, Replica.Type type) {
        return Assign.buildCoreName(stateManager, collection, shard, type, false);
    }

    private static boolean existCoreName(String coreName, Slice slice) {
        if (slice == null) {
            return false;
        }
        for (Replica replica : slice.getReplicas()) {
            if (!coreName.equals(replica.getStr("core"))) continue;
            return true;
        }
        return false;
    }

    public static List<String> getLiveOrLiveAndCreateNodeSetList(Set<String> liveNodes, ZkNodeProps message, Random random) {
        ArrayList<Object> nodeList;
        List createNodeList;
        String createNodeSetStr = message.getStr("createNodeSet");
        List list = createNodeSetStr == null ? null : (createNodeList = StrUtils.splitSmart((String)("EMPTY".equals(createNodeSetStr) ? "" : createNodeSetStr), (String)",", (boolean)true));
        if (createNodeList != null) {
            nodeList = new ArrayList(createNodeList);
            nodeList.retainAll(liveNodes);
            if (message.getBool("createNodeSet.shuffle", true)) {
                Collections.shuffle(nodeList, random);
            }
        } else {
            nodeList = new ArrayList<String>(liveNodes);
            Collections.shuffle(nodeList, random);
        }
        return nodeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ReplicaPosition> identifyNodes(OverseerCollectionMessageHandler ocmh, ClusterState clusterState, List<String> nodeList, String collectionName, ZkNodeProps message, List<String> shardNames, int numNrtReplicas, int numTlogReplicas, int numPullReplicas) throws IOException, InterruptedException {
        List rulesMap = (List)message.get("rule");
        String policyName = message.getStr("policy");
        AutoScalingConfig autoScalingConfig = ocmh.overseer.getSolrCloudManager().getDistribStateManager().getAutoScalingConfig();
        if (rulesMap == null && policyName == null && autoScalingConfig.getPolicy().getClusterPolicy().isEmpty()) {
            log.debug("Identify nodes using default");
            int i = 0;
            ArrayList<ReplicaPosition> result = new ArrayList<ReplicaPosition>();
            for (String aShard : shardNames) {
                for (Map.Entry e2 : ImmutableMap.of((Object)Replica.Type.NRT, (Object)numNrtReplicas, (Object)Replica.Type.TLOG, (Object)numTlogReplicas, (Object)Replica.Type.PULL, (Object)numPullReplicas).entrySet()) {
                    for (int j = 0; j < (Integer)e2.getValue(); ++j) {
                        result.add(new ReplicaPosition(aShard, j, (Replica.Type)e2.getKey(), nodeList.get(i % nodeList.size())));
                        ++i;
                    }
                }
            }
            return result;
        }
        if (numTlogReplicas + numPullReplicas != 0 && rulesMap != null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, Replica.Type.TLOG + " or " + Replica.Type.PULL + " replica types not supported with placement rules or cluster policies");
        }
        if (rulesMap != null && !rulesMap.isEmpty()) {
            ArrayList<Rule> rules = new ArrayList<Rule>();
            for (Object map : rulesMap) {
                rules.add(new Rule((Map)map));
            }
            HashMap<String, Integer> sharVsReplicaCount = new HashMap<String, Integer>();
            for (String shard : shardNames) {
                sharVsReplicaCount.put(shard, numNrtReplicas);
            }
            ReplicaAssigner replicaAssigner = new ReplicaAssigner(rules, sharVsReplicaCount, (List)message.get("snitch"), new HashMap<String, Map<String, Integer>>(), nodeList, ocmh.overseer.getSolrCloudManager(), clusterState);
            Map<ReplicaPosition, String> nodeMappings = replicaAssigner.getNodeMappings();
            return nodeMappings.entrySet().stream().map(e -> new ReplicaPosition(((ReplicaPosition)e.getKey()).shard, ((ReplicaPosition)e.getKey()).index, ((ReplicaPosition)e.getKey()).type, (String)e.getValue())).collect(Collectors.toList());
        }
        if (message.getStr("createNodeSet") == null) {
            nodeList = Collections.emptyList();
        }
        OverseerCollectionMessageHandler overseerCollectionMessageHandler = ocmh;
        synchronized (overseerCollectionMessageHandler) {
            List<ReplicaPosition> list;
            PolicyHelper.SESSION_REF.set(ocmh.policySessionRef);
            try {
                list = Assign.getPositionsUsingPolicy(collectionName, shardNames, numNrtReplicas, numTlogReplicas, numPullReplicas, policyName, ocmh.overseer.getSolrCloudManager(), nodeList);
                PolicyHelper.SESSION_REF.remove();
            }
            catch (Throwable throwable) {
                PolicyHelper.SESSION_REF.remove();
                throw throwable;
            }
            return list;
        }
    }

    public static List<ReplicaCount> getNodesForNewReplicas(ClusterState clusterState, String collectionName, String shard, int nrtReplicas, Object createNodeSet, SolrCloudManager cloudManager) throws IOException, InterruptedException {
        log.debug("getNodesForNewReplicas() shard: {} , replicas : {} , createNodeSet {}", new Object[]{shard, nrtReplicas, createNodeSet});
        DocCollection coll = clusterState.getCollection(collectionName);
        Integer maxShardsPerNode = coll.getMaxShardsPerNode();
        List createNodeList = null;
        createNodeList = createNodeSet instanceof List ? (List)createNodeSet : (createNodeSet == null ? null : StrUtils.splitSmart((String)((String)createNodeSet), (String)",", (boolean)true));
        HashMap<String, ReplicaCount> nodeNameVsShardCount = Assign.getNodeNameVsShardCount(collectionName, clusterState, createNodeList);
        if (createNodeList == null) {
            int availableSlots = 0;
            for (Map.Entry<String, ReplicaCount> ent : nodeNameVsShardCount.entrySet()) {
                if (maxShardsPerNode <= ent.getValue().thisCollectionNodes) continue;
                availableSlots += maxShardsPerNode - ent.getValue().thisCollectionNodes;
            }
            if (availableSlots < nrtReplicas) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Cannot create %d new replicas for collection %s given the current number of live nodes and a maxShardsPerNode of %d", nrtReplicas, collectionName, maxShardsPerNode));
            }
        }
        List l = (List)coll.get("rule");
        List<ReplicaPosition> replicaPositions = null;
        if (l != null) {
            replicaPositions = Assign.getNodesViaRules(clusterState, shard, nrtReplicas, cloudManager, coll, createNodeList, l);
        }
        String policyName = coll.getStr("policy");
        AutoScalingConfig autoScalingConfig = cloudManager.getDistribStateManager().getAutoScalingConfig();
        if (policyName != null || !autoScalingConfig.getPolicy().getClusterPolicy().isEmpty()) {
            replicaPositions = Assign.getPositionsUsingPolicy(collectionName, Collections.singletonList(shard), nrtReplicas, 0, 0, policyName, cloudManager, createNodeList);
        }
        if (replicaPositions != null) {
            ArrayList<ReplicaCount> repCounts = new ArrayList<ReplicaCount>();
            for (ReplicaPosition p : replicaPositions) {
                repCounts.add(new ReplicaCount(p.node));
            }
            return repCounts;
        }
        ArrayList<ReplicaCount> sortedNodeList = new ArrayList<ReplicaCount>(nodeNameVsShardCount.values());
        Collections.sort(sortedNodeList, (x, y) -> x.weight() < y.weight() ? -1 : (x.weight() == y.weight() ? 0 : 1));
        return sortedNodeList;
    }

    public static List<ReplicaPosition> getPositionsUsingPolicy(String collName, List<String> shardNames, int nrtReplicas, int tlogReplicas, int pullReplicas, String policyName, SolrCloudManager cloudManager, List<String> nodesList) throws IOException, InterruptedException {
        log.debug("shardnames {} NRT {} TLOG {} PULL {} , policy {}, nodeList {}", new Object[]{shardNames, nrtReplicas, tlogReplicas, pullReplicas, policyName, nodesList});
        List replicaPositions = null;
        AutoScalingConfig autoScalingConfig = cloudManager.getDistribStateManager().getAutoScalingConfig();
        try {
            Map<String, String> kvMap = Collections.singletonMap(collName, policyName);
            List list = replicaPositions = PolicyHelper.getReplicaLocations((String)collName, (AutoScalingConfig)autoScalingConfig, (SolrCloudManager)cloudManager, kvMap, shardNames, (int)nrtReplicas, (int)tlogReplicas, (int)pullReplicas, nodesList);
            return list;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error closing CloudSolrClient", (Throwable)e);
        }
        finally {
            if (log.isTraceEnabled()) {
                if (replicaPositions != null) {
                    log.trace("REPLICA_POSITIONS: " + Utils.toJSONString((Object)Utils.getDeepCopy((Collection)replicaPositions, (int)7, (boolean)true)));
                }
                log.trace("AUTOSCALING_CONF: " + Utils.toJSONString((Object)autoScalingConfig));
            }
        }
    }

    private static List<ReplicaPosition> getNodesViaRules(ClusterState clusterState, String shard, int numberOfNodes, SolrCloudManager cloudManager, DocCollection coll, List<String> createNodeList, List l) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Object o : l) {
            rules.add(new Rule((Map)o));
        }
        LinkedHashMap<String, Map<String, Integer>> shardVsNodes = new LinkedHashMap<String, Map<String, Integer>>();
        for (Slice slice : coll.getSlices()) {
            LinkedHashMap<String, Integer> n = new LinkedHashMap<String, Integer>();
            shardVsNodes.put(slice.getName(), n);
            for (Replica replica : slice.getReplicas()) {
                Integer count = (Integer)n.get(replica.getNodeName());
                if (count == null) {
                    count = 0;
                }
                count = count + 1;
                n.put(replica.getNodeName(), count);
            }
        }
        List snitches = (List)coll.get("snitch");
        ArrayList<String> nodesList = createNodeList == null ? new ArrayList<String>(clusterState.getLiveNodes()) : createNodeList;
        Map<ReplicaPosition, String> positions = new ReplicaAssigner(rules, Collections.singletonMap(shard, numberOfNodes), snitches, shardVsNodes, nodesList, cloudManager, clusterState).getNodeMappings();
        return positions.entrySet().stream().map(e -> ((ReplicaPosition)e.getKey()).setNode((String)e.getValue())).collect(Collectors.toList());
    }

    private static HashMap<String, ReplicaCount> getNodeNameVsShardCount(String collectionName, ClusterState clusterState, List<String> createNodeList) {
        Set nodes = clusterState.getLiveNodes();
        ArrayList nodeList = new ArrayList(nodes.size());
        nodeList.addAll(nodes);
        if (createNodeList != null) {
            nodeList.retainAll(createNodeList);
        }
        HashMap<String, ReplicaCount> nodeNameVsShardCount = new HashMap<String, ReplicaCount>();
        for (String s : nodeList) {
            nodeNameVsShardCount.put(s, new ReplicaCount(s));
        }
        if (createNodeList != null) {
            if (createNodeList.size() != nodeNameVsShardCount.size()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "At least one of the node(s) specified " + createNodeList + " are not currently active in " + nodeNameVsShardCount.keySet() + ", no action taken.");
            }
            return nodeNameVsShardCount;
        }
        DocCollection coll = clusterState.getCollection(collectionName);
        Integer maxShardsPerNode = coll.getMaxShardsPerNode();
        Map collections = clusterState.getCollectionsMap();
        for (Map.Entry entry : collections.entrySet()) {
            DocCollection c = (DocCollection)entry.getValue();
            for (Slice slice : c.getSlices()) {
                Collection replicas = slice.getReplicas();
                for (Replica replica : replicas) {
                    ReplicaCount count = nodeNameVsShardCount.get(replica.getNodeName());
                    if (count == null) continue;
                    ++count.totalNodes;
                    if (!((String)entry.getKey()).equals(collectionName)) continue;
                    ++count.thisCollectionNodes;
                    if (count.thisCollectionNodes < maxShardsPerNode) continue;
                    nodeNameVsShardCount.remove(replica.getNodeName());
                }
            }
        }
        return nodeNameVsShardCount;
    }

    static class ReplicaCount {
        public final String nodeName;
        public int thisCollectionNodes = 0;
        public int totalNodes = 0;

        ReplicaCount(String nodeName) {
            this.nodeName = nodeName;
        }

        public int weight() {
            return this.thisCollectionNodes * 100 + this.totalNodes;
        }
    }
}

