/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.responseprocessor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardDoc;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.search.Grouping;
import org.apache.solr.search.grouping.distributed.ShardResponseProcessor;
import org.apache.solr.search.grouping.distributed.command.QueryCommandResult;
import org.apache.solr.search.grouping.distributed.shardresultserializer.TopGroupsResultTransformer;

public class TopGroupsShardResponseProcessor
implements ShardResponseProcessor {
    @Override
    public void process(ResponseBuilder rb, ShardRequest shardRequest) {
        Sort groupSort = rb.getGroupingSpec().getGroupSort();
        String[] fields = rb.getGroupingSpec().getFields();
        String[] queries = rb.getGroupingSpec().getQueries();
        Sort withinGroupSort = rb.getGroupingSpec().getSortWithinGroup();
        assert (withinGroupSort != null);
        int groupOffsetDefault = rb.getGroupingSpec().getResponseFormat() == Grouping.Format.simple || rb.getGroupingSpec().isMain() ? 0 : rb.getGroupingSpec().getWithinGroupOffset();
        int docsPerGroupDefault = rb.getGroupingSpec().getWithinGroupLimit();
        HashMap commandTopGroups = new HashMap();
        for (String field : fields) {
            commandTopGroups.put(field, new ArrayList());
        }
        HashMap commandTopDocs = new HashMap();
        for (String query : queries) {
            commandTopDocs.put(query, new ArrayList());
        }
        TopGroupsResultTransformer serializer = new TopGroupsResultTransformer(rb);
        SimpleOrderedMap shardInfo = null;
        if (rb.req.getParams().getBool("shards.info", false)) {
            shardInfo = new SimpleOrderedMap();
            rb.rsp.getValues().add("shards.info", (Object)shardInfo);
        }
        for (ShardResponse srsp : shardRequest.responses) {
            SimpleOrderedMap individualShardInfo = null;
            if (shardInfo != null) {
                individualShardInfo = new SimpleOrderedMap();
                if (srsp.getException() != null) {
                    Throwable t = srsp.getException();
                    if (t instanceof SolrServerException && ((SolrServerException)t).getCause() != null) {
                        t = ((SolrServerException)t).getCause();
                    }
                    individualShardInfo.add("error", (Object)t.toString());
                    StringWriter trace = new StringWriter();
                    t.printStackTrace(new PrintWriter(trace));
                    individualShardInfo.add("trace", (Object)trace.toString());
                }
                if (srsp.getSolrResponse() != null) {
                    individualShardInfo.add("time", (Object)srsp.getSolrResponse().getElapsedTime());
                }
                if (srsp.getShardAddress() != null) {
                    individualShardInfo.add("shardAddress", (Object)srsp.getShardAddress());
                }
                shardInfo.add(srsp.getShard(), (Object)individualShardInfo);
            }
            if (rb.req.getParams().getBool("shards.tolerant", false) && srsp.getException() != null) {
                if (rb.rsp.getResponseHeader().get("partialResults") != null) continue;
                rb.rsp.getResponseHeader().add("partialResults", (Object)Boolean.TRUE);
                continue;
            }
            NamedList secondPhaseResult = (NamedList)srsp.getSolrResponse().getResponse().get("secondPhase");
            if (secondPhaseResult == null) continue;
            Object result = serializer.transformToNative(secondPhaseResult, groupSort, withinGroupSort, srsp.getShard());
            int numFound = 0;
            float maxScore = Float.NaN;
            for (String field : commandTopGroups.keySet()) {
                TopGroups topGroups = (TopGroups)result.get(field);
                if (topGroups == null) continue;
                if (individualShardInfo != null) {
                    numFound += topGroups.totalHitCount;
                    if (Float.isNaN(maxScore) || topGroups.maxScore > maxScore) {
                        maxScore = topGroups.maxScore;
                    }
                }
                ((List)commandTopGroups.get(field)).add(topGroups);
            }
            for (String query : queries) {
                QueryCommandResult queryCommandResult = (QueryCommandResult)result.get(query);
                if (individualShardInfo != null) {
                    numFound += queryCommandResult.getMatches();
                    float thisMax = queryCommandResult.getTopDocs().getMaxScore();
                    if (Float.isNaN(maxScore) || thisMax > maxScore) {
                        maxScore = thisMax;
                    }
                }
                ((List)commandTopDocs.get(query)).add(queryCommandResult);
            }
            if (individualShardInfo == null) continue;
            individualShardInfo.add("numFound", (Object)numFound);
            individualShardInfo.add("maxScore", (Object)Float.valueOf(maxScore));
        }
        for (String groupField : commandTopGroups.keySet()) {
            List topGroups = (List)commandTopGroups.get(groupField);
            if (topGroups.isEmpty()) continue;
            TopGroups[] topGroupsArr = new TopGroups[topGroups.size()];
            int docsPerGroup = docsPerGroupDefault;
            if (docsPerGroup < 0) {
                docsPerGroup = 0;
                for (TopGroups subTopGroups : topGroups) {
                    docsPerGroup += subTopGroups.totalGroupedHitCount;
                }
            }
            rb.mergedTopGroups.put(groupField, (TopGroups<BytesRef>)TopGroups.merge((TopGroups[])topGroups.toArray(topGroupsArr), (Sort)groupSort, (Sort)withinGroupSort, (int)groupOffsetDefault, (int)docsPerGroup, (TopGroups.ScoreMergeMode)TopGroups.ScoreMergeMode.None));
        }
        for (String query : commandTopDocs.keySet()) {
            List queryCommandResults = (List)commandTopDocs.get(query);
            ArrayList<TopDocs> topDocs = new ArrayList<TopDocs>(queryCommandResults.size());
            int mergedMatches = 0;
            for (QueryCommandResult queryCommandResult : queryCommandResults) {
                topDocs.add(queryCommandResult.getTopDocs());
                mergedMatches += queryCommandResult.getMatches();
            }
            int topN = rb.getGroupingSpec().getOffset() + rb.getGroupingSpec().getLimit();
            Object mergedTopDocs = withinGroupSort.equals((Object)Sort.RELEVANCE) ? TopDocs.merge((int)topN, (TopDocs[])topDocs.toArray(new TopDocs[topDocs.size()])) : TopDocs.merge((Sort)withinGroupSort, (int)topN, (TopFieldDocs[])topDocs.toArray(new TopFieldDocs[topDocs.size()]));
            rb.mergedQueryCommandResults.put(query, new QueryCommandResult((TopDocs)mergedTopDocs, mergedMatches));
        }
        HashMap<Object, ShardDoc> resultIds = new HashMap<Object, ShardDoc>();
        int i = 0;
        for (TopGroups<BytesRef> topGroups : rb.mergedTopGroups.values()) {
            for (GroupDocs group : topGroups.groups) {
                for (ScoreDoc scoreDoc : group.scoreDocs) {
                    ShardDoc solrDoc = (ShardDoc)scoreDoc;
                    if (resultIds.containsKey(solrDoc.id)) continue;
                    solrDoc.positionInResponse = i++;
                    resultIds.put(solrDoc.id, solrDoc);
                }
            }
        }
        for (QueryCommandResult queryCommandResult : rb.mergedQueryCommandResults.values()) {
            for (ScoreDoc scoreDoc : queryCommandResult.getTopDocs().scoreDocs) {
                ShardDoc solrDoc = (ShardDoc)scoreDoc;
                solrDoc.positionInResponse = i++;
                resultIds.put(solrDoc.id, solrDoc);
            }
        }
        rb.resultIds = resultIds;
    }
}

