/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.util.LightWeightLinkedSet;

class UnderReplicatedBlocks
implements Iterable<Block> {
    static final int LEVEL = 5;
    static final int QUEUE_HIGHEST_PRIORITY = 0;
    static final int QUEUE_VERY_UNDER_REPLICATED = 1;
    static final int QUEUE_UNDER_REPLICATED = 2;
    static final int QUEUE_REPLICAS_BADLY_DISTRIBUTED = 3;
    static final int QUEUE_WITH_CORRUPT_BLOCKS = 4;
    private final List<LightWeightLinkedSet<Block>> priorityQueues = new ArrayList<LightWeightLinkedSet<Block>>();
    private Map<Integer, Integer> priorityToReplIdx = new HashMap<Integer, Integer>(5);
    private int corruptReplOneBlocks = 0;

    UnderReplicatedBlocks() {
        for (int i = 0; i < 5; ++i) {
            this.priorityQueues.add(new LightWeightLinkedSet());
            this.priorityToReplIdx.put(i, 0);
        }
    }

    synchronized void clear() {
        for (int i = 0; i < 5; ++i) {
            this.priorityQueues.get(i).clear();
        }
        this.corruptReplOneBlocks = 0;
    }

    synchronized int size() {
        int size = 0;
        for (int i = 0; i < 5; ++i) {
            size += this.priorityQueues.get(i).size();
        }
        return size;
    }

    synchronized int getUnderReplicatedBlockCount() {
        int size = 0;
        for (int i = 0; i < 5; ++i) {
            if (i == 4) continue;
            size += this.priorityQueues.get(i).size();
        }
        return size;
    }

    synchronized int getCorruptBlockSize() {
        return this.priorityQueues.get(4).size();
    }

    synchronized int getCorruptReplOneBlockSize() {
        return this.corruptReplOneBlocks;
    }

    synchronized boolean contains(Block block) {
        for (LightWeightLinkedSet<Block> set : this.priorityQueues) {
            if (!set.contains(block)) continue;
            return true;
        }
        return false;
    }

    private int getPriority(Block block, int curReplicas, int decommissionedReplicas, int expectedReplicas) {
        assert (curReplicas >= 0) : "Negative replicas!";
        if (curReplicas >= expectedReplicas) {
            return 3;
        }
        if (curReplicas == 0) {
            if (decommissionedReplicas > 0) {
                return 0;
            }
            return 4;
        }
        if (curReplicas == 1) {
            return 0;
        }
        if (curReplicas * 3 < expectedReplicas) {
            return 1;
        }
        return 2;
    }

    synchronized boolean add(Block block, int curReplicas, int decomissionedReplicas, int expectedReplicas) {
        assert (curReplicas >= 0) : "Negative replicas!";
        int priLevel = this.getPriority(block, curReplicas, decomissionedReplicas, expectedReplicas);
        if (this.priorityQueues.get(priLevel).add(block)) {
            if (priLevel == 4 && expectedReplicas == 1) {
                ++this.corruptReplOneBlocks;
            }
            NameNode.blockStateChangeLog.debug("BLOCK* NameSystem.UnderReplicationBlock.add: {} has only {} replicas and need {} replicas so is added to neededReplications at priority level {}", new Object[]{block, curReplicas, expectedReplicas, priLevel});
            return true;
        }
        return false;
    }

    synchronized boolean remove(Block block, int oldReplicas, int decommissionedReplicas, int oldExpectedReplicas) {
        int priLevel = this.getPriority(block, oldReplicas, decommissionedReplicas, oldExpectedReplicas);
        boolean removedBlock = this.remove(block, priLevel);
        if (priLevel == 4 && oldExpectedReplicas == 1 && removedBlock) {
            --this.corruptReplOneBlocks;
            assert (this.corruptReplOneBlocks >= 0) : "Number of corrupt blocks with replication factor 1 should be non-negative";
        }
        return removedBlock;
    }

    boolean remove(Block block, int priLevel) {
        if (priLevel >= 0 && priLevel < 5 && this.priorityQueues.get(priLevel).remove(block)) {
            NameNode.blockStateChangeLog.debug("BLOCK* NameSystem.UnderReplicationBlock.remove: Removing block {} from priority queue {}", (Object)block, (Object)priLevel);
            return true;
        }
        for (int i = 0; i < 5; ++i) {
            if (!this.priorityQueues.get(i).remove(block)) continue;
            NameNode.blockStateChangeLog.debug("BLOCK* NameSystem.UnderReplicationBlock.remove: Removing block {} from priority queue {}", (Object)block, (Object)priLevel);
            return true;
        }
        return false;
    }

    synchronized void update(Block block, int curReplicas, int decommissionedReplicas, int curExpectedReplicas, int curReplicasDelta, int expectedReplicasDelta) {
        int oldReplicas = curReplicas - curReplicasDelta;
        int oldExpectedReplicas = curExpectedReplicas - expectedReplicasDelta;
        int curPri = this.getPriority(block, curReplicas, decommissionedReplicas, curExpectedReplicas);
        int oldPri = this.getPriority(block, oldReplicas, decommissionedReplicas, oldExpectedReplicas);
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("UnderReplicationBlocks.update " + block + " curReplicas " + curReplicas + " curExpectedReplicas " + curExpectedReplicas + " oldReplicas " + oldReplicas + " oldExpectedReplicas  " + oldExpectedReplicas + " curPri  " + curPri + " oldPri  " + oldPri);
        }
        this.remove(block, oldPri);
        if (this.priorityQueues.get(curPri).add(block)) {
            NameNode.blockStateChangeLog.debug("BLOCK* NameSystem.UnderReplicationBlock.update: {} has only {} replicas and needs {} replicas so is added to neededReplications at priority level {}", new Object[]{block, curReplicas, curExpectedReplicas, curPri});
        }
        if (oldPri != curPri || expectedReplicasDelta != 0) {
            if (curPri == 4 && curExpectedReplicas == 1) {
                ++this.corruptReplOneBlocks;
            } else if (oldPri == 4 && curExpectedReplicas - expectedReplicasDelta == 1) {
                --this.corruptReplOneBlocks;
            }
        }
    }

    public synchronized List<List<Block>> chooseUnderReplicatedBlocks(int blocksToProcess) {
        ArrayList<List<Block>> blocksToReplicate = new ArrayList<List<Block>>(5);
        for (int i = 0; i < 5; ++i) {
            blocksToReplicate.add(new ArrayList());
        }
        if (this.size() == 0) {
            return blocksToReplicate;
        }
        int blockCount = 0;
        for (int priority = 0; priority < 5; ++priority) {
            int i;
            BlockIterator neededReplicationsIterator = this.iterator(priority);
            Integer replIndex = this.priorityToReplIdx.get(priority);
            for (i = 0; i < replIndex && neededReplicationsIterator.hasNext(); ++i) {
                neededReplicationsIterator.next();
            }
            if (blockCount == (blocksToProcess = Math.min(blocksToProcess, this.size()))) break;
            while (blockCount < blocksToProcess && neededReplicationsIterator.hasNext()) {
                Block block = neededReplicationsIterator.next();
                ((List)blocksToReplicate.get(priority)).add(block);
                Integer n = replIndex;
                Integer n2 = replIndex = Integer.valueOf(replIndex + 1);
                ++blockCount;
            }
            if (!neededReplicationsIterator.hasNext() && neededReplicationsIterator.getPriority() == 4) {
                for (i = 0; i < 5; ++i) {
                    this.priorityToReplIdx.put(i, 0);
                }
                break;
            }
            this.priorityToReplIdx.put(priority, replIndex);
        }
        return blocksToReplicate;
    }

    synchronized BlockIterator iterator(int level) {
        return new BlockIterator(level);
    }

    public synchronized BlockIterator iterator() {
        return new BlockIterator();
    }

    public void decrementReplicationIndex(int priority) {
        Integer replIdx = this.priorityToReplIdx.get(priority);
        replIdx = replIdx - 1;
        this.priorityToReplIdx.put(priority, replIdx);
    }

    class BlockIterator
    implements Iterator<Block> {
        private int level;
        private boolean isIteratorForLevel = false;
        private final List<Iterator<Block>> iterators = new ArrayList<Iterator<Block>>();

        private BlockIterator() {
            this.level = 0;
            for (int i = 0; i < 5; ++i) {
                this.iterators.add(((LightWeightLinkedSet)UnderReplicatedBlocks.this.priorityQueues.get(i)).iterator());
            }
        }

        private BlockIterator(int l) {
            this.level = l;
            this.isIteratorForLevel = true;
            this.iterators.add(((LightWeightLinkedSet)UnderReplicatedBlocks.this.priorityQueues.get(this.level)).iterator());
        }

        private void update() {
            if (this.isIteratorForLevel) {
                return;
            }
            while (this.level < 4 && !this.iterators.get(this.level).hasNext()) {
                ++this.level;
            }
        }

        @Override
        public Block next() {
            if (this.isIteratorForLevel) {
                return this.iterators.get(0).next();
            }
            this.update();
            return this.iterators.get(this.level).next();
        }

        @Override
        public boolean hasNext() {
            if (this.isIteratorForLevel) {
                return this.iterators.get(0).hasNext();
            }
            this.update();
            return this.iterators.get(this.level).hasNext();
        }

        @Override
        public void remove() {
            if (this.isIteratorForLevel) {
                this.iterators.get(0).remove();
            } else {
                this.iterators.get(this.level).remove();
            }
        }

        int getPriority() {
            return this.level;
        }
    }
}

