/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import java.util.HashMap;
import java.util.Map;
import org.carrot2.core.ComponentInitializationException;
import org.carrot2.core.IControllerContext;
import org.carrot2.core.IProcessingComponent;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Processing;
import org.carrot2.shaded.guava.common.base.Predicate;
import org.carrot2.shaded.guava.common.base.Predicates;
import org.carrot2.shaded.guava.common.collect.Maps;
import org.carrot2.util.attribute.AttributeBinder;
import org.carrot2.util.attribute.AttributeBindingException;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Output;

final class ControllerUtils {
    private ControllerUtils() {
    }

    public static void init(IProcessingComponent processingComponent, Map<String, Object> inputAttributes, Map<String, Object> outputAttributes, boolean checkRequiredAttributes, IControllerContext context) throws ComponentInitializationException {
        try {
            AttributeBinder.set((Object)processingComponent, inputAttributes, (boolean)checkRequiredAttributes, (Class[])new Class[]{Input.class, Init.class});
            processingComponent.init(context);
            AttributeBinder.get((Object)processingComponent, outputAttributes, (Class[])new Class[]{Output.class, Init.class});
        }
        catch (InstantiationException e) {
            throw new ComponentInitializationException("Attribute binding failed", e);
        }
    }

    public static void beforeProcessing(IProcessingComponent processingComponent, Map<String, Object> attributes) throws ProcessingException {
        try {
            if (processingComponent.getClass().getAnnotation(Bindable.class) != null) {
                AttributeBinder.set((Object)processingComponent, attributes, (Class[])new Class[]{Input.class, Processing.class});
            }
            processingComponent.beforeProcessing();
        }
        catch (InstantiationException e) {
            throw new ProcessingException("Attribute binding failed: " + e.getMessage(), e);
        }
        catch (AttributeBindingException e) {
            throw new ProcessingException("Attribute binding failed: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performProcessing(IProcessingComponent processingComponent, Map<String, Object> inputAttributes, Map<String, Object> outputAttributes) {
        try {
            ControllerUtils.beforeProcessing(processingComponent, inputAttributes);
            processingComponent.process();
        }
        finally {
            ControllerUtils.afterProcessing(processingComponent, outputAttributes);
        }
    }

    public static void afterProcessing(IProcessingComponent processingComponent, Map<String, Object> attributes) {
        try {
            processingComponent.afterProcessing();
            HashMap outputAttributesWithNulls = Maps.newHashMap();
            if (processingComponent.getClass().getAnnotation(Bindable.class) != null) {
                AttributeBinder.get((Object)processingComponent, (Map)outputAttributesWithNulls, (Class[])new Class[]{Output.class, Processing.class});
            }
            attributes.putAll(Maps.filterValues((Map)outputAttributesWithNulls, (Predicate)Predicates.notNull()));
        }
        catch (InstantiationException e) {
            throw new ProcessingException("Attribute binding failed", e);
        }
    }
}

