/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.trello;

import com.intellij.tasks.trello.model.TrelloLabel;
import com.intellij.util.ui.UIUtil;
import icons.TasksCoreIcons;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class TrelloIconBuilder {
    private final Map<Set<TrelloLabel.LabelColor>, Image> CACHE = new HashMap<Set<TrelloLabel.LabelColor>, Image>();
    public static final double SQRT_2 = Math.sqrt(2.0);
    private final int size;

    public TrelloIconBuilder(int size) {
        this.size = size;
    }

    public Icon buildIcon(Set<TrelloLabel.LabelColor> colorSet) {
        if (colorSet.isEmpty()) {
            return TasksCoreIcons.Trello;
        }
        Image image = this.CACHE.get(colorSet);
        if (image == null) {
            BufferedImage bufferedImage = UIUtil.createImage((int)this.size, (int)this.size, (int)2);
            int adjustedSize = this.size - 1;
            int nStripes = colorSet.size();
            Graphics2D g2d = bufferedImage.createGraphics();
            double diag = (double)adjustedSize * SQRT_2;
            double stripeWidth = diag / (double)nStripes;
            RoundRectangle2D.Double baseRectangle = new RoundRectangle2D.Double(0.0, 0.0, adjustedSize, adjustedSize, 2.0, 2.0);
            ArrayList<TrelloLabel.LabelColor> colorsList = new ArrayList<TrelloLabel.LabelColor>(colorSet);
            for (int i = 0; i < nStripes; ++i) {
                Color color = colorsList.get(i).getColor();
                Area stripe = new Area(new Rectangle2D.Double(-diag / 2.0, (double)i * stripeWidth, diag, stripeWidth));
                stripe.transform(AffineTransform.getRotateInstance(-0.7853981633974483, 0.0, 0.0));
                stripe.intersect(new Area(baseRectangle));
                g2d.setPaint(color);
                g2d.fill(stripe);
            }
            g2d.setPaint(Color.BLACK);
            g2d.draw(baseRectangle);
            image = bufferedImage;
            this.CACHE.put(colorSet, image);
        }
        return new ImageIcon(image);
    }
}

