/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rollback;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitSimpleHandler;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitUntrackedFilesHolder;
import git4idea.util.GitFileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GitRollbackEnvironment
implements RollbackEnvironment {
    private final Project myProject;

    public GitRollbackEnvironment(@NotNull Project project) {
        if (project == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public String getRollbackOperationName() {
        String string = GitBundle.getString("revert.action.name");
        if (string == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void rollbackModifiedWithoutCheckout(@NotNull List<VirtualFile> files, List<VcsException> exceptions, RollbackProgressListener listener2) {
        if (files == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(2);
        }
        throw new UnsupportedOperationException("Explicit file checkout is not supported by GIT.");
    }

    public void rollbackMissingFileDeletion(@NotNull List<FilePath> files, List<VcsException> exceptions, RollbackProgressListener listener2) {
        if (files == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(3);
        }
        throw new UnsupportedOperationException("Missing file delete is not reported by GIT.");
    }

    public void rollbackIfUnchanged(@NotNull VirtualFile file) {
        if (file == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackChanges(@NotNull List<Change> changes, List<VcsException> exceptions, @NotNull RollbackProgressListener listener2) {
        if (changes == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(5);
        }
        if (listener2 == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(6);
        }
        HashMap<VirtualFile, List<FilePath>> toUnindex = new HashMap<VirtualFile, List<FilePath>>();
        HashMap<VirtualFile, List<FilePath>> toUnversion = new HashMap<VirtualFile, List<FilePath>>();
        HashMap<VirtualFile, List<FilePath>> toRevert = new HashMap<VirtualFile, List<FilePath>>();
        ArrayList<FilePath> toDelete = new ArrayList<FilePath>();
        listener2.determinate();
        for (Change change : changes) {
            switch (change.getType()) {
                case NEW: {
                    GitRollbackEnvironment.registerFile(toUnversion, change.getAfterRevision().getFile(), exceptions);
                    break;
                }
                case MOVED: {
                    GitRollbackEnvironment.registerFile(toRevert, change.getBeforeRevision().getFile(), exceptions);
                    GitRollbackEnvironment.registerFile(toUnindex, change.getAfterRevision().getFile(), exceptions);
                    toDelete.add(change.getAfterRevision().getFile());
                    break;
                }
                case MODIFICATION: {
                    GitRollbackEnvironment.registerFile(toUnindex, change.getBeforeRevision().getFile(), exceptions);
                    GitRollbackEnvironment.registerFile(toRevert, change.getBeforeRevision().getFile(), exceptions);
                    break;
                }
                case DELETED: {
                    GitRollbackEnvironment.registerFile(toRevert, change.getBeforeRevision().getFile(), exceptions);
                }
            }
        }
        for (Map.Entry entry : toUnindex.entrySet()) {
            listener2.accept((List)entry.getValue());
            try {
                this.unindex((VirtualFile)entry.getKey(), (List)entry.getValue(), false);
            }
            catch (VcsException vcsException) {
                exceptions.add(vcsException);
            }
        }
        for (Map.Entry entry : toUnversion.entrySet()) {
            listener2.accept((List)entry.getValue());
            try {
                this.unindex((VirtualFile)entry.getKey(), (List)entry.getValue(), true);
            }
            catch (VcsException vcsException) {
                exceptions.add(vcsException);
            }
        }
        for (FilePath filePath : toDelete) {
            listener2.accept(filePath);
            try {
                File file = filePath.getIOFile();
                if (!file.exists() || file.delete()) continue;
                exceptions.add(new VcsException("Unable to delete file: " + filePath));
            }
            catch (Exception exception) {
                exceptions.add(new VcsException("Unable to delete file: " + filePath, (Throwable)exception));
            }
        }
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.myProject);
        try {
            for (Map.Entry<VirtualFile, List<FilePath>> entry : toRevert.entrySet()) {
                listener2.accept(entry.getValue());
                try {
                    this.revert(entry.getKey(), entry.getValue());
                }
                catch (VcsException e) {
                    exceptions.add(e);
                }
            }
        }
        finally {
            token.finish();
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        HashSet<File> hashSet = new HashSet<File>();
        for (Change c : changes) {
            ContentRevision after;
            ContentRevision before = c.getBeforeRevision();
            if (before != null) {
                hashSet.add(new File(before.getFile().getPath()));
            }
            if ((after = c.getAfterRevision()) == null) continue;
            hashSet.add(new File(after.getFile().getPath()));
        }
        localFileSystem.refreshIoFiles(hashSet);
        for (GitRepository repo : GitUtil.getRepositoryManager(this.myProject).getRepositories()) {
            repo.update();
        }
    }

    public void revert(VirtualFile root, List<FilePath> files) throws VcsException {
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitSimpleHandler handler = new GitSimpleHandler(this.myProject, root, GitCommand.CHECKOUT);
            handler.addParameters("HEAD");
            handler.endOptions();
            handler.addParameters(paths);
            handler.run();
        }
    }

    private void unindex(VirtualFile root, List<FilePath> files, boolean toUnversioned) throws VcsException {
        GitFileUtils.delete(this.myProject, root, files, "--cached", "-f");
        if (toUnversioned) {
            GitRepository repo = (GitRepository)GitUtil.getRepositoryManager(this.myProject).getRepositoryForRoot(root);
            GitUntrackedFilesHolder untrackedFilesHolder = repo == null ? null : repo.getUntrackedFilesHolder();
            for (FilePath path : files) {
                VirtualFile vf = VcsUtil.getVirtualFile((File)path.getIOFile());
                if (untrackedFilesHolder == null || vf == null) continue;
                untrackedFilesHolder.add(vf);
            }
        }
    }

    private static void registerFile(Map<VirtualFile, List<FilePath>> files, FilePath file, List<VcsException> exceptions) {
        VirtualFile root;
        try {
            root = GitUtil.getGitRoot(file);
        }
        catch (VcsException e) {
            exceptions.add(e);
            return;
        }
        List<FilePath> paths = files.get(root);
        if (paths == null) {
            paths = new ArrayList<FilePath>();
            files.put(root, paths);
        }
        paths.add(file);
    }

    public static GitRollbackEnvironment getInstance(Project project) {
        return (GitRollbackEnvironment)PeriodicalTasksCloser.getInstance().safeGetService(project, GitRollbackEnvironment.class);
    }

    public static void resetHardLocal(Project project, VirtualFile root) {
        GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.RESET);
        handler.addParameters("--hard");
        handler.endOptions();
        GitHandlerUtil.runInCurrentThread(handler, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/rollback/GitRollbackEnvironment";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/rollback/GitRollbackEnvironment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRollbackOperationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "rollbackModifiedWithoutCheckout";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "rollbackMissingFileDeletion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "rollbackIfUnchanged";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "rollbackChanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

