/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.ui.WindowWrapperBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.config.GitVersion;
import git4idea.repo.GitRepositoryImpl;
import git4idea.repo.GitRepositoryManager;
import java.awt.BorderLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitShowExternalLogAction
extends DumbAwareAction {
    private static final String EXTERNAL = "EXTERNAL";

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && GitVcs.getInstance(e.getProject()) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        GitVcs vcs = (GitVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)GitVcs.getInstance(project))));
        List<VirtualFile> roots = GitShowExternalLogAction.getGitRootsFromUser(project);
        if (roots.isEmpty()) {
            return;
        }
        if (project.isDefault() || !ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss()) {
            ProgressManager.getInstance().run((Task)new ShowLogInDialogTask(project, roots, vcs));
            return;
        }
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
        Runnable showContent = () -> {
            ContentManager cm = window.getContentManager();
            if (GitShowExternalLogAction.checkIfProjectLogMatches(project, vcs, cm, roots) || GitShowExternalLogAction.checkIfAlreadyOpened(cm, roots)) {
                return;
            }
            String tabName = GitShowExternalLogAction.calcTabName(cm, roots);
            MyContentComponent component = GitShowExternalLogAction.createManagerAndContent(project, vcs, roots, tabName);
            Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)component, tabName, false);
            content.setDisposer(component.myDisposable);
            content.setDescription("Log for " + StringUtil.join((Collection)roots, VirtualFile::getPath, (String)"\n"));
            content.setCloseable(true);
            cm.addContent(content);
            cm.setSelectedContent(content);
        };
        if (!window.isVisible()) {
            window.activate(showContent, true);
        } else {
            showContent.run();
        }
    }

    @NotNull
    private static MyContentComponent createManagerAndContent(@NotNull Project project, @NotNull GitVcs vcs, @NotNull List<VirtualFile> roots, @Nullable String tabName) {
        if (project == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(2);
        }
        if (vcs == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(3);
        }
        if (roots == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(4);
        }
        GitRepositoryManager repositoryManager = GitRepositoryManager.getInstance(project);
        for (VirtualFile root2 : roots) {
            repositoryManager.addExternalRepository(root2, GitRepositoryImpl.getInstance(root2, project, true));
        }
        VcsLogManager manager = new VcsLogManager(project, (VcsLogTabsProperties)ServiceManager.getService((Project)project, VcsLogTabsProperties.class), (Collection)ContainerUtil.map(roots, root -> {
            if (vcs == null) {
                GitShowExternalLogAction.$$$reportNull$$$0(25);
            }
            return new VcsRoot((AbstractVcs)vcs, root);
        }));
        Disposable disposable = () -> {
            if (roots == null) {
                GitShowExternalLogAction.$$$reportNull$$$0(23);
            }
            manager.dispose(() -> {
                if (roots == null) {
                    GitShowExternalLogAction.$$$reportNull$$$0(24);
                }
                for (VirtualFile root : roots) {
                    repositoryManager.removeExternalRepository(root);
                }
            });
        };
        VcsLogUiImpl ui = manager.createLogUi(GitShowExternalLogAction.calcLogId(roots), tabName);
        Disposer.register((Disposable)disposable, (Disposable)ui);
        MyContentComponent myContentComponent = new MyContentComponent((JComponent)new VcsLogPanel(manager, (AbstractVcsLogUi)ui), roots, disposable);
        if (myContentComponent == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(5);
        }
        return myContentComponent;
    }

    @NotNull
    private static String calcLogId(@NotNull List<VirtualFile> roots) {
        if (roots == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(6);
        }
        String string = "EXTERNAL " + StringUtil.join(roots, VirtualFile::getPath, (String)File.pathSeparator);
        if (string == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static String calcTabName(@NotNull ContentManager cm, @NotNull List<VirtualFile> roots) {
        if (cm == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(8);
        }
        if (roots == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(9);
        }
        String name = "Log (" + roots.get(0).getName();
        if (roots.size() > 1) {
            name = name + "+";
        }
        String candidate = name = name + ")";
        int cnt = 1;
        while (GitShowExternalLogAction.hasContentsWithName(cm, candidate)) {
            candidate = name + "-" + cnt;
            ++cnt;
        }
        String string = candidate;
        if (string == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static boolean hasContentsWithName(@NotNull ContentManager cm, @NotNull String candidate) {
        if (cm == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(11);
        }
        if (candidate == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(12);
        }
        return ContainerUtil.exists((Object[])cm.getContents(), content -> {
            if (candidate == null) {
                GitShowExternalLogAction.$$$reportNull$$$0(22);
            }
            return content.getDisplayName().equals(candidate);
        });
    }

    @NotNull
    private static List<VirtualFile> getGitRootsFromUser(@NotNull Project project) {
        FileChooserDescriptor descriptor;
        VirtualFile[] virtualFiles;
        if (project == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(13);
        }
        if ((virtualFiles = FileChooser.chooseFiles((FileChooserDescriptor)(descriptor = new FileChooserDescriptor(false, true, false, true, false, true)), (Project)project, null)).length == 0) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                GitShowExternalLogAction.$$$reportNull$$$0(14);
            }
            return list;
        }
        ArrayList correctRoots = ContainerUtil.newArrayList();
        for (VirtualFile vf : virtualFiles) {
            if (!GitUtil.isGitRoot(new File(vf.getPath()))) continue;
            correctRoots.add(vf);
        }
        ArrayList arrayList = correctRoots;
        if (arrayList == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static boolean checkIfProjectLogMatches(@NotNull Project project, @NotNull GitVcs vcs, @NotNull ContentManager cm, @NotNull List<VirtualFile> requestedRoots) {
        VirtualFile[] projectRoots;
        if (project == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(16);
        }
        if (vcs == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(17);
        }
        if (cm == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(18);
        }
        if (requestedRoots == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(19);
        }
        if (Comparing.haveEqualElements(requestedRoots, Arrays.asList(projectRoots = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs)))) {
            Content[] contents;
            for (Content content : contents = cm.getContents()) {
                if (!"Log".equals(content.getDisplayName())) continue;
                cm.setSelectedContent(content);
                return true;
            }
        }
        return false;
    }

    private static boolean checkIfAlreadyOpened(@NotNull ContentManager cm, @NotNull Collection<VirtualFile> roots) {
        if (cm == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(20);
        }
        if (roots == null) {
            GitShowExternalLogAction.$$$reportNull$$$0(21);
        }
        for (Content content : cm.getContents()) {
            JComponent component = content.getComponent();
            if (!(component instanceof MyContentComponent) || !Comparing.haveEqualElements(roots, (Collection)((MyContentComponent)component).myRoots)) continue;
            cm.setSelectedContent(content);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/log/GitShowExternalLogAction";
                break;
            }
            case 8: 
            case 11: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cm";
                break;
            }
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/log/GitShowExternalLogAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createManagerAndContent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "calcLogId";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "calcTabName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getGitRootsFromUser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createManagerAndContent";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 15: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calcLogId";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calcTabName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasContentsWithName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getGitRootsFromUser";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkIfProjectLogMatches";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkIfAlreadyOpened";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$hasContentsWithName$4";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createManagerAndContent$3";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createManagerAndContent$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ShowLogInDialogTask
    extends Task.Backgroundable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final List<VirtualFile> myRoots;
        @NotNull
        private final GitVcs myVcs;
        private GitVersion myVersion;

        private ShowLogInDialogTask(@NotNull Project project, @NotNull List<VirtualFile> roots, @NotNull GitVcs vcs) {
            if (project == null) {
                ShowLogInDialogTask.$$$reportNull$$$0(0);
            }
            if (roots == null) {
                ShowLogInDialogTask.$$$reportNull$$$0(1);
            }
            if (vcs == null) {
                ShowLogInDialogTask.$$$reportNull$$$0(2);
            }
            super(project, "Loading Git Log...", true);
            this.myProject = project;
            this.myRoots = roots;
            this.myVcs = vcs;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                ShowLogInDialogTask.$$$reportNull$$$0(3);
            }
            this.myVersion = this.myVcs.getVersion();
            if (this.myVersion.isNull()) {
                this.myVcs.checkVersion();
                this.myVersion = this.myVcs.getVersion();
            }
        }

        public void onSuccess() {
            if (!this.myVersion.isNull() && !this.myProject.isDisposed()) {
                MyContentComponent content = GitShowExternalLogAction.createManagerAndContent(this.myProject, this.myVcs, this.myRoots, null);
                WindowWrapper window = new WindowWrapperBuilder(WindowWrapper.Mode.FRAME, (JComponent)content).setProject(this.myProject).setTitle("Git Log").setPreferredFocusedComponent((JComponent)content).setDimensionServiceKey(GitShowExternalLogAction.class.getName()).build();
                Disposer.register((Disposable)window, (Disposable)content.myDisposable);
                window.show();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vcs";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "git4idea/log/GitShowExternalLogAction$ShowLogInDialogTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyContentComponent
    extends JPanel {
        @NotNull
        private final Collection<VirtualFile> myRoots;
        @NotNull
        private final Disposable myDisposable;

        MyContentComponent(@NotNull JComponent actualComponent, @NotNull Collection<VirtualFile> roots, @NotNull Disposable disposable) {
            if (actualComponent == null) {
                MyContentComponent.$$$reportNull$$$0(0);
            }
            if (roots == null) {
                MyContentComponent.$$$reportNull$$$0(1);
            }
            if (disposable == null) {
                MyContentComponent.$$$reportNull$$$0(2);
            }
            super(new BorderLayout());
            this.myDisposable = disposable;
            this.myRoots = roots;
            this.add(actualComponent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "actualComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "roots";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "disposable";
                    break;
                }
            }
            objectArray[1] = "git4idea/log/GitShowExternalLogAction$MyContentComponent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

