/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.LogDataImpl;
import com.intellij.vcs.log.util.StopWatch;
import git4idea.GitCommit;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitTextHandler;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitLogOutputSplitter;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogRecordCollector;
import git4idea.log.GitLogProvider;
import git4idea.log.GitRefManager;
import git4idea.util.GitUIUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLogUtil {
    private static final Logger LOG = Logger.getInstance(GitLogUtil.class);
    public static final String GRAFTED = "grafted";
    public static final String REPLACED = "replaced";
    public static final List<String> LOG_ALL = Arrays.asList("HEAD", "--branches", "--remotes", "--tags");
    public static final String STDIN = "--stdin";

    @NotNull
    public static List<? extends VcsShortCommitDetails> collectShortDetails(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> hashes2) throws VcsException {
        VcsLogObjectsFactory factory;
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(1);
        }
        if (hashes2 == null) {
            GitLogUtil.$$$reportNull$$$0(2);
        }
        if ((factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                GitLogUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        GitLineHandler h = GitLogUtil.createGitHandler(project, root);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.NONE, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.AUTHOR_TIME);
        h.setSilent(true);
        h.addParameters("--no-walk");
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h.addParameters(new ArrayList<String>(hashes2));
        h.endOptions();
        ArrayList result2 = ContainerUtil.newArrayList();
        GitLogOutputSplitter handlerListener = new GitLogOutputSplitter(h, (Consumer<StringBuilder>)((Consumer)output -> {
            if (root == null) {
                GitLogUtil.$$$reportNull$$$0(101);
            }
            List<GitLogRecord> records = parser.parse((CharSequence)output);
            for (GitLogRecord record : records) {
                SmartList parents = new SmartList();
                for (String parent : record.getParentsHashes()) {
                    parents.add(HashImpl.build((String)parent));
                }
                record.setUsedHandler(h);
                result2.add(factory.createShortDetails(HashImpl.build((String)record.getHash()), (List)parents, record.getCommitTime(), root, record.getSubject(), record.getAuthorName(), record.getAuthorEmail(), record.getCommitterName(), record.getCommitterEmail(), record.getAuthorTimeStamp()));
            }
        }));
        h.runInCurrentThread(null);
        handlerListener.reportErrors();
        ArrayList arrayList = result2;
        if (arrayList == null) {
            GitLogUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public static void readTimedCommits(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> parameters, @NotNull Consumer<VcsUser> userConsumer, @NotNull Consumer<VcsRef> refConsumer, @NotNull Consumer<TimedVcsCommit> commitConsumer) throws VcsException {
        VcsLogObjectsFactory factory;
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(5);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(6);
        }
        if (parameters == null) {
            GitLogUtil.$$$reportNull$$$0(7);
        }
        if (userConsumer == null) {
            GitLogUtil.$$$reportNull$$$0(8);
        }
        if (refConsumer == null) {
            GitLogUtil.$$$reportNull$$$0(9);
        }
        if (commitConsumer == null) {
            GitLogUtil.$$$reportNull$$$0(10);
        }
        if ((factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            return;
        }
        GitLineHandler handler = GitLogUtil.createGitHandler(project, root);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.NONE, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.REF_NAMES);
        handler.setStdoutSuppressed(true);
        handler.addParameters(parser.getPretty(), "--encoding=UTF-8");
        handler.addParameters("--decorate=full");
        handler.addParameters(parameters);
        handler.endOptions();
        GitLogOutputSplitter handlerListener = new GitLogOutputSplitter(handler, (Consumer<StringBuilder>)((Consumer)output -> {
            if (commitConsumer == null) {
                GitLogUtil.$$$reportNull$$$0(97);
            }
            if (root == null) {
                GitLogUtil.$$$reportNull$$$0(98);
            }
            if (refConsumer == null) {
                GitLogUtil.$$$reportNull$$$0(99);
            }
            if (userConsumer == null) {
                GitLogUtil.$$$reportNull$$$0(100);
            }
            List<GitLogRecord> records = parser.parse((CharSequence)output);
            for (GitLogRecord record : records) {
                if (record == null) continue;
                record.setUsedHandler(handler);
                Hash hash = HashImpl.build((String)record.getHash());
                List<Hash> parents = GitLogUtil.getParentHashes(factory, record);
                commitConsumer.consume((Object)factory.createTimedCommit(hash, parents, record.getCommitTime()));
                for (VcsRef ref : GitLogUtil.parseRefs(record.getRefs(), hash, factory, root)) {
                    refConsumer.consume((Object)ref);
                }
                userConsumer.consume((Object)factory.createUser(record.getAuthorName(), record.getAuthorEmail()));
            }
        }));
        handler.runInCurrentThread(null);
        handlerListener.reportErrors();
    }

    @NotNull
    private static Collection<VcsRef> parseRefs(@NotNull Collection<String> refs, @NotNull Hash hash, @NotNull VcsLogObjectsFactory factory, @NotNull VirtualFile root) {
        if (refs == null) {
            GitLogUtil.$$$reportNull$$$0(11);
        }
        if (hash == null) {
            GitLogUtil.$$$reportNull$$$0(12);
        }
        if (factory == null) {
            GitLogUtil.$$$reportNull$$$0(13);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(14);
        }
        List list = ContainerUtil.mapNotNull(refs, refName -> {
            if (factory == null) {
                GitLogUtil.$$$reportNull$$$0(94);
            }
            if (hash == null) {
                GitLogUtil.$$$reportNull$$$0(95);
            }
            if (root == null) {
                GitLogUtil.$$$reportNull$$$0(96);
            }
            if (refName.equals(GRAFTED) || refName.equals(REPLACED)) {
                return null;
            }
            VcsRefType type = GitRefManager.getRefType(refName);
            return (refName = GitBranchUtil.stripRefsPrefix(refName)).equals("origin/HEAD") ? null : factory.createRef(hash, refName, type, root);
        });
        if (list == null) {
            GitLogUtil.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    public static VcsLogProvider.DetailedLogData collectMetadata(@NotNull Project project, @NotNull VirtualFile root, String ... params) throws VcsException {
        VcsLogObjectsFactory factory;
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(16);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(17);
        }
        if ((factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            LogDataImpl logDataImpl = LogDataImpl.empty();
            if (logDataImpl == null) {
                GitLogUtil.$$$reportNull$$$0(18);
            }
            return logDataImpl;
        }
        OpenTHashSet refs = new OpenTHashSet(GitLogProvider.DONT_CONSIDER_SHA);
        List<VcsCommitMetadata> commits2 = GitLogUtil.collectMetadata(project, root, (NullableFunction<GitLogRecord, VcsCommitMetadata>)((NullableFunction)arg_0 -> GitLogUtil.lambda$collectMetadata$4(project, root, factory, (Set)refs, arg_0)), params);
        LogDataImpl logDataImpl = new LogDataImpl((Set)refs, commits2);
        if (logDataImpl == null) {
            GitLogUtil.$$$reportNull$$$0(19);
        }
        return logDataImpl;
    }

    @NotNull
    private static List<VcsCommitMetadata> collectMetadata(@NotNull Project project, @NotNull VirtualFile root, @NotNull NullableFunction<GitLogRecord, VcsCommitMetadata> converter, String ... parameters) throws VcsException {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(20);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(21);
        }
        if (converter == null) {
            GitLogUtil.$$$reportNull$$$0(22);
        }
        ArrayList commits2 = ContainerUtil.newArrayList();
        try {
            GitLogUtil.readRecords(project, root, true, false, DiffRenameLimit.GIT_CONFIG, (Consumer<GitLogRecord>)((Consumer)record -> {
                if (converter == null) {
                    GitLogUtil.$$$reportNull$$$0(91);
                }
                commits2.add(converter.fun(record));
            }), parameters);
        }
        catch (VcsException e) {
            if (commits2.isEmpty()) {
                throw e;
            }
            LOG.warn("Error during loading details, returning partially loaded commits\n", (Throwable)e);
        }
        ArrayList arrayList = commits2;
        if (arrayList == null) {
            GitLogUtil.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    @Nullable
    public static VcsLogObjectsFactory getObjectsFactoryWithDisposeCheck(@NotNull Project project) {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(24);
        }
        return (VcsLogObjectsFactory)ReadAction.compute(() -> {
            if (project == null) {
                GitLogUtil.$$$reportNull$$$0(90);
            }
            if (!project.isDisposed()) {
                return (VcsLogObjectsFactory)ServiceManager.getService((Project)project, VcsLogObjectsFactory.class);
            }
            return null;
        });
    }

    @NotNull
    private static GitCommit createCommit(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<GitLogRecord> records, @NotNull VcsLogObjectsFactory factory) {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(25);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(26);
        }
        if (records == null) {
            GitLogUtil.$$$reportNull$$$0(27);
        }
        if (factory == null) {
            GitLogUtil.$$$reportNull$$$0(28);
        }
        GitCommit gitCommit = GitLogUtil.createCommit(project, root, records, factory, DiffRenameLimit.GIT_CONFIG);
        if (gitCommit == null) {
            GitLogUtil.$$$reportNull$$$0(29);
        }
        return gitCommit;
    }

    @NotNull
    private static GitCommit createCommit(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<GitLogRecord> records, @NotNull VcsLogObjectsFactory factory, @NotNull DiffRenameLimit renameLimit) {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(30);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(31);
        }
        if (records == null) {
            GitLogUtil.$$$reportNull$$$0(32);
        }
        if (factory == null) {
            GitLogUtil.$$$reportNull$$$0(33);
        }
        if (renameLimit == null) {
            GitLogUtil.$$$reportNull$$$0(34);
        }
        GitLogRecord record = (GitLogRecord)ObjectUtils.notNull((Object)ContainerUtil.getLastItem(records));
        List<Hash> parents = GitLogUtil.getParentHashes(factory, record);
        GitCommit gitCommit = new GitCommit(project, HashImpl.build((String)record.getHash()), parents, record.getCommitTime(), root, record.getSubject(), factory.createUser(record.getAuthorName(), record.getAuthorEmail()), record.getFullMessage(), factory.createUser(record.getCommitterName(), record.getCommitterEmail()), record.getAuthorTimeStamp(), ContainerUtil.map(records, GitLogRecord::getStatusInfos), renameLimit);
        if (gitCommit == null) {
            GitLogUtil.$$$reportNull$$$0(35);
        }
        return gitCommit;
    }

    @NotNull
    public static List<Hash> getParentHashes(@NotNull VcsLogObjectsFactory factory, @NotNull GitLogRecord record) {
        if (factory == null) {
            GitLogUtil.$$$reportNull$$$0(36);
        }
        if (record == null) {
            GitLogUtil.$$$reportNull$$$0(37);
        }
        List list = ContainerUtil.map((Object[])record.getParentsHashes(), arg_0 -> ((VcsLogObjectsFactory)factory).createHash(arg_0));
        if (list == null) {
            GitLogUtil.$$$reportNull$$$0(38);
        }
        return list;
    }

    @NotNull
    public static List<GitCommit> collectFullDetails(@NotNull Project project, @NotNull VirtualFile root, String ... parameters) throws VcsException {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(39);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(40);
        }
        ArrayList commits2 = ContainerUtil.newArrayList();
        try {
            GitLogUtil.readFullDetails(project, root, (Consumer<? super GitCommit>)((Consumer)commits2::add), parameters);
        }
        catch (VcsException e) {
            if (commits2.isEmpty()) {
                throw e;
            }
            LOG.warn("Error during loading details, returning partially loaded commits\n", (Throwable)e);
        }
        ArrayList arrayList = commits2;
        if (arrayList == null) {
            GitLogUtil.$$$reportNull$$$0(41);
        }
        return arrayList;
    }

    public static void readFullDetails(final @NotNull Project project, final @NotNull VirtualFile root, final @NotNull Consumer<? super GitCommit> commitConsumer, String ... parameters) throws VcsException {
        VcsLogObjectsFactory factory;
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(42);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(43);
        }
        if (commitConsumer == null) {
            GitLogUtil.$$$reportNull$$$0(44);
        }
        if (parameters == null) {
            GitLogUtil.$$$reportNull$$$0(45);
        }
        if ((factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            return;
        }
        GitLogRecordCollector recordCollector = new GitLogRecordCollector(project, root){

            @Override
            public void consume(@NotNull List<GitLogRecord> records) {
                if (records == null) {
                    1.$$$reportNull$$$0(0);
                }
                GitLogUtil.assertCorrectNumberOfRecords(records);
                commitConsumer.consume((Object)GitLogUtil.createCommit(project, root, records, factory));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "git4idea/history/GitLogUtil$1", "consume"));
            }
        };
        GitLogUtil.readRecords(project, root, false, true, DiffRenameLimit.REGISTRY, recordCollector, parameters);
        recordCollector.finish();
    }

    public static void assertCorrectNumberOfRecords(@NotNull List<GitLogRecord> records) {
        GitLogRecord firstRecord;
        String[] parents;
        if (records == null) {
            GitLogUtil.$$$reportNull$$$0(46);
        }
        LOG.assertTrue((parents = (firstRecord = (GitLogRecord)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(records))).getParentsHashes()).length == 0 || parents.length == records.size(), (Object)("Not enough records for commit " + firstRecord.getHash() + " expected " + parents.length + " records, but got " + records.size()));
    }

    private static void readRecords(@NotNull Project project, @NotNull VirtualFile root, boolean withRefs, boolean withChanges, @NotNull DiffRenameLimit renameLimit, @NotNull Consumer<GitLogRecord> converter, String ... parameters) throws VcsException {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(47);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(48);
        }
        if (renameLimit == null) {
            GitLogUtil.$$$reportNull$$$0(49);
        }
        if (converter == null) {
            GitLogUtil.$$$reportNull$$$0(50);
        }
        GitLineHandler handler = GitLogUtil.createGitHandler(project, root, GitLogUtil.createConfigParameters(withChanges, renameLimit));
        GitLogUtil.readRecordsFromHandler(project, root, withRefs, withChanges, converter, handler, parameters);
    }

    private static void readRecordsFromHandler(@NotNull Project project, @NotNull VirtualFile root, boolean withRefs, boolean withChanges, @NotNull Consumer<GitLogRecord> converter, @NotNull GitLineHandler handler, String ... parameters) throws VcsException {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(51);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(52);
        }
        if (converter == null) {
            GitLogUtil.$$$reportNull$$$0(53);
        }
        if (handler == null) {
            GitLogUtil.$$$reportNull$$$0(54);
        }
        if (parameters == null) {
            GitLogUtil.$$$reportNull$$$0(55);
        }
        GitLogParser parser = GitLogUtil.createParserForDetails(handler, project, withRefs, withChanges, parameters);
        StopWatch sw = StopWatch.start((String)("loading details in [" + root.getName() + "]"));
        Ref parseError = new Ref();
        GitLogOutputSplitter handlerListener = new GitLogOutputSplitter(handler, (Consumer<StringBuilder>)((Consumer)output -> {
            block6: {
                if (handler == null) {
                    GitLogUtil.$$$reportNull$$$0(88);
                }
                if (converter == null) {
                    GitLogUtil.$$$reportNull$$$0(89);
                }
                try {
                    GitLogRecord record = parser.parseOneRecord((CharSequence)output);
                    if (record != null) {
                        record.setUsedHandler(handler);
                        converter.consume((Object)record);
                    }
                }
                catch (ProcessCanceledException pce) {
                    throw pce;
                }
                catch (Throwable t) {
                    if (!parseError.isNull()) break block6;
                    parseError.set((Object)t);
                    LOG.error("Could not parse \" " + GitLogParser.getTruncatedEscapedOutput(output) + "\"\nCommand " + handler.printableCommandLine(), t);
                }
            }
        }));
        handler.runInCurrentThread(null);
        handlerListener.reportErrors();
        if (!parseError.isNull()) {
            throw new VcsException((Throwable)parseError.get());
        }
        sw.report();
    }

    @NotNull
    private static GitLogParser createParserForDetails(@NotNull GitTextHandler h, @NotNull Project project, boolean withRefs, boolean withChanges, String ... parameters) {
        if (h == null) {
            GitLogUtil.$$$reportNull$$$0(56);
        }
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(57);
        }
        GitLogParser.NameStatus status = withChanges ? GitLogParser.NameStatus.STATUS : GitLogParser.NameStatus.NONE;
        GitLogParser.GitLogOption[] options = new GitLogParser.GitLogOption[]{GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_TIME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY};
        if (withRefs) {
            options = (GitLogParser.GitLogOption[])ArrayUtil.append((Object[])options, (Object)((Object)GitLogParser.GitLogOption.REF_NAMES));
        }
        GitLogParser parser = new GitLogParser(project, status, options);
        h.setStdoutSuppressed(true);
        h.addParameters(parameters);
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        if (withRefs) {
            h.addParameters("--decorate=full");
        }
        if (withChanges) {
            h.addParameters("-M", "--name-status", "-m");
        }
        h.endOptions();
        GitLogParser gitLogParser = parser;
        if (gitLogParser == null) {
            GitLogUtil.$$$reportNull$$$0(58);
        }
        return gitLogParser;
    }

    public static void readFullDetailsForHashes(final @NotNull Project project, final @NotNull VirtualFile root, @NotNull GitVcs vcs, final @NotNull Consumer<? super GitCommit> commitConsumer, @NotNull List<String> hashes2, final @NotNull DiffRenameLimit renameLimit) throws VcsException {
        VcsLogObjectsFactory factory;
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(59);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(60);
        }
        if (vcs == null) {
            GitLogUtil.$$$reportNull$$$0(61);
        }
        if (commitConsumer == null) {
            GitLogUtil.$$$reportNull$$$0(62);
        }
        if (hashes2 == null) {
            GitLogUtil.$$$reportNull$$$0(63);
        }
        if (renameLimit == null) {
            GitLogUtil.$$$reportNull$$$0(64);
        }
        if ((factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            return;
        }
        GitLogRecordCollector recordCollector = new GitLogRecordCollector(project, root){

            @Override
            public void consume(@NotNull List<GitLogRecord> records) {
                if (records == null) {
                    2.$$$reportNull$$$0(0);
                }
                GitLogUtil.assertCorrectNumberOfRecords(records);
                commitConsumer.consume((Object)GitLogUtil.createCommit(project, root, records, factory, renameLimit));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "git4idea/history/GitLogUtil$2", "consume"));
            }
        };
        GitLineHandler handler = GitLogUtil.createGitHandler(project, root, GitLogUtil.createConfigParameters(true, renameLimit));
        GitLogUtil.sendHashesToStdin(vcs, hashes2, handler);
        GitLogUtil.readRecordsFromHandler(project, root, false, true, recordCollector, handler, GitLogUtil.getNoWalkParameter(vcs), STDIN);
        recordCollector.finish();
        if (!handler.errors().isEmpty()) {
            throw new VcsException(GitUIUtil.stringifyErrors(handler.errors()));
        }
    }

    public static void sendHashesToStdin(@NotNull GitVcs vcs, @NotNull Collection<String> hashes2, @NotNull GitHandler handler) {
        if (vcs == null) {
            GitLogUtil.$$$reportNull$$$0(65);
        }
        if (hashes2 == null) {
            GitLogUtil.$$$reportNull$$$0(66);
        }
        if (handler == null) {
            GitLogUtil.$$$reportNull$$$0(67);
        }
        String separator = GitLogUtil.getSeparator(vcs);
        handler.setInputProcessor((ThrowableConsumer<OutputStream, IOException>)((ThrowableConsumer)stream -> {
            if (handler == null) {
                GitLogUtil.$$$reportNull$$$0(86);
            }
            if (hashes2 == null) {
                GitLogUtil.$$$reportNull$$$0(87);
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, handler.getCharset());
            for (String hash : hashes2) {
                writer.write(hash);
                writer.write(separator);
            }
            writer.write(separator);
            writer.flush();
        }));
    }

    @NotNull
    private static String getSeparator(@NotNull GitVcs vcs) {
        if (vcs == null) {
            GitLogUtil.$$$reportNull$$$0(68);
        }
        if (GitVersionSpecialty.LF_SEPARATORS_IN_STDIN.existsIn(vcs.getVersion())) {
            if ("\n" == null) {
                GitLogUtil.$$$reportNull$$$0(69);
            }
            return "\n";
        }
        String string = System.lineSeparator();
        if (string == null) {
            GitLogUtil.$$$reportNull$$$0(70);
        }
        return string;
    }

    @NotNull
    public static String getNoWalkParameter(@NotNull GitVcs vcs) {
        if (vcs == null) {
            GitLogUtil.$$$reportNull$$$0(71);
        }
        String string = GitVersionSpecialty.NO_WALK_UNSORTED.existsIn(vcs.getVersion()) ? "--no-walk=unsorted" : "--no-walk";
        if (string == null) {
            GitLogUtil.$$$reportNull$$$0(72);
        }
        return string;
    }

    @NotNull
    private static GitLineHandler createGitHandler(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(73);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(74);
        }
        GitLineHandler gitLineHandler = GitLogUtil.createGitHandler(project, root, Collections.emptyList());
        if (gitLineHandler == null) {
            GitLogUtil.$$$reportNull$$$0(75);
        }
        return gitLineHandler;
    }

    @NotNull
    private static GitLineHandler createGitHandler(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> configParameters) {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(76);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(77);
        }
        if (configParameters == null) {
            GitLogUtil.$$$reportNull$$$0(78);
        }
        GitLineHandler gitLineHandler = new GitLineHandler(project, root, GitCommand.LOG, configParameters, false);
        if (gitLineHandler == null) {
            GitLogUtil.$$$reportNull$$$0(79);
        }
        return gitLineHandler;
    }

    @NotNull
    private static List<String> createConfigParameters(boolean withChanges, @NotNull DiffRenameLimit renameLimit) {
        if (renameLimit == null) {
            GitLogUtil.$$$reportNull$$$0(80);
        }
        if (!withChanges) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GitLogUtil.$$$reportNull$$$0(81);
            }
            return list;
        }
        switch (renameLimit) {
            case INFINITY: {
                List<String> list = GitLogUtil.renameLimit(0);
                if (list == null) {
                    GitLogUtil.$$$reportNull$$$0(82);
                }
                return list;
            }
            case REGISTRY: {
                List<String> list = GitLogUtil.renameLimit(Registry.intValue((String)"git.diff.renameLimit"));
                if (list == null) {
                    GitLogUtil.$$$reportNull$$$0(83);
                }
                return list;
            }
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            GitLogUtil.$$$reportNull$$$0(84);
        }
        return list;
    }

    @NotNull
    private static List<String> renameLimit(int limit) {
        List<String> list = Collections.singletonList("diff.renameLimit=" + limit);
        if (list == null) {
            GitLogUtil.$$$reportNull$$$0(85);
        }
        return list;
    }

    private static /* synthetic */ VcsCommitMetadata lambda$collectMetadata$4(@NotNull Project project, @NotNull VirtualFile root, VcsLogObjectsFactory factory, Set refs, GitLogRecord record) {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(92);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(93);
        }
        GitCommit commit = GitLogUtil.createCommit(project, root, Collections.singletonList(record), factory);
        Collection<VcsRef> refsInRecord = GitLogUtil.parseRefs(record.getRefs(), commit.getId(), factory, root);
        for (VcsRef ref : refsInRecord) {
            if (refs.add(ref)) continue;
            VcsRef otherRef = (VcsRef)ContainerUtil.find((Iterable)refs, r -> GitLogProvider.DONT_CONSIDER_SHA.equals(r, (Object)ref));
            LOG.error("Adding duplicate element " + ref + " to the set containing " + otherRef);
        }
        return commit;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 29: 
            case 35: 
            case 38: 
            case 41: 
            case 58: 
            case 69: 
            case 70: 
            case 72: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 29: 
            case 35: 
            case 38: 
            case 41: 
            case 58: 
            case 69: 
            case 70: 
            case 72: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 14: 
            case 17: 
            case 21: 
            case 26: 
            case 31: 
            case 40: 
            case 43: 
            case 48: 
            case 52: 
            case 60: 
            case 74: 
            case 77: 
            case 93: 
            case 96: 
            case 98: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 63: 
            case 66: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 29: 
            case 35: 
            case 38: 
            case 41: 
            case 58: 
            case 69: 
            case 70: 
            case 72: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/history/GitLogUtil";
                break;
            }
            case 7: 
            case 45: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 8: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userConsumer";
                break;
            }
            case 9: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refConsumer";
                break;
            }
            case 10: 
            case 44: 
            case 62: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitConsumer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 12: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 13: 
            case 28: 
            case 33: 
            case 36: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 22: 
            case 50: 
            case 53: 
            case 89: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 27: 
            case 32: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "records";
                break;
            }
            case 34: 
            case 49: 
            case 64: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renameLimit";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "record";
                break;
            }
            case 54: 
            case 67: 
            case 86: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "h";
                break;
            }
            case 61: 
            case 65: 
            case 68: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/history/GitLogUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectShortDetails";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRefs";
                break;
            }
            case 18: 
            case 19: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMetadata";
                break;
            }
            case 29: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommit";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentHashes";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFullDetails";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "createParserForDetails";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparator";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getNoWalkParameter";
                break;
            }
            case 75: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "createGitHandler";
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigParameters";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "renameLimit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectShortDetails";
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 29: 
            case 35: 
            case 38: 
            case 41: 
            case 58: 
            case 69: 
            case 70: 
            case 72: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readTimedCommits";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseRefs";
                break;
            }
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "collectMetadata";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getObjectsFactoryWithDisposeCheck";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createCommit";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getParentHashes";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "collectFullDetails";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "readFullDetails";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "assertCorrectNumberOfRecords";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "readRecords";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "readRecordsFromHandler";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createParserForDetails";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "readFullDetailsForHashes";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "sendHashesToStdin";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getSeparator";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getNoWalkParameter";
                break;
            }
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "createGitHandler";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "createConfigParameters";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "lambda$sendHashesToStdin$8";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "lambda$readRecordsFromHandler$7";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getObjectsFactoryWithDisposeCheck$6";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectMetadata$5";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectMetadata$4";
                break;
            }
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "lambda$parseRefs$2";
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "lambda$readTimedCommits$1";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectShortDetails$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 29: 
            case 35: 
            case 38: 
            case 41: 
            case 58: 
            case 69: 
            case 70: 
            case 72: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum DiffRenameLimit {
        INFINITY,
        REGISTRY,
        GIT_CONFIG;

    }
}

