/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.google.common.collect.Maps;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.BranchChangeListener;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUiHandler;
import git4idea.commands.Git;
import git4idea.commands.GitMessageWithFilesDetector;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class GitBranchOperation {
    protected static final Logger LOG = Logger.getInstance(GitBranchOperation.class);
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final Git myGit;
    @NotNull
    protected final GitBranchUiHandler myUiHandler;
    @NotNull
    private final Collection<GitRepository> myRepositories;
    @NotNull
    protected final Map<GitRepository, String> myCurrentHeads;
    @NotNull
    protected final Map<GitRepository, String> myInitialRevisions;
    @NotNull
    private final GitVcsSettings mySettings;
    @NotNull
    private final Collection<GitRepository> mySuccessfulRepositories;
    @NotNull
    private final Collection<GitRepository> mySkippedRepositories;
    @NotNull
    private final Collection<GitRepository> myRemainingRepositories;

    protected GitBranchOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull Collection<GitRepository> repositories) {
        if (project == null) {
            GitBranchOperation.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitBranchOperation.$$$reportNull$$$0(1);
        }
        if (uiHandler == null) {
            GitBranchOperation.$$$reportNull$$$0(2);
        }
        if (repositories == null) {
            GitBranchOperation.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myGit = git;
        this.myUiHandler = uiHandler;
        this.myRepositories = GitUtil.getRepositoryManager(project).sortByDependency(repositories);
        this.myCurrentHeads = Maps.toMap(repositories, repo -> (String)ObjectUtils.chooseNotNull((Object)repo.getCurrentBranchName(), (Object)repo.getCurrentRevision()));
        this.myInitialRevisions = Maps.toMap(repositories, Repository::getCurrentRevision);
        this.mySuccessfulRepositories = new ArrayList<GitRepository>();
        this.mySkippedRepositories = new ArrayList<GitRepository>();
        this.myRemainingRepositories = new ArrayList<GitRepository>(this.myRepositories);
        this.mySettings = GitVcsSettings.getInstance(this.myProject);
    }

    protected abstract void execute();

    protected abstract void rollback();

    @NotNull
    public abstract String getSuccessMessage();

    @NotNull
    protected abstract String getRollbackProposal();

    @NotNull
    protected abstract String getOperationName();

    @NotNull
    protected GitRepository next() {
        GitRepository gitRepository = this.myRemainingRepositories.iterator().next();
        if (gitRepository == null) {
            GitBranchOperation.$$$reportNull$$$0(4);
        }
        return gitRepository;
    }

    protected boolean hasMoreRepositories() {
        return !this.myRemainingRepositories.isEmpty();
    }

    protected void markSuccessful(GitRepository ... repositories) {
        for (GitRepository repository : repositories) {
            this.mySuccessfulRepositories.add(repository);
            this.myRemainingRepositories.remove(repository);
        }
    }

    protected void markSkip(GitRepository ... repositories) {
        for (GitRepository repository : repositories) {
            this.mySkippedRepositories.add(repository);
            this.myRemainingRepositories.remove(repository);
        }
    }

    protected boolean wereSuccessful() {
        return !this.mySuccessfulRepositories.isEmpty();
    }

    protected boolean wereSkipped() {
        return !this.mySkippedRepositories.isEmpty();
    }

    @NotNull
    protected Collection<GitRepository> getSuccessfulRepositories() {
        Collection<GitRepository> collection = this.mySuccessfulRepositories;
        if (collection == null) {
            GitBranchOperation.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    protected Collection<GitRepository> getSkippedRepositories() {
        Collection<GitRepository> collection = this.mySkippedRepositories;
        if (collection == null) {
            GitBranchOperation.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    protected String successfulRepositoriesJoined() {
        String string = GitUtil.joinToHtml(this.mySuccessfulRepositories);
        if (string == null) {
            GitBranchOperation.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    protected Collection<GitRepository> getRepositories() {
        Collection<GitRepository> collection = this.myRepositories;
        if (collection == null) {
            GitBranchOperation.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NotNull
    protected Collection<GitRepository> getRemainingRepositories() {
        Collection<GitRepository> collection = this.myRemainingRepositories;
        if (collection == null) {
            GitBranchOperation.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @NotNull
    protected List<GitRepository> getRemainingRepositoriesExceptGiven(@NotNull GitRepository currentRepository) {
        if (currentRepository == null) {
            GitBranchOperation.$$$reportNull$$$0(10);
        }
        ArrayList<GitRepository> repositories = new ArrayList<GitRepository>(this.myRemainingRepositories);
        repositories.remove(currentRepository);
        ArrayList<GitRepository> arrayList = repositories;
        if (arrayList == null) {
            GitBranchOperation.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    protected void notifySuccess(@NotNull String message) {
        if (message == null) {
            GitBranchOperation.$$$reportNull$$$0(12);
        }
        VcsNotifier.getInstance((Project)this.myProject).notifySuccess(message);
    }

    protected void notifySuccess() {
        this.notifySuccess(this.getSuccessMessage());
    }

    protected static void saveAllDocuments() {
        ApplicationManager.getApplication().invokeAndWait(() -> FileDocumentManager.getInstance().saveAllDocuments());
    }

    protected void fatalError(@NotNull String title, @NotNull String message) {
        if (title == null) {
            GitBranchOperation.$$$reportNull$$$0(13);
        }
        if (message == null) {
            GitBranchOperation.$$$reportNull$$$0(14);
        }
        if (this.wereSuccessful()) {
            this.showFatalErrorDialogWithRollback(title, message);
        } else {
            this.showFatalNotification(title, message);
        }
    }

    protected void showFatalErrorDialogWithRollback(@NotNull String title, @NotNull String message) {
        boolean rollback;
        if (title == null) {
            GitBranchOperation.$$$reportNull$$$0(15);
        }
        if (message == null) {
            GitBranchOperation.$$$reportNull$$$0(16);
        }
        if (rollback = this.myUiHandler.notifyErrorWithRollbackProposal(title, message, this.getRollbackProposal())) {
            this.rollback();
        }
    }

    protected void showFatalNotification(@NotNull String title, @NotNull String message) {
        if (title == null) {
            GitBranchOperation.$$$reportNull$$$0(17);
        }
        if (message == null) {
            GitBranchOperation.$$$reportNull$$$0(18);
        }
        this.notifyError(title, message);
    }

    protected void notifyError(@NotNull String title, @NotNull String message) {
        if (title == null) {
            GitBranchOperation.$$$reportNull$$$0(19);
        }
        if (message == null) {
            GitBranchOperation.$$$reportNull$$$0(20);
        }
        VcsNotifier.getInstance((Project)this.myProject).notifyError(title, message);
    }

    @NotNull
    protected ProgressIndicator getIndicator() {
        ProgressIndicator progressIndicator = this.myUiHandler.getProgressIndicator();
        if (progressIndicator == null) {
            GitBranchOperation.$$$reportNull$$$0(21);
        }
        return progressIndicator;
    }

    protected void fatalUnmergedFilesError() {
        if (this.wereSuccessful()) {
            this.showUnmergedFilesDialogWithRollback();
        } else {
            this.showUnmergedFilesNotification();
        }
    }

    @NotNull
    protected String repositories() {
        String string = StringUtil.pluralize((String)"repository", (int)this.getSuccessfulRepositories().size());
        if (string == null) {
            GitBranchOperation.$$$reportNull$$$0(22);
        }
        return string;
    }

    protected void updateRecentBranch(@Nullable String branchName) {
        if (branchName != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                ((BranchChangeListener)this.myProject.getMessageBus().syncPublisher(BranchChangeListener.VCS_BRANCH_CHANGED)).branchHasChanged(branchName);
            });
        }
        if (this.getRepositories().size() == 1) {
            GitRepository repository = this.myRepositories.iterator().next();
            String currentHead = this.myCurrentHeads.get(repository);
            if (currentHead != null) {
                this.mySettings.setRecentBranchOfRepository(repository.getRoot().getPath(), currentHead);
            } else {
                LOG.error("Current head is not known for " + repository.getRoot().getPath());
            }
        } else {
            String recentCommonBranch = this.getRecentCommonBranch();
            if (recentCommonBranch != null) {
                this.mySettings.setRecentCommonBranch(recentCommonBranch);
            }
        }
    }

    protected void branchWillChange() {
        String currentBranch = this.myCurrentHeads.values().iterator().next();
        if (currentBranch != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                ((BranchChangeListener)this.myProject.getMessageBus().syncPublisher(BranchChangeListener.VCS_BRANCH_CHANGED)).branchWillChange(currentBranch);
            });
        }
    }

    @NotNull
    protected String getInitialRevision(@NotNull GitRepository repository) {
        if (repository == null) {
            GitBranchOperation.$$$reportNull$$$0(23);
        }
        String string = this.myInitialRevisions.get(repository);
        if (string == null) {
            GitBranchOperation.$$$reportNull$$$0(24);
        }
        return string;
    }

    @Nullable
    private String getRecentCommonBranch() {
        String recentCommonBranch = null;
        for (String branch : this.myCurrentHeads.values()) {
            if (recentCommonBranch == null) {
                recentCommonBranch = branch;
                continue;
            }
            if (recentCommonBranch.equals(branch)) continue;
            return null;
        }
        return recentCommonBranch;
    }

    private void showUnmergedFilesDialogWithRollback() {
        boolean ok = this.myUiHandler.showUnmergedFilesMessageWithRollback(this.getOperationName(), this.getRollbackProposal());
        if (ok) {
            this.rollback();
        }
    }

    private void showUnmergedFilesNotification() {
        this.myUiHandler.showUnmergedFilesNotification(this.getOperationName(), this.getRepositories());
    }

    protected void fatalLocalChangesError(@NotNull String reference) {
        if (reference == null) {
            GitBranchOperation.$$$reportNull$$$0(25);
        }
        String title = String.format("Couldn't %s %s", this.getOperationName(), reference);
        if (this.wereSuccessful()) {
            this.showFatalErrorDialogWithRollback(title, "");
        }
    }

    protected void fatalUntrackedFilesError(@NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        if (root == null) {
            GitBranchOperation.$$$reportNull$$$0(26);
        }
        if (relativePaths == null) {
            GitBranchOperation.$$$reportNull$$$0(27);
        }
        if (this.wereSuccessful()) {
            this.showUntrackedFilesDialogWithRollback(root, relativePaths);
        } else {
            this.showUntrackedFilesNotification(root, relativePaths);
        }
    }

    private void showUntrackedFilesNotification(@NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        if (root == null) {
            GitBranchOperation.$$$reportNull$$$0(28);
        }
        if (relativePaths == null) {
            GitBranchOperation.$$$reportNull$$$0(29);
        }
        this.myUiHandler.showUntrackedFilesNotification(this.getOperationName(), root, relativePaths);
    }

    private void showUntrackedFilesDialogWithRollback(@NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        boolean ok;
        if (root == null) {
            GitBranchOperation.$$$reportNull$$$0(30);
        }
        if (relativePaths == null) {
            GitBranchOperation.$$$reportNull$$$0(31);
        }
        if (ok = this.myUiHandler.showUntrackedFilesDialogWithRollback(this.getOperationName(), this.getRollbackProposal(), root, relativePaths)) {
            this.rollback();
        }
    }

    @NotNull
    Map<GitRepository, List<Change>> collectLocalChangesConflictingWithBranch(@NotNull Collection<GitRepository> repositories, @NotNull String currentBranch, @NotNull String otherBranch) {
        if (repositories == null) {
            GitBranchOperation.$$$reportNull$$$0(32);
        }
        if (currentBranch == null) {
            GitBranchOperation.$$$reportNull$$$0(33);
        }
        if (otherBranch == null) {
            GitBranchOperation.$$$reportNull$$$0(34);
        }
        HashMap<GitRepository, List<Change>> changes = new HashMap<GitRepository, List<Change>>();
        for (GitRepository repository : repositories) {
            try {
                Collection<String> diff = GitUtil.getPathsDiffBetweenRefs(this.myGit, repository, currentBranch, otherBranch);
                List<Change> changesInRepo = GitUtil.findLocalChangesForPaths(this.myProject, repository.getRoot(), diff, false);
                if (changesInRepo.isEmpty()) continue;
                changes.put(repository, changesInRepo);
            }
            catch (VcsException e) {
                LOG.warn(String.format("Couldn't collect diff between %s and %s in %s", currentBranch, otherBranch, repository.getRoot()), (Throwable)e);
            }
        }
        HashMap<GitRepository, List<Change>> hashMap = changes;
        if (hashMap == null) {
            GitBranchOperation.$$$reportNull$$$0(35);
        }
        return hashMap;
    }

    @NotNull
    protected Pair<List<GitRepository>, List<Change>> getConflictingRepositoriesAndAffectedChanges(@NotNull GitRepository currentRepository, @NotNull GitMessageWithFilesDetector localChangesOverwrittenBy, String currentBranch, String nextBranch) {
        if (currentRepository == null) {
            GitBranchOperation.$$$reportNull$$$0(36);
        }
        if (localChangesOverwrittenBy == null) {
            GitBranchOperation.$$$reportNull$$$0(37);
        }
        List<Change> affectedChanges = GitUtil.findLocalChangesForPaths(this.myProject, currentRepository.getRoot(), localChangesOverwrittenBy.getRelativeFilePaths(), true);
        Map<GitRepository, List<Change>> conflictingChangesInRepositories = this.collectLocalChangesConflictingWithBranch(this.getRemainingRepositoriesExceptGiven(currentRepository), currentBranch, nextBranch);
        Set<GitRepository> otherProblematicRepositories = conflictingChangesInRepositories.keySet();
        ArrayList<GitRepository> allConflictingRepositories = new ArrayList<GitRepository>(otherProblematicRepositories);
        allConflictingRepositories.add(currentRepository);
        for (List<Change> changes : conflictingChangesInRepositories.values()) {
            affectedChanges.addAll(changes);
        }
        Pair pair = Pair.create(allConflictingRepositories, affectedChanges);
        if (pair == null) {
            GitBranchOperation.$$$reportNull$$$0(38);
        }
        return pair;
    }

    @NotNull
    protected static String stringifyBranchesByRepos(@NotNull Map<GitRepository, String> heads) {
        MultiMap<String, VirtualFile> grouped;
        if (heads == null) {
            GitBranchOperation.$$$reportNull$$$0(39);
        }
        if ((grouped = GitBranchOperation.groupByBranches(heads)).size() == 1) {
            String string = (String)grouped.keySet().iterator().next();
            if (string == null) {
                GitBranchOperation.$$$reportNull$$$0(40);
            }
            return string;
        }
        String string = StringUtil.join((Collection)grouped.entrySet(), entry -> {
            String roots = StringUtil.join((Collection)((Collection)entry.getValue()), file -> file.getName(), (String)", ");
            return (String)entry.getKey() + " (in " + roots + ")";
        }, (String)"<br/>");
        if (string == null) {
            GitBranchOperation.$$$reportNull$$$0(41);
        }
        return string;
    }

    @NotNull
    private static MultiMap<String, VirtualFile> groupByBranches(@NotNull Map<GitRepository, String> heads) {
        if (heads == null) {
            GitBranchOperation.$$$reportNull$$$0(42);
        }
        MultiMap result2 = MultiMap.createLinked();
        List sortedRepos = DvcsUtil.sortRepositories(heads.keySet());
        for (GitRepository repo : sortedRepos) {
            result2.putValue((Object)heads.get(repo), (Object)repo.getRoot());
        }
        MultiMap multiMap = result2;
        if (multiMap == null) {
            GitBranchOperation.$$$reportNull$$$0(43);
        }
        return multiMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 21: 
            case 22: 
            case 24: 
            case 35: 
            case 38: 
            case 40: 
            case 41: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 21: 
            case 22: 
            case 24: 
            case 35: 
            case 38: 
            case 40: 
            case 41: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiHandler";
                break;
            }
            case 3: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 21: 
            case 22: 
            case 24: 
            case 35: 
            case 38: 
            case 40: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitBranchOperation";
                break;
            }
            case 10: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRepository";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePaths";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentBranch";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherBranch";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localChangesOverwrittenBy";
                break;
            }
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heads";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitBranchOperation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "next";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuccessfulRepositories";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkippedRepositories";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "successfulRepositoriesJoined";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemainingRepositories";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemainingRepositoriesExceptGiven";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndicator";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "repositories";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialRevision";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "collectLocalChangesConflictingWithBranch";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflictingRepositoriesAndAffectedChanges";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "stringifyBranchesByRepos";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByBranches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 21: 
            case 22: 
            case 24: 
            case 35: 
            case 38: 
            case 40: 
            case 41: 
            case 43: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRemainingRepositoriesExceptGiven";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "notifySuccess";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fatalError";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showFatalErrorDialogWithRollback";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "showFatalNotification";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "notifyError";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getInitialRevision";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fatalLocalChangesError";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "fatalUntrackedFilesError";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "showUntrackedFilesNotification";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "showUntrackedFilesDialogWithRollback";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "collectLocalChangesConflictingWithBranch";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getConflictingRepositoriesAndAffectedChanges";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "stringifyBranchesByRepos";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "groupByBranches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 21: 
            case 22: 
            case 24: 
            case 35: 
            case 38: 
            case 40: 
            case 41: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

