/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnConfigurationState;
import org.jetbrains.idea.svn.commandLine.BaseCommandRuntimeModule;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandRuntime;

public class SshTunnelRuntimeModule
extends BaseCommandRuntimeModule {
    public static final String DEFAULT_SSH_TUNNEL_VALUE = "$SVN_SSH ssh -q";

    public SshTunnelRuntimeModule(@NotNull CommandRuntime runtime) {
        if (runtime == null) {
            SshTunnelRuntimeModule.$$$reportNull$$$0(0);
        }
        super(runtime);
    }

    @Override
    public void onStart(@NotNull Command command) {
        if (command == null) {
            SshTunnelRuntimeModule.$$$reportNull$$$0(1);
        }
        if (!CommandRuntime.isLocal(command) && !SvnConfiguration.SshConnectionType.SUBVERSION_CONFIG.equals((Object)this.getState().sshConnectionType)) {
            command.put("--config-option", "config:tunnels:ssh=" + StringUtil.notNullize((String)this.buildTunnelValue()));
        }
    }

    @NotNull
    private SvnConfiguration getConfiguration() {
        SvnConfiguration svnConfiguration = this.myRuntime.getVcs().getSvnConfiguration();
        if (svnConfiguration == null) {
            SshTunnelRuntimeModule.$$$reportNull$$$0(2);
        }
        return svnConfiguration;
    }

    @NotNull
    private SvnConfigurationState getState() {
        SvnConfigurationState svnConfigurationState = this.getConfiguration().getState();
        if (svnConfigurationState == null) {
            SshTunnelRuntimeModule.$$$reportNull$$$0(3);
        }
        return svnConfigurationState;
    }

    @Nullable
    private String buildTunnelValue() {
        String sshPath = this.getState().sshExecutablePath;
        sshPath = !StringUtil.isEmpty((String)sshPath) ? sshPath : SshTunnelRuntimeModule.getExecutablePath(this.getConfiguration().getSshTunnelSetting());
        return StringUtil.join((Collection)CommandLineUtil.toCommandLine((String)sshPath, (List)this.buildTunnelCommandLine(sshPath).getParametersList().getParameters()), (String)" ");
    }

    @NotNull
    private GeneralCommandLine buildTunnelCommandLine(@NotNull String sshPath) {
        if (sshPath == null) {
            SshTunnelRuntimeModule.$$$reportNull$$$0(4);
        }
        GeneralCommandLine result = new GeneralCommandLine(new String[]{sshPath});
        boolean isPuttyLinkClient = StringUtil.endsWithIgnoreCase((String)FileUtil.getNameWithoutExtension((String)sshPath), (String)"plink");
        SvnConfigurationState state = this.getState();
        if (!isPuttyLinkClient) {
            result.addParameter("-q");
        }
        result.addParameters(new String[]{isPuttyLinkClient ? "-P" : "-p", String.valueOf(state.sshPort)});
        if (!StringUtil.isEmpty((String)state.sshUserName)) {
            result.addParameters(new String[]{"-l", state.sshUserName});
        }
        if (SvnConfiguration.SshConnectionType.PRIVATE_KEY.equals((Object)state.sshConnectionType) && !StringUtil.isEmpty((String)state.sshPrivateKeyPath)) {
            result.addParameters(new String[]{"-i", FileUtil.toSystemIndependentName((String)state.sshPrivateKeyPath)});
        }
        GeneralCommandLine generalCommandLine = result;
        if (generalCommandLine == null) {
            SshTunnelRuntimeModule.$$$reportNull$$$0(5);
        }
        return generalCommandLine;
    }

    @NotNull
    public static String getSshTunnelValue(@Nullable String tunnelSetting) {
        String svnSshVariableName = SshTunnelRuntimeModule.getSvnSshVariableName(tunnelSetting = !StringUtil.isEmpty((String)tunnelSetting) ? tunnelSetting : DEFAULT_SSH_TUNNEL_VALUE);
        String svnSshVariableValue = EnvironmentUtil.getValue((String)svnSshVariableName);
        String string = !StringUtil.isEmpty((String)svnSshVariableValue) ? svnSshVariableValue : (!StringUtil.isEmpty((String)svnSshVariableName) ? tunnelSetting.substring(1 + svnSshVariableName.length()) : tunnelSetting);
        if (string == null) {
            SshTunnelRuntimeModule.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String getSvnSshVariableName(@Nullable String tunnel) {
        String result = "";
        if (tunnel != null && tunnel.startsWith("$")) {
            result = ((String)ObjectUtils.notNull((Object)StringUtil.substringBefore((String)tunnel, (String)" "), (Object)tunnel)).substring(1);
        }
        String string = result;
        if (string == null) {
            SshTunnelRuntimeModule.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String getExecutablePath(@Nullable String tunnelSetting) {
        String string = StringUtil.notNullize((String)((String)ContainerUtil.getFirstItem((List)ParametersListUtil.parse((String)SshTunnelRuntimeModule.getSshTunnelValue(tunnelSetting))))).trim();
        if (string == null) {
            SshTunnelRuntimeModule.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtime";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/commandLine/SshTunnelRuntimeModule";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sshPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/commandLine/SshTunnelRuntimeModule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTunnelCommandLine";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSshTunnelValue";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSvnSshVariableName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutablePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onStart";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildTunnelCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

