/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.status.StatusType;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNEvent;

public class ProgressEvent {
    private final File myFile;
    private final long myRevision;
    private final SVNURL myURL;
    @NotNull
    private final StatusType myContentsStatus;
    @NotNull
    private final StatusType myPropertiesStatus;
    private final SVNErrorMessage myErrorMessage;
    private final EventAction myAction;

    @Nullable
    public static ProgressEvent create(@Nullable SVNEvent event) {
        ProgressEvent result = null;
        if (event != null) {
            result = event.getFile() == null && event.getURL() == null ? new ProgressEvent(event.getErrorMessage()) : new ProgressEvent(event.getFile(), event.getRevision(), StatusType.from(event.getContentsStatus()), StatusType.from(event.getPropertiesStatus()), EventAction.from(event.getAction()), event.getErrorMessage(), event.getURL());
        }
        return result;
    }

    public ProgressEvent(SVNErrorMessage errorMessage) {
        this(null, 0L, null, null, EventAction.SKIP, errorMessage, null);
    }

    public ProgressEvent(File file, long revision, @Nullable StatusType contentStatus, @Nullable StatusType propertiesStatus, EventAction action, SVNErrorMessage error, SVNURL url) {
        this.myFile = file != null ? file.getAbsoluteFile() : null;
        this.myRevision = revision;
        this.myContentsStatus = contentStatus == null ? StatusType.INAPPLICABLE : contentStatus;
        this.myPropertiesStatus = propertiesStatus == null ? StatusType.INAPPLICABLE : propertiesStatus;
        this.myAction = action;
        this.myErrorMessage = error;
        this.myURL = url;
    }

    public File getFile() {
        return this.myFile;
    }

    public EventAction getAction() {
        return this.myAction;
    }

    @NotNull
    public StatusType getContentsStatus() {
        StatusType statusType = this.myContentsStatus;
        if (statusType == null) {
            ProgressEvent.$$$reportNull$$$0(0);
        }
        return statusType;
    }

    public SVNErrorMessage getErrorMessage() {
        return this.myErrorMessage;
    }

    @NotNull
    public StatusType getPropertiesStatus() {
        StatusType statusType = this.myPropertiesStatus;
        if (statusType == null) {
            ProgressEvent.$$$reportNull$$$0(1);
        }
        return statusType;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public SVNURL getURL() {
        return this.myURL;
    }

    @Nullable
    public String getPath() {
        return this.myFile != null ? this.myFile.getName() : (this.myURL != null ? this.myURL.toString() : null);
    }

    public String toString() {
        return (Object)((Object)this.getAction()) + " " + this.getFile() + " " + this.getURL();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/svn/api/ProgressEvent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentsStatus";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesStatus";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

