/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.idea.RareLogger;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.apache.log4j.Level;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;

public class SvnExceptionLogFilter
implements RareLogger.LogFilter {
    private static final int ourLogUsualInterval = 20000;
    private static final int ourLogRareInterval = 30000;
    private static final Set<SVNErrorCode> ourLogRarelyCodes = ContainerUtil.newHashSet((Object[])new SVNErrorCode[]{SVNErrorCode.WC_UNSUPPORTED_FORMAT, SVNErrorCode.WC_CORRUPT, SVNErrorCode.WC_CORRUPT_TEXT_BASE, SVNErrorCode.WC_NOT_FILE, SVNErrorCode.WC_NOT_DIRECTORY, SVNErrorCode.WC_PATH_NOT_FOUND});

    public Object getKey(@NotNull Level level, @NonNls String message, @Nullable Throwable t, String ... details) {
        SVNException e;
        if (level == null) {
            SvnExceptionLogFilter.$$$reportNull$$$0(0);
        }
        boolean shouldFilter = (e = SvnExceptionLogFilter.getSvnException(t)) != null && ourLogRarelyCodes.contains(e.getErrorMessage().getErrorCode());
        return shouldFilter ? e.getErrorMessage().getErrorCode() : null;
    }

    @NotNull
    public Integer getAllowedLoggingInterval(Level level, String message, Throwable t, String[] details) {
        SVNException e = SvnExceptionLogFilter.getSvnException(t);
        boolean shouldFilter = e != null && ourLogRarelyCodes.contains(e.getErrorMessage().getErrorCode());
        Integer n = shouldFilter ? 30000 : 20000;
        if (n == null) {
            SvnExceptionLogFilter.$$$reportNull$$$0(1);
        }
        return n;
    }

    @Nullable
    private static SVNException getSvnException(@Nullable Throwable t) {
        SVNException result = null;
        if (t instanceof SVNException) {
            result = (SVNException)t;
        } else if (t instanceof VcsException && t.getCause() instanceof SVNException) {
            result = (SVNException)t.getCause();
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/SvnExceptionLogFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/SvnExceptionLogFilter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllowedLoggingInterval";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getKey";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

