/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRepository;
import icons.GithubIcons;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubOpenInBrowserAction
extends DumbAwareAction {
    public static final String CANNOT_OPEN_IN_BROWSER = "Can't open in browser";

    public GithubOpenInBrowserAction() {
        super("Open on GitHub", "Open corresponding link in browser", GithubIcons.Github_icon);
    }

    public void update(AnActionEvent e) {
        CommitData data = this.getData(e);
        e.getPresentation().setEnabled(data != null && (data.revisionHash != null || data.virtualFile != null));
        e.getPresentation().setVisible(data != null);
    }

    public void actionPerformed(AnActionEvent e) {
        CommitData data = this.getData(e);
        assert (data != null);
        assert (data.revisionHash != null || data.virtualFile != null);
        if (data.revisionHash != null) {
            GithubOpenInBrowserAction.openCommitInBrowser(data.project, data.repository, data.revisionHash);
        } else {
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            GithubOpenInBrowserAction.openFileInBrowser(data.project, data.repository, data.virtualFile, editor);
        }
    }

    @Nullable
    protected CommitData getData(AnActionEvent e) {
        CommitData data = GithubOpenInBrowserAction.getDataFromHistory(e);
        if (data == null) {
            data = GithubOpenInBrowserAction.getDataFromLog(e);
        }
        if (data == null) {
            data = GithubOpenInBrowserAction.getDataFromVirtualFile(e);
        }
        return data;
    }

    protected static void openCommitInBrowser(@NotNull Project project, @NotNull GitRepository repository, @NotNull String revisionHash) {
        String url;
        if (project == null) {
            GithubOpenInBrowserAction.$$$reportNull$$$0(0);
        }
        if (repository == null) {
            GithubOpenInBrowserAction.$$$reportNull$$$0(1);
        }
        if (revisionHash == null) {
            GithubOpenInBrowserAction.$$$reportNull$$$0(2);
        }
        if ((url = GithubUtil.findGithubRemoteUrl(repository)) == null) {
            GithubUtil.LOG.info(String.format("Repository is not under GitHub. Root: %s, Remotes: %s", repository.getRoot(), GitUtil.getPrintableRemotes((Collection)repository.getRemotes())));
            return;
        }
        GithubFullPath userAndRepository = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(url);
        if (userAndRepository == null) {
            GithubNotifications.showError(project, CANNOT_OPEN_IN_BROWSER, "Can't extract info about repository: " + url);
            return;
        }
        String githubUrl = GithubUrlUtil.getGithubHost() + '/' + userAndRepository.getUser() + '/' + userAndRepository.getRepository() + "/commit/" + revisionHash;
        BrowserUtil.browse((String)githubUrl);
    }

    private static void openFileInBrowser(@NotNull Project project, @NotNull GitRepository repository, @NotNull VirtualFile virtualFile, @Nullable Editor editor) {
        String githubRemoteUrl;
        if (project == null) {
            GithubOpenInBrowserAction.$$$reportNull$$$0(3);
        }
        if (repository == null) {
            GithubOpenInBrowserAction.$$$reportNull$$$0(4);
        }
        if (virtualFile == null) {
            GithubOpenInBrowserAction.$$$reportNull$$$0(5);
        }
        if ((githubRemoteUrl = GithubUtil.findGithubRemoteUrl(repository)) == null) {
            GithubUtil.LOG.info(String.format("Repository is not under GitHub. Root: %s, Remotes: %s", repository.getRoot(), GitUtil.getPrintableRemotes((Collection)repository.getRemotes())));
            return;
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)repository.getRoot());
        if (relativePath == null) {
            GithubNotifications.showError(project, CANNOT_OPEN_IN_BROWSER, "File is not under repository root", "Root: " + repository.getRoot().getPresentableUrl() + ", file: " + virtualFile.getPresentableUrl());
            return;
        }
        String hash = GithubOpenInBrowserAction.getCurrentFileRevisionHash(project, virtualFile);
        if (hash == null) {
            GithubNotifications.showError(project, CANNOT_OPEN_IN_BROWSER, "Can't get last revision.");
            return;
        }
        String githubUrl = GithubOpenInBrowserAction.makeUrlToOpen(editor, relativePath, hash, githubRemoteUrl);
        if (githubUrl != null) {
            BrowserUtil.browse((String)githubUrl);
        }
    }

    @Nullable
    private static CommitData getDataFromHistory(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        VcsFileRevision fileRevision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
        if (project == null || filePath == null || fileRevision == null) {
            return null;
        }
        if (!(fileRevision instanceof GitFileRevision)) {
            return null;
        }
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForFile(filePath);
        if (repository == null || !GithubUtil.isRepositoryOnGitHub(repository)) {
            return null;
        }
        return new CommitData(project, repository, fileRevision.getRevisionNumber().asString());
    }

    @Nullable
    private static CommitData getDataFromLog(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        if (project == null || log == null) {
            return null;
        }
        List selectedCommits = log.getSelectedCommits();
        if (selectedCommits.size() != 1) {
            return null;
        }
        CommitId commit = (CommitId)ContainerUtil.getFirstItem((List)selectedCommits);
        if (commit == null) {
            return null;
        }
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForRoot(commit.getRoot());
        if (repository == null || !GithubUtil.isRepositoryOnGitHub(repository)) {
            return null;
        }
        return new CommitData(project, repository, commit.getHash().asString());
    }

    @Nullable
    private static CommitData getDataFromVirtualFile(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || virtualFile == null) {
            return null;
        }
        GitRepository gitRepository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForFile(virtualFile);
        if (gitRepository == null || !GithubUtil.isRepositoryOnGitHub(gitRepository)) {
            return null;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        if (changeListManager.isUnversioned(virtualFile)) {
            return new CommitData(project, gitRepository);
        }
        Change change = changeListManager.getChange(virtualFile);
        if (change != null && change.getType() == Change.Type.NEW) {
            return new CommitData(project, gitRepository);
        }
        return new CommitData(project, gitRepository, virtualFile);
    }

    @Nullable
    private static String getCurrentFileRevisionHash(final @NotNull Project project, final @NotNull VirtualFile file) {
        if (project == null) {
            GithubOpenInBrowserAction.$$$reportNull$$$0(6);
        }
        if (file == null) {
            GithubOpenInBrowserAction.$$$reportNull$$$0(7);
        }
        final Ref ref = new Ref();
        ProgressManager.getInstance().run((Task)new Task.Modal(project, "Getting Last Revision", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    ref.set((Object)((GitRevisionNumber)GitHistoryUtils.getCurrentRevision((Project)project, (FilePath)VcsUtil.getFilePath((VirtualFile)file), (String)"HEAD")));
                }
                catch (VcsException e) {
                    GithubUtil.LOG.warn((Throwable)e);
                }
            }

            public void onCancel() {
                throw new ProcessCanceledException();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubOpenInBrowserAction$1", "run"));
            }
        });
        if (ref.isNull()) {
            return null;
        }
        return ((GitRevisionNumber)ref.get()).getRev();
    }

    @Nullable
    private static String makeUrlToOpen(@Nullable Editor editor, @NotNull String relativePath, @NotNull String branch, @NotNull String githubRemoteUrl) {
        if (relativePath == null) {
            GithubOpenInBrowserAction.$$$reportNull$$$0(8);
        }
        if (branch == null) {
            GithubOpenInBrowserAction.$$$reportNull$$$0(9);
        }
        if (githubRemoteUrl == null) {
            GithubOpenInBrowserAction.$$$reportNull$$$0(10);
        }
        StringBuilder builder = new StringBuilder();
        String githubRepoUrl = GithubUrlUtil.makeGithubRepoUrlFromRemoteUrl(githubRemoteUrl);
        if (githubRepoUrl == null) {
            return null;
        }
        if (StringUtil.isEmptyOrSpaces((String)relativePath)) {
            builder.append(githubRepoUrl).append("/tree/").append(branch);
        } else {
            builder.append(githubRepoUrl).append("/blob/").append(branch).append('/').append(relativePath);
        }
        if (editor != null && editor.getDocument().getLineCount() >= 1) {
            SelectionModel selectionModel = editor.getSelectionModel();
            int begin = editor.getDocument().getLineNumber(selectionModel.getSelectionStart()) + 1;
            int selectionEnd = selectionModel.getSelectionEnd();
            int end = editor.getDocument().getLineNumber(selectionEnd) + 1;
            if (editor.getDocument().getLineStartOffset(end - 1) == selectionEnd) {
                --end;
            }
            builder.append("#L").append(begin);
            if (begin != end) {
                builder.append("-L").append(end);
            }
        }
        return builder.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionHash";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "githubRemoteUrl";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/github/GithubOpenInBrowserAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "openCommitInBrowser";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "openFileInBrowser";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getCurrentFileRevisionHash";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "makeUrlToOpen";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class CommitData {
        @NotNull
        private final Project project;
        @NotNull
        private final GitRepository repository;
        @Nullable
        private final String revisionHash;
        @Nullable
        private final VirtualFile virtualFile;

        public CommitData(@NotNull Project project, @NotNull GitRepository repository) {
            if (project == null) {
                CommitData.$$$reportNull$$$0(0);
            }
            if (repository == null) {
                CommitData.$$$reportNull$$$0(1);
            }
            this.project = project;
            this.repository = repository;
            this.revisionHash = null;
            this.virtualFile = null;
        }

        public CommitData(@NotNull Project project, @NotNull GitRepository repository, @Nullable String revisionHash) {
            if (project == null) {
                CommitData.$$$reportNull$$$0(2);
            }
            if (repository == null) {
                CommitData.$$$reportNull$$$0(3);
            }
            this.project = project;
            this.repository = repository;
            this.revisionHash = revisionHash;
            this.virtualFile = null;
        }

        public CommitData(@NotNull Project project, @NotNull GitRepository repository, @Nullable VirtualFile virtualFile) {
            if (project == null) {
                CommitData.$$$reportNull$$$0(4);
            }
            if (repository == null) {
                CommitData.$$$reportNull$$$0(5);
            }
            this.project = project;
            this.repository = repository;
            this.revisionHash = null;
            this.virtualFile = virtualFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repository";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/github/GithubOpenInBrowserAction$CommitData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

