/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl.compiler;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.util.JpsPathUtil;

public class JpsCompilerExcludesImpl
implements JpsCompilerExcludes {
    private final Set<File> myFiles = new LinkedHashSet<File>();
    private final Set<File> myDirectories = new LinkedHashSet<File>();
    private final Set<File> myRecursivelyExcludedDirectories = new LinkedHashSet<File>();

    public void addExcludedFile(String url) {
        this.addExcludedFile(JpsPathUtil.urlToFile((String)url));
    }

    public void addExcludedDirectory(String url, boolean recursively) {
        this.addExcludedDirectory(JpsPathUtil.urlToFile((String)url), recursively);
    }

    protected void addExcludedFile(File file2) {
        this.myFiles.add(file2);
    }

    protected void addExcludedDirectory(File dir, boolean recursively) {
        (recursively ? this.myRecursivelyExcludedDirectories : this.myDirectories).add(dir);
    }

    public boolean isExcluded(File file2) {
        if (this.myFiles.contains(file2)) {
            return true;
        }
        if (!this.myDirectories.isEmpty() || !this.myRecursivelyExcludedDirectories.isEmpty()) {
            File parent = FileUtilRt.getParentFile((File)file2);
            if (this.myDirectories.contains(parent)) {
                return true;
            }
            while (parent != null) {
                if (this.myRecursivelyExcludedDirectories.contains(parent)) {
                    return true;
                }
                parent = FileUtilRt.getParentFile((File)parent);
            }
        }
        return false;
    }

    public Set<File> getExcludedFiles() {
        return this.myFiles;
    }

    public Set<File> getExcludedDirectories() {
        return this.myDirectories;
    }

    public Set<File> getRecursivelyExcludedDirectories() {
        return this.myRecursivelyExcludedDirectories;
    }
}

