/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.google.common.collect.ObjectArrays;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.run.PythonConfigurationFactoryBase;
import com.jetbrains.python.testing.PyTestLegacyInteropKt;
import com.jetbrains.python.testing.PyTestsSharedKt;
import com.jetbrains.python.testing.doctest.PythonDocTestRunConfiguration;
import com.jetbrains.python.testing.nosetestLegacy.PythonNoseTestRunConfiguration;
import com.jetbrains.python.testing.pytestLegacy.PyTestRunConfiguration;
import com.jetbrains.python.testing.unittestLegacy.PythonUnitTestRunConfiguration;
import icons.PythonIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class PythonTestConfigurationType
implements ConfigurationType {
    public static final String ID = "tests";
    public final PythonConfigurationFactoryBase PY_DOCTEST_FACTORY = new PythonDocTestConfigurationFactory(this);
    public final PythonConfigurationFactoryBase LEGACY_UNITTEST_FACTORY = new PythonLegacyUnitTestConfigurationFactory(this);
    public final PythonConfigurationFactoryBase LEGACY_NOSETEST_FACTORY = new PythonLegacyNoseTestConfigurationFactory(this);
    public final PythonConfigurationFactoryBase LEGACY_PYTEST_FACTORY = new PythonLegacyPyTestConfigurationFactory(this);

    public static PythonTestConfigurationType getInstance() {
        return (PythonTestConfigurationType)ConfigurationTypeUtil.findConfigurationType(PythonTestConfigurationType.class);
    }

    public String getDisplayName() {
        return PyBundle.message("runcfg.test.display_name", new Object[0]);
    }

    public String getConfigurationTypeDescription() {
        return PyBundle.message("runcfg.test.description", new Object[0]);
    }

    public Icon getIcon() {
        return PythonIcons.Python.PythonTests;
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            PythonTestConfigurationType.$$$reportNull$$$0(0);
        }
        return ID;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        PythonConfigurationFactoryBase[] pythonConfigurationFactoryBaseArray;
        if (PyTestLegacyInteropKt.isNewTestsModeEnabled()) {
            pythonConfigurationFactoryBaseArray = PyTestsSharedKt.getFactories();
        } else {
            ConfigurationFactory[] configurationFactoryArray = new ConfigurationFactory[3];
            configurationFactoryArray[0] = this.LEGACY_UNITTEST_FACTORY;
            configurationFactoryArray[1] = this.LEGACY_NOSETEST_FACTORY;
            pythonConfigurationFactoryBaseArray = configurationFactoryArray;
            configurationFactoryArray[2] = this.LEGACY_PYTEST_FACTORY;
        }
        PythonConfigurationFactoryBase[] factories = pythonConfigurationFactoryBaseArray;
        return (ConfigurationFactory[])ObjectArrays.concat((Object[])factories, (Object)((Object)this.PY_DOCTEST_FACTORY));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/testing/PythonTestConfigurationType", "getId"));
    }

    private static class PythonLegacyNoseTestConfigurationFactory
    extends PythonConfigurationFactoryBase {
        protected PythonLegacyNoseTestConfigurationFactory(ConfigurationType configurationType) {
            super(configurationType);
        }

        public RunConfiguration createTemplateConfiguration(Project project) {
            return new PythonNoseTestRunConfiguration(project, this);
        }

        public String getName() {
            return PyBundle.message("runcfg.nosetests.display_name", new Object[0]);
        }
    }

    private static class PythonLegacyPyTestConfigurationFactory
    extends PythonConfigurationFactoryBase {
        protected PythonLegacyPyTestConfigurationFactory(ConfigurationType configurationType) {
            super(configurationType);
        }

        public RunConfiguration createTemplateConfiguration(Project project) {
            return new PyTestRunConfiguration(project, this);
        }

        public String getName() {
            return PyBundle.message("runcfg.pytest.display_name", new Object[0]);
        }
    }

    private static class PythonDocTestConfigurationFactory
    extends PythonConfigurationFactoryBase {
        protected PythonDocTestConfigurationFactory(ConfigurationType configurationType) {
            super(configurationType);
        }

        public RunConfiguration createTemplateConfiguration(Project project) {
            return new PythonDocTestRunConfiguration(project, this);
        }

        public String getName() {
            return PyBundle.message("runcfg.doctest.display_name", new Object[0]);
        }
    }

    private static class PythonLegacyUnitTestConfigurationFactory
    extends PythonConfigurationFactoryBase {
        protected PythonLegacyUnitTestConfigurationFactory(ConfigurationType configurationType) {
            super(configurationType);
        }

        public RunConfiguration createTemplateConfiguration(Project project) {
            return new PythonUnitTestRunConfiguration(project, this);
        }

        public String getName() {
            return PyBundle.message("runcfg.unittest.display_name", new Object[0]);
        }
    }
}

