/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.google.common.collect.Lists;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.AbstractRunConfiguration;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonModuleTypeBase;
import com.jetbrains.python.run.AbstractPythonRunConfigurationParams;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PyCommonOptionsFormData;
import com.jetbrains.python.run.PythonExtendedConfigurationEditor;
import com.jetbrains.python.run.PythonRunConfigurationExtensionsManager;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPythonRunConfiguration<T extends AbstractPythonRunConfiguration<T>>
extends AbstractRunConfiguration
implements AbstractPythonRunConfigurationParams,
CommandLinePatcher {
    private String myInterpreterOptions = "";
    private String myWorkingDirectory = "";
    private String mySdkHome = "";
    private boolean myUseModuleSdk;
    private boolean myAddContentRoots = true;
    private boolean myAddSourceRoots = true;
    protected PathMappingSettings myMappingSettings;
    protected boolean mySkipModuleSerialization;

    public AbstractPythonRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
        this.getConfigurationModule().init();
    }

    public List<Module> getValidModules() {
        return AbstractPythonRunConfiguration.getValidModules(this.getProject());
    }

    @Override
    public PathMappingSettings getMappingSettings() {
        return this.myMappingSettings;
    }

    @Override
    public void setMappingSettings(@Nullable PathMappingSettings mappingSettings) {
        this.myMappingSettings = mappingSettings;
    }

    public boolean isIdTestBased() {
        return false;
    }

    public static List<Module> getValidModules(Project project) {
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        ArrayList result2 = Lists.newArrayList();
        for (Module module2 : modules) {
            if (PythonSdkType.findPythonSdk(module2) == null) continue;
            result2.add(module2);
        }
        return result2;
    }

    public PyCommonOptionsFormData getCommonOptionsFormData() {
        return new PyCommonOptionsFormData(){

            @Override
            public Project getProject() {
                return AbstractPythonRunConfiguration.this.getProject();
            }

            @Override
            public List<Module> getValidModules() {
                return AbstractPythonRunConfiguration.this.getValidModules();
            }

            @Override
            public boolean showConfigureInterpretersLink() {
                return false;
            }
        };
    }

    @NotNull
    public final SettingsEditor<T> getConfigurationEditor() {
        PythonExtendedConfigurationEditor<T> runConfigurationEditor = PythonExtendedConfigurationEditor.create(this.createConfigurationEditor());
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), runConfigurationEditor);
        PythonRunConfigurationExtensionsManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(0);
        }
        return settingsEditorGroup;
    }

    protected abstract SettingsEditor<T> createConfigurationEditor();

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        this.checkSdk();
        this.checkExtensions();
    }

    private void checkExtensions() throws RuntimeConfigurationException {
        try {
            PythonRunConfigurationExtensionsManager.getInstance().validateConfiguration((RunConfigurationBase)this, false);
        }
        catch (RuntimeConfigurationException e) {
            throw e;
        }
        catch (Exception ee) {
            throw new RuntimeConfigurationException(ee.getMessage());
        }
    }

    private void checkSdk() throws RuntimeConfigurationError {
        if (PlatformUtils.isPyCharm()) {
            String path = this.getInterpreterPath();
            if (StringUtil.isEmptyOrSpaces((String)path)) {
                throw new RuntimeConfigurationError("Please select a valid Python interpreter");
            }
        } else if (!this.myUseModuleSdk) {
            if (StringUtil.isEmptyOrSpaces((String)this.getSdkHome())) {
                Sdk projectSdk = ProjectRootManager.getInstance((Project)this.getProject()).getProjectSdk();
                if (projectSdk == null || !(projectSdk.getSdkType() instanceof PythonSdkType)) {
                    throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_sdk", new Object[0]));
                }
            } else if (!PythonSdkType.getInstance().isValidSdkHome(this.getSdkHome())) {
                throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_valid_sdk", new Object[0]));
            }
        } else {
            Sdk sdk = PythonSdkType.findPythonSdk(this.getModule());
            if (sdk == null) {
                throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_module_sdk", new Object[0]));
            }
        }
    }

    @Override
    public String getSdkHome() {
        Sdk projectJdk;
        String sdkHome = this.mySdkHome;
        if (StringUtil.isEmptyOrSpaces((String)this.mySdkHome) && (projectJdk = PythonSdkType.findPythonSdk(this.getModule())) != null) {
            sdkHome = projectJdk.getHomePath();
        }
        return sdkHome;
    }

    @Nullable
    public String getInterpreterPath() {
        String sdkHome;
        if (this.myUseModuleSdk) {
            Sdk sdk = PythonSdkType.findPythonSdk(this.getModule());
            if (sdk == null) {
                return null;
            }
            sdkHome = sdk.getHomePath();
        } else {
            sdkHome = this.getSdkHome();
        }
        return sdkHome;
    }

    @Nullable
    public Sdk getSdk() {
        if (this.myUseModuleSdk) {
            return PythonSdkType.findPythonSdk(this.getModule());
        }
        return PythonSdkType.findSdkByPath(this.getSdkHome());
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(1);
        }
        super.readExternal(element);
        this.myInterpreterOptions = JDOMExternalizerUtil.readField((Element)element, (String)"INTERPRETER_OPTIONS");
        this.readEnvs(element);
        this.mySdkHome = JDOMExternalizerUtil.readField((Element)element, (String)"SDK_HOME");
        this.myWorkingDirectory = JDOMExternalizerUtil.readField((Element)element, (String)"WORKING_DIRECTORY");
        this.myUseModuleSdk = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)"IS_MODULE_SDK"));
        String addContentRoots = JDOMExternalizerUtil.readField((Element)element, (String)"ADD_CONTENT_ROOTS");
        this.myAddContentRoots = addContentRoots == null || Boolean.parseBoolean(addContentRoots);
        String addSourceRoots = JDOMExternalizerUtil.readField((Element)element, (String)"ADD_SOURCE_ROOTS");
        boolean bl = this.myAddSourceRoots = addSourceRoots == null || Boolean.parseBoolean(addSourceRoots);
        if (!this.mySkipModuleSerialization) {
            this.getConfigurationModule().readExternal(element);
        }
        this.setMappingSettings(PathMappingSettings.readExternal((Element)element));
        PythonRunConfigurationExtensionsManager.getInstance().readExternal((RunConfigurationBase)this, element);
    }

    protected void readEnvs(Element element) {
        String parentEnvs = JDOMExternalizerUtil.readField((Element)element, (String)"PARENT_ENVS");
        if (parentEnvs != null) {
            this.setPassParentEnvs(Boolean.parseBoolean(parentEnvs));
        }
        EnvironmentVariablesComponent.readExternal(element, this.getEnvs());
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(2);
        }
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)"INTERPRETER_OPTIONS", (String)this.myInterpreterOptions);
        this.writeEnvs(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)"SDK_HOME", (String)this.mySdkHome);
        JDOMExternalizerUtil.writeField((Element)element, (String)"WORKING_DIRECTORY", (String)this.myWorkingDirectory);
        JDOMExternalizerUtil.writeField((Element)element, (String)"IS_MODULE_SDK", (String)Boolean.toString(this.myUseModuleSdk));
        JDOMExternalizerUtil.writeField((Element)element, (String)"ADD_CONTENT_ROOTS", (String)Boolean.toString(this.myAddContentRoots));
        JDOMExternalizerUtil.writeField((Element)element, (String)"ADD_SOURCE_ROOTS", (String)Boolean.toString(this.myAddSourceRoots));
        if (!this.mySkipModuleSerialization) {
            this.getConfigurationModule().writeExternal(element);
        }
        PythonRunConfigurationExtensionsManager.getInstance().writeExternal((RunConfigurationBase)this, element);
        PathMappingSettings.writeExternal((Element)element, (PathMappingSettings)this.getMappingSettings());
    }

    protected void writeEnvs(Element element) {
        JDOMExternalizerUtil.writeField((Element)element, (String)"PARENT_ENVS", (String)Boolean.toString(this.isPassParentEnvs()));
        EnvironmentVariablesComponent.writeExternal(element, this.getEnvs());
    }

    @Override
    public String getInterpreterOptions() {
        return this.myInterpreterOptions;
    }

    @Override
    public void setInterpreterOptions(String interpreterOptions) {
        this.myInterpreterOptions = interpreterOptions;
    }

    @Override
    public String getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    @Override
    public void setWorkingDirectory(String workingDirectory) {
        this.myWorkingDirectory = workingDirectory;
    }

    @Override
    public void setSdkHome(String sdkHome) {
        this.mySdkHome = sdkHome;
    }

    @Override
    @Nullable
    public Module getModule() {
        return this.getConfigurationModule().getModule();
    }

    @NotNull
    public final Module getModuleNotNull() throws ExecutionException {
        Module module2 = this.getModule();
        if (module2 == null) {
            throw new ExecutionException("No module set for configuration, please choose one");
        }
        Module module3 = module2;
        if (module3 == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(3);
        }
        return module3;
    }

    @Override
    public boolean isUseModuleSdk() {
        return this.myUseModuleSdk;
    }

    @Override
    public void setUseModuleSdk(boolean useModuleSdk) {
        this.myUseModuleSdk = useModuleSdk;
    }

    @Override
    public boolean shouldAddContentRoots() {
        return this.myAddContentRoots;
    }

    @Override
    public boolean shouldAddSourceRoots() {
        return this.myAddSourceRoots;
    }

    @Override
    public void setAddSourceRoots(boolean flag) {
        this.myAddSourceRoots = flag;
    }

    @Override
    public void setAddContentRoots(boolean flag) {
        this.myAddContentRoots = flag;
    }

    public static void copyParams(AbstractPythonRunConfigurationParams source, AbstractPythonRunConfigurationParams target2) {
        target2.setEnvs(new HashMap<String, String>(source.getEnvs()));
        target2.setInterpreterOptions(source.getInterpreterOptions());
        target2.setPassParentEnvs(source.isPassParentEnvs());
        target2.setSdkHome(source.getSdkHome());
        target2.setWorkingDirectory(source.getWorkingDirectory());
        target2.setModule(source.getModule());
        target2.setUseModuleSdk(source.isUseModuleSdk());
        target2.setMappingSettings(source.getMappingSettings());
        target2.setAddContentRoots(source.shouldAddContentRoots());
        target2.setAddSourceRoots(source.shouldAddSourceRoots());
    }

    @Override
    public void patchCommandLine(GeneralCommandLine commandLine) {
        String interpreterPath = this.getInterpreterPath();
        Sdk sdk = this.getSdk();
        if (sdk != null && interpreterPath != null) {
            this.patchCommandLineFirst(commandLine, interpreterPath);
            this.patchCommandLineForVirtualenv(commandLine, interpreterPath);
            this.patchCommandLineForBuildout(commandLine, interpreterPath);
            this.patchCommandLineLast(commandLine, interpreterPath);
        }
    }

    protected void patchCommandLineFirst(GeneralCommandLine commandLine, String sdkHome) {
    }

    protected void patchCommandLineLast(GeneralCommandLine commandLine, String sdkHome) {
    }

    protected void patchCommandLineForBuildout(GeneralCommandLine commandLine, String sdkHome) {
    }

    protected void patchCommandLineForVirtualenv(GeneralCommandLine commandLine, String sdkHome) {
        PythonSdkType.patchCommandLineForVirtualenv(commandLine, sdkHome, this.isPassParentEnvs());
    }

    protected void setUnbufferedEnv() {
        Map envs = this.getEnvs();
        PythonEnvUtil.setPythonUnbuffered(envs);
    }

    public boolean excludeCompileBeforeLaunchOption() {
        Module module2 = this.getModule();
        return module2 != null ? ModuleType.get((Module)module2) instanceof PythonModuleTypeBase : true;
    }

    public boolean canRunWithCoverage() {
        return true;
    }

    @NotNull
    public String getWorkingDirectorySafe() {
        String result2;
        String string = result2 = StringUtil.isEmpty((String)this.myWorkingDirectory) ? this.getProject().getBasePath() : this.myWorkingDirectory;
        if (result2 != null) {
            String string2 = result2;
            if (string2 == null) {
                AbstractPythonRunConfiguration.$$$reportNull$$$0(4);
            }
            return string2;
        }
        String firstModuleRoot = this.getFirstModuleRoot();
        if (firstModuleRoot != null) {
            String string3 = firstModuleRoot;
            if (string3 == null) {
                AbstractPythonRunConfiguration.$$$reportNull$$$0(5);
            }
            return string3;
        }
        String string4 = new File(".").getAbsolutePath();
        if (string4 == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(6);
        }
        return string4;
    }

    @Nullable
    private String getFirstModuleRoot() {
        Module module2 = this.getModule();
        if (module2 == null) {
            return null;
        }
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        return roots.length > 0 ? roots[0].getPath() : null;
    }

    @Override
    public String getModuleName() {
        Module module2 = this.getModule();
        return module2 != null ? module2.getName() : null;
    }

    public boolean isCompileBeforeLaunchAddedByDefault() {
        return false;
    }

    public void addTestSpecsAsParameters(@NotNull ParamsGroup paramsGroup, @NotNull List<String> testSpecs) {
        if (paramsGroup == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(7);
        }
        if (testSpecs == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(8);
        }
        paramsGroup.addParameters(testSpecs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/run/AbstractPythonRunConfiguration";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramsGroup";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testSpecs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/run/AbstractPythonRunConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleNotNull";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectorySafe";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addTestSpecsAsParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

