/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes;

import com.google.common.collect.Collections2;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.codeInsight.imports.PyImportOptimizer;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.refactoring.classes.PyDependenciesComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyClassRefactoringUtil {
    private static final Logger LOG = Logger.getInstance((String)PyClassRefactoringUtil.class.getName());
    private static final Key<PsiNamedElement> ENCODED_IMPORT = Key.create((String)"PyEncodedImport");
    private static final Key<Boolean> ENCODED_USE_FROM_IMPORT = Key.create((String)"PyEncodedUseFromImport");
    private static final Key<String> ENCODED_IMPORT_AS = Key.create((String)"PyEncodedImportAs");

    private PyClassRefactoringUtil() {
    }

    @NotNull
    public static List<PyAssignmentStatement> copyFieldDeclarationToStatement(@NotNull Collection<PyAssignmentStatement> assignmentStatements, @NotNull PyStatementList superClassStatement, @Nullable PyClass dequalifyIfDeclaredInClass) {
        if (assignmentStatements == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(0);
        }
        if (superClassStatement == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(1);
        }
        ArrayList<PyAssignmentStatement> declarations = new ArrayList<PyAssignmentStatement>(assignmentStatements.size());
        Collections.sort(declarations, PyDependenciesComparator.INSTANCE);
        for (PyAssignmentStatement pyAssignmentStatement : assignmentStatements) {
            PyExpression value = pyAssignmentStatement.getAssignedValue();
            PyAssignmentStatement newDeclaration = (PyAssignmentStatement)pyAssignmentStatement.copy();
            if (value instanceof PyReferenceExpression && dequalifyIfDeclaredInClass != null) {
                String newValue = PyClassRefactoringUtil.getNewValueToAssign((PyReferenceExpression)value, dequalifyIfDeclaredInClass);
                PyClassRefactoringUtil.setNewAssigneeValue(newDeclaration, newValue);
            }
            declarations.add(PyUtil.addElementToStatementList(newDeclaration, superClassStatement));
            PyPsiUtils.removeRedundantPass(superClassStatement);
        }
        ArrayList<PyAssignmentStatement> arrayList = declarations;
        if (arrayList == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static void setNewAssigneeValue(@NotNull PyAssignmentStatement assignmentStatement, @NotNull String newValue) {
        if (assignmentStatement == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(3);
        }
        if (newValue == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(4);
        }
        PyExpression oldValue = assignmentStatement.getAssignedValue();
        PyExpression newExpression = PyElementGenerator.getInstance(assignmentStatement.getProject()).createExpressionFromText(LanguageLevel.forElement(assignmentStatement), newValue);
        if (oldValue != null) {
            oldValue.replace((PsiElement)newExpression);
        } else {
            assignmentStatement.add((PsiElement)newExpression);
        }
    }

    @NotNull
    private static String getNewValueToAssign(@NotNull PyReferenceExpression currentValue, @NotNull PyClass dequalifyIfDeclaredInClass) {
        PyExpression qualifier;
        if (currentValue == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(5);
        }
        if (dequalifyIfDeclaredInClass == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(6);
        }
        if ((qualifier = currentValue.getQualifier()) instanceof PyReferenceExpression && ((PyReferenceExpression)qualifier).getReference().isReferenceTo((PsiElement)dequalifyIfDeclaredInClass)) {
            String name = currentValue.getName();
            String string = name != null ? name : currentValue.getText();
            if (string == null) {
                PyClassRefactoringUtil.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = currentValue.getText();
        if (string == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static List<PyFunction> copyMethods(Collection<PyFunction> methods, PyClass superClass, boolean skipIfExist) {
        if (methods.isEmpty()) {
            List<PyFunction> list2 = Collections.emptyList();
            if (list2 == null) {
                PyClassRefactoringUtil.$$$reportNull$$$0(9);
            }
            return list2;
        }
        for (PsiElement psiElement : methods) {
            PyClassRefactoringUtil.rememberNamedReferences(psiElement, new String[0]);
        }
        PyFunction[] elements = methods.toArray(new PyFunction[methods.size()]);
        List<PyFunction> list3 = PyClassRefactoringUtil.addMethods(superClass, skipIfExist, elements);
        if (list3 == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(10);
        }
        return list3;
    }

    @NotNull
    public static List<PyFunction> addMethods(@NotNull PyClass destination, boolean skipIfExist, PyFunction ... methods) {
        if (destination == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(11);
        }
        if (methods == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(12);
        }
        PyStatementList destStatementList = destination.getStatementList();
        ArrayList<PyFunction> result2 = new ArrayList<PyFunction>(methods.length);
        for (PyFunction method : methods) {
            PyFunction existingMethod = destination.findMethodByName(method.getName(), false, null);
            if (existingMethod != null && skipIfExist) {
                result2.add(existingMethod);
                continue;
            }
            PyFunction newMethod = PyClassRefactoringUtil.insertMethodInProperPlace(destStatementList, method);
            result2.add(newMethod);
            PyClassRefactoringUtil.restoreNamedReferences(newMethod);
        }
        PyPsiUtils.removeRedundantPass(destStatementList);
        ArrayList<PyFunction> arrayList = result2;
        if (arrayList == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    private static PyFunction insertMethodInProperPlace(@NotNull PyStatementList destStatementList, @NotNull PyFunction method) {
        boolean methodIsInit;
        if (destStatementList == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(14);
        }
        if (method == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(15);
        }
        if (!(methodIsInit = PyUtil.isInit(method))) {
            PyFunction pyFunction = (PyFunction)destStatementList.add(method);
            if (pyFunction == null) {
                PyClassRefactoringUtil.$$$reportNull$$$0(16);
            }
            return pyFunction;
        }
        for (PsiElement element : destStatementList.getChildren()) {
            boolean elementComment = element instanceof PyExpressionStatement;
            boolean elementClassField = element instanceof PyAssignmentStatement;
            if (elementComment || elementClassField) continue;
            PyFunction pyFunction = (PyFunction)destStatementList.addBefore(method, element);
            if (pyFunction == null) {
                PyClassRefactoringUtil.$$$reportNull$$$0(17);
            }
            return pyFunction;
        }
        PyFunction pyFunction = (PyFunction)destStatementList.add(method);
        if (pyFunction == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(18);
        }
        return pyFunction;
    }

    public static void restoreNamedReferences(@NotNull PsiElement element) {
        if (element == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(19);
        }
        PyClassRefactoringUtil.restoreNamedReferences(element, null);
    }

    public static void restoreNamedReferences(@NotNull PsiElement newElement, @Nullable PsiElement oldElement) {
        if (newElement == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(20);
        }
        PyClassRefactoringUtil.restoreNamedReferences(newElement, oldElement, PsiElement.EMPTY_ARRAY);
    }

    public static void restoreNamedReferences(final @NotNull PsiElement newElement, final @Nullable PsiElement oldElement, final @NotNull PsiElement[] otherMovedElements) {
        if (newElement == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(21);
        }
        if (otherMovedElements == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(22);
        }
        newElement.acceptChildren((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitPyReferenceExpression(PyReferenceExpression node) {
                super.visitPyReferenceExpression(node);
                PyClassRefactoringUtil.restoreReference(node, otherMovedElements);
            }

            @Override
            public void visitPyStringLiteralExpression(PyStringLiteralExpression node) {
                super.visitPyStringLiteralExpression(node);
                for (PsiReference ref : node.getReferences()) {
                    if (!ref.isReferenceTo(oldElement)) continue;
                    ref.bindToElement(newElement);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restoreReference(@NotNull PyReferenceExpression node, @NotNull PsiElement[] otherMovedElements) {
        if (node == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(23);
        }
        if (otherMovedElements == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(24);
        }
        try {
            PyFunction f;
            PyClass c;
            Object target2 = (PsiNamedElement)node.getCopyableUserData(ENCODED_IMPORT);
            String asName = (String)node.getCopyableUserData(ENCODED_IMPORT_AS);
            Boolean useFromImport = (Boolean)node.getCopyableUserData(ENCODED_USE_FROM_IMPORT);
            if (target2 instanceof PsiDirectory) {
                target2 = (PsiNamedElement)PyUtil.getPackageElement((PsiDirectory)target2, (PsiElement)node);
            }
            if (target2 instanceof PyFunction && (c = (f = (PyFunction)target2).getContainingClass()) != null && c.findInitOrNew(false, null) == f) {
                target2 = c;
            }
            if (target2 == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)node.getContainingFile(), (PsiElement)target2, (boolean)false)) {
                return;
            }
            if (ArrayUtil.contains((Object)target2, (Object[])otherMovedElements)) {
                return;
            }
            if (target2 instanceof PyFile || target2 instanceof PsiDirectory) {
                PyClassRefactoringUtil.insertImport((PsiElement)node, target2, asName, useFromImport != null ? useFromImport : true);
            } else {
                PyClassRefactoringUtil.insertImport((PsiElement)node, target2, asName, true);
            }
        }
        finally {
            node.putCopyableUserData(ENCODED_IMPORT, null);
            node.putCopyableUserData(ENCODED_IMPORT_AS, null);
            node.putCopyableUserData(ENCODED_USE_FROM_IMPORT, null);
        }
    }

    public static void insertImport(PsiElement anchor, Collection<PsiNamedElement> elements) {
        for (PsiNamedElement newClass : elements) {
            PyClassRefactoringUtil.insertImport(anchor, newClass);
        }
    }

    public static boolean isValidQualifiedName(QualifiedName name) {
        if (name == null) {
            return false;
        }
        List components = name.getComponents();
        if (components.isEmpty()) {
            return false;
        }
        for (String s : components) {
            if (PyNames.isIdentifier(s) && !PyNames.isReserved(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean insertImport(@NotNull PsiElement anchor, @NotNull PsiNamedElement element) {
        if (anchor == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(25);
        }
        if (element == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(26);
        }
        return PyClassRefactoringUtil.insertImport(anchor, element, null);
    }

    public static boolean insertImport(@NotNull PsiElement anchor, @NotNull PsiNamedElement element, @Nullable String asName) {
        if (anchor == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(27);
        }
        if (element == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(28);
        }
        return PyClassRefactoringUtil.insertImport(anchor, element, asName, PyCodeInsightSettings.getInstance().PREFER_FROM_IMPORT);
    }

    public static boolean insertImport(@NotNull PsiElement anchor, @NotNull PsiNamedElement element, @Nullable String asName, boolean preferFromImport) {
        String importedName;
        QualifiedName containingQName;
        boolean importingModuleOrPackage;
        PsiFile file2;
        if (anchor == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(29);
        }
        if (element == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(30);
        }
        if (PyBuiltinCache.getInstance((PsiElement)element).isBuiltin((PsiElement)element)) {
            return false;
        }
        Object elementSource = element instanceof PsiDirectory ? (PsiFileSystemItem)element : element.getContainingFile();
        if (elementSource == (file2 = anchor.getContainingFile())) {
            return false;
        }
        QualifiedName qname = QualifiedNameFinder.findCanonicalImportPath((PsiElement)element, anchor);
        if (qname == null || !PyClassRefactoringUtil.isValidQualifiedName(qname)) {
            return false;
        }
        boolean bl = importingModuleOrPackage = element instanceof PyFile || element instanceof PsiDirectory;
        if (importingModuleOrPackage) {
            containingQName = qname.removeLastComponent();
            importedName = qname.getLastComponent();
        } else {
            containingQName = qname;
            importedName = PyClassRefactoringUtil.getOriginalName(element);
        }
        AddImportHelper.ImportPriority priority = AddImportHelper.getImportPriority(anchor, elementSource);
        if (preferFromImport && !containingQName.getComponents().isEmpty() || !importingModuleOrPackage) {
            return AddImportHelper.addOrUpdateFromImportStatement(file2, containingQName.toString(), importedName, asName, priority, anchor);
        }
        return AddImportHelper.addImportStatement(file2, containingQName.append(importedName).toString(), asName, priority, anchor);
    }

    public static void rememberNamedReferences(final @NotNull PsiElement element, final String ... namesToSkip) {
        if (element == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(31);
        }
        if (namesToSkip == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(32);
        }
        element.acceptChildren((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitPyReferenceExpression(PyReferenceExpression node) {
                super.visitPyReferenceExpression(node);
                if (PsiTreeUtil.getParentOfType((PsiElement)node, PyImportStatementBase.class) != null) {
                    return;
                }
                PyImportedNameDefiner importElement = PyClassRefactoringUtil.getImportElement(node);
                if (importElement != null && PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)importElement, (boolean)false)) {
                    return;
                }
                if (!ArrayUtil.contains((String)node.getText(), (String[])namesToSkip)) {
                    PyClassRefactoringUtil.rememberReference(node, element);
                }
            }
        });
    }

    private static void rememberReference(@NotNull PyReferenceExpression node, @NotNull PsiElement element) {
        PyExpression qualifier;
        if (node == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(33);
        }
        if (element == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(34);
        }
        if ((qualifier = node.getQualifier()) != null && !(PyClassRefactoringUtil.resolveExpression(qualifier) instanceof PyImportedModule)) {
            return;
        }
        List<PsiElement> allResolveResults = PyClassRefactoringUtil.multiResolveExpression(node);
        Object target2 = (PsiElement)ContainerUtil.getFirstItem(allResolveResults);
        if (target2 instanceof PsiNamedElement && !PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)target2, (boolean)false)) {
            PyImportedNameDefiner importElement = PyClassRefactoringUtil.getImportElement(node);
            if (!PyUtil.inSameFile(element, target2) && importElement == null && !(target2 instanceof PsiFileSystemItem)) {
                return;
            }
            if (target2 instanceof PyTargetExpression && "__all__".equals(((PyTargetExpression)target2).getName())) {
                for (PsiElement result2 : allResolveResults) {
                    QualifiedName importedQName;
                    if (!(result2 instanceof PyImportElement) || (importedQName = ((PyImportElement)result2).getImportedQName()) == null) continue;
                    target2 = new DynamicNamedElement(target2.getContainingFile(), importedQName.toString());
                    break;
                }
            }
            node.putCopyableUserData(ENCODED_IMPORT, (PsiNamedElement)target2);
            if (importElement instanceof PyImportElement) {
                node.putCopyableUserData(ENCODED_IMPORT_AS, ((PyImportElement)importElement).getAsName());
            }
            node.putCopyableUserData(ENCODED_USE_FROM_IMPORT, qualifier == null);
        }
    }

    @Nullable
    private static PyImportedNameDefiner getImportElement(PyReferenceExpression expr) {
        for (ResolveResult result2 : expr.getReference().multiResolve(false)) {
            PsiElement e = result2.getElement();
            if (e instanceof PyImportElement) {
                return (PyImportElement)e;
            }
            if (!(e instanceof PyStarImportElement)) continue;
            return (PyStarImportElement)e;
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveExpression(@NotNull PyExpression expr) {
        if (expr == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(35);
        }
        if (expr instanceof PyReferenceExpression) {
            return ((PyReferenceExpression)expr).getReference().resolve();
        }
        return null;
    }

    @NotNull
    private static List<PsiElement> multiResolveExpression(@NotNull PyReferenceExpression expr) {
        if (expr == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(36);
        }
        List list2 = ContainerUtil.mapNotNull((Object[])expr.getReference().multiResolve(false), result2 -> result2.getElement());
        if (list2 == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(37);
        }
        return list2;
    }

    public static boolean updateUnqualifiedImportOfElement(@NotNull PyImportStatementBase importStatement, @NotNull PsiNamedElement element) {
        String name;
        if (importStatement == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(38);
        }
        if (element == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(39);
        }
        if ((name = PyClassRefactoringUtil.getOriginalName(element)) != null) {
            PyImportElement importElement = null;
            for (PyImportElement e : importStatement.getImportElements()) {
                if (!name.equals(PyClassRefactoringUtil.getOriginalName(e))) continue;
                importElement = e;
            }
            if (importElement != null) {
                PsiFile file2 = importStatement.getContainingFile();
                PsiFile newFile = element.getContainingFile();
                if (newFile == file2 || PyClassRefactoringUtil.insertImport((PsiElement)importStatement, element, importElement.getAsName(), true)) {
                    if (importStatement.getImportElements().length == 1) {
                        boolean isInjected = InjectedLanguageManager.getInstance((Project)importElement.getProject()).isInjectedFragment(importElement.getContainingFile());
                        if (!isInjected) {
                            importStatement.delete();
                        } else {
                            PyClassRefactoringUtil.deleteImportStatementFromInjected(importStatement);
                        }
                    } else {
                        importElement.delete();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static void deleteImportStatementFromInjected(@NotNull PyImportStatementBase importStatement) {
        if (importStatement == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(40);
        }
        PsiElement sibling = importStatement.getPrevSibling();
        importStatement.delete();
        if (sibling instanceof PsiWhiteSpace) {
            sibling.delete();
        }
    }

    @Nullable
    public static String getOriginalName(@NotNull PsiNamedElement element) {
        if (element == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(41);
        }
        if (element instanceof PyFile) {
            VirtualFile virtualFile = PsiUtilBase.asVirtualFile((PsiElement)PyUtil.turnInitIntoDir((PsiElement)element));
            if (virtualFile != null) {
                return virtualFile.getNameWithoutExtension();
            }
            return null;
        }
        return element.getName();
    }

    @Nullable
    private static String getOriginalName(PyImportElement element) {
        QualifiedName qname = element.getImportedQName();
        if (qname != null && qname.getComponentCount() > 0) {
            return (String)qname.getComponents().get(0);
        }
        return null;
    }

    public static void addSuperclasses(@NotNull Project project, @NotNull PyClass clazz, PyClass ... superClasses) {
        if (project == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(42);
        }
        if (clazz == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(43);
        }
        if (superClasses == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(44);
        }
        ArrayList<String> superClassNames = new ArrayList<String>();
        for (PyClass superClass : Collections2.filter(Arrays.asList(superClasses), NotNullPredicate.INSTANCE)) {
            if (superClass.getName() == null) continue;
            superClassNames.add(superClass.getName());
            PyClassRefactoringUtil.insertImport((PsiElement)clazz, (PsiNamedElement)superClass);
        }
        PyClassRefactoringUtil.addSuperClassExpressions(project, clazz, superClassNames, null);
    }

    public static void addSuperClassExpressions(@NotNull Project project, @NotNull PyClass clazz, @Nullable Collection<String> paramExpressions, @Nullable Collection<Pair<String, String>> keywordArguments) {
        if (project == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(45);
        }
        if (clazz == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(46);
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(project);
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)clazz);
        PyArgumentList superClassExpressionList = clazz.getSuperClassExpressionList();
        boolean addExpression = false;
        if (superClassExpressionList == null) {
            superClassExpressionList = generator.createFromText(languageLevel, PyClass.class, "class foo():pass").getSuperClassExpressionList();
            assert (superClassExpressionList != null) : "expression not created";
            addExpression = true;
        }
        generator.createFromText(LanguageLevel.PYTHON34, PyClass.class, "class foo(object, metaclass=Foo): pass").getSuperClassExpressionList();
        if (paramExpressions != null) {
            for (String string : paramExpressions) {
                superClassExpressionList.addArgument(generator.createParameter(string));
            }
        }
        if (keywordArguments != null) {
            for (Pair pair : keywordArguments) {
                superClassExpressionList.addArgument(generator.createKeywordArgument(languageLevel, (String)pair.first, (String)pair.second));
            }
        }
        if (addExpression) {
            ASTNode classNameNode = clazz.getNameNode();
            PsiElement psiElement = classNameNode == null ? clazz.getFirstChild() : classNameNode.getPsi();
            clazz.addAfter((PsiElement)superClassExpressionList, psiElement);
        }
    }

    public static void optimizeImports(@NotNull PsiFile file2) {
        if (file2 == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(47);
        }
        PyImportOptimizer.onlyRemoveUnused().processFile(file2).run();
    }

    @Nullable
    public static PsiElement addClassAttributeIfNotExist(@NotNull PyClass aClass, @NotNull String attributeName, @NotNull String value) {
        if (aClass == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(48);
        }
        if (attributeName == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(49);
        }
        if (value == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(50);
        }
        if (aClass.findClassAttribute(attributeName, false, null) != null) {
            return null;
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(aClass.getProject());
        String text = String.format("%s = %s", attributeName, value);
        LanguageLevel level = LanguageLevel.forElement((PsiElement)aClass);
        PyAssignmentStatement assignmentStatement = generator.createFromText(level, PyAssignmentStatement.class, text);
        return PyUtil.addElementToStatementList(assignmentStatement, aClass.getStatementList(), true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentStatements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClassStatement";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentStatement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentValue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dequalifyIfDeclaredInClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destStatementList";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 19: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherMovedElements";
                break;
            }
            case 23: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesToSkip";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClasses";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFieldDeclarationToStatement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewValueToAssign";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "copyMethods";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "addMethods";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "insertMethodInProperPlace";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyFieldDeclarationToStatement";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 37: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setNewAssigneeValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNewValueToAssign";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addMethods";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "insertMethodInProperPlace";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "restoreNamedReferences";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "restoreReference";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "insertImport";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "rememberNamedReferences";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "rememberReference";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "resolveExpression";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveExpression";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "updateUnqualifiedImportOfElement";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "deleteImportStatementFromInjected";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalName";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addSuperclasses";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addSuperClassExpressions";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "optimizeImports";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "addClassAttributeIfNotExist";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DynamicNamedElement
    extends LightElement
    implements PsiNamedElement {
        private final PsiFile myFile;
        private final String myName;

        public DynamicNamedElement(@NotNull PsiFile file2, @NotNull String name) {
            if (file2 == null) {
                DynamicNamedElement.$$$reportNull$$$0(0);
            }
            if (name == null) {
                DynamicNamedElement.$$$reportNull$$$0(1);
            }
            super(file2.getManager(), file2.getLanguage());
            this.myName = name;
            this.myFile = file2;
        }

        @Override
        public String toString() {
            return "DynamicNamedElement(file='" + this.getContainingFile().getName() + "', name='" + this.getName() + "')";
        }

        @Override
        public PsiFile getContainingFile() {
            return this.myFile;
        }

        public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
            if (name == null) {
                DynamicNamedElement.$$$reportNull$$$0(2);
            }
            return null;
        }

        @Override
        public String getName() {
            return this.myName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil$DynamicNamedElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

