/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCallableParameterImpl
implements PyCallableParameter {
    @Nullable
    private final String myName;
    @Nullable
    private final Ref<PyType> myType;
    @Nullable
    private final PyExpression myDefaultValue;
    @Nullable
    private final PyParameter myElement;

    private PyCallableParameterImpl(@Nullable String name, @Nullable Ref<PyType> type, @Nullable PyExpression defaultValue, @Nullable PyParameter element) {
        this.myName = name;
        this.myType = type;
        this.myDefaultValue = defaultValue;
        this.myElement = element;
    }

    @NotNull
    public static PyCallableParameter nonPsi(@Nullable PyType type) {
        PyCallableParameter pyCallableParameter = PyCallableParameterImpl.nonPsi(null, type);
        if (pyCallableParameter == null) {
            PyCallableParameterImpl.$$$reportNull$$$0(0);
        }
        return pyCallableParameter;
    }

    @NotNull
    public static PyCallableParameter nonPsi(@Nullable String name, @Nullable PyType type) {
        PyCallableParameter pyCallableParameter = PyCallableParameterImpl.nonPsi(name, type, null);
        if (pyCallableParameter == null) {
            PyCallableParameterImpl.$$$reportNull$$$0(1);
        }
        return pyCallableParameter;
    }

    @NotNull
    public static PyCallableParameter nonPsi(@Nullable String name, @Nullable PyType type, @Nullable PyExpression defaultValue) {
        PyCallableParameterImpl pyCallableParameterImpl = new PyCallableParameterImpl(name, (Ref<PyType>)Ref.create((Object)type), defaultValue, null);
        if (pyCallableParameterImpl == null) {
            PyCallableParameterImpl.$$$reportNull$$$0(2);
        }
        return pyCallableParameterImpl;
    }

    @NotNull
    public static PyCallableParameter psi(@NotNull PyParameter parameter) {
        if (parameter == null) {
            PyCallableParameterImpl.$$$reportNull$$$0(3);
        }
        PyCallableParameterImpl pyCallableParameterImpl = new PyCallableParameterImpl(null, null, null, parameter);
        if (pyCallableParameterImpl == null) {
            PyCallableParameterImpl.$$$reportNull$$$0(4);
        }
        return pyCallableParameterImpl;
    }

    @NotNull
    public static PyCallableParameter psi(@NotNull PyParameter parameter, @Nullable PyType type) {
        if (parameter == null) {
            PyCallableParameterImpl.$$$reportNull$$$0(5);
        }
        PyCallableParameterImpl pyCallableParameterImpl = new PyCallableParameterImpl(null, (Ref<PyType>)Ref.create((Object)type), null, parameter);
        if (pyCallableParameterImpl == null) {
            PyCallableParameterImpl.$$$reportNull$$$0(6);
        }
        return pyCallableParameterImpl;
    }

    @Override
    @Nullable
    public String getName() {
        if (this.myName != null) {
            return this.myName;
        }
        if (this.myElement != null) {
            return this.myElement.getName();
        }
        return null;
    }

    @Override
    @Nullable
    public PyType getType(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyCallableParameterImpl.$$$reportNull$$$0(7);
        }
        if (this.myType != null) {
            return (PyType)this.myType.get();
        }
        if (this.myElement instanceof PyNamedParameter) {
            return context.getType((PyNamedParameter)this.myElement);
        }
        return null;
    }

    @Override
    @Nullable
    public PyParameter getParameter() {
        return this.myElement;
    }

    @Override
    @Nullable
    public PyExpression getDefaultValue() {
        return this.myElement == null ? this.myDefaultValue : this.myElement.getDefaultValue();
    }

    @Override
    public boolean hasDefaultValue() {
        return this.myElement == null ? this.myDefaultValue != null : this.myElement.hasDefaultValue();
    }

    @Override
    @Nullable
    public String getDefaultValueText() {
        if (this.myElement != null) {
            return this.myElement.getDefaultValueText();
        }
        return this.myDefaultValue == null ? null : this.myDefaultValue.getText();
    }

    @Override
    public boolean isPositionalContainer() {
        PyNamedParameter namedParameter = PyUtil.as(this.myElement, PyNamedParameter.class);
        return namedParameter != null && namedParameter.isPositionalContainer();
    }

    @Override
    public boolean isKeywordContainer() {
        PyNamedParameter namedParameter = PyUtil.as(this.myElement, PyNamedParameter.class);
        return namedParameter != null && namedParameter.isKeywordContainer();
    }

    @Override
    public boolean isSelf() {
        PyParameter parameter = PyUtil.as(this.myElement, PyParameter.class);
        return parameter != null && parameter.isSelf();
    }

    @Override
    @NotNull
    public String getPresentableText(boolean includeDefaultValue, @Nullable TypeEvalContext context) {
        if (this.myElement instanceof PyNamedParameter || this.myElement == null) {
            PyType argumentType;
            StringBuilder sb = new StringBuilder();
            if (this.isPositionalContainer()) {
                sb.append("*");
            } else if (this.isKeywordContainer()) {
                sb.append("**");
            }
            String name = this.getName();
            sb.append(name != null ? name : "...");
            PyType pyType = argumentType = context == null ? null : this.getArgumentType(context);
            if (argumentType != null) {
                sb.append(": ");
                sb.append(PythonDocumentationProvider.getTypeDescription(argumentType, context));
            }
            String defaultValue = this.getDefaultValueText();
            if (includeDefaultValue && defaultValue != null) {
                Pair<String, String> quotes = PyStringLiteralUtil.getQuotes(defaultValue);
                sb.append("=");
                if (quotes != null) {
                    String value = defaultValue.substring(((String)quotes.getFirst()).length(), defaultValue.length() - ((String)quotes.getSecond()).length());
                    sb.append((String)quotes.getFirst());
                    StringUtil.escapeStringCharacters((int)value.length(), (String)value, (StringBuilder)sb);
                    sb.append((String)quotes.getSecond());
                } else {
                    sb.append(defaultValue);
                }
            }
            String string = sb.toString();
            if (string == null) {
                PyCallableParameterImpl.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = PyUtil.getReadableRepr((PsiElement)this.myElement, false);
        if (string == null) {
            PyCallableParameterImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @Nullable
    public PyType getArgumentType(@NotNull TypeEvalContext context) {
        PyType parameterType;
        if (context == null) {
            PyCallableParameterImpl.$$$reportNull$$$0(10);
        }
        if ((parameterType = this.getType(context)) instanceof PyCollectionType) {
            PyCollectionType collectionType = (PyCollectionType)parameterType;
            if (this.isPositionalContainer()) {
                return collectionType.getIteratedItemType();
            }
            if (this.isKeywordContainer()) {
                return (PyType)ContainerUtil.getOrElse(collectionType.getElementTypes(), (int)1, null);
            }
        }
        return parameterType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyCallableParameterImpl parameter = (PyCallableParameterImpl)o;
        return Objects.equals(this.myName, parameter.myName) && Objects.equals(Ref.deref(this.myType), Ref.deref(parameter.myType)) && Objects.equals(this.myElement, parameter.myElement);
    }

    public int hashCode() {
        return Objects.hash(this.myName, Ref.deref(this.myType), this.myElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyCallableParameterImpl";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "nonPsi";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyCallableParameterImpl";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "psi";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "psi";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

