/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRenameElementQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.NAME.rename.element", new Object[0]);
        if (string == null) {
            PyRenameElementQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        VirtualFile virtualFile;
        PsiNameIdentifierOwner nameOwner;
        PsiElement element;
        if (project == null) {
            PyRenameElementQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            PyRenameElementQuickFix.$$$reportNull$$$0(2);
        }
        if ((element = descriptor2.getPsiElement()) instanceof PyReferenceExpression) {
            PsiReference reference = element.getReference();
            if (reference == null) {
                return;
            }
            element = reference.resolve();
        }
        PsiNameIdentifierOwner psiNameIdentifierOwner = nameOwner = element instanceof PsiNameIdentifierOwner ? (PsiNameIdentifierOwner)element : (PsiNameIdentifierOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNameIdentifierOwner.class, (boolean)true);
        if (nameOwner != null && (virtualFile = nameOwner.getContainingFile().getVirtualFile()) != null) {
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile), true);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                PyRenameElementQuickFix.renameInUnitTestMode(project, nameOwner, editor);
            } else if (this.checkLocalScope(element) != null && (nameOwner instanceof PyNamedParameter || nameOwner instanceof PyTargetExpression)) {
                new VariableInplaceRenamer((PsiNamedElement)nameOwner, editor).performInplaceRename();
            } else {
                PsiElementRenameHandler.invoke((PsiElement)nameOwner, project, (PsiElement)ScopeUtil.getScopeOwner((PsiElement)nameOwner), editor);
            }
        }
    }

    @Nullable
    protected PsiElement checkLocalScope(PsiElement element) {
        SearchScope searchScope = PsiSearchHelper.SERVICE.getInstance((Project)element.getProject()).getUseScope(element);
        if (searchScope instanceof LocalSearchScope) {
            PsiElement[] elements = ((LocalSearchScope)searchScope).getScope();
            return PsiTreeUtil.findCommonParent((PsiElement[])elements);
        }
        return null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        if (file2 == null) {
            PyRenameElementQuickFix.$$$reportNull$$$0(3);
        }
        return file2;
    }

    private static void renameInUnitTestMode(@NotNull Project project, @NotNull PsiNameIdentifierOwner nameOwner, @Nullable Editor editor) {
        PsiElement substitution;
        if (project == null) {
            PyRenameElementQuickFix.$$$reportNull$$$0(4);
        }
        if (nameOwner == null) {
            PyRenameElementQuickFix.$$$reportNull$$$0(5);
        }
        if ((substitution = RenamePsiElementProcessor.forElement((PsiElement)nameOwner).substituteElementToRename((PsiElement)nameOwner, editor)) != null) {
            new RenameProcessor(project, substitution, "a", false, false).run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyRenameElementQuickFix";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyRenameElementQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "renameInUnitTestMode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

