/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.dataflow.DFALimitExceededException;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.HashSet;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeVariable;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyUnreachableCodeInspection;
import com.jetbrains.python.inspections.quickfix.AddGlobalQuickFix;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpressionCodeFragment;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyGlobalStatementNavigator;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyUnboundLocalVariableInspection
extends PyInspection {
    private static Key<Set<ScopeOwner>> LARGE_FUNCTIONS_KEY = Key.create((String)"PyUnboundLocalVariableInspection.LargeFunctions");

    @NotNull
    @Nls
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.unbound", new Object[0]);
        if (string == null) {
            PyUnboundLocalVariableInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            PyUnboundLocalVariableInspection.$$$reportNull$$$0(1);
        }
        if (session2 == null) {
            PyUnboundLocalVariableInspection.$$$reportNull$$$0(2);
        }
        session2.putUserData(LARGE_FUNCTIONS_KEY, (Object)new HashSet());
        Visitor visitor2 = new Visitor(holder, session2);
        if (visitor2 == null) {
            PyUnboundLocalVariableInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyUnboundLocalVariableInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyUnboundLocalVariableInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(ProblemsHolder holder, LocalInspectionToolSession session2) {
            super(holder, session2);
        }

        @Override
        public void visitPyReferenceExpression(PyReferenceExpression node) {
            ScopeVariable variable;
            if (node.getContainingFile() instanceof PyExpressionCodeFragment) {
                return;
            }
            if (PyGlobalStatementNavigator.getByArgument((PsiElement)node) != null) {
                return;
            }
            if (node.isQualified()) {
                return;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)node, PyImportStatementBase.class) != null) {
                return;
            }
            String name = node.getReferencedName();
            if (name == null) {
                return;
            }
            ScopeOwner owner = ScopeUtil.getDeclarationScopeOwner((PsiElement)node, name);
            Set largeFunctions = (Set)this.getSession().getUserData(LARGE_FUNCTIONS_KEY);
            assert (largeFunctions != null);
            if (owner == null || largeFunctions.contains(owner)) {
                return;
            }
            if (owner != ScopeUtil.getScopeOwner((PsiElement)node)) {
                return;
            }
            Scope scope = ControlFlowCache.getScope(owner);
            if (scope.isGlobal(name) || !scope.containsDeclaration(name)) {
                return;
            }
            PyAugAssignmentStatement augAssignment = (PyAugAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PyAugAssignmentStatement.class);
            PyElement anchor = augAssignment != null && name.equals(augAssignment.getTarget().getName()) ? augAssignment : node;
            try {
                variable = scope.getDeclaredVariable((PsiElement)anchor, name);
            }
            catch (DFALimitExceededException e) {
                largeFunctions.add(owner);
                this.registerLargeFunction(owner);
                return;
            }
            if (variable == null) {
                if (!Visitor.isFirstUnboundRead(node, owner)) {
                    return;
                }
                PsiPolyVariantReference ref = node.getReference(this.getResolveContext());
                if (ref == null) {
                    return;
                }
                PsiElement resolved = ref.resolve();
                boolean isBuiltin = PyBuiltinCache.getInstance((PsiElement)node).isBuiltin(resolved);
                if (owner instanceof PyClass && (isBuiltin || ScopeUtil.getDeclarationScopeOwner((PsiElement)owner, name) != null)) {
                    return;
                }
                if (PyUnreachableCodeInspection.hasAnyInterruptedControlFlowPaths((PsiElement)node)) {
                    return;
                }
                if (owner instanceof PyFile) {
                    if (isBuiltin) {
                        return;
                    }
                    if (resolved != null && !PyUtil.inSameFile((PsiElement)node, resolved)) {
                        return;
                    }
                    this.registerProblem((PsiElement)node, PyBundle.message("INSP.unbound.name.not.defined", name));
                } else {
                    this.registerProblem((PsiElement)node, PyBundle.message("INSP.unbound.local.variable", node.getName()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, new AddGlobalQuickFix());
                }
            }
        }

        private static boolean isFirstUnboundRead(@NotNull PyReferenceExpression node, @NotNull ScopeOwner owner) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (owner == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            String nodeName = node.getReferencedName();
            Scope scope = ControlFlowCache.getScope(owner);
            ControlFlow flow = ControlFlowCache.getControlFlow(owner);
            Instruction[] instructions = flow.getInstructions();
            int num = ControlFlowUtil.findInstructionNumberByElement(instructions, (PsiElement)node);
            if (num < 0) {
                return true;
            }
            Ref first = Ref.create((Object)true);
            ControlFlowUtil.iteratePrev(num, instructions, (Function<Instruction, ControlFlowUtil.Operation>)((Function)instruction -> {
                if (instruction instanceof ReadWriteInstruction) {
                    ReadWriteInstruction rwInstruction = (ReadWriteInstruction)instruction;
                    String name = rwInstruction.getName();
                    PsiElement element = rwInstruction.getElement();
                    if (element != null && name != null && name.equals(nodeName) && instruction.num() != num) {
                        try {
                            ReadWriteInstruction.ACCESS access;
                            if (scope.getDeclaredVariable(element, name) == null && (access = rwInstruction.getAccess()).isReadAccess()) {
                                first.set((Object)false);
                                return ControlFlowUtil.Operation.BREAK;
                            }
                        }
                        catch (DFALimitExceededException e) {
                            first.set((Object)false);
                        }
                        return ControlFlowUtil.Operation.CONTINUE;
                    }
                }
                return ControlFlowUtil.Operation.NEXT;
            }));
            return (Boolean)first.get();
        }

        @Override
        public void visitPyNonlocalStatement(PyNonlocalStatement node) {
            for (PyTargetExpression var : node.getVariables()) {
                String name = var.getName();
                ScopeOwner owner = ScopeUtil.getDeclarationScopeOwner(var, name);
                if (owner != null && !(owner instanceof PyFile)) continue;
                this.registerProblem((PsiElement)var, PyBundle.message("INSP.unbound.nonlocal.variable", name), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
        }

        private void registerLargeFunction(ScopeOwner owner) {
            this.registerProblem((PsiElement)(owner instanceof PyFunction ? ((PyFunction)owner).getNameIdentifier() : owner), PyBundle.message("INSP.unbound.function.too.large", owner.getName()), ProblemHighlightType.WEAK_WARNING);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/inspections/PyUnboundLocalVariableInspection$Visitor";
            objectArray[2] = "isFirstUnboundRead";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

