/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.xmlb.SmartSerializer;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.RedundantParenthesesQuickFix;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyPrintStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyWhilePart;
import com.jetbrains.python.psi.PyYieldExpression;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyRedundantParenthesesInspection
extends PyInspection {
    private final SmartSerializer mySerializer = new SmartSerializer();
    public boolean myIgnorePercOperator = false;
    public boolean myIgnoreTupleInReturn = false;
    public boolean myIgnoreEmptyBaseClasses = false;

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.redundant.parentheses", new Object[0]);
        if (string == null) {
            PyRedundantParenthesesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            PyRedundantParenthesesInspection.$$$reportNull$$$0(1);
        }
        if (session2 == null) {
            PyRedundantParenthesesInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session2);
        if (visitor2 == null) {
            PyRedundantParenthesesInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            PyRedundantParenthesesInspection.$$$reportNull$$$0(4);
        }
        this.mySerializer.writeExternal((Object)this, node);
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            PyRedundantParenthesesInspection.$$$reportNull$$$0(5);
        }
        this.mySerializer.readExternal((Object)this, node);
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox("Ignore argument of % operator", "myIgnorePercOperator");
        panel2.addCheckbox("Ignore tuples", "myIgnoreTupleInReturn");
        panel2.addCheckbox("Ignore empty lists of base classes", "myIgnoreEmptyBaseClasses");
        return panel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyRedundantParenthesesInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyRedundantParenthesesInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, LocalInspectionToolSession session2) {
            if (holder == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (session2 == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super(holder, session2);
        }

        @Override
        public void visitPyParenthesizedExpression(PyParenthesizedExpression node) {
            PyExpression expression = node.getContainedExpression();
            if (node.getText().contains("\n")) {
                return;
            }
            PyYieldExpression yieldExpression = (PyYieldExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PyYieldExpression.class, (boolean)false);
            if (yieldExpression != null) {
                return;
            }
            if (expression instanceof PyTupleExpression && PyRedundantParenthesesInspection.this.myIgnoreTupleInReturn) {
                return;
            }
            if (expression instanceof PyReferenceExpression || expression instanceof PyLiteralExpression) {
                PsiElement parent;
                if (PyRedundantParenthesesInspection.this.myIgnorePercOperator && (parent = node.getParent()) instanceof PyBinaryExpression && ((PyBinaryExpression)parent).getOperator() == PyTokenTypes.PERC) {
                    return;
                }
                if (node.getParent() instanceof PyPrintStatement) {
                    return;
                }
                this.registerProblem((PsiElement)node, PyBundle.message("QFIX.redundant.parentheses", new Object[0]), new RedundantParenthesesQuickFix());
            } else if (node.getParent() instanceof PyIfPart || node.getParent() instanceof PyWhilePart || node.getParent() instanceof PyReturnStatement) {
                this.registerProblem((PsiElement)node, PyBundle.message("QFIX.redundant.parentheses", new Object[0]), new RedundantParenthesesQuickFix());
            } else if (expression instanceof PyBinaryExpression) {
                PyBinaryExpression binaryExpression = (PyBinaryExpression)expression;
                if (node.getParent() instanceof PyPrefixExpression) {
                    return;
                }
                if (binaryExpression.getOperator() == PyTokenTypes.AND_KEYWORD || binaryExpression.getOperator() == PyTokenTypes.OR_KEYWORD) {
                    PyExpression leftExpression = binaryExpression.getLeftExpression();
                    PyExpression rightExpression = binaryExpression.getRightExpression();
                    if (leftExpression instanceof PyParenthesizedExpression && rightExpression instanceof PyParenthesizedExpression && !(((PyParenthesizedExpression)leftExpression).getContainedExpression() instanceof PyBinaryExpression) && !(((PyParenthesizedExpression)rightExpression).getContainedExpression() instanceof PyBinaryExpression)) {
                        this.registerProblem((PsiElement)node, PyBundle.message("QFIX.redundant.parentheses", new Object[0]), new RedundantParenthesesQuickFix());
                    }
                }
            } else if (expression instanceof PyParenthesizedExpression) {
                this.registerProblem((PsiElement)expression, PyBundle.message("QFIX.redundant.parentheses", new Object[0]), new RedundantParenthesesQuickFix());
            }
        }

        @Override
        public void visitPyArgumentList(PyArgumentList node) {
            if (!(node.getParent() instanceof PyClass)) {
                return;
            }
            if (!PyRedundantParenthesesInspection.this.myIgnoreEmptyBaseClasses && node.getArguments().length == 0) {
                this.registerProblem((PsiElement)node, PyBundle.message("QFIX.redundant.parentheses", new Object[0]), new RedundantParenthesesQuickFix());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "session";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/inspections/PyRedundantParenthesesInspection$Visitor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

