/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.documentation.docstrings.DocStringParameterReference;
import com.jetbrains.python.documentation.docstrings.DocStringTypeReference;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.docstrings.SectionBasedDocString;
import com.jetbrains.python.documentation.docstrings.TagBasedDocString;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.toolbox.Substring;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocStringReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            DocStringReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DocStringReferenceProvider.$$$reportNull$$$0(1);
        }
        if (element == DocStringUtil.getParentDefinitionDocString(element)) {
            PyStringLiteralExpression expr = (PyStringLiteralExpression)element;
            List<TextRange> ranges = expr.getStringValueTextRanges();
            String exprText = expr.getText();
            if (!ranges.isEmpty()) {
                TextRange firstNodeRange = ranges.get(0);
                int offset = firstNodeRange.getStartOffset();
                String text = firstNodeRange.substring(exprText);
                ArrayList<PsiReference> result2 = new ArrayList<PsiReference>();
                StructuredDocString docString = DocStringUtil.parse(text, element);
                if (docString instanceof TagBasedDocString) {
                    TagBasedDocString taggedDocString = (TagBasedDocString)docString;
                    result2.addAll(DocStringReferenceProvider.referencesFromNames(expr, offset, docString, taggedDocString.getTagArguments(TagBasedDocString.PARAM_TAGS), DocStringParameterReference.ReferenceType.PARAMETER));
                    result2.addAll(DocStringReferenceProvider.referencesFromNames(expr, offset, docString, taggedDocString.getTagArguments(TagBasedDocString.PARAM_TYPE_TAGS), DocStringParameterReference.ReferenceType.PARAMETER_TYPE));
                    result2.addAll(DocStringReferenceProvider.referencesFromNames(expr, offset, docString, docString.getKeywordArgumentSubstrings(), DocStringParameterReference.ReferenceType.KEYWORD));
                    result2.addAll(DocStringReferenceProvider.referencesFromNames(expr, offset, docString, taggedDocString.getTagArguments("var"), DocStringParameterReference.ReferenceType.VARIABLE));
                    result2.addAll(DocStringReferenceProvider.referencesFromNames(expr, offset, docString, taggedDocString.getTagArguments("cvar"), DocStringParameterReference.ReferenceType.CLASS_VARIABLE));
                    result2.addAll(DocStringReferenceProvider.referencesFromNames(expr, offset, docString, taggedDocString.getTagArguments("ivar"), DocStringParameterReference.ReferenceType.INSTANCE_VARIABLE));
                    result2.addAll(DocStringReferenceProvider.returnTypes(element, docString, offset));
                } else if (docString instanceof SectionBasedDocString) {
                    SectionBasedDocString sectioned = (SectionBasedDocString)docString;
                    result2.addAll(DocStringReferenceProvider.referencesFromFields(expr, offset, sectioned.getParameterFields(), DocStringParameterReference.ReferenceType.PARAMETER));
                    result2.addAll(DocStringReferenceProvider.referencesFromFields(expr, offset, sectioned.getKeywordArgumentFields(), DocStringParameterReference.ReferenceType.KEYWORD));
                    result2.addAll(DocStringReferenceProvider.referencesFromFields(expr, offset, sectioned.getAttributeFields(), PyUtil.isTopLevel(element) ? DocStringParameterReference.ReferenceType.GLOBAL_VARIABLE : DocStringParameterReference.ReferenceType.INSTANCE_VARIABLE));
                    result2.addAll(DocStringReferenceProvider.referencesFromFields(expr, offset, sectioned.getReturnFields(), null));
                }
                PsiReference[] psiReferenceArray = result2.toArray(new PsiReference[result2.size()]);
                if (psiReferenceArray == null) {
                    DocStringReferenceProvider.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            DocStringReferenceProvider.$$$reportNull$$$0(3);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static List<PsiReference> returnTypes(PsiElement element, StructuredDocString docString, int offset) {
        ArrayList<PsiReference> result2 = new ArrayList<PsiReference>();
        Substring rtype = docString.getReturnTypeSubstring();
        if (rtype != null) {
            result2.addAll(DocStringReferenceProvider.parseTypeReferences(element, rtype, offset));
        }
        return result2;
    }

    private static List<PsiReference> referencesFromNames(@NotNull PyStringLiteralExpression element, int offset, @NotNull StructuredDocString docString, @NotNull List<Substring> paramNames, @NotNull DocStringParameterReference.ReferenceType refType) {
        if (element == null) {
            DocStringReferenceProvider.$$$reportNull$$$0(4);
        }
        if (docString == null) {
            DocStringReferenceProvider.$$$reportNull$$$0(5);
        }
        if (paramNames == null) {
            DocStringReferenceProvider.$$$reportNull$$$0(6);
        }
        if (refType == null) {
            DocStringReferenceProvider.$$$reportNull$$$0(7);
        }
        ArrayList<PsiReference> result2 = new ArrayList<PsiReference>();
        for (Substring name : paramNames) {
            Substring type;
            String s = name.toString();
            if (PyNames.isIdentifier(s)) {
                TextRange range = name.getTextRange().shiftRight(offset);
                result2.add(new DocStringParameterReference(element, range, refType));
            }
            if (!refType.equals((Object)DocStringParameterReference.ReferenceType.PARAMETER_TYPE) || (type = docString.getParamTypeSubstring(s)) == null) continue;
            result2.addAll(DocStringReferenceProvider.parseTypeReferences(element, type, offset));
        }
        return result2;
    }

    @NotNull
    private static List<PsiReference> referencesFromFields(@NotNull PyStringLiteralExpression element, int offset, @NotNull List<SectionBasedDocString.SectionField> fields, @Nullable DocStringParameterReference.ReferenceType nameRefType) {
        if (element == null) {
            DocStringReferenceProvider.$$$reportNull$$$0(8);
        }
        if (fields == null) {
            DocStringReferenceProvider.$$$reportNull$$$0(9);
        }
        ArrayList<PsiReference> result2 = new ArrayList<PsiReference>();
        for (SectionBasedDocString.SectionField field : fields) {
            for (Substring nameSub : field.getNamesAsSubstrings()) {
                if (nameRefType == null || nameSub == null || nameSub.isEmpty()) continue;
                TextRange range = nameSub.getTextRange().shiftRight(offset);
                result2.add(new DocStringParameterReference(element, range, nameRefType));
            }
            Substring typeSub = field.getTypeAsSubstring();
            if (typeSub == null || typeSub.isEmpty()) continue;
            result2.addAll(DocStringReferenceProvider.parseTypeReferences(element, typeSub, offset));
        }
        ArrayList<PsiReference> arrayList = result2;
        if (arrayList == null) {
            DocStringReferenceProvider.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiReference> parseTypeReferences(@NotNull PsiElement anchor, @NotNull Substring s, int offset) {
        if (anchor == null) {
            DocStringReferenceProvider.$$$reportNull$$$0(11);
        }
        if (s == null) {
            DocStringReferenceProvider.$$$reportNull$$$0(12);
        }
        ArrayList<PsiReference> result2 = new ArrayList<PsiReference>();
        PyTypeParser.ParseResult parseResult = PyTypeParser.parse(anchor, s.toString());
        Map<TextRange, ? extends PyType> types = parseResult.getTypes();
        if (types.isEmpty()) {
            result2.add((PsiReference)new DocStringTypeReference(anchor, s.getTextRange().shiftRight(offset), s.getTextRange().shiftRight(offset), null, null));
        }
        offset = s.getTextRange().getStartOffset() + offset;
        Map<? extends PyType, TextRange> fullRanges = parseResult.getFullRanges();
        for (Map.Entry<TextRange, ? extends PyType> pair : types.entrySet()) {
            PyType t = pair.getValue();
            TextRange range = pair.getKey().shiftRight(offset);
            TextRange fullRange = fullRanges.containsKey(t) ? fullRanges.get(t).shiftRight(offset) : range;
            PyImportElement importElement = parseResult.getImports().get(t);
            result2.add((PsiReference)new DocStringTypeReference(anchor, range, fullRange, t, importElement));
        }
        ArrayList<PsiReference> arrayList = result2;
        if (arrayList == null) {
            DocStringReferenceProvider.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Nullable
    public static TextRange findNextTag(String docString, int pos, String[] paramTags) {
        int result2 = Integer.MAX_VALUE;
        String foundTag = null;
        for (String paramTag : paramTags) {
            int tagPos = docString.indexOf(paramTag, pos);
            while (tagPos >= 0 && tagPos + paramTag.length() < docString.length() && Character.isLetterOrDigit(docString.charAt(tagPos + paramTag.length()))) {
                tagPos = docString.indexOf(paramTag, tagPos + 1);
            }
            if (tagPos < 0 || tagPos >= result2) continue;
            foundTag = paramTag;
            result2 = tagPos;
        }
        return foundTag == null ? null : new TextRange(result2, result2 + foundTag.length());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/DocStringReferenceProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docString";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramNames";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/DocStringReferenceProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "referencesFromFields";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "referencesFromNames";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "referencesFromFields";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseTypeReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

