/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.attach;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.attach.XLocalAttachDebugger;
import com.intellij.xdebugger.attach.XLocalAttachDebuggerProvider;
import com.intellij.xdebugger.attach.XLocalAttachGroup;
import com.jetbrains.python.debugger.attach.PyAttachToProcessDebugRunner;
import com.jetbrains.python.debugger.attach.PyLocalAttachGroup;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyLocalAttachDebuggerProvider
implements XLocalAttachDebuggerProvider {
    private static final Key<List<XLocalAttachDebugger>> DEBUGGERS_KEY = Key.create((String)"PyLocalAttachDebuggerProvider.DEBUGGERS");

    @Override
    @NotNull
    public XLocalAttachGroup getAttachGroup() {
        PyLocalAttachGroup pyLocalAttachGroup = PyLocalAttachGroup.INSTANCE;
        if (pyLocalAttachGroup == null) {
            PyLocalAttachDebuggerProvider.$$$reportNull$$$0(0);
        }
        return pyLocalAttachGroup;
    }

    @Override
    @NotNull
    public List<XLocalAttachDebugger> getAvailableDebuggers(@NotNull Project project, @NotNull ProcessInfo processInfo, @NotNull UserDataHolder contextHolder) {
        if (project == null) {
            PyLocalAttachDebuggerProvider.$$$reportNull$$$0(1);
        }
        if (processInfo == null) {
            PyLocalAttachDebuggerProvider.$$$reportNull$$$0(2);
        }
        if (contextHolder == null) {
            PyLocalAttachDebuggerProvider.$$$reportNull$$$0(3);
        }
        if (StringUtil.containsIgnoreCase((String)processInfo.getExecutableName(), (String)"python")) {
            List result2 = (List)contextHolder.getUserData(DEBUGGERS_KEY);
            if (result2 != null) {
                List list2 = result2;
                if (list2 == null) {
                    PyLocalAttachDebuggerProvider.$$$reportNull$$$0(4);
                }
                return list2;
            }
            result2 = processInfo.getExecutableCannonicalPath().isPresent() && new File(processInfo.getExecutableCannonicalPath().get()).exists() ? Lists.newArrayList((Object[])new XLocalAttachDebugger[]{new PyLocalAttachDebugger(processInfo.getExecutableCannonicalPath().get())}) : ContainerUtil.map(PythonSdkType.getAllLocalCPythons(), sdk -> new PyLocalAttachDebugger((Sdk)sdk));
            Collections.sort(result2, (a, b) -> -a.getDebuggerDisplayName().compareToIgnoreCase(b.getDebuggerDisplayName()));
            contextHolder.putUserData(DEBUGGERS_KEY, Collections.unmodifiableList(result2));
            List list3 = result2;
            if (list3 == null) {
                PyLocalAttachDebuggerProvider.$$$reportNull$$$0(5);
            }
            return list3;
        }
        List<XLocalAttachDebugger> list4 = Collections.emptyList();
        if (list4 == null) {
            PyLocalAttachDebuggerProvider.$$$reportNull$$$0(6);
        }
        return list4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/attach/PyLocalAttachDebuggerProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachGroup";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/attach/PyLocalAttachDebuggerProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDebuggers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableDebuggers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PyLocalAttachDebugger
    implements XLocalAttachDebugger {
        private final String mySdkHome;
        @NotNull
        private final String myName;

        public PyLocalAttachDebugger(@NotNull Sdk sdk) {
            if (sdk == null) {
                PyLocalAttachDebugger.$$$reportNull$$$0(0);
            }
            this.mySdkHome = sdk.getHomePath();
            this.myName = PythonSdkType.getInstance().getVersionString(sdk) + " (" + this.mySdkHome + ")";
        }

        public PyLocalAttachDebugger(@NotNull String sdkHome) {
            if (sdkHome == null) {
                PyLocalAttachDebugger.$$$reportNull$$$0(1);
            }
            this.mySdkHome = sdkHome;
            this.myName = "Python Debugger";
        }

        @Override
        @NotNull
        public String getDebuggerDisplayName() {
            String string = this.myName;
            if (string == null) {
                PyLocalAttachDebugger.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public void attachDebugSession(@NotNull Project project, @NotNull ProcessInfo processInfo) throws ExecutionException {
            if (project == null) {
                PyLocalAttachDebugger.$$$reportNull$$$0(3);
            }
            if (processInfo == null) {
                PyLocalAttachDebugger.$$$reportNull$$$0(4);
            }
            PyAttachToProcessDebugRunner runner = new PyAttachToProcessDebugRunner(project, processInfo.getPid(), this.mySdkHome);
            runner.launch();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdkHome";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/attach/PyLocalAttachDebuggerProvider$PyLocalAttachDebugger";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/attach/PyLocalAttachDebuggerProvider$PyLocalAttachDebugger";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDebuggerDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "attachDebugSession";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

