/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyVariableViewSettings {
    public static final String PYDEVD_LOAD_VALUES_ASYNC = "PYDEVD_LOAD_VALUES_ASYNC";

    public static class AsyncView
    extends ToggleAction {
        private final String myText;
        private volatile boolean myLazyVariablesEvaluation = PyDebuggerSettings.getInstance().isLoadValuesAsync();

        public AsyncView() {
            super("", "Load variable values asynchronously", null);
            this.myText = "Load Values Asynchronously";
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AsyncView.$$$reportNull$$$0(0);
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(true);
            presentation.setText(this.myText);
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myLazyVariablesEvaluation;
        }

        public void setSelected(AnActionEvent e, boolean hide) {
            this.myLazyVariablesEvaluation = hide;
            PyDebuggerSettings.getInstance().setLoadValuesAsync(hide);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/debugger/PyVariableViewSettings$AsyncView", "update"));
        }
    }

    public static class SimplifiedView
    extends ToggleAction {
        private final PyDebugProcess myProcess;
        private final String myText;
        private volatile boolean mySimplifiedView = PyDebuggerSettings.getInstance().isSimplifiedView();

        public SimplifiedView(@Nullable PyDebugProcess debugProcess) {
            super("", "Disables watching classes, functions and modules objects", null);
            this.myProcess = debugProcess;
            this.myText = "Simplified Variables View";
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SimplifiedView.$$$reportNull$$$0(0);
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(true);
            presentation.setText(this.myText);
        }

        public boolean isSelected(AnActionEvent e) {
            return this.mySimplifiedView;
        }

        public void setSelected(AnActionEvent e, boolean hide) {
            this.mySimplifiedView = hide;
            PyDebuggerSettings.getInstance().setSimplifiedView(hide);
            if (this.myProcess != null) {
                this.myProcess.getSession().rebuildViews();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/debugger/PyVariableViewSettings$SimplifiedView", "update"));
        }
    }
}

