/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.stdlib;

import com.google.common.collect.ImmutableSet;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.stdlib.PyNamedTupleType;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionNavigator;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.impl.stubs.PyNamedTupleStubImpl;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.stubs.PyNamedTupleStub;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyTypeProviderBase;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStdlibTypeProvider
extends PyTypeProviderBase {
    @NotNull
    private static final Set<String> OPEN_FUNCTIONS = ImmutableSet.of((Object)"io.open", (Object)"pathlib.Path.open", (Object)"_io.open", (Object)"os.fdopen", (Object)"posix.fdopen", (Object)"nt.fdopen", (Object[])new String[0]);

    @Nullable
    public static PyStdlibTypeProvider getInstance() {
        for (PyTypeProvider typeProvider : (PyTypeProvider[])Extensions.getExtensions(PyTypeProvider.EP_NAME)) {
            if (!(typeProvider instanceof PyStdlibTypeProvider)) continue;
            return (PyStdlibTypeProvider)typeProvider;
        }
        return null;
    }

    @Override
    public PyType getReferenceType(@NotNull PsiElement referenceTarget, @NotNull TypeEvalContext context, @Nullable PsiElement anchor) {
        PyType type;
        if (referenceTarget == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(1);
        }
        if ((type = PyStdlibTypeProvider.getBaseStringType(referenceTarget)) != null) {
            return type;
        }
        type = PyStdlibTypeProvider.getNamedTupleTypeForResolvedCallee(referenceTarget, context, anchor);
        if (type != null) {
            return type;
        }
        type = PyStdlibTypeProvider.getEnumType(referenceTarget, context, anchor);
        if (type != null) {
            return type;
        }
        return null;
    }

    @Override
    @Nullable
    public PyType getReferenceExpressionType(@NotNull PyReferenceExpression referenceExpression, @NotNull TypeEvalContext context) {
        PyType fieldTypeForNamedTuple;
        if (referenceExpression == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(3);
        }
        if (!referenceExpression.isQualified()) {
            String name = referenceExpression.getReferencedName();
            if ("None".equals(name)) {
                return PyNoneType.INSTANCE;
            }
            if ("False".equals(name) || "True".equals(name)) {
                return PyBuiltinCache.getInstance((PsiElement)referenceExpression).getBoolType();
            }
        }
        if ((fieldTypeForNamedTuple = PyStdlibTypeProvider.getFieldTypeForNamedTupleAsTarget(referenceExpression, context)) != null) {
            return fieldTypeForNamedTuple;
        }
        PyNamedTupleType namedTupleTypeForCallee = PyStdlibTypeProvider.getNamedTupleTypeForCallee(referenceExpression, context);
        if (namedTupleTypeForCallee != null) {
            return namedTupleTypeForCallee;
        }
        return null;
    }

    @Nullable
    private static PyType getBaseStringType(@NotNull PsiElement referenceTarget) {
        if (referenceTarget == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(4);
        }
        PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(referenceTarget);
        if (referenceTarget instanceof PyElement && builtinCache.isBuiltin(referenceTarget) && "basestring".equals(((PyElement)referenceTarget).getName())) {
            return builtinCache.getStrOrUnicodeType(true);
        }
        return null;
    }

    @Nullable
    static PyNamedTupleType getNamedTupleTypeForResolvedCallee(@NotNull PsiElement referenceTarget, @NotNull TypeEvalContext context, @Nullable PsiElement anchor) {
        if (referenceTarget == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(5);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(6);
        }
        if (referenceTarget instanceof PyFunction && anchor instanceof PyCallExpression) {
            return PyStdlibTypeProvider.getNamedTupleFunctionType((PyFunction)referenceTarget, context, (PyCallExpression)anchor);
        }
        if (referenceTarget instanceof PyTargetExpression) {
            return PyStdlibTypeProvider.getNamedTupleTypeForTarget((PyTargetExpression)referenceTarget, context);
        }
        return null;
    }

    @Nullable
    private static PyType getEnumType(@NotNull PsiElement referenceTarget, @NotNull TypeEvalContext context, @Nullable PsiElement anchor) {
        PyTargetExpression target2;
        ScopeOwner owner;
        if (referenceTarget == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(7);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(8);
        }
        if (referenceTarget instanceof PyTargetExpression && (owner = ScopeUtil.getScopeOwner(target2 = (PyTargetExpression)referenceTarget)) instanceof PyClass) {
            PyClass cls = (PyClass)owner;
            List types = cls.getAncestorTypes(context);
            for (PyClassLikeType type : types) {
                PyType classType;
                if (type == null || !"enum.Enum".equals(type.getClassQName()) || !((classType = context.getType(cls)) instanceof PyClassType)) continue;
                return ((PyClassType)classType).toInstance();
            }
        }
        if (referenceTarget instanceof PyQualifiedNameOwner) {
            PyQualifiedNameOwner qualifiedNameOwner = (PyQualifiedNameOwner)referenceTarget;
            String name = qualifiedNameOwner.getQualifiedName();
            if ("enum.Enum.name".equals(name)) {
                return PyBuiltinCache.getInstance(referenceTarget).getStrType();
            }
            if ("enum.Enum.value".equals(name) && anchor instanceof PyReferenceExpression && context.maySwitchToAST(anchor)) {
                PyExpression value;
                PyTargetExpression qualifierTarget;
                PyReferenceExpression qualifierExpr;
                PsiElement resolvedQualifier;
                PyReferenceExpression anchorExpr = (PyReferenceExpression)anchor;
                PyExpression qualifier = anchorExpr.getQualifier();
                if (qualifier instanceof PyReferenceExpression && (resolvedQualifier = (qualifierExpr = (PyReferenceExpression)qualifier).getReference().resolve()) instanceof PyTargetExpression && context.maySwitchToAST(qualifierTarget = (PyTargetExpression)resolvedQualifier) && (value = qualifierTarget.findAssignedValue()) != null) {
                    return context.getType(value);
                }
            } else if ("enum.EnumMeta.__members__".equals(name)) {
                return PyTypeParser.getTypeByName(referenceTarget, "dict[str, unknown]", context);
            }
        }
        return null;
    }

    @Nullable
    private static PyType getFieldTypeForNamedTupleAsTarget(@NotNull PyReferenceExpression referenceExpression, @NotNull TypeEvalContext context) {
        Map<String, PyNamedTupleType.FieldTypeAndDefaultValue> fields;
        PyNamedTupleType.FieldTypeAndDefaultValue typeAndDefaultValue;
        PyType qualifierType;
        PyExpression qualifier;
        if (referenceExpression == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(9);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(10);
        }
        if ((qualifier = referenceExpression.getQualifier()) != null && (qualifierType = context.getType(qualifier)) instanceof PyNamedTupleType && (typeAndDefaultValue = (fields = ((PyNamedTupleType)qualifierType).getFields()).get(referenceExpression.getName())) != null) {
            return typeAndDefaultValue.getType();
        }
        return null;
    }

    @Nullable
    private static PyNamedTupleType getNamedTupleTypeForCallee(@NotNull PyReferenceExpression referenceExpression, @NotNull TypeEvalContext context) {
        if (referenceExpression == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(11);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(12);
        }
        if (PyCallExpressionNavigator.getPyCallExpressionByCallee((PsiElement)referenceExpression) == null) {
            return null;
        }
        PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context);
        ResolveResult[] resolveResults = referenceExpression.getReference(resolveContext).multiResolve(false);
        for (PsiElement element : PyUtil.filterTopPriorityResults(resolveResults)) {
            PyType type;
            PyNamedTupleType result2;
            if (element instanceof PyTargetExpression && (result2 = PyStdlibTypeProvider.getNamedTupleTypeForTarget((PyTargetExpression)element, context)) != null) {
                return result2;
            }
            if (element instanceof PyClass && (result2 = PyStdlibTypeProvider.getNamedTupleTypeForTypingNTInheritorAsCallee((PyClass)element, context)) != null) {
                return result2;
            }
            if (!(element instanceof PyTypedElement) || !((type = context.getType((PyTypedElement)element)) instanceof PyClassLikeType)) continue;
            List<PyClassLikeType> superClassTypes = ((PyClassLikeType)type).getSuperClassTypes(context);
            PyClassLikeType superNTType = (PyClassLikeType)ContainerUtil.find(superClassTypes, PyNamedTupleType.class::isInstance);
            if (superNTType == null) continue;
            return PyUtil.as(superNTType, PyNamedTupleType.class);
        }
        return null;
    }

    @Override
    @Nullable
    public Ref<PyType> getCallType(@NotNull PyFunction function, @Nullable PyCallSiteExpression callSite, @NotNull TypeEvalContext context) {
        String qname;
        if (function == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(13);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(14);
        }
        if ((qname = function.getQualifiedName()) != null) {
            if (OPEN_FUNCTIONS.contains(qname) && callSite instanceof PyCallExpression) {
                return PyStdlibTypeProvider.getOpenFunctionCallType(function, qname, (PyCallExpression)callSite, context);
            }
            if ("tuple.__init__".equals(qname) && callSite instanceof PyCallExpression) {
                return PyStdlibTypeProvider.getTupleInitializationType((PyCallExpression)callSite, context);
            }
            if ("tuple.__add__".equals(qname) && callSite instanceof PyBinaryExpression) {
                return PyStdlibTypeProvider.getTupleConcatenationResultType((PyBinaryExpression)callSite, context);
            }
            if ("tuple.__mul__".equals(qname) && callSite instanceof PyBinaryExpression) {
                return PyStdlibTypeProvider.getTupleMultiplicationResultType((PyBinaryExpression)callSite, context);
            }
            if ("object.__new__".equals(qname) && callSite instanceof PyCallExpression) {
                PyExpression firstArgument = ((PyCallExpression)callSite).getArgument(0, PyExpression.class);
                PyClassLikeType classLikeType = PyUtil.as(firstArgument != null ? context.getType(firstArgument) : null, PyClassLikeType.class);
                return classLikeType != null ? Ref.create(classLikeType.toInstance()) : null;
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getTupleMultiplicationResultType(@NotNull PyBinaryExpression multiplication, @NotNull TypeEvalContext context) {
        PsiElement target2;
        PyTupleType leftTupleType;
        if (multiplication == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(15);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(16);
        }
        if ((leftTupleType = PyUtil.as(context.getType(multiplication.getLeftExpression()), PyTupleType.class)) == null) {
            return null;
        }
        PyExpression rightExpression = multiplication.getRightExpression();
        if (rightExpression instanceof PyReferenceExpression && (target2 = ((PyReferenceExpression)rightExpression).getReference().resolve()) instanceof PyTargetExpression) {
            rightExpression = ((PyTargetExpression)target2).findAssignedValue();
        }
        if (rightExpression instanceof PyNumericLiteralExpression && ((PyNumericLiteralExpression)rightExpression).isIntegerLiteral()) {
            if (leftTupleType.isHomogeneous()) {
                return Ref.create((Object)leftTupleType);
            }
            int multiplier = ((PyNumericLiteralExpression)rightExpression).getBigIntegerValue().intValue();
            int originalSize = leftTupleType.getElementCount();
            if (originalSize * multiplier <= 20) {
                PyType[] elementTypes = new PyType[leftTupleType.getElementCount() * multiplier];
                for (int i = 0; i < multiplier; ++i) {
                    for (int j = 0; j < originalSize; ++j) {
                        elementTypes[i * originalSize + j] = leftTupleType.getElementType(j);
                    }
                }
                return Ref.create((Object)PyTupleType.create((PsiElement)multiplication, Arrays.asList(elementTypes)));
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getTupleConcatenationResultType(@NotNull PyBinaryExpression addition, @NotNull TypeEvalContext context) {
        if (addition == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(17);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(18);
        }
        if (addition.getRightExpression() != null) {
            PyTupleType leftTupleType = PyUtil.as(context.getType(addition.getLeftExpression()), PyTupleType.class);
            PyTupleType rightTupleType = PyUtil.as(context.getType(addition.getRightExpression()), PyTupleType.class);
            if (leftTupleType != null && rightTupleType != null) {
                if (leftTupleType.isHomogeneous() || rightTupleType.isHomogeneous()) {
                    return null;
                }
                List newElementTypes = ContainerUtil.concat(leftTupleType.getElementTypes(), rightTupleType.getElementTypes());
                return Ref.create((Object)PyTupleType.create((PsiElement)addition, newElementTypes));
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getTupleInitializationType(@NotNull PyCallExpression call, @NotNull TypeEvalContext context) {
        PyExpression[] arguments;
        if (call == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(19);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(20);
        }
        if ((arguments = call.getArguments()).length != 1) {
            return null;
        }
        PyExpression argument = arguments[0];
        PyType argumentType = context.getType(argument);
        if (argumentType instanceof PyTupleType) {
            return Ref.create((Object)argumentType);
        }
        if (argumentType instanceof PyCollectionType) {
            PyType iteratedItemType = ((PyCollectionType)argumentType).getIteratedItemType();
            return Ref.create((Object)PyTupleType.createHomogeneous((PsiElement)call, iteratedItemType));
        }
        return null;
    }

    @Override
    @Nullable
    public PyType getContextManagerVariableType(@NotNull PyClass contextManager, @NotNull PyExpression withExpression, @NotNull TypeEvalContext context) {
        PyExpression closee;
        if (contextManager == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(21);
        }
        if (withExpression == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(22);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(23);
        }
        if ("contextlib.closing".equals(contextManager.getQualifiedName()) && withExpression instanceof PyCallExpression && (closee = ((PyCallExpression)withExpression).getArgument(0, PyExpression.class)) != null) {
            return context.getType(closee);
        }
        String name = contextManager.getName();
        if ("FileIO".equals(name) || "TextIOWrapper".equals(name) || "IOBase".equals(name) || "_IOBase".equals(name)) {
            return context.getType(withExpression);
        }
        return null;
    }

    @Nullable
    private static PyNamedTupleType getNamedTupleFunctionType(@NotNull PyFunction function, @NotNull TypeEvalContext context, @NotNull PyCallExpression call) {
        PyClass cls;
        if (function == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(24);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(25);
        }
        if (call == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(26);
        }
        if ("collections.namedtuple".equals(function.getQualifiedName())) {
            return PyStdlibTypeProvider.getNamedTupleTypeFromAST(call, context, PyNamedTupleType.DefinitionLevel.NT_FUNCTION);
        }
        if (PyUtil.isInit(function) && (cls = function.getContainingClass()) != null && "typing.NamedTuple".equals(cls.getQualifiedName())) {
            return PyStdlibTypeProvider.getNamedTupleTypeFromAST(call, context, PyNamedTupleType.DefinitionLevel.NT_FUNCTION);
        }
        return null;
    }

    @Nullable
    private static PyNamedTupleType getNamedTupleTypeForTarget(@NotNull PyTargetExpression target2, @NotNull TypeEvalContext context) {
        PyTargetExpressionStub stub;
        if (target2 == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(27);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(28);
        }
        if ((stub = (PyTargetExpressionStub)target2.getStub()) != null) {
            return PyStdlibTypeProvider.getNamedTupleTypeFromStub(target2, stub.getCustomStub(PyNamedTupleStub.class), context, PyNamedTupleType.DefinitionLevel.NEW_TYPE);
        }
        return PyStdlibTypeProvider.getNamedTupleTypeFromAST(target2, context, PyNamedTupleType.DefinitionLevel.NEW_TYPE);
    }

    @Nullable
    private static PyNamedTupleType getNamedTupleTypeForTypingNTInheritorAsCallee(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        PsiElement typingNT;
        PyClass tupleClass;
        String name;
        if (cls == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(29);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(30);
        }
        Condition isTypingNT2 = type -> type != null && !(type instanceof PyNamedTupleType) && "typing.NamedTuple".equals(type.getClassQName());
        if (ContainerUtil.exists(cls.getSuperClassTypes(context), (Condition)isTypingNT2) && (name = cls.getName()) != null && (tupleClass = PyUtil.as(typingNT = PyResolveImportUtil.resolveTopLevelMember(QualifiedName.fromDottedString((String)"typing.NamedTuple"), PyResolveImportUtil.fromFoothold((PsiElement)cls)), PyClass.class)) != null) {
            final TreeSet<PyTargetExpression> fields = new TreeSet<PyTargetExpression>(Comparator.comparingInt(PsiElement::getTextOffset));
            cls.processClassLevelDeclarations(new BaseScopeProcessor(){

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState substitutor) {
                    PyTargetExpression target2;
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (substitutor == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (element instanceof PyTargetExpression && (target2 = (PyTargetExpression)element).getAnnotation() != null) {
                        fields.add(target2);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "substitutor";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider$1";
                    objectArray[2] = "execute";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            Collector<PyTargetExpression, ?, LinkedHashMap> toNTFields = Collectors.toMap(NavigationItem::getName, field -> {
                if (context == null) {
                    PyStdlibTypeProvider.$$$reportNull$$$0(53);
                }
                return new PyNamedTupleType.FieldTypeAndDefaultValue(context.getType((PyTypedElement)field), field.findAssignedValue());
            }, (v1, v2) -> v2, LinkedHashMap::new);
            return new PyNamedTupleType(tupleClass, (PsiElement)cls, name, fields.stream().collect(toNTFields), PyNamedTupleType.DefinitionLevel.NEW_TYPE);
        }
        return null;
    }

    @NotNull
    private static Ref<PyType> getOpenFunctionCallType(@NotNull PyFunction function, @NotNull String functionQName, @NotNull PyCallExpression call, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(31);
        }
        if (functionQName == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(32);
        }
        if (call == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(33);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(34);
        }
        LanguageLevel typeLevel = ArrayUtil.contains((String)functionQName, (String[])new String[]{"io.open", "pathlib.Path.open", "_io.open"}) ? LanguageLevel.PYTHON30 : LanguageLevel.forElement((PsiElement)call);
        Ref<PyType> ref = PyTypingTypeProvider.getOpenFunctionCallType(function, call, typeLevel, context);
        if (ref == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(35);
        }
        return ref;
    }

    @Nullable
    private static PyNamedTupleType getNamedTupleTypeFromStub(@NotNull PsiElement referenceTarget, @Nullable PyNamedTupleStub stub, @NotNull TypeEvalContext context, @NotNull PyNamedTupleType.DefinitionLevel definitionLevel) {
        if (referenceTarget == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(36);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(37);
        }
        if (definitionLevel == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(38);
        }
        if (stub == null) {
            return null;
        }
        PsiElement typingNT = PyResolveImportUtil.resolveTopLevelMember(QualifiedName.fromDottedString((String)"typing.NamedTuple"), PyResolveImportUtil.fromFoothold(referenceTarget));
        PyClass tupleClass = PyUtil.as(typingNT, PyClass.class);
        if (tupleClass == null) {
            return null;
        }
        return new PyNamedTupleType(tupleClass, referenceTarget, stub.getName(), PyStdlibTypeProvider.parseNamedTupleFields(referenceTarget, stub.getFields(), context), definitionLevel);
    }

    @Nullable
    private static PyNamedTupleType getNamedTupleTypeFromAST(@NotNull PyTargetExpression expression, @NotNull TypeEvalContext context, @NotNull PyNamedTupleType.DefinitionLevel definitionLevel) {
        if (expression == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(39);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(40);
        }
        if (definitionLevel == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(41);
        }
        if (context.maySwitchToAST(expression)) {
            return PyStdlibTypeProvider.getNamedTupleTypeFromStub(expression, PyNamedTupleStubImpl.create(expression), context, definitionLevel);
        }
        return null;
    }

    @Nullable
    private static PyNamedTupleType getNamedTupleTypeFromAST(@NotNull PyCallExpression expression, @NotNull TypeEvalContext context, @NotNull PyNamedTupleType.DefinitionLevel definitionLevel) {
        if (expression == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(42);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(43);
        }
        if (definitionLevel == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(44);
        }
        if (context.maySwitchToAST((PsiElement)expression)) {
            return PyStdlibTypeProvider.getNamedTupleTypeFromStub((PsiElement)expression, PyNamedTupleStubImpl.create(expression), context, definitionLevel);
        }
        return null;
    }

    @NotNull
    private static LinkedHashMap<String, PyNamedTupleType.FieldTypeAndDefaultValue> parseNamedTupleFields(@NotNull PsiElement anchor, @NotNull Map<String, Optional<String>> fields, @NotNull TypeEvalContext context) {
        if (anchor == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(45);
        }
        if (fields == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(46);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(47);
        }
        LinkedHashMap<String, PyNamedTupleType.FieldTypeAndDefaultValue> result2 = new LinkedHashMap<String, PyNamedTupleType.FieldTypeAndDefaultValue>();
        for (Map.Entry<String, Optional<String>> entry : fields.entrySet()) {
            result2.put(entry.getKey(), PyStdlibTypeProvider.parseNamedTupleField(anchor, entry.getValue().orElse(null), context));
        }
        LinkedHashMap<String, PyNamedTupleType.FieldTypeAndDefaultValue> linkedHashMap = result2;
        if (linkedHashMap == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(48);
        }
        return linkedHashMap;
    }

    @NotNull
    private static PyNamedTupleType.FieldTypeAndDefaultValue parseNamedTupleField(@NotNull PsiElement anchor, @Nullable String type, @NotNull TypeEvalContext context) {
        if (anchor == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(49);
        }
        if (context == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(50);
        }
        if (type == null) {
            PyNamedTupleType.FieldTypeAndDefaultValue fieldTypeAndDefaultValue = new PyNamedTupleType.FieldTypeAndDefaultValue(null, null);
            if (fieldTypeAndDefaultValue == null) {
                PyStdlibTypeProvider.$$$reportNull$$$0(51);
            }
            return fieldTypeAndDefaultValue;
        }
        PyType pyType = (PyType)Ref.deref(PyTypingTypeProvider.getStringBasedType(type, anchor, context));
        PyNamedTupleType.FieldTypeAndDefaultValue fieldTypeAndDefaultValue = new PyNamedTupleType.FieldTypeAndDefaultValue(pyType, null);
        if (fieldTypeAndDefaultValue == null) {
            PyStdlibTypeProvider.$$$reportNull$$$0(52);
        }
        return fieldTypeAndDefaultValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 35: 
            case 48: 
            case 51: 
            case 52: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 35: 
            case 48: 
            case 51: 
            case 52: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceTarget";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 28: 
            case 30: 
            case 34: 
            case 37: 
            case 40: 
            case 43: 
            case 47: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 13: 
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiplication";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addition";
                break;
            }
            case 19: 
            case 26: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextManager";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "withExpression";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionQName";
                break;
            }
            case 35: 
            case 48: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider";
                break;
            }
            case 38: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionLevel";
                break;
            }
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 45: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/stdlib/PyStdlibTypeProvider";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenFunctionCallType";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "parseNamedTupleFields";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "parseNamedTupleField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceExpressionType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBaseStringType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNamedTupleTypeForResolvedCallee";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getEnumType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFieldTypeForNamedTupleAsTarget";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNamedTupleTypeForCallee";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTupleMultiplicationResultType";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTupleConcatenationResultType";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTupleInitializationType";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getContextManagerVariableType";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getNamedTupleFunctionType";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getNamedTupleTypeForTarget";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getNamedTupleTypeForTypingNTInheritorAsCallee";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getOpenFunctionCallType";
                break;
            }
            case 35: 
            case 48: 
            case 51: 
            case 52: {
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getNamedTupleTypeFromStub";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getNamedTupleTypeFromAST";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "parseNamedTupleFields";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "parseNamedTupleField";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getNamedTupleTypeForTypingNTInheritorAsCallee$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 35: 
            case 48: 
            case 51: 
            case 52: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

