/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaAnnotatorChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.MatchResult;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaAnnotator
implements Annotator {
    private static final Key<Set<PsiElement>> ANNOTATED_PROPERTIES = Key.create((String)"JsonSchema.Properties.Annotated");

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            JsonSchemaAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            JsonSchemaAnnotator.$$$reportNull$$$0(1);
        }
        if (element.getContainingFile() == null || !(element instanceof JsonProperty) && !(element instanceof JsonObject)) {
            return;
        }
        JsonSchemaObject rootSchema = JsonSchemaService.Impl.get(element.getProject()).getSchemaObject(element.getContainingFile().getViewProvider().getVirtualFile());
        if (rootSchema == null) {
            return;
        }
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(element, rootSchema);
        if (walker == null) {
            return;
        }
        new Worker(rootSchema, holder, walker).annotate(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Worker {
        @NotNull
        private final JsonSchemaObject myRootSchema;
        @NotNull
        private final AnnotationHolder myHolder;
        @NotNull
        private final JsonLikePsiWalker myWalker;

        public Worker(@NotNull JsonSchemaObject rootSchema, @NotNull AnnotationHolder holder, @NotNull JsonLikePsiWalker walker) {
            if (rootSchema == null) {
                Worker.$$$reportNull$$$0(0);
            }
            if (holder == null) {
                Worker.$$$reportNull$$$0(1);
            }
            if (walker == null) {
                Worker.$$$reportNull$$$0(2);
            }
            this.myRootSchema = rootSchema;
            this.myHolder = holder;
            this.myWalker = walker;
        }

        public void annotate(@NotNull PsiElement element) {
            JsonPropertyAdapter firstProp;
            if (element == null) {
                Worker.$$$reportNull$$$0(3);
            }
            if ((firstProp = this.myWalker.getParentPropertyAdapter(element)) != null && firstProp.getValue() != null) {
                List<JsonSchemaVariantsTreeBuilder.Step> position = this.myWalker.findPosition(firstProp.getDelegate(), false, true);
                if (position == null || position.isEmpty()) {
                    return;
                }
                MatchResult result2 = new JsonSchemaResolver(this.myRootSchema, false, position).detailedResolve();
                this.createWarnings(JsonSchemaAnnotatorChecker.checkByMatchResult(firstProp.getValue(), result2));
            }
            this.checkRoot(element, firstProp);
        }

        private void checkRoot(@NotNull PsiElement element, JsonPropertyAdapter firstProp) {
            JsonValueAdapter rootToCheck;
            if (element == null) {
                Worker.$$$reportNull$$$0(4);
            }
            if (firstProp == null) {
                rootToCheck = Worker.findTopLevelElement(this.myWalker, element);
            } else {
                rootToCheck = firstProp.getParentObject();
                if (rootToCheck == null) {
                    rootToCheck = firstProp.getParentArray();
                }
                if (rootToCheck == null || !this.myWalker.isTopJsonElement(rootToCheck.getDelegate().getParent())) {
                    return;
                }
            }
            if (rootToCheck != null) {
                MatchResult matchResult = new JsonSchemaResolver(this.myRootSchema).detailedResolve();
                this.createWarnings(JsonSchemaAnnotatorChecker.checkByMatchResult(rootToCheck, matchResult));
            }
        }

        private void createWarnings(@Nullable JsonSchemaAnnotatorChecker checker) {
            if (checker != null && !checker.isCorrect()) {
                for (Map.Entry<PsiElement, String> entry : checker.getErrors().entrySet()) {
                    if (Worker.checkIfAlreadyProcessed(this.myHolder, entry.getKey())) continue;
                    this.myHolder.createWarningAnnotation(entry.getKey(), entry.getValue());
                }
            }
        }

        private static JsonValueAdapter findTopLevelElement(@NotNull JsonLikePsiWalker walker, @NotNull PsiElement element) {
            if (walker == null) {
                Worker.$$$reportNull$$$0(5);
            }
            if (element == null) {
                Worker.$$$reportNull$$$0(6);
            }
            Ref ref = new Ref();
            PsiTreeUtil.findFirstParent((PsiElement)element, el -> {
                boolean isTop;
                if (walker == null) {
                    Worker.$$$reportNull$$$0(8);
                }
                if (!(isTop = walker.isTopJsonElement((PsiElement)el))) {
                    ref.set(el);
                }
                return isTop;
            });
            return ref.isNull() ? null : walker.createValueAdapter((PsiElement)ref.get());
        }

        private static boolean checkIfAlreadyProcessed(@NotNull AnnotationHolder holder, PsiElement property) {
            AnnotationSession session2;
            HashSet<PsiElement> data;
            if (holder == null) {
                Worker.$$$reportNull$$$0(7);
            }
            if ((data = (HashSet<PsiElement>)(session2 = holder.getCurrentAnnotationSession()).getUserData(ANNOTATED_PROPERTIES)) == null) {
                data = new HashSet<PsiElement>();
                session2.putUserData(ANNOTATED_PROPERTIES, data);
            }
            if (data.contains(property)) {
                return true;
            }
            data.add(property);
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootSchema";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 2: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "walker";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotator$Worker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "annotate";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkRoot";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findTopLevelElement";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkIfAlreadyProcessed";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$findTopLevelElement$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

