/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsCommitCache;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.IndexedDetails;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.util.SequentialLimitedLifoExecutor;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractDataGetter<T extends VcsShortCommitDetails>
implements Disposable,
DataGetter<T> {
    private static final Logger LOG = Logger.getInstance(AbstractDataGetter.class);
    private static final int MAX_LOADING_TASKS = 10;
    @NotNull
    protected final VcsLogStorage myStorage;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myLogProviders;
    @NotNull
    private final VcsCommitCache<Integer, T> myCache;
    @NotNull
    private final SequentialLimitedLifoExecutor<TaskDescriptor> myLoader;
    private long myCurrentTaskIndex;
    @NotNull
    private final Collection<Runnable> myLoadingFinishedListeners;
    @NotNull
    private final VcsLogIndex myIndex;

    AbstractDataGetter(@NotNull VcsLogStorage storage2, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull VcsCommitCache<Integer, T> cache, @NotNull VcsLogIndex index, @NotNull Disposable parentDisposable) {
        if (storage2 == null) {
            AbstractDataGetter.$$$reportNull$$$0(0);
        }
        if (logProviders == null) {
            AbstractDataGetter.$$$reportNull$$$0(1);
        }
        if (cache == null) {
            AbstractDataGetter.$$$reportNull$$$0(2);
        }
        if (index == null) {
            AbstractDataGetter.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            AbstractDataGetter.$$$reportNull$$$0(4);
        }
        this.myCurrentTaskIndex = 0L;
        this.myLoadingFinishedListeners = new ArrayList<Runnable>();
        this.myStorage = storage2;
        this.myLogProviders = logProviders;
        this.myCache = cache;
        this.myIndex = index;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myLoader = new SequentialLimitedLifoExecutor(this, 10, task2 -> {
            this.preLoadCommitData(((TaskDescriptor)task2).myCommits);
            this.notifyLoaded();
        });
    }

    private void notifyLoaded() {
        UIUtil.invokeAndWaitIfNeeded(() -> {
            for (Runnable loadingFinishedListener : this.myLoadingFinishedListeners) {
                loadingFinishedListener.run();
            }
        });
    }

    public void dispose() {
        this.myLoadingFinishedListeners.clear();
    }

    @Override
    @NotNull
    public T getCommitData(@NotNull Integer hash, @NotNull Iterable<Integer> neighbourHashes) {
        if (hash == null) {
            AbstractDataGetter.$$$reportNull$$$0(5);
        }
        if (neighbourHashes == null) {
            AbstractDataGetter.$$$reportNull$$$0(6);
        }
        assert (EventQueue.isDispatchThread());
        T details = this.getFromCache(hash);
        if (details != null) {
            T t = details;
            if (t == null) {
                AbstractDataGetter.$$$reportNull$$$0(7);
            }
            return t;
        }
        this.runLoadCommitsData(neighbourHashes);
        T result2 = this.myCache.get(hash);
        assert (result2 != null);
        T t = result2;
        if (t == null) {
            AbstractDataGetter.$$$reportNull$$$0(8);
        }
        return t;
    }

    @Override
    public void loadCommitsData(@NotNull List<Integer> hashes, @NotNull Consumer<List<T>> consumer, @Nullable ProgressIndicator indicator) {
        if (hashes == null) {
            AbstractDataGetter.$$$reportNull$$$0(9);
        }
        if (consumer == null) {
            AbstractDataGetter.$$$reportNull$$$0(10);
        }
        assert (EventQueue.isDispatchThread());
        this.loadCommitsData(AbstractDataGetter.getCommitsMap(hashes), consumer, indicator);
    }

    private void loadCommitsData(final @NotNull TIntIntHashMap commits, final @NotNull Consumer<List<T>> consumer, @Nullable ProgressIndicator indicator) {
        if (commits == null) {
            AbstractDataGetter.$$$reportNull$$$0(11);
        }
        if (consumer == null) {
            AbstractDataGetter.$$$reportNull$$$0(12);
        }
        final ArrayList result2 = ContainerUtil.newArrayList();
        final TIntHashSet toLoad = new TIntHashSet();
        long taskNumber = this.myCurrentTaskIndex++;
        for (int id : commits.keys()) {
            T details = this.getFromCache(id);
            if (details == null || details instanceof LoadingDetails) {
                toLoad.add(id);
                this.cacheCommit(id, taskNumber);
                continue;
            }
            result2.add(details);
        }
        if (toLoad.isEmpty()) {
            this.sortCommitsByRow(result2, commits);
            consumer.consume((Object)result2);
        } else {
            Task.Backgroundable task2 = new Task.Backgroundable(null, "Loading Selected Details", true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    indicator.checkCanceled();
                    try {
                        TIntObjectHashMap map2 = AbstractDataGetter.this.preLoadCommitData(toLoad);
                        map2.forEachValue(value -> {
                            result2.add(value);
                            return true;
                        });
                        AbstractDataGetter.this.sortCommitsByRow(result2, commits);
                        AbstractDataGetter.this.notifyLoaded();
                    }
                    catch (VcsException e) {
                        LOG.error((Throwable)e);
                    }
                }

                public void onSuccess() {
                    consumer.consume((Object)result2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/data/AbstractDataGetter$1", "run"));
                }
            };
            if (indicator != null) {
                ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, indicator);
            } else {
                ProgressManager.getInstance().run((Task)task2);
            }
        }
    }

    private void sortCommitsByRow(@NotNull List<T> result2, @NotNull TIntIntHashMap rowsForCommits) {
        if (result2 == null) {
            AbstractDataGetter.$$$reportNull$$$0(13);
        }
        if (rowsForCommits == null) {
            AbstractDataGetter.$$$reportNull$$$0(14);
        }
        ContainerUtil.sort(result2, (details1, details2) -> {
            if (rowsForCommits == null) {
                AbstractDataGetter.$$$reportNull$$$0(25);
            }
            int row1 = rowsForCommits.get(this.myStorage.getCommitIndex((Hash)details1.getId(), details1.getRoot()));
            int row2 = rowsForCommits.get(this.myStorage.getCommitIndex((Hash)details2.getId(), details2.getRoot()));
            return Comparing.compare((int)row1, (int)row2);
        });
    }

    @Override
    @Nullable
    public T getCommitDataIfAvailable(int hash) {
        return this.getFromCache(hash);
    }

    @Nullable
    private T getFromCache(@NotNull Integer commitId) {
        T details;
        if (commitId == null) {
            AbstractDataGetter.$$$reportNull$$$0(15);
        }
        if ((details = this.myCache.get(commitId)) != null) {
            if (details instanceof LoadingDetails && ((LoadingDetails)details).getLoadingTaskIndex() <= this.myCurrentTaskIndex - 10L) {
                this.myCache.remove(commitId);
                return null;
            }
            return details;
        }
        return this.getFromAdditionalCache(commitId);
    }

    @Nullable
    protected abstract T getFromAdditionalCache(int var1);

    private void runLoadCommitsData(@NotNull Iterable<Integer> hashes) {
        if (hashes == null) {
            AbstractDataGetter.$$$reportNull$$$0(16);
        }
        long taskNumber = this.myCurrentTaskIndex++;
        TIntIntHashMap commits = AbstractDataGetter.getCommitsMap(hashes);
        TIntHashSet toLoad = new TIntHashSet();
        for (int id : commits.keys()) {
            this.cacheCommit(id, taskNumber);
            toLoad.add(id);
        }
        this.myLoader.queue(new TaskDescriptor(toLoad));
    }

    private void cacheCommit(int commitId, long taskNumber) {
        if (!this.myCache.isKeyCached(commitId)) {
            IndexDataGetter dataGetter = this.myIndex.getDataGetter();
            if (dataGetter != null) {
                this.myCache.put(commitId, new IndexedDetails(dataGetter, this.myStorage, commitId, taskNumber));
            } else {
                this.myCache.put(commitId, new LoadingDetails((Computable<CommitId>)((Computable)() -> this.myStorage.getCommitId(commitId)), taskNumber));
            }
        }
    }

    @NotNull
    private static TIntIntHashMap getCommitsMap(@NotNull Iterable<Integer> hashes) {
        if (hashes == null) {
            AbstractDataGetter.$$$reportNull$$$0(17);
        }
        TIntIntHashMap commits = new TIntIntHashMap();
        int row = 0;
        for (Integer commitId : hashes) {
            commits.put(commitId.intValue(), row);
            ++row;
        }
        TIntIntHashMap tIntIntHashMap = commits;
        if (tIntIntHashMap == null) {
            AbstractDataGetter.$$$reportNull$$$0(18);
        }
        return tIntIntHashMap;
    }

    @NotNull
    public TIntObjectHashMap<T> preLoadCommitData(@NotNull TIntHashSet commits) throws VcsException {
        if (commits == null) {
            AbstractDataGetter.$$$reportNull$$$0(19);
        }
        TIntObjectHashMap result2 = new TIntObjectHashMap();
        MultiMap rootsAndHashes = MultiMap.create();
        commits.forEach(commit -> {
            CommitId commitId = this.myStorage.getCommitId(commit);
            if (commitId != null) {
                rootsAndHashes.putValue((Object)commitId.getRoot(), (Object)commitId.getHash().asString());
            }
            return true;
        });
        for (Map.Entry entry : rootsAndHashes.entrySet()) {
            VcsLogProvider logProvider = this.myLogProviders.get(entry.getKey());
            if (logProvider != null) {
                List<T> details = this.readDetails(logProvider, (VirtualFile)entry.getKey(), ContainerUtil.newArrayList((Iterable)((Iterable)entry.getValue())));
                for (VcsShortCommitDetails data : details) {
                    int index = this.myStorage.getCommitIndex((Hash)data.getId(), data.getRoot());
                    result2.put(index, (Object)data);
                }
                this.saveInCache(result2);
                continue;
            }
            LOG.error("No log provider for root " + ((VirtualFile)entry.getKey()).getPath() + ". All known log providers " + this.myLogProviders);
        }
        TIntObjectHashMap tIntObjectHashMap = result2;
        if (tIntObjectHashMap == null) {
            AbstractDataGetter.$$$reportNull$$$0(20);
        }
        return tIntObjectHashMap;
    }

    public void saveInCache(@NotNull TIntObjectHashMap<T> details) {
        if (details == null) {
            AbstractDataGetter.$$$reportNull$$$0(21);
        }
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (details == null) {
                AbstractDataGetter.$$$reportNull$$$0(24);
            }
            details.forEachEntry((key, value) -> {
                this.myCache.put(key, (VcsShortCommitDetails)value);
                return true;
            });
        });
    }

    @NotNull
    protected abstract List<? extends T> readDetails(@NotNull VcsLogProvider var1, @NotNull VirtualFile var2, @NotNull List<String> var3) throws VcsException;

    public void addDetailsLoadedListener(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            AbstractDataGetter.$$$reportNull$$$0(22);
        }
        this.myLoadingFinishedListeners.add(runnable2);
    }

    public void removeDetailsLoadedListener(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            AbstractDataGetter.$$$reportNull$$$0(23);
        }
        this.myLoadingFinishedListeners.remove(runnable2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProviders";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "neighbourHashes";
                break;
            }
            case 7: 
            case 8: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/AbstractDataGetter";
                break;
            }
            case 9: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowsForCommits";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/AbstractDataGetter";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitData";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitsMap";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "preLoadCommitData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCommitData";
                break;
            }
            case 7: 
            case 8: 
            case 18: 
            case 20: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadCommitsData";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sortCommitsByRow";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFromCache";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "runLoadCommitsData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCommitsMap";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "preLoadCommitData";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "saveInCache";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addDetailsLoadedListener";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removeDetailsLoadedListener";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$saveInCache$6";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$sortCommitsByRow$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TaskDescriptor {
        @NotNull
        private final TIntHashSet myCommits;

        private TaskDescriptor(@NotNull TIntHashSet commits) {
            if (commits == null) {
                TaskDescriptor.$$$reportNull$$$0(0);
            }
            this.myCommits = commits;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/AbstractDataGetter$TaskDescriptor", "<init>"));
        }
    }
}

