/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.xml.DomAnchor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomFileIndex;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.ModelMergerImpl;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.util.xml.XmlFileHeader;
import com.intellij.util.xml.impl.DomAnchorImpl;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.structure.DomStructureViewBuilder;
import com.intellij.util.xml.stubs.FileStub;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomServiceImpl
extends DomService {
    private static final Key<CachedValue<XmlFileHeader>> ROOT_TAG_NS_KEY = Key.create((String)"rootTag&ns");
    private static final UserDataCache<CachedValue<XmlFileHeader>, XmlFile, Object> ourRootTagCache = new UserDataCache<CachedValue<XmlFileHeader>, XmlFile, Object>(){

        protected CachedValue<XmlFileHeader> compute(XmlFile file2, Object o) {
            return CachedValuesManager.getManager((Project)file2.getProject()).createCachedValue(() -> new CachedValueProvider.Result((Object)DomServiceImpl.calcXmlFileHeader(file2), new Object[]{file2}), false);
        }
    };

    @NotNull
    private static XmlFileHeader calcXmlFileHeader(XmlFile file2) {
        Stub root;
        ObjectStubTree tree;
        VirtualFile virtualFile;
        if (file2 instanceof PsiFileEx && ((PsiFileEx)file2).isContentsLoaded() && file2.getNode().isParsed()) {
            XmlFileHeader xmlFileHeader = DomServiceImpl.computeHeaderByPsi(file2);
            if (xmlFileHeader == null) {
                DomServiceImpl.$$$reportNull$$$0(0);
            }
            return xmlFileHeader;
        }
        if (!XmlUtil.isStubBuilding() && file2.getFileType() == XmlFileType.INSTANCE && (virtualFile = file2.getVirtualFile()) instanceof VirtualFileWithId && (tree = StubTreeLoader.getInstance().readFromVFile(file2.getProject(), virtualFile)) != null && (root = tree.getRoot()) instanceof FileStub) {
            XmlFileHeader xmlFileHeader = ((FileStub)root).getHeader();
            if (xmlFileHeader == null) {
                DomServiceImpl.$$$reportNull$$$0(1);
            }
            return xmlFileHeader;
        }
        if (!file2.isValid()) {
            XmlFileHeader xmlFileHeader = XmlFileHeader.EMPTY;
            if (xmlFileHeader == null) {
                DomServiceImpl.$$$reportNull$$$0(2);
            }
            return xmlFileHeader;
        }
        XmlFileHeader xmlFileHeader = NanoXmlUtil.parseHeader((PsiFile)file2);
        if (xmlFileHeader == null) {
            DomServiceImpl.$$$reportNull$$$0(3);
        }
        return xmlFileHeader;
    }

    private static XmlFileHeader computeHeaderByPsi(XmlFile file2) {
        XmlTag tag;
        XmlDoctype doctype;
        XmlDocument document = file2.getDocument();
        if (document == null) {
            return XmlFileHeader.EMPTY;
        }
        String publicId = null;
        String systemId = null;
        XmlProlog prolog = document.getProlog();
        if (prolog != null && (doctype = prolog.getDoctype()) != null) {
            publicId = doctype.getPublicId();
            systemId = doctype.getSystemId();
            if (systemId == null) {
                systemId = doctype.getDtdUri();
            }
        }
        if ((tag = document.getRootTag()) == null) {
            return XmlFileHeader.EMPTY;
        }
        String localName = tag.getLocalName();
        if (StringUtil.isNotEmpty((String)localName)) {
            if (tag.getPrevSibling() instanceof PsiErrorElement) {
                return XmlFileHeader.EMPTY;
            }
            String psiNs = tag.getNamespace();
            return new XmlFileHeader(localName, psiNs == "" || Comparing.equal((String)psiNs, (String)systemId) ? null : psiNs, publicId, systemId);
        }
        return XmlFileHeader.EMPTY;
    }

    public ModelMerger createModelMerger() {
        return new ModelMergerImpl();
    }

    public <T extends DomElement> DomAnchor<T> createAnchor(T domElement) {
        return DomAnchorImpl.createAnchor(domElement);
    }

    @NotNull
    public XmlFile getContainingFile(@NotNull DomElement domElement) {
        if (domElement == null) {
            DomServiceImpl.$$$reportNull$$$0(4);
        }
        if (domElement instanceof DomFileElement) {
            XmlFile xmlFile = ((DomFileElement)domElement).getFile();
            if (xmlFile == null) {
                DomServiceImpl.$$$reportNull$$$0(5);
            }
            return xmlFile;
        }
        XmlFile xmlFile = DomManagerImpl.getNotNullHandler(domElement).getFile();
        if (xmlFile == null) {
            DomServiceImpl.$$$reportNull$$$0(6);
        }
        return xmlFile;
    }

    @NotNull
    public EvaluatedXmlName getEvaluatedXmlName(@NotNull DomElement element) {
        if (element == null) {
            DomServiceImpl.$$$reportNull$$$0(7);
        }
        EvaluatedXmlName evaluatedXmlName = DomManagerImpl.getNotNullHandler(element).getXmlName();
        if (evaluatedXmlName == null) {
            DomServiceImpl.$$$reportNull$$$0(8);
        }
        return evaluatedXmlName;
    }

    @NotNull
    public XmlFileHeader getXmlFileHeader(XmlFile file2) {
        XmlFileHeader xmlFileHeader = file2.isValid() ? (XmlFileHeader)((CachedValue)ourRootTagCache.get(ROOT_TAG_NS_KEY, (UserDataHolder)file2, null)).getValue() : XmlFileHeader.EMPTY;
        if (xmlFileHeader == null) {
            DomServiceImpl.$$$reportNull$$$0(9);
        }
        return xmlFileHeader;
    }

    public Collection<VirtualFile> getDomFileCandidates(Class<? extends DomElement> rootElementClass, Project project, GlobalSearchScope scope) {
        return FileBasedIndex.getInstance().getContainingFiles(DomFileIndex.NAME, (Object)rootElementClass.getName(), scope);
    }

    public <T extends DomElement> List<DomFileElement<T>> getFileElements(Class<T> clazz, Project project, @Nullable GlobalSearchScope scope) {
        Collection<VirtualFile> list2 = this.getDomFileCandidates(clazz, project, scope != null ? scope : GlobalSearchScope.allScope((Project)project));
        ArrayList<DomFileElement<T>> result2 = new ArrayList<DomFileElement<T>>(list2.size());
        for (VirtualFile file2 : list2) {
            DomFileElement element;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
            if (!(psiFile instanceof XmlFile) || (element = DomManager.getDomManager((Project)project).getFileElement((XmlFile)psiFile, clazz)) == null) continue;
            result2.add(element);
        }
        return result2;
    }

    public StructureViewBuilder createSimpleStructureViewBuilder(XmlFile file2, Function<DomElement, DomService.StructureViewMode> modeProvider) {
        return new DomStructureViewBuilder(file2, modeProvider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/impl/DomServiceImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "calcXmlFileHeader";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/impl/DomServiceImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluatedXmlName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlFileHeader";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEvaluatedXmlName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

